/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.workflow.v2;

import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.model.InstallWizardProperties;
import com.mathworks.installwizard.workflow.v2.AbstractBranchingInstallWorkflow;
import com.mathworks.installwizard.workflow.v2.InstallWorkflowFactory;
import com.mathworks.instutil.AvailablePlatform;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.model.PlatformModel;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.io.File;
import java.util.Arrays;
import java.util.Properties;

public final class DownloadFolderSelectionWorkflow
extends AbstractBranchingInstallWorkflow<String> {
    private final InstallWizardContext installWizardContext;
    private final DefaultedModel<File> downloadFolderModel;
    private final String token;
    private PlatformModel<AvailablePlatform> platformModel;
    private final Model<String[]> languagesModel = new ModelImpl();

    DownloadFolderSelectionWorkflow(InstallModelFactory installModelFactory, InstallCommandStepFactory installCommandStepFactory, InstallWorkflowFactory installWorkflowFactory, Properties properties, InstallWizardContext installWizardContext, String string) {
        super(installModelFactory, installCommandStepFactory, installWorkflowFactory, properties);
        this.installWizardContext = installWizardContext;
        this.downloadFolderModel = installModelFactory.createDownloadFolderModel();
        this.platformModel = installModelFactory.createPlatformModel();
        this.token = string;
    }

    @Override
    protected void construct(PanelStepBuilder panelStepBuilder, InstallCommandStepFactory installCommandStepFactory) {
        this.addStep(panelStepBuilder.buildDownloadFolderSelectionStep(this.downloadFolderModel, this.platformModel));
        this.addStep(installCommandStepFactory.createCheckDownloadPathForInvalidCharactersStep(this.downloadFolderModel));
        this.addStep(installCommandStepFactory.createVerifyDownloadRootDirectoryStep(this.downloadFolderModel));
        this.addStep(installCommandStepFactory.createDownloadFolderIfItDoesNotAlreadyExistStep(this.downloadFolderModel));
        this.addStep(installCommandStepFactory.createCheckWritePermissionsForDownloadFolderStep(this.downloadFolderModel));
        this.addStep(installCommandStepFactory.createGetLanguagesStep(this.languagesModel, this.token));
    }

    @Override
    protected String evaluateWorkflow(InstallWizardProperties installWizardProperties) {
        return ((File)this.downloadFolderModel.get()).getAbsolutePath() + Arrays.toString(this.platformModel.getSelectedPlatforms());
    }

    @Override
    protected Workflow createNewBranch(InstallWorkflowFactory installWorkflowFactory, Properties properties) {
        return installWorkflowFactory.createReadArchivesWorkflow(this.token, properties, this.installWizardContext, this.downloadFolderModel, this.platformModel, this.languagesModel);
    }
}

