/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.model;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.mathworks.install.DefaultDirectoryProvider;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.installwizard.model.DefaultInstallFolderModelFactory;
import com.mathworks.installwizard.model.InstallFileSystemFactory;
import com.mathworks.installwizard.model.InstallFileSystemFactoryImpl;
import com.mathworks.installwizard.model.InstallFolderModelFactory;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallModelFactoryImpl;
import com.mathworks.installwizard.model.InstallTaskFactory;
import com.mathworks.installwizard.model.InstallTaskFactoryImpl;
import com.mathworks.installwizard.model.MacInstallFolderModelFactory;
import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.DownloaderImpl;
import com.mathworks.instutil.FolderUtils;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.URLConnectionFactory;
import com.mathworks.instutil.URLConnectionFactoryImpl;

public final class ModelModule
extends AbstractModule {
    protected void configure() {
        this.bind(InstallFileSystemFactory.class).to(InstallFileSystemFactoryImpl.class);
        this.bind(InstallModelFactory.class).to(InstallModelFactoryImpl.class);
        this.bind(InstallTaskFactory.class).to(InstallTaskFactoryImpl.class);
    }

    @Provides
    static Downloader provideDownloader(URLConnectionFactory uRLConnectionFactory, FolderUtils folderUtils) {
        return new DownloaderImpl(uRLConnectionFactory, folderUtils);
    }

    @Provides
    static URLConnectionFactory provideURLConnectionFactory() {
        return new URLConnectionFactoryImpl();
    }

    @Provides
    static InstallFolderModelFactory provideInstallFolderModelFactory(Platform platform, InstallConfiguration installConfiguration, DefaultDirectoryProvider defaultDirectoryProvider, FolderUtils folderUtils) {
        if (platform.isMac()) {
            return new MacInstallFolderModelFactory(installConfiguration, defaultDirectoryProvider, folderUtils, platform);
        }
        return new DefaultInstallFolderModelFactory(installConfiguration, defaultDirectoryProvider, platform);
    }
}

