/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.model;

import com.mathworks.install.status.InstallStatusObserverAdapter;
import com.mathworks.installwizard.model.AbstractTask;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.wizard.model.TaskStatusObserver;

final class InstallerStatusObserverImpl
extends InstallStatusObserverAdapter {
    private static final String MCR_PRODUCT_NAME = "MATLAB Runtime";
    private static final String NO_PRODUCT_NAME = "...";
    private long unitsDoneSoFar;
    private long confirmedUnits;
    private int percentComplete;
    private AbstractTask abstractTask;
    private long unitsRemaining;
    private long currentDownloadUnits;

    InstallerStatusObserverImpl(AbstractTask abstractTask) {
        this.abstractTask = abstractTask;
        this.unitsRemaining = this.abstractTask.getTotalUnits();
    }

    public void addProduct(String string) {
        for (TaskStatusObserver taskStatusObserver : this.abstractTask.getTaskStatusObservers()) {
            taskStatusObserver.updateCurrentStatus(ResourceKeys.LABEL_INSTALL.getString(this.getDisplayProductName(string)));
        }
    }

    public void removeProduct(String string) {
        String string2 = ResourceKeys.LABEL_UNINSTALL.getString(string);
        if (this.isMCRProduct(string)) {
            string2 = ResourceKeys.LABEL_MCR_UNINSTALL.getString(this.getDisplayProductName(string));
        }
        for (TaskStatusObserver taskStatusObserver : this.abstractTask.getTaskStatusObservers()) {
            taskStatusObserver.updateCurrentStatus(string2);
        }
    }

    public void updateUnits(long l) {
        this.unitsDoneSoFar += l;
        this.unitsRemaining -= l;
        int n = this.calculatePercentComplete();
        for (TaskStatusObserver taskStatusObserver : this.abstractTask.getTaskStatusObservers()) {
            if (n == this.percentComplete) continue;
            taskStatusObserver.updatePercentComplete(n);
            this.percentComplete = n;
        }
    }

    public void confirm() {
        this.confirmedUnits = this.unitsDoneSoFar;
    }

    public void reset() {
        this.currentDownloadUnits = 0L;
        this.updateUnits(-(this.unitsDoneSoFar - this.confirmedUnits));
    }

    public void downloadingProduct(String string, long l) {
        this.currentDownloadUnits = 0L;
        for (TaskStatusObserver taskStatusObserver : this.abstractTask.getTaskStatusObservers()) {
            taskStatusObserver.updateOverallStatus(ResourceKeys.STATUS_DOWNLOADING.getString(this.getDisplayProductName(string), 0, l / 0x100000L));
            taskStatusObserver.updateCurrentStatus(ResourceKeys.STATUS_PREPARING.getString(new Object[0]));
        }
    }

    public void updateDownloadUnits(String string, long l, long l2) {
        this.updateUnits(l);
        this.currentDownloadUnits += l;
        for (TaskStatusObserver taskStatusObserver : this.abstractTask.getTaskStatusObservers()) {
            taskStatusObserver.updateOverallStatus(ResourceKeys.STATUS_DOWNLOADING.getString(this.getDisplayProductName(string), this.currentDownloadUnits / 0x100000L, l2 / 0x100000L));
        }
    }

    public void finishedDownloading(long l) {
        for (TaskStatusObserver taskStatusObserver : this.abstractTask.getTaskStatusObservers()) {
            taskStatusObserver.updateOverallStatus(ResourceKeys.STATUS_DOWNLOADING_FINISHED.getString(l / 0x100000L));
        }
    }

    public void postInstall() {
        for (TaskStatusObserver taskStatusObserver : this.abstractTask.getTaskStatusObservers()) {
            taskStatusObserver.updateCurrentStatus(ResourceKeys.LABEL_POST_INSTALL.getString(new Object[0]));
        }
    }

    public void preInstall() {
        for (TaskStatusObserver taskStatusObserver : this.abstractTask.getTaskStatusObservers()) {
            taskStatusObserver.updateCurrentStatus(ResourceKeys.LABEL_PRE_INSTALL.getString(new Object[0]));
        }
    }

    public void downloadingInstaller(long l) {
        this.updateUnits(l);
        for (TaskStatusObserver taskStatusObserver : this.abstractTask.getTaskStatusObservers()) {
            taskStatusObserver.updateOverallStatus(ResourceKeys.STATUS_DOWNLOADING_INSTALLER.getString(new Object[0]));
            taskStatusObserver.updateCurrentStatus(ResourceKeys.STATUS_PREPARING_INSTALLER.getString(new Object[0]));
        }
    }

    private int calculatePercentComplete() {
        if (this.unitsDoneSoFar + this.unitsRemaining == 0L) {
            return 100;
        }
        int n = (int)(100L * this.unitsDoneSoFar / (this.unitsDoneSoFar + this.unitsRemaining));
        if (n > 100) {
            return 100;
        }
        return n;
    }

    private boolean isMCRProduct(String string) {
        return string.toLowerCase().contains(MCR_PRODUCT_NAME.toLowerCase());
    }

    private String getDisplayProductName(String string) {
        String string2 = string;
        if (this.isMCRProduct(string)) {
            string2 = NO_PRODUCT_NAME;
        }
        return string2;
    }
}

