/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.model;

import com.mathworks.install.SoftwareManager;
import com.mathworks.instutil.FolderUtils;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.FileSystem;
import java.io.File;
import java.io.IOException;

final class FileSystemImpl
implements FileSystem {
    private final SoftwareManager softwareManager;
    private final DefaultedModel<String> installFolderModel;
    private final FolderUtils folderUtils;

    FileSystemImpl(SoftwareManager softwareManager, DefaultedModel<String> defaultedModel, FolderUtils folderUtils) {
        this.softwareManager = softwareManager;
        this.installFolderModel = defaultedModel;
        this.folderUtils = folderUtils;
    }

    public long getMegabytesRequired() {
        long l = this.softwareManager.getBytesRequired(this.getInstallFolder()) / 0x100000L;
        return l >= 0L ? l : 0L;
    }

    public long getMegabytesAvailable() throws IOException {
        File file = this.getInstallFolder();
        if (this.folderUtils.firstExistingDirectoryExists(file)) {
            return this.folderUtils.getFirstExistingDirectory(file).getUsableSpace() / 0x100000L;
        }
        return 0L;
    }

    private File getInstallFolder() {
        return new File((String)this.installFolderModel.get());
    }

    public long getMegabytesToDownload() {
        long l = this.softwareManager.getDownloadSize(this.getInstallFolder());
        return l / 0x100000L;
    }
}

