/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.model;

import com.mathworks.install.AvailableProduct;
import com.mathworks.installwizard.model.AbstractProductTableFormat;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.wizard.model.ProductModel;

final class AvailableDownloadProductTableFormat
extends AbstractProductTableFormat {
    AvailableDownloadProductTableFormat(ProductModel<AvailableProduct> productModel) {
        super(productModel);
    }

    public Object getColumnValue(AvailableProduct availableProduct, int n) {
        switch (n) {
            case 0: {
                return this.notDownloaded(availableProduct) && availableProduct.isSelected();
            }
            case 1: {
                String string = availableProduct.getName() + ' ' + availableProduct.getVersion();
                if (this.isDownloaded(availableProduct)) {
                    return this.getFormattedDownloadedString(string);
                }
                return string;
            }
            case 2: {
                if (this.isDownloaded(availableProduct)) {
                    return this.getFormattedDownloadedString(ResourceKeys.ALREADY_DOWNLOADED.getString(new Object[0]));
                }
                return "";
            }
        }
        throw new IllegalStateException();
    }

    public boolean isEditable(AvailableProduct availableProduct, int n) {
        return n == 0 && this.notDownloaded(availableProduct);
    }

    @Override
    public void toggleSelect(AvailableProduct availableProduct, int n, int n2) {
        if (n2 > 0 && this.notDownloaded(availableProduct) && n > 0) {
            this.productModel.toggleSelect((Object)availableProduct);
        }
    }

    private String getFormattedDownloadedString(String string) {
        return "<html><i><font color=\"gray\">" + string + "</font></i></html>";
    }

    private boolean notDownloaded(AvailableProduct availableProduct) {
        return !this.isDownloaded(availableProduct);
    }

    private boolean isDownloaded(AvailableProduct availableProduct) {
        return availableProduct.getDownloadSize() == 0L;
    }

    @Override
    public int getColumnCount() {
        if (this.productModel.isAnyProductPreviouslyDownloaded()) {
            return 3;
        }
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return ResourceKeys.PRODUCT_HEADER.getString(new Object[0]);
            }
            case 2: {
                return ResourceKeys.NOTES_HEADER.getString(new Object[0]);
            }
        }
        throw new IllegalStateException();
    }
}

