/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.model;

import com.mathworks.install.DefaultDirectoryProvider;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.Product;
import com.mathworks.installwizard.model.InstallFolderModelFactory;
import com.mathworks.instutil.Platform;
import com.mathworks.wizard.model.DefaultedModel;

abstract class AbstractInstallFolderModelFactory
implements InstallFolderModelFactory {
    protected final InstallConfiguration installConfiguration;
    protected final DefaultDirectoryProvider defaultDirectoryProvider;
    private final Platform platform;

    AbstractInstallFolderModelFactory(InstallConfiguration installConfiguration, DefaultDirectoryProvider defaultDirectoryProvider, Platform platform) {
        this.installConfiguration = installConfiguration;
        this.defaultDirectoryProvider = defaultDirectoryProvider;
        this.platform = platform;
    }

    @Override
    public final DefaultedModel<String> createDisplayedFolderModel(DefaultedModel<String> defaultedModel, Product[] productArray) {
        DefaultDisplayedFolderModel defaultDisplayedFolderModel = new DefaultDisplayedFolderModel(defaultedModel);
        if (this.installConfiguration.alwaysUseDefaultInstallFolderModel(this.platform.getArchString(), productArray)) {
            return defaultDisplayedFolderModel;
        }
        return this.createDisplayedFolderModel(defaultedModel, defaultDisplayedFolderModel);
    }

    protected abstract DefaultedModel<String> createDisplayedFolderModel(DefaultedModel<String> var1, DefaultedModel<String> var2);

    @Override
    public final DefaultedModel<String> createInstallFolderModel(final Product[] productArray) {
        return new DefaultedModel<String>(){
            private String installationPath;
            {
                this.installationPath = AbstractInstallFolderModelFactory.this.installConfiguration.getInstallationPath(this.getDefault());
            }

            public String getDefault() {
                return AbstractInstallFolderModelFactory.this.defaultDirectoryProvider.getDefaultDirectory(productArray).getAbsolutePath();
            }

            public String get() {
                return this.installationPath;
            }

            public void set(String string) {
                this.installationPath = AbstractInstallFolderModelFactory.this.installConfiguration.getInstallationPath(string);
            }
        };
    }

    private static class DefaultDisplayedFolderModel
    implements DefaultedModel<String> {
        private String value;
        private final DefaultedModel<String> folderModel;

        DefaultDisplayedFolderModel(DefaultedModel<String> defaultedModel) {
            this.folderModel = defaultedModel;
            this.value = this.getDefault();
        }

        public String getDefault() {
            return (String)this.folderModel.getDefault();
        }

        public String get() {
            return this.value;
        }

        public void set(String string) {
            this.value = string;
            this.folderModel.set((Object)string);
        }
    }
}

