/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.installwizard.command.AbstractCommandStep;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.Machine;
import com.mathworks.instutil.licensefiles.LicenseFileParserImpl;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.wizard.ExceptionHandler;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.ui.WizardUI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.io.IOUtils;

class ValidateLicenseFileStep
extends AbstractCommandStep {
    private final Model<String> licenseFilePathModel;
    private final Model<String> licenseFileContentsModel;
    private final ExceptionHandler exceptionHandler;
    private final WizardUI wizardUI;
    private final AppLogger logger;
    private final Machine machineInfo;
    private static final String NO_HOSTID = "YOUR_HOSTID";

    ValidateLicenseFileStep(Model<String> model, Model<String> model2, ExceptionHandler exceptionHandler, WizardUI wizardUI, AppLogger appLogger, Machine machine) {
        this.licenseFilePathModel = model;
        this.licenseFileContentsModel = model2;
        this.exceptionHandler = exceptionHandler;
        this.wizardUI = wizardUI;
        this.logger = appLogger;
        this.machineInfo = machine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean forwardVisitStep() {
        block9: {
            String string = (String)this.licenseFilePathModel.get();
            if (string == null) break block9;
            File file = new File(string);
            if (file.isDirectory()) {
                this.wizardUI.showErrorMessage(InstutilResourceKeys.ERROR_LICENSEFILE_TITLE.getString(new Object[0]), InstutilResourceKeys.ERROR_LICENSEFILE_FOLDER.getString(new Object[]{string}));
                return false;
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                this.licenseFileContentsModel.set((Object)IOUtils.toString((InputStream)fileInputStream));
            }
            catch (IOException iOException) {
                boolean bl;
                try {
                    this.wizardUI.showErrorMessage(InstutilResourceKeys.ERROR_LICENSEFILE_TITLE.getString(new Object[0]), InstutilResourceKeys.ERROR_LICENSEFILE_EXCEPTION.getString(new Object[]{iOException.getMessage()}));
                    bl = false;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileInputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fileInputStream);
                return bl;
            }
            IOUtils.closeQuietly((InputStream)fileInputStream);
            String string2 = (String)this.licenseFileContentsModel.get();
            if (!this.checkLicenseFileformat(string2)) {
                this.wizardUI.showErrorMessage(ResourceKeys.ERROR_TITLE_LICENSEFILE_FORMAT.getString(new Object[0]), ResourceKeys.ERROR_LICENSEFILE_FORMAT.getString(string));
                return false;
            }
            if (!this.hasServerLine(string2)) {
                String string3 = ValidateLicenseFileStep.getHostidFromComment(string2);
                if (string3.equalsIgnoreCase(NO_HOSTID)) {
                    return this.wizardUI.showWarningMessage(ResourceKeys.ERROR_HOSTID_TITLE.getString(new Object[0]), ResourceKeys.WARNING_HOSTID_MISSING.getString(new Object[0]));
                }
                if (!this.isHostIDMatch(string3)) {
                    return this.wizardUI.showWarningMessage(ResourceKeys.ERROR_HOSTID_TITLE.getString(new Object[0]), ResourceKeys.ERROR_HOSTID.getString(this.machineInfo.getEthernetAddress(), string3));
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkLicenseFileformat(String string) {
        boolean bl = true;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null && bl) {
                String string3;
                boolean bl2 = true;
                if (string2.contains("INCREMENT") && !(string3 = string2.trim()).startsWith("INCREMENT") && string3.charAt(0) != '#') {
                    this.logger.debugMsg("Bad INCREMENT line: " + string3);
                    bl2 = false;
                }
                boolean bl3 = true;
                int n = string2.indexOf(92);
                int n2 = string2.indexOf("DAEMON");
                if (n != -1 && n2 == -1) {
                    int n3 = string2.indexOf(35);
                    if (n3 != -1 && n > n3) {
                        bl3 = true;
                    } else if (n == string2.length() - 1) {
                        bl3 = true;
                    } else {
                        String string4 = string2.toLowerCase();
                        int n4 = string4.indexOf("options=");
                        int n5 = string4.indexOf("mlm.opt");
                        int n6 = string4.indexOf("mlm.exe");
                        if (n4 != -1 || n5 != -1 || n6 != -1) {
                            bl3 = true;
                        } else {
                            this.logger.debugMsg(ResourceKeys.ERROR_LICENSEFILE_BADLINE.getString(string2));
                            bl3 = false;
                        }
                    }
                }
                bl = bl2 && bl3;
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            try {
                this.exceptionHandler.handleException((Throwable)iOException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedReader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)bufferedReader);
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasServerLine(String string) {
        boolean bl = false;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new StringReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!new LicenseFileParserImpl().containsServerLine(string2.trim())) continue;
                bl = true;
                break;
            }
        }
        catch (IOException iOException) {
            try {
                this.exceptionHandler.logException((Throwable)iOException);
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedReader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)bufferedReader);
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
        return bl;
    }

    static String getHostidFromComment(String string) {
        String string2;
        int n = string.indexOf("HostID:");
        int n2 = string.lastIndexOf("HostID:");
        if (n != -1 && n == n2) {
            if (string.contains("HostID: INTERNET=")) {
                int n3 = string.indexOf("HostID: INTERNET=");
                int n4 = string.indexOf(32, n3 + 20);
                int n5 = string.indexOf(10, n3 + 20);
                int n6 = string.indexOf(13, n3 + 20);
                int n7 = n4 > -1 && n5 > -1 ? Math.min(n4, n5) : Math.max(n4, n5);
                int n8 = n7 > -1 && n6 > -1 ? Math.min(n7, n6) : (n7 > -1 || n6 > -1 ? Math.max(n7, n6) : n3 + 32);
                string2 = string.substring(n3 + 8, n8);
            } else if (string.contains("HostID: ANY")) {
                string2 = "ANY";
            } else if (string.contains("HostID: DEMO")) {
                string2 = "DEMO";
            } else if (string.contains("HostID: ID=")) {
                int n9 = string.indexOf("HostID: ID=");
                int n10 = string.indexOf(32, n9 + 10);
                int n11 = string.indexOf(10, n9 + 10);
                int n12 = string.indexOf(13, n9 + 10);
                int n13 = n10 > -1 && n11 > -1 ? Math.min(n10, n11) : Math.max(n10, n11);
                int n14 = n13 > -1 && n12 > -1 ? Math.min(n13, n12) : (n13 > -1 || n12 > -1 ? Math.max(n13, n12) : n9 + 17);
                int n15 = string.indexOf("HostID:");
                string2 = string.substring(n15 + 8, n14);
            } else if (string.contains("HostID: ")) {
                int n16 = string.indexOf("HostID: ");
                int n17 = string.indexOf(32, n16 + 8);
                int n18 = string.indexOf(10, n16 + 8);
                int n19 = string.indexOf(13, n16 + 8);
                int n20 = n17 > -1 && n18 > -1 ? Math.min(n17, n18) : Math.max(n17, n18);
                int n21 = n20 > -1 && n19 > -1 ? Math.min(n20, n19) : (n20 > -1 || n19 > -1 ? Math.max(n20, n19) : n16 + 21);
                int n22 = string.indexOf("HostID:");
                string2 = string.substring(n22 + 8, n21);
            } else {
                string2 = NO_HOSTID;
            }
        } else {
            string2 = NO_HOSTID;
        }
        return string2;
    }

    private boolean isHostIDMatch(String string) {
        boolean bl = false;
        if (string.length() > 0) {
            boolean bl2 = false;
            boolean bl3 = false;
            if (!(string.contains("ANY") || string.contains("DEMO") || string.contains("ID=") || string.contains("USER=") || string.contains("HOSTNAME=") || string.contains("none"))) {
                if (!string.contains("INTERNET=")) {
                    bl3 = true;
                    bl2 = false;
                } else if (string.contains("*")) {
                    bl3 = false;
                } else {
                    bl3 = true;
                    bl2 = true;
                }
            }
            if (bl3) {
                if (bl2) {
                    String string2 = this.machineInfo.getIpAddress();
                    if (string.contains(string2)) {
                        bl = true;
                    }
                } else {
                    String[] stringArray;
                    String string3 = this.machineInfo.getEthernetAddress();
                    string3 = string3.replaceAll("\"", "");
                    for (String string4 : stringArray = string3.split(" ")) {
                        if (!string.equalsIgnoreCase(string4)) continue;
                        bl = true;
                        break;
                    }
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }
}

