/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install.AvailableProduct;
import com.mathworks.install.Installer;
import com.mathworks.install.Product;
import com.mathworks.install.SoftwareManager;
import com.mathworks.installwizard.command.AbstractCommandStep;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.FileSystem;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.resources.WizardResourceKeys;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

final class MCRProductSelectionAndGetConfirmationTextStep
extends AbstractCommandStep {
    private static final String SEP = System.getProperty("line.separator");
    private Model<File> userAppInstallLocationModel;
    private Installer installer;
    private Model<Boolean> atLeastOneMCRInstalled;
    private DefaultedModel<String> installFolder;
    private List<Integer> requiredMCRProductIdentifiers;
    private FileSystem mcrFileSystem;
    private InstallWizardContext context;
    private String applicationName;
    private Model<Boolean> isIncrementalModel;
    private Model<String> confirmationTextModel;

    MCRProductSelectionAndGetConfirmationTextStep(Installer installer, DefaultedModel<String> defaultedModel, InstallWizardContext installWizardContext, Model<Boolean> model, List<Integer> list, String string, Model<File> model2, FileSystem fileSystem, Model<Boolean> model3, Model<String> model4) {
        this.installer = installer;
        this.atLeastOneMCRInstalled = model3;
        this.installFolder = defaultedModel;
        this.mcrFileSystem = fileSystem;
        this.requiredMCRProductIdentifiers = list;
        this.userAppInstallLocationModel = model2;
        this.context = installWizardContext;
        this.applicationName = string;
        this.isIncrementalModel = model;
        this.confirmationTextModel = model4;
    }

    @Override
    boolean forwardVisitStep() {
        File file = new File((String)this.installFolder.get());
        this.atLeastOneMCRInstalled.set((Object)(this.installer.getSelectedProductsAlreadyInstalled(file).length != 0 ? 1 : 0));
        this.deselectNotRequiredProducts((SoftwareManager)this.installer, this.requiredMCRProductIdentifiers);
        this.setDependentAndInstalledProductStatus(this.installer, file);
        Long l = this.mcrFileSystem.getMegabytesToDownload();
        String string = "";
        if (l != 0L) {
            string = MessageFormat.format(WizardResourceKeys.MCR_DOWNLOAD_SIZE_LABEL.getString(new Object[0]), l);
        }
        String string2 = this.context.buildInstallAgentConfirmationText(file.getAbsolutePath(), ((File)this.userAppInstallLocationModel.get()).getAbsolutePath(), this.applicationName, this.atLeastOneMCRInstalled, this.isIncrementalModel);
        this.confirmationTextModel.set((Object)(string2 + SEP + SEP + string));
        return true;
    }

    private void deselectNotRequiredProducts(SoftwareManager softwareManager, List<Integer> list) {
        for (AvailableProduct availableProduct : softwareManager.getAvailableProducts()) {
            if (list.contains(availableProduct.getProductNumber())) continue;
            availableProduct.setSelected(false);
        }
    }

    private void setDependentAndInstalledProductStatus(Installer installer, File file) {
        Product[] productArray = installer.getDependencies();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (Product product : productArray) {
            arrayList.add(product.getProductNumber());
        }
        if (arrayList.size() > 0) {
            for (Product product : installer.getAvailableProducts()) {
                if (!arrayList.contains(product.getProductNumber())) continue;
                product.setSelected(true);
            }
        }
        for (Product product : installer.getSelectedProductsAlreadyInstalled(file)) {
            arrayList2.add(product.getProductNumber());
            product.setOverwrite(false);
            product.setSelected(false);
        }
    }
}

