/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallerBuilder;
import com.mathworks.install.InstallerRequirements;
import com.mathworks.install.service.Service;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.installwizard.command.AbstractCommandStep;
import com.mathworks.installwizard.command.AbstractCommandStepFactory;
import com.mathworks.installwizard.command.CheckDownloadPathForInvalidCharactersStep;
import com.mathworks.installwizard.command.CheckPathForInvalidCharactersStep;
import com.mathworks.installwizard.command.DependencyChecker;
import com.mathworks.installwizard.command.OpenDownloadLocationCommandLinux;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.Machine;
import com.mathworks.instutil.ProcessExecutor;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.internal.dws.client.DownloadService;
import com.mathworks.internal.mwaws.client.v6.ActivationService;
import com.mathworks.mlwebservices.loginws.LoginService;
import com.mathworks.net.hyperlink.HyperlinkProvider;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.wizard.ExceptionHandler;
import com.mathworks.wizard.ExitHandler;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.StepCallback;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.InstallOptionModel;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.ui.CheckBoxConfiguration;
import com.mathworks.wizard.ui.WizardUI;
import com.mathworks.wizard.worker.WorkerFactory;
import java.io.File;
import java.util.concurrent.ExecutorService;

public final class InstallCommandStepFactoryLinux
extends AbstractCommandStepFactory {
    private static final String VALID_CHARS_STRING = "'-', '_', '.', or '/'";
    private static final String PATTERN = "([\\w-_./])+";

    public InstallCommandStepFactoryLinux(InstallerBuilder installerBuilder, WizardUI wizardUI, ExceptionHandler exceptionHandler, ExecutorService executorService, ExitHandler exitHandler, LoginService loginService, ActivationService activationService, DownloadService downloadService, String string, String[] stringArray, String string2, AppLogger appLogger, Machine machine, IO iO, DependencyChecker dependencyChecker, InstallerRequirements installerRequirements, WorkerFactory workerFactory, InstallConfiguration installConfiguration, HyperlinkProvider hyperlinkProvider, Downloader downloader, ProxyConfiguration proxyConfiguration, ProcessExecutor processExecutor, UsageDataCollector usageDataCollector) {
        super(downloadService, activationService, executorService, installerBuilder, exitHandler, string2, wizardUI, exceptionHandler, appLogger, string, stringArray, machine, loginService, iO, dependencyChecker, installerRequirements, workerFactory, installConfiguration, hyperlinkProvider, downloader, proxyConfiguration, processExecutor, usageDataCollector);
    }

    @Override
    public Step createValidateLicenseServerSelectionStep(InstallOptionModel installOptionModel, Service service, File file) {
        return new Step(){

            public void reverseVisitStep(StepCallback stepCallback) {
                stepCallback.stepBack();
            }

            public void forwardVisitStep(StepCallback stepCallback) {
                stepCallback.stepForward();
            }
        };
    }

    @Override
    public Step createCheckPathForInvalidCharactersStep(DefaultedModel<String> defaultedModel) {
        return new CheckPathForInvalidCharactersStep(defaultedModel, this.wizardUI, VALID_CHARS_STRING, PATTERN, ResourceKeys.FOLDER_INVALID_PATH_CHARS_UNIX);
    }

    @Override
    public Step createCheckSymbolicLinkCreationPermissionsStep(DefaultedModel<String> defaultedModel) {
        return this.createCheckWritePermissionsStep(defaultedModel);
    }

    @Override
    public final Step createOpenDownloadLocationStep(DefaultedModel<File> defaultedModel, Model<CheckBoxConfiguration> model) {
        return new OpenDownloadLocationCommandLinux(model);
    }

    @Override
    public final Step createCheckDownloadPathForInvalidCharactersStep(DefaultedModel<File> defaultedModel) {
        return new CheckDownloadPathForInvalidCharactersStep(defaultedModel, this.wizardUI, VALID_CHARS_STRING, PATTERN, ResourceKeys.FOLDER_INVALID_PATH_CHARS_UNIX);
    }

    @Override
    public Step createWarningMessageIfMATLABRunning(final DefaultedModel<String> defaultedModel) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                boolean bl = InstallCommandStepFactoryLinux.this.installerRequirements.isSpecificMatlabRunningForUser((String)defaultedModel.get(), InstallCommandStepFactoryLinux.this.executorService);
                if (bl) {
                    InstallCommandStepFactoryLinux.this.showWarningMessage();
                }
                return !bl;
            }
        };
    }
}

