/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install.SoftwareManagerBuilder;
import com.mathworks.install.input.ComponentURLProvider;
import com.mathworks.installwizard.command.AbstractWebServiceCallable;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.internal.dws.client.ComponentId;
import com.mathworks.internal.dws.client.DownloadService;
import com.mathworks.internal.dws.client.GetComponentsRequest;
import com.mathworks.internal.dws.client.GetComponentsReturn;
import com.mathworks.internal.dws.client.MWMessage;
import com.mathworks.internal.dws.client.ReleaseData;
import com.mathworks.internal.dws.client.SoftwareComponentInfo;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.wizard.ExceptionHandler;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.ui.WizardUI;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

final class GetUpdatesCallable
extends AbstractWebServiceCallable<GetComponentsReturn, MWMessage> {
    private static final MWMessage[] NO_MESSAGES = new MWMessage[0];
    private final Model<String> securityToken;
    private final DownloadService downloadService;
    private final SoftwareManagerBuilder softwareManagerBuilder;
    private final Model<ReleaseData[]> releaseDataModel;
    private final Downloader downloader;
    private final ProxyConfiguration proxyConfiguration;
    private IO io;

    GetUpdatesCallable(WizardUI wizardUI, ExceptionHandler exceptionHandler, String string, Model<String> model, DownloadService downloadService, SoftwareManagerBuilder softwareManagerBuilder, Model<ReleaseData[]> model2, Downloader downloader, ProxyConfiguration proxyConfiguration, IO iO, String string2) {
        super(wizardUI, exceptionHandler, string, string2);
        this.securityToken = model;
        this.downloadService = downloadService;
        this.softwareManagerBuilder = softwareManagerBuilder;
        this.releaseDataModel = model2;
        this.downloader = downloader;
        this.proxyConfiguration = proxyConfiguration;
        this.io = iO;
    }

    @Override
    protected int getResult(GetComponentsReturn getComponentsReturn) {
        return getComponentsReturn.getResult();
    }

    protected MWMessage[] getMessages(GetComponentsReturn getComponentsReturn) {
        MWMessage[] mWMessageArray = getComponentsReturn.getMessages();
        if (mWMessageArray == null) {
            return NO_MESSAGES;
        }
        return mWMessageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected GetComponentsReturn doCall(String string, String string2, String string3) throws IOException, InterruptedException {
        MyComponentURLProvider myComponentURLProvider = new MyComponentURLProvider(string2, string);
        for (ReleaseData releaseData : (ReleaseData[])this.releaseDataModel.get()) {
            File file = null;
            try {
                file = File.createTempFile("dwsZipFile", null);
                URL uRL = new URL(releaseData.getUrl());
                this.downloader.download(this.proxyConfiguration, uRL, file, new IOObserver[0]);
                myComponentURLProvider.setReleaseId(releaseData.getReleaseId());
                this.softwareManagerBuilder.addReleaseData(file, (ComponentURLProvider)myComponentURLProvider);
            }
            finally {
                this.io.deleteFile(file);
            }
        }
        return myComponentURLProvider.doCall();
    }

    @Override
    protected boolean shouldDisplayError(MWMessage mWMessage) {
        return true;
    }

    @Override
    protected Object[] getErrorArguments(MWMessage mWMessage) {
        return new Object[]{mWMessage.getCode(), mWMessage.getDescription()};
    }

    @Override
    protected void apply(GetComponentsReturn getComponentsReturn) {
    }

    private String getComponentPath(SoftwareComponentInfo softwareComponentInfo) {
        String string = softwareComponentInfo.getComponentId().getComponentName();
        if (string.contains("_doc_ja")) {
            return "doc_ja";
        }
        if (string.contains("_ko_KR")) {
            return "doc_ko";
        }
        if (string.contains("_zh_CN")) {
            return "doc_zh";
        }
        if (string.contains("_common")) {
            return "common";
        }
        if (string.contains("_glnxa64")) {
            return "glnxa64";
        }
        if (string.contains("_maci64")) {
            return "maci64";
        }
        if (string.contains("_win32")) {
            return "win32";
        }
        if (string.contains("_win64")) {
            return "win64";
        }
        return "";
    }

    private class MyComponentURLProvider
    implements ComponentURLProvider {
        private final String clientString;
        private final String localeString;
        private final Collection<ComponentId> componentIds = new ArrayList<ComponentId>();
        private final Map<String, String> componentIdToURLMap = new HashMap<String, String>();
        private String releaseId;

        MyComponentURLProvider(String string, String string2) {
            this.clientString = string;
            this.localeString = string2;
        }

        private GetComponentsReturn doCall() throws RemoteException {
            GetComponentsRequest getComponentsRequest = new GetComponentsRequest();
            getComponentsRequest.setClientString(this.clientString);
            getComponentsRequest.setLocale(this.localeString);
            getComponentsRequest.setSecurityToken((String)GetUpdatesCallable.this.securityToken.get());
            getComponentsRequest.setReleaseFamily(InstutilResourceKeys.RELEASE.getString(new Object[0]));
            if (!this.componentIds.isEmpty()) {
                getComponentsRequest.setComponentIds(this.componentIds.toArray(new ComponentId[this.componentIds.size()]));
            }
            GetComponentsReturn getComponentsReturn = GetUpdatesCallable.this.downloadService.getComponents(getComponentsRequest);
            SoftwareComponentInfo[] softwareComponentInfoArray = getComponentsReturn.getComponents();
            String string = System.getenv(ResourceKeys.MW_ARCHIVE_LOCATION.getString(new Object[0]));
            boolean bl = string != null && !string.isEmpty();
            for (SoftwareComponentInfo softwareComponentInfo : softwareComponentInfoArray) {
                File file;
                ComponentId componentId = softwareComponentInfo.getComponentId();
                String string2 = componentId.getComponentName();
                String string3 = componentId.getVersion();
                String string4 = softwareComponentInfo.getComponentUrl();
                if (bl && !(file = new File(string + File.separator + GetUpdatesCallable.this.getComponentPath(softwareComponentInfo) + File.separator + this.getKey(string2, string3) + ".enc")).isFile()) {
                    try {
                        string4 = file.toURI().toURL().toString();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                this.componentIdToURLMap.put(this.getKey(string2, string3), string4);
            }
            return getComponentsReturn;
        }

        public String getURL(String string, String string2) {
            return this.componentIdToURLMap.get(this.getKey(string, string2));
        }

        private String getKey(String string, String string2) {
            return string + "_" + string2;
        }

        public void add(String string, String string2) {
            ComponentId componentId = new ComponentId();
            componentId.setReleaseId(this.releaseId);
            componentId.setComponentName(string);
            componentId.setVersion(string2);
            this.componentIds.add(componentId);
        }

        public void setReleaseId(String string) {
            this.releaseId = string;
        }
    }
}

