/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.installwizard.command.AbstractCommandStep;
import com.mathworks.instutil.ProcessExecutorImpl;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class CollectUdcGpuInfoStep
extends AbstractCommandStep {
    public static final String GPU_EXECUTABLE = "gpu_info.exe";
    private final String arch;
    private final String matlabRoot;
    private final ExecutorService executorService;
    private final UsageDataCollector usageDataCollector;

    public CollectUdcGpuInfoStep(String string, String string2, ExecutorService executorService, UsageDataCollector usageDataCollector) {
        this.arch = string;
        this.matlabRoot = string2;
        this.executorService = executorService;
        this.usageDataCollector = usageDataCollector;
    }

    @Override
    boolean forwardVisitStep() {
        String string = File.separator + "bin" + File.separator + this.arch + File.separator + GPU_EXECUTABLE;
        FileSystem fileSystem = FileSystems.getDefault();
        Path path = fileSystem.getPath(this.matlabRoot, string);
        File file = path.toFile();
        try {
            if (file.exists() && file.canExecute()) {
                String[] stringArray = new String[]{file.toString()};
                List list = ProcessExecutorImpl.executeTaskWithOutput((String[])stringArray, (ExecutorService)this.executorService);
                this.usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_GPU_INFO, (Object)list);
            }
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_GPU_INFO_ERROR, (Object)string2);
        }
        return true;
    }
}

