/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install.AvailableProduct;
import com.mathworks.install.Installer;
import com.mathworks.installwizard.command.AbstractCommandStep;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.ui.MessageType;
import com.mathworks.wizard.ui.OptionType;
import com.mathworks.wizard.ui.Response;
import com.mathworks.wizard.ui.WizardUI;
import java.io.File;
import java.util.ArrayList;

final class CheckOverwritesForMCRStep
extends AbstractCommandStep {
    private final Installer install;
    private final DefaultedModel<String> folder;
    private final WizardUI ui;
    private static final String MCR_NAME = "MATLAB Runtime";

    CheckOverwritesForMCRStep(Installer installer, DefaultedModel<String> defaultedModel, WizardUI wizardUI) {
        this.install = installer;
        this.folder = defaultedModel;
        this.ui = wizardUI;
    }

    @Override
    void reverseVisitStep() {
        this.resetAvailableProducts();
    }

    @Override
    boolean forwardVisitStep() {
        this.resetAvailableProducts();
        File file = new File((String)this.folder.get());
        AvailableProduct[] availableProductArray = this.install.getSelectedProductsAlreadyInstalled(file);
        AvailableProduct[] availableProductArray2 = this.install.getIncompatibleProducts(file);
        if (availableProductArray2.length > 0) {
            return this.getResponseToIncompatibleProductsQuestion(availableProductArray2[0]);
        }
        Response response = this.processProductsToOverwrite(file, availableProductArray);
        if (Response.CANCEL.equals((Object)response)) {
            return false;
        }
        boolean bl = false;
        for (AvailableProduct availableProduct : this.install.getAvailableProducts()) {
            if (!availableProduct.canInstall()) continue;
            bl = true;
        }
        if (!bl) {
            this.ui.showErrorMessage(ResourceKeys.OVERWRITE_TITLE_NOPRODUCTS.getString(new Object[0]), ResourceKeys.OVERWRITE_MESSAGE_NOPRODUCTS.getString(new Object[0]));
            return false;
        }
        return true;
    }

    private Response processProductsToOverwrite(File file, AvailableProduct[] availableProductArray) {
        ArrayList<AvailableProduct> arrayList = new ArrayList<AvailableProduct>();
        Response response = Response.YES;
        if (availableProductArray != null && availableProductArray.length > 0) {
            AvailableProduct availableProduct = availableProductArray[0];
            response = this.getResponseToOverwriteQuestion();
            AvailableProduct availableProduct2 = this.getResponseToVersionQuestion(file, availableProduct, response);
            if (Response.CANCEL.equals((Object)availableProduct2)) {
                response = availableProduct2;
            } else if (Response.NO.equals((Object)availableProduct2)) {
                for (AvailableProduct availableProduct3 : availableProductArray) {
                    arrayList.add(availableProduct3);
                }
            }
        }
        for (AvailableProduct availableProduct2 : arrayList) {
            availableProduct2.setOverwrite(false);
        }
        return response;
    }

    private Response getResponseToVersionQuestion(File file, AvailableProduct availableProduct, Response response) {
        if (this.shouldDisplayVersionQuestion(file, availableProduct, response)) {
            return this.getResponseToVersionQuestion();
        }
        return response;
    }

    private boolean shouldDisplayVersionQuestion(File file, AvailableProduct availableProduct, Response response) {
        return (Response.YES.equals((Object)response) || Response.YES_TO_ALL.equals((Object)response)) && this.install.folderContainsNewerVersion(availableProduct, file);
    }

    private Response getResponseToVersionQuestion() {
        return this.ui.getResponseToQuestion(ResourceKeys.OVERWRITE_TITLE_WARNING.getString(new Object[0]), ResourceKeys.OVERWRITE_MESSAGE_VERSION.getString(MCR_NAME), MessageType.WARNING, OptionType.YES_NO_CANCEL);
    }

    private Response getResponseToOverwriteQuestion() {
        return this.ui.getResponseToQuestion(ResourceKeys.OVERWRITE_TITLE.getString(new Object[0]), ResourceKeys.MCR_OVERWRITE_MESSAGE.getString(MCR_NAME), MessageType.QUESTION, OptionType.OK_CANCEL);
    }

    private boolean getResponseToIncompatibleProductsQuestion(AvailableProduct availableProduct) {
        Response response = this.ui.getResponseToQuestion(ResourceKeys.OVERWRITE_TITLE_WARNING.getString(new Object[0]), ResourceKeys.OVERWRITE_MESSAGE_INCOMPATIBLE.getString(availableProduct.getName()), MessageType.QUESTION, OptionType.OK_CANCEL);
        return !response.equals((Object)Response.CANCEL);
    }

    private void resetAvailableProducts() {
        for (AvailableProduct availableProduct : this.install.getAvailableProducts()) {
            availableProduct.setOverwrite(true);
        }
    }
}

