/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install.Product;
import com.mathworks.install.ValidatedFik;
import com.mathworks.installwizard.command.AbstractWebServiceCallable;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.VersionUtils;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.internal.dws.client.DownloadService;
import com.mathworks.internal.dws.client.EntitledProduct;
import com.mathworks.internal.dws.client.GetReleaseDataRequest;
import com.mathworks.internal.dws.client.GetReleaseDataReturn;
import com.mathworks.internal.dws.client.MWMessage;
import com.mathworks.internal.dws.client.ReleaseData;
import com.mathworks.internal.mwaws.client.v6.MWAEntitlement;
import com.mathworks.wizard.ExceptionHandler;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.ui.WizardUI;
import java.io.IOException;
import java.util.Arrays;

final class CheckForUpdatesCallable
extends AbstractWebServiceCallable<GetReleaseDataReturn, MWMessage> {
    private static final MWMessage[] EMPTY_MESSAGE_ARRAY = new MWMessage[0];
    private static final ReleaseData[] NO_RELEASE_DATA = new ReleaseData[0];
    private static final EntitledProduct[] NO_ENTITLED_PRODUCTS = new EntitledProduct[0];
    private static final MWMessage[] NO_MESSAGES = new MWMessage[0];
    private final WizardUI wizardUI;
    private final String arch;
    private final DownloadService downloadService;
    private final Model<String> securityToken;
    private final Model<MWAEntitlement> entitlement;
    private final Model<Boolean> checkForUpdatesSwitch;
    private final Model<Boolean> getUpdatesSwitch;
    private final Model<ReleaseData[]> releaseDataModel;
    private final Model<ValidatedFik> validatedFikModel;
    private final AppLogger logger;

    CheckForUpdatesCallable(WizardUI wizardUI, ExceptionHandler exceptionHandler, String string, DownloadService downloadService, String string2, Model<String> model, Model<MWAEntitlement> model2, Model<Boolean> model3, Model<Boolean> model4, Model<ReleaseData[]> model5, Model<ValidatedFik> model6, AppLogger appLogger) {
        super(wizardUI, exceptionHandler, string, string2);
        this.wizardUI = wizardUI;
        this.arch = string2;
        this.downloadService = downloadService;
        this.securityToken = model;
        this.entitlement = model2;
        this.checkForUpdatesSwitch = model3;
        this.getUpdatesSwitch = model4;
        this.releaseDataModel = model5;
        this.validatedFikModel = model6;
        this.logger = appLogger;
    }

    @Override
    protected int getResult(GetReleaseDataReturn getReleaseDataReturn) {
        int n = 0;
        for (MWMessage mWMessage : this.getMessages(getReleaseDataReturn)) {
            if (mWMessage.getSeverity() != 1) continue;
            n = getReleaseDataReturn.getResult();
        }
        return n;
    }

    protected MWMessage[] getMessages(GetReleaseDataReturn getReleaseDataReturn) {
        MWMessage[] mWMessageArray = getReleaseDataReturn.getMessages();
        if (mWMessageArray == null) {
            return EMPTY_MESSAGE_ARRAY;
        }
        return mWMessageArray;
    }

    @Override
    protected GetReleaseDataReturn doCall(String string, String string2, String string3) throws IOException {
        try {
            GetReleaseDataRequest getReleaseDataRequest = new GetReleaseDataRequest();
            getReleaseDataRequest.setLocale(string);
            getReleaseDataRequest.setRelease(string3);
            getReleaseDataRequest.setClientString(string2);
            getReleaseDataRequest.setArchitecture(this.arch);
            getReleaseDataRequest.setToken((String)this.securityToken.get());
            getReleaseDataRequest.setEntitlementId(((MWAEntitlement)this.entitlement.get()).getId());
            return this.downloadService.getReleaseData(getReleaseDataRequest);
        }
        catch (Throwable throwable) {
            GetReleaseDataReturn getReleaseDataReturn = new GetReleaseDataReturn();
            getReleaseDataReturn.setResult(-1);
            getReleaseDataReturn.setReleaseData(NO_RELEASE_DATA);
            getReleaseDataReturn.setEntitledProducts(NO_ENTITLED_PRODUCTS);
            getReleaseDataReturn.setMessages(NO_MESSAGES);
            return getReleaseDataReturn;
        }
    }

    @Override
    protected boolean shouldDisplayError(MWMessage mWMessage) {
        return false;
    }

    @Override
    protected Object[] getErrorArguments(MWMessage mWMessage) {
        return new Object[]{mWMessage.getDescription()};
    }

    @Override
    protected void apply(GetReleaseDataReturn getReleaseDataReturn) {
        this.releaseDataModel.set((Object)getReleaseDataReturn.getReleaseData());
        if (Arrays.asList(getReleaseDataReturn.getEntitledProducts()).isEmpty()) {
            this.logger.logMsg("Empty EntitledProduct array. Disabling DWS.");
            this.checkForUpdatesSwitch.set((Object)false);
        } else if (Arrays.asList(getReleaseDataReturn.getReleaseData()).isEmpty()) {
            this.logger.logMsg("Empty ReleaseData array. Disabling DWS.");
            this.checkForUpdatesSwitch.set((Object)false);
        } else {
            this.checkForUpdatesSwitch.set((Object)true);
        }
        if (getReleaseDataReturn.getResult() == 0) {
            this.validatedFikModel.set((Object)new DWSEnabledValidatedFik((ValidatedFik)this.validatedFikModel.get(), getReleaseDataReturn.getEntitledProducts()));
        }
    }

    @Override
    protected void showMessageBySeverity(Object ... objectArray) {
        this.wizardUI.showErrorMessage(ResourceKeys.VERIFY_LOGIN_INFORMATION.getString(new Object[0]), this.getErrorDescription(objectArray));
    }

    private String getErrorDescription(Object[] objectArray) {
        return objectArray[0].toString();
    }

    @Override
    protected boolean shouldDisplayMessageBySeverity(MWMessage mWMessage) {
        boolean bl = false;
        if (mWMessage.getSeverity() == 1) {
            bl = true;
        }
        return bl;
    }

    private class DWSEnabledValidatedFik
    implements ValidatedFik {
        private final ValidatedFik inner;
        private final EntitledProduct[] entitledProducts;

        DWSEnabledValidatedFik(ValidatedFik validatedFik, EntitledProduct[] entitledProductArray) {
            this.inner = validatedFik;
            this.entitledProducts = (EntitledProduct[])entitledProductArray.clone();
        }

        public String get() {
            return this.inner.get();
        }

        public boolean canActivate() {
            return this.inner.canActivate();
        }

        public boolean canInstall(Product product, long l) {
            if (this.inner.canInstall(product, l) && (((Boolean)CheckForUpdatesCallable.this.getUpdatesSwitch.get()).booleanValue() || l == 0L)) {
                if (l == 0L) {
                    return true;
                }
                for (EntitledProduct entitledProduct : this.entitledProducts) {
                    if (entitledProduct.getBitNumber() != product.getProductNumber() || VersionUtils.compareVersionNumbers((String)entitledProduct.getVersion(), (String)product.getVersion()) <= -1) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        public boolean requiresLicenseFile() {
            return this.inner.requiresLicenseFile();
        }
    }
}

