/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.installwizard.command;

import com.mathworks.install.AvailableProduct;
import com.mathworks.install.ComponentData;
import com.mathworks.install.Downloader;
import com.mathworks.install.DownloaderBuilder;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallOptionType;
import com.mathworks.install.Installer;
import com.mathworks.install.InstallerBuilder;
import com.mathworks.install.InstallerRequirements;
import com.mathworks.install.InvalidFikException;
import com.mathworks.install.InvalidInstallationFolderException;
import com.mathworks.install.Product;
import com.mathworks.install.SoftwareManager;
import com.mathworks.install.SoftwareManagerBuilder;
import com.mathworks.install.ValidatedFik;
import com.mathworks.install.WrongReleaseFikException;
import com.mathworks.install.XMLParseException;
import com.mathworks.install.exception.InstallerRequirementNotSatisfiedException;
import com.mathworks.install.input.DownloadLocationUtility;
import com.mathworks.install.udc.UdcUtil;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.installwizard.command.AbstractCommandStep;
import com.mathworks.installwizard.command.AssociateSelfCallable;
import com.mathworks.installwizard.command.BuildSoftwareManagerCallable;
import com.mathworks.installwizard.command.CheckForUpdatesCallable;
import com.mathworks.installwizard.command.CheckForUpdatesInDownloadOnlyCallable;
import com.mathworks.installwizard.command.CheckIfOverwriteImpossibleStep;
import com.mathworks.installwizard.command.CheckOverwritesForMCRStep;
import com.mathworks.installwizard.command.CheckOverwritesStep;
import com.mathworks.installwizard.command.CheckProductFamilyAndVersionStep;
import com.mathworks.installwizard.command.CollectUdcCpuInfoStep;
import com.mathworks.installwizard.command.ConditionalCallable;
import com.mathworks.installwizard.command.ConnectToServicesCallable;
import com.mathworks.installwizard.command.CreateAccountCallable;
import com.mathworks.installwizard.command.DeleteDownloadedArchivesStep;
import com.mathworks.installwizard.command.DependencyChecker;
import com.mathworks.installwizard.command.GenerateEntitlementCallable;
import com.mathworks.installwizard.command.GetEntitlementByActivationKeyCallable;
import com.mathworks.installwizard.command.GetEntitlementByIdCallable;
import com.mathworks.installwizard.command.GetEntitlementsButAlwaysProceedCallable;
import com.mathworks.installwizard.command.GetEntitlementsCallable;
import com.mathworks.installwizard.command.GetInstallerInDownloadOnlyCallable;
import com.mathworks.installwizard.command.GetLanguageCodesForProfileCallable;
import com.mathworks.installwizard.command.GetUpdatesCallable;
import com.mathworks.installwizard.command.InstallCommandStepFactory;
import com.mathworks.installwizard.command.LaunchDeactivationStep;
import com.mathworks.installwizard.command.LoginCallable;
import com.mathworks.installwizard.command.MCRProductSelectionAndGetConfirmationTextStep;
import com.mathworks.installwizard.command.ValidateLicenseFileStep;
import com.mathworks.installwizard.model.InstallModelFactory;
import com.mathworks.installwizard.model.InstallWizardContext;
import com.mathworks.installwizard.resources.ResourceKeys;
import com.mathworks.instutil.AvailablePlatform;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.InstallerDownloadURLInfo;
import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.Machine;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.ProcessExecutor;
import com.mathworks.instutil.VersionUtils;
import com.mathworks.instutil.licensefiles.LModeSwitchingUtility;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.internal.dws.client.DownloadService;
import com.mathworks.internal.dws.client.EntitledProduct;
import com.mathworks.internal.dws.client.ReleaseData;
import com.mathworks.internal.mwaws.client.v6.ActivationService;
import com.mathworks.internal.mwaws.client.v6.ArrayOfString;
import com.mathworks.internal.mwaws.client.v6.MWAEntitlement;
import com.mathworks.mlwebservices.EntitlementUtility;
import com.mathworks.mlwebservices.LockingTypeConstants;
import com.mathworks.mlwebservices.loginws.LoginService;
import com.mathworks.net.hyperlink.HyperlinkProvider;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.wizard.ExceptionHandler;
import com.mathworks.wizard.ExitHandler;
import com.mathworks.wizard.ExitStatus;
import com.mathworks.wizard.PropertyKey;
import com.mathworks.wizard.SourcePathProvider;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.StepCallback;
import com.mathworks.wizard.command.ServiceTaskStep;
import com.mathworks.wizard.command.ServiceTaskStepForArchives;
import com.mathworks.wizard.command.TaskStep;
import com.mathworks.wizard.model.BackgroundTask;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.DefaultedModelImpl;
import com.mathworks.wizard.model.FileSystem;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ModelImpl;
import com.mathworks.wizard.model.PlatformModel;
import com.mathworks.wizard.model.ProductModel;
import com.mathworks.wizard.model.ProductTableFormat;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.CheckBoxConfiguration;
import com.mathworks.wizard.ui.MessageType;
import com.mathworks.wizard.ui.OptionType;
import com.mathworks.wizard.ui.Response;
import com.mathworks.wizard.ui.WizardUI;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import com.mathworks.wizard.worker.WorkerFactory;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

abstract class AbstractCommandStepFactory
implements InstallCommandStepFactory {
    protected final InstallerBuilder installerBuilder;
    protected final WizardUI wizardUI;
    protected final ExceptionHandler exceptionHandler;
    protected final ExecutorService executorService;
    protected final ExitHandler exitHandler;
    protected final LoginService loginService;
    protected final ActivationService activationService;
    protected final DownloadService downloadService;
    protected final String clientString;
    protected final String archString;
    protected final AppLogger logger;
    protected final Machine machine;
    protected final ArrayOfString controllingProducts;
    protected final InstallerRequirements installerRequirements;
    protected final InstallConfiguration installConfiguration;
    private final IO io;
    private final DependencyChecker dependencyChecker;
    private final WorkerFactory workerFactory;
    private final HyperlinkProvider hyperlinkProvider;
    protected final UsageDataCollector usageDataCollector;
    protected ProcessExecutor processExecutor;
    private com.mathworks.instutil.Downloader downloader;
    private ProxyConfiguration proxyConfiguration;

    AbstractCommandStepFactory(DownloadService downloadService, ActivationService activationService, ExecutorService executorService, InstallerBuilder installerBuilder, ExitHandler exitHandler, String string, WizardUI wizardUI, ExceptionHandler exceptionHandler, AppLogger appLogger, String string2, String[] stringArray, Machine machine, LoginService loginService, IO iO, DependencyChecker dependencyChecker, InstallerRequirements installerRequirements, WorkerFactory workerFactory, InstallConfiguration installConfiguration, HyperlinkProvider hyperlinkProvider, com.mathworks.instutil.Downloader downloader, ProxyConfiguration proxyConfiguration, ProcessExecutor processExecutor, UsageDataCollector usageDataCollector) {
        this.downloadService = downloadService;
        this.activationService = activationService;
        this.executorService = executorService;
        this.installerBuilder = installerBuilder;
        this.exitHandler = exitHandler;
        this.archString = string;
        this.wizardUI = wizardUI;
        this.exceptionHandler = exceptionHandler;
        this.logger = appLogger;
        this.clientString = string2;
        this.machine = machine;
        this.loginService = loginService;
        this.io = iO;
        this.dependencyChecker = dependencyChecker;
        this.installerRequirements = installerRequirements;
        this.workerFactory = workerFactory;
        this.installConfiguration = installConfiguration;
        this.hyperlinkProvider = hyperlinkProvider;
        this.downloader = downloader;
        this.proxyConfiguration = proxyConfiguration;
        this.processExecutor = processExecutor;
        this.usageDataCollector = usageDataCollector;
        this.controllingProducts = new ArrayOfString();
        for (String string3 : stringArray) {
            this.controllingProducts.addItem(string3);
        }
    }

    private static String buildProductListString(Product[] productArray, SoftwareManager softwareManager) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (Product product : productArray) {
            if (AbstractCommandStepFactory.isAvailable(product, (Product[])softwareManager.getAvailableProducts())) {
                stringBuilder.append(System.getProperty("line.separator")).append(product.getName()).append(' ').append(product.getVersion());
                continue;
            }
            stringBuilder2.append(System.getProperty("line.separator")).append(ResourceKeys.DEPENDENCIES_UNAVAILABLE.getString(product.getName() + ' ' + product.getVersion()));
        }
        return stringBuilder.append((CharSequence)stringBuilder2).toString();
    }

    private static boolean isAvailable(Product product, Product[] productArray) {
        for (Product product2 : productArray) {
            if (product2.getProductNumber() != product.getProductNumber() || VersionUtils.compareVersionNumbers((String)product2.getVersion(), (String)product.getVersion()) <= -1) continue;
            return true;
        }
        return false;
    }

    @Override
    public Step createIsIncrementalInstallationStep(final List<Integer> list, final DefaultedModel<String> defaultedModel, final Installer installer, final Model<Boolean> model) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                model.set((Object)false);
                for (AvailableProduct availableProduct : installer.getAvailableProducts()) {
                    availableProduct.setSelected(true);
                    availableProduct.setOverwrite(true);
                }
                ArrayList arrayList = new ArrayList();
                AvailableProduct[] availableProductArray = installer.getSelectedProductsAlreadyInstalled(new File((String)defaultedModel.get()));
                for (AvailableProduct availableProduct : availableProductArray) {
                    arrayList.add(availableProduct.getProductNumber());
                }
                if (arrayList.size() != 0) {
                    for (Integer n : list) {
                        if (arrayList.contains(n)) continue;
                        model.set((Object)true);
                    }
                }
                return true;
            }
        };
    }

    @Override
    public final Step createMCRProductSelectionAndGetConfirmationTextStep(Installer installer, DefaultedModel<String> defaultedModel, InstallWizardContext installWizardContext, Model<Boolean> model, List<Integer> list, String string, Model<File> model2, FileSystem fileSystem, Model<Boolean> model3, Model<String> model4) {
        return new MCRProductSelectionAndGetConfirmationTextStep(installer, defaultedModel, installWizardContext, model, list, string, model2, fileSystem, model3, model4);
    }

    @Override
    public final Step createStartReadingArchivesStep(final File[] fileArray) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                AbstractCommandStepFactory.this.installerBuilder.startReadingArchives(fileArray);
                return true;
            }
        };
    }

    @Override
    public Step createStartReadingDownloadFolderArchives(final DefaultedModel<File> defaultedModel, final Model<DownloaderBuilder> model, final DownloaderBuilder downloaderBuilder) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                downloaderBuilder.startReadingArchives(new File[]{DownloadLocationUtility.getPathForReadingArchives((File)((File)defaultedModel.get()))});
                model.set((Object)downloaderBuilder);
                return true;
            }
        };
    }

    @Override
    public final Step createAddDWSArchivesInDestinationStep(final DefaultedModel<File> defaultedModel, final Installer installer, final ValidatedFik validatedFik) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                AbstractCommandStepFactory.this.installerBuilder.addArchives(new File[]{(File)defaultedModel.get()}, installer, validatedFik);
                return true;
            }
        };
    }

    @Override
    public final Step createDeleteDWSArchivesStep(final Model<File> model, final Model<CheckBoxConfiguration> model2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                if (CheckBoxConfiguration.SELECTED.equals(model2.get())) {
                    try {
                        AbstractCommandStepFactory.this.io.deleteDirectory((File)model.get());
                    }
                    catch (IOException iOException) {
                        AbstractCommandStepFactory.this.exceptionHandler.handleException((Throwable)iOException);
                    }
                }
                return true;
            }
        };
    }

    @Override
    public Step createErrorIfNotEnoughAvailableInstallSpaceStep(final Model<FileSystem> model, final Model<String> model2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                try {
                    FileSystem fileSystem = (FileSystem)model.get();
                    long l = fileSystem.getMegabytesRequired();
                    if (fileSystem.getMegabytesAvailable() < l) {
                        String string = ResourceKeys.TITLE_INSTALLSPACE.getString(new Object[0]);
                        String string2 = ResourceKeys.DRIVESPACE_ERROR.getString("Installation", model2.get(), l);
                        AbstractCommandStepFactory.this.wizardUI.showErrorMessage(string, string2);
                        return false;
                    }
                    return true;
                }
                catch (IOException iOException) {
                    AbstractCommandStepFactory.this.exceptionHandler.handleException((Throwable)iOException);
                    return false;
                }
            }
        };
    }

    @Override
    public Step createErrorIfNotEnoughAvailableDownloadSpaceStep(final Model<FileSystem> model, final Model<String> model2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                try {
                    FileSystem fileSystem = (FileSystem)model.get();
                    long l = fileSystem.getMegabytesToDownload();
                    if (fileSystem.getMegabytesAvailable() < l) {
                        String string = ResourceKeys.TITLE_INSTALLSPACE.getString(new Object[0]);
                        String string2 = ResourceKeys.DRIVESPACE_ERROR.getString("Download", model2.get(), l);
                        AbstractCommandStepFactory.this.wizardUI.showErrorMessage(string, string2);
                        return false;
                    }
                    return true;
                }
                catch (IOException iOException) {
                    AbstractCommandStepFactory.this.exceptionHandler.handleException((Throwable)iOException);
                    return false;
                }
            }
        };
    }

    @Override
    public final Step createWarnIfNotEnoughAvailableSpaceStep(final FileSystem fileSystem) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                try {
                    if (fileSystem.getMegabytesAvailable() < fileSystem.getMegabytesRequired()) {
                        String string = ResourceKeys.TITLE_INSTALLSPACE.getString(new Object[0]);
                        String string2 = ResourceKeys.OPTION_INSTALLSPACE.getString(new Object[0]);
                        return AbstractCommandStepFactory.this.wizardUI.getResponseToYesNoQuestion(string, string2, MessageType.WARNING);
                    }
                    return true;
                }
                catch (IOException iOException) {
                    AbstractCommandStepFactory.this.exceptionHandler.handleException((Throwable)iOException);
                    return false;
                }
            }
        };
    }

    @Override
    public final Step createWarnIfNotEnoughAvailableDownloadSpaceStep(final FileSystem fileSystem, final String string) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                try {
                    if (fileSystem.getMegabytesAvailable() < fileSystem.getMegabytesToDownload()) {
                        String string3 = ResourceKeys.TITLE_INSTALLSPACE.getString(new Object[0]);
                        String string2 = ResourceKeys.OPTION_INSUFFICIENT_DOWNLOADSPACE.getString(string);
                        return AbstractCommandStepFactory.this.wizardUI.getResponseToYesNoQuestion(string3, string2, MessageType.WARNING);
                    }
                    return true;
                }
                catch (IOException iOException) {
                    AbstractCommandStepFactory.this.exceptionHandler.handleException((Throwable)iOException);
                    return false;
                }
            }
        };
    }

    @Override
    public Step createCheckIfAllProductsDownloaded(final Model<Downloader> model, final DefaultedModel<File> defaultedModel) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                if (((Downloader)model.get()).getDownloadSize((File)defaultedModel.get()) == 0L) {
                    AbstractCommandStepFactory.this.wizardUI.showErrorMessage(WizardResourceKeys.PRODUCTS_ALREADY_DOWNLOADED_TITLE.getString(new Object[0]), WizardResourceKeys.ALL_PRODUCTS_ALREADY_DOWNLOADED.getString(new Object[]{defaultedModel.get()}));
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public final Step createVerifyRootDirectoryStep(final DefaultedModel<String> defaultedModel) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                return AbstractCommandStepFactory.this.verifyRootDirectory((DefaultedModel<String>)defaultedModel);
            }
        };
    }

    private boolean verifyRootDirectory(DefaultedModel<String> defaultedModel) {
        String string = (String)defaultedModel.get();
        return this.io.isAbsolute(string) || this.showFolderError(ResourceKeys.DIRECTORY_INVALID_DRIVE.getString(string));
    }

    @Override
    public final Step createVerifyDownloadRootDirectoryStep(final DefaultedModel<File> defaultedModel) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                return AbstractCommandStepFactory.this.verifyRootDirectory((DefaultedModel<String>)AbstractCommandStepFactory.this.createDownloadFolder((DefaultedModel<File>)defaultedModel));
            }
        };
    }

    private boolean showFolderError(String string) {
        String string2 = ResourceKeys.FOLDER_ERROR.getString(new Object[0]);
        this.wizardUI.showErrorMessage(string2, string);
        return false;
    }

    private boolean showFolderAccessError(String string) {
        this.wizardUI.showErrorMessage(ResourceKeys.FOLDER_CANNOT_WRITE_TITLE.getString(new Object[0]), string);
        return false;
    }

    @Override
    public final Step createCheckWritePermissionsStep(final DefaultedModel<String> defaultedModel) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                return AbstractCommandStepFactory.this.checkWritePermissions((DefaultedModel<String>)defaultedModel);
            }
        };
    }

    private boolean checkWritePermissions(DefaultedModel<String> defaultedModel) {
        String string = (String)defaultedModel.get();
        return this.io.canWriteToFolder(string) || this.showFolderAccessError(ResourceKeys.FOLDER_CANNOT_WRITE.getString(string));
    }

    @Override
    public final Step createCheckWritePermissionsForDownloadFolderStep(final DefaultedModel<File> defaultedModel) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                return AbstractCommandStepFactory.this.checkWritePermissions((DefaultedModel<String>)AbstractCommandStepFactory.this.createDownloadFolder((DefaultedModel<File>)defaultedModel));
            }
        };
    }

    @Override
    public final Step createCheckPathForExistenceStep(final DefaultedModel<String> defaultedModel) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                String string = (String)defaultedModel.get();
                if (AbstractCommandStepFactory.this.io.exists(string)) {
                    return true;
                }
                String string2 = ResourceKeys.DIRECTORY_TITLE.getString(new Object[0]);
                return AbstractCommandStepFactory.this.wizardUI.getResponseToYesNoQuestion(string2, ResourceKeys.FOLDER_CREATE_LABEL.getString(string), MessageType.QUESTION);
            }
        };
    }

    @Override
    public final Step createCreateFolderIfItDoesNotAlreadyExistStep(final DefaultedModel<String> defaultedModel) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                return AbstractCommandStepFactory.this.createFolderIfItDoesNotAlreadyExist((DefaultedModel<String>)defaultedModel);
            }
        };
    }

    private boolean createFolderIfItDoesNotAlreadyExist(DefaultedModel<String> defaultedModel) {
        String string = (String)defaultedModel.get();
        this.logger.debugMsg("Creating folder " + string);
        return this.io.mkdirs(string) || this.showFolderError(ResourceKeys.FOLDER_FAILED.getString(string));
    }

    @Override
    public final Step createDownloadFolderIfItDoesNotAlreadyExistStep(final DefaultedModel<File> defaultedModel) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                DefaultedModelImpl<String> defaultedModelImpl = AbstractCommandStepFactory.this.createDownloadFolder((DefaultedModel<File>)defaultedModel);
                return AbstractCommandStepFactory.this.createFolderIfItDoesNotAlreadyExist((DefaultedModel<String>)defaultedModelImpl);
            }
        };
    }

    @Override
    public final Step createCheckPathForNonEnglishCharactersStep(final DefaultedModel<String> defaultedModel) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                String string = (String)defaultedModel.get();
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (!this.isNonEnglishCharacter(c)) continue;
                    String string2 = ResourceKeys.FOLDER_ERROR.getString(new Object[0]);
                    String string3 = ResourceKeys.FOLDER_NON_ENGLISH.getString(new Object[0]);
                    AbstractCommandStepFactory.this.wizardUI.showErrorMessage(string2, string3);
                    return false;
                }
                return true;
            }

            private boolean isNonEnglishCharacter(char c) {
                return c < ' ' || c > '~';
            }
        };
    }

    @Override
    public final Step createLoadNativeLibrariesStep(final String string) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                try {
                    AbstractCommandStepFactory.this.installerBuilder.loadNativeLibrary(string);
                    return true;
                }
                catch (JNIException jNIException) {
                    AbstractCommandStepFactory.this.wizardUI.showErrorMessage(ResourceKeys.ERROR_NATIVE_LIBRARY_TITLE.getString(new Object[0]), ResourceKeys.ERROR_NATIVE_LIBRARY_MESSAGE.getString(new Object[0]));
                    return false;
                }
            }
        };
    }

    @Override
    public final Step createBuildInstallerStep(final Model<ValidatedFik> model, final Model<Installer> model2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                Installer installer = AbstractCommandStepFactory.this.installerBuilder.buildInstaller((ValidatedFik)model.get());
                model2.set((Object)installer);
                return true;
            }
        };
    }

    @Override
    public final Step createBuildDownloaderStep(final Model<DownloaderBuilder> model, final Model<Downloader> model2, final Model<InstallerDownloadURLInfo[]> model3, final Model<EntitledProduct[]> model4) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                Downloader downloader = ((DownloaderBuilder)model.get()).buildDownloader((InstallerDownloadURLInfo[])model3.get(), (EntitledProduct[])model4.get());
                model2.set((Object)downloader);
                return true;
            }
        };
    }

    @Override
    public final Step createBuildLightweightDownloaderStep(final Model<DownloaderBuilder> model, final Model<Downloader> model2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                Downloader downloader = ((DownloaderBuilder)model.get()).buildDownloader();
                model2.set((Object)downloader);
                return true;
            }
        };
    }

    @Override
    public final Step createFinishReadingArchivesStep() {
        return this.finishReadingLocalArchives((SoftwareManagerBuilder)this.installerBuilder);
    }

    private Step finishReadingLocalArchives(SoftwareManagerBuilder softwareManagerBuilder) {
        if (softwareManagerBuilder.isFinishedReadingArchives()) {
            return new AbstractCommandStep(){

                @Override
                boolean forwardVisitStep() {
                    return true;
                }
            };
        }
        if (this.installConfiguration.displayAssemblingProductProgressDialog()) {
            return this.createServiceTaskStepsWithServiceDialog(new BuildSoftwareManagerCallable(softwareManagerBuilder, this.exceptionHandler, this.wizardUI), ResourceKeys.ARCHIVES_TITLE.getString(new Object[0]), ResourceKeys.ARCHIVES_MESSAGE.getString(new Object[0]));
        }
        return this.createServiceTaskStep(new BuildSoftwareManagerCallable(softwareManagerBuilder, this.exceptionHandler, this.wizardUI), ResourceKeys.ARCHIVES_TITLE.getString(new Object[0]), ResourceKeys.ARCHIVES_MESSAGE.getString(new Object[0]));
    }

    @Override
    public Step createFinishReadingDownloadFolderArchives(Model<DownloaderBuilder> model) {
        return this.finishReadingLocalArchives((SoftwareManagerBuilder)model.get());
    }

    @Override
    public Step createCheckForFolderConflictStep(final DefaultedModel<String> defaultedModel) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                String string = AbstractCommandStepFactory.this.installConfiguration.getInstallationPath((String)defaultedModel.getDefault());
                String string2 = (String)defaultedModel.get();
                if (!string2.equalsIgnoreCase(string)) {
                    AbstractCommandStepFactory.this.wizardUI.showErrorMessage(ResourceKeys.INSTALLALERT_TITLE.getString(new Object[0]), ResourceKeys.ERROR_INVALID_DESTINATION_FOLDER.getString(string2, string));
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public Step createCheckInstallerRequirementsStep() {
        return new Step(){

            public void reverseVisitStep(StepCallback stepCallback) {
                stepCallback.stepBack();
            }

            public void forwardVisitStep(StepCallback stepCallback) {
                try {
                    AbstractCommandStepFactory.this.installConfiguration.checkInstallerRequirements(AbstractCommandStepFactory.this.installerRequirements);
                    stepCallback.stepForward();
                }
                catch (InstallerRequirementNotSatisfiedException installerRequirementNotSatisfiedException) {
                    AbstractCommandStepFactory.this.handleInstallerRequirementNotSatisfiedException(stepCallback, installerRequirementNotSatisfiedException);
                }
            }
        };
    }

    private void handleInstallerRequirementNotSatisfiedException(StepCallback stepCallback, InstallerRequirementNotSatisfiedException installerRequirementNotSatisfiedException) {
        switch (installerRequirementNotSatisfiedException.getExceptionLevel()) {
            case SEVERE: {
                this.wizardUI.showErrorMessage(installerRequirementNotSatisfiedException.getTitle(), installerRequirementNotSatisfiedException.getMessage());
                this.exitHandler.exit(ExitStatus.FAILED);
                break;
            }
            case ERROR: {
                this.wizardUI.showErrorMessage(installerRequirementNotSatisfiedException.getTitle(), installerRequirementNotSatisfiedException.getMessage());
                stepCallback.stepBack();
                break;
            }
            default: {
                if (this.wizardUI.showWarningMessage(installerRequirementNotSatisfiedException.getTitle(), installerRequirementNotSatisfiedException.getMessage())) {
                    stepCallback.stepForward();
                    break;
                }
                stepCallback.stepBack();
            }
        }
    }

    @Override
    public Step createCheckUninstallerRequirementsStep() {
        return new Step(){

            public void reverseVisitStep(StepCallback stepCallback) {
                stepCallback.stepBack();
            }

            public void forwardVisitStep(StepCallback stepCallback) {
                try {
                    AbstractCommandStepFactory.this.installConfiguration.checkUninstallerRequirements(AbstractCommandStepFactory.this.installerRequirements);
                    stepCallback.stepForward();
                }
                catch (InstallerRequirementNotSatisfiedException installerRequirementNotSatisfiedException) {
                    AbstractCommandStepFactory.this.handleInstallerRequirementNotSatisfiedException(stepCallback, installerRequirementNotSatisfiedException);
                }
            }
        };
    }

    @Override
    public final Step createLicenseAgreementStep(PanelStepBuilder panelStepBuilder, Model<Boolean> model) {
        if (this.installConfiguration.requiresLicenseAgreement()) {
            try {
                URL uRL = this.installConfiguration.getLicenseAgreementURL();
                String string = this.io.getResourceFromFile(uRL);
                return panelStepBuilder.buildLicenseAgreementStep(model, string);
            }
            catch (IOException iOException) {
                return new AbstractCommandStep(){

                    @Override
                    boolean forwardVisitStep() {
                        AbstractCommandStepFactory.this.exceptionHandler.unwindAndExit((Throwable)iOException);
                        return false;
                    }
                };
            }
        }
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                return true;
            }
        };
    }

    @Override
    public final Step createLoadFileListDataStep(final File file) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                try {
                    AbstractCommandStepFactory.this.installerBuilder.loadFileListData(file);
                }
                catch (XMLParseException | IOException | InterruptedException | ExecutionException throwable) {
                    AbstractCommandStepFactory.this.exceptionHandler.unwindAndExit(throwable);
                }
                return true;
            }
        };
    }

    @Override
    public final Step createBuildUninstallerStep(final SourcePathProvider sourcePathProvider, final Model<Installer> model) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                try {
                    model.set((Object)AbstractCommandStepFactory.this.installerBuilder.buildInstallerForUninstaller(new File(sourcePathProvider.getSourcePath())));
                    return true;
                }
                catch (InvalidInstallationFolderException invalidInstallationFolderException) {
                    AbstractCommandStepFactory.this.wizardUI.showErrorMessage(ResourceKeys.ERROR_UNINSTALL_NOPRODUCTS_TITLE.getString(new Object[0]), invalidInstallationFolderException.getMessage());
                    return false;
                }
            }
        };
    }

    @Override
    public final Step createCheckControllingProductsStep(final Installer installer, final DefaultedModel<String> defaultedModel) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                File file = new File((String)defaultedModel.get());
                Product[] productArray = AbstractCommandStepFactory.this.dependencyChecker.checkMissingControllingProducts(installer.getDependencies(), installer.getDependencySatisfiers(file));
                if (productArray.length > 0) {
                    AbstractCommandStepFactory.this.wizardUI.showErrorMessage(ResourceKeys.DEPENDENCIES_TITLE.getString(new Object[0]), ResourceKeys.CONTROLLING_PRODUCTS_MESSAGE.getString(AbstractCommandStepFactory.buildProductListString(productArray, (SoftwareManager)installer)));
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public final Step createCheckProductDependenciesStep(final SoftwareManager softwareManager, final DefaultedModel<String> defaultedModel) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                File file = new File((String)defaultedModel.get());
                Product[] productArray = AbstractCommandStepFactory.this.dependencyChecker.checkMissingRequiredProducts(softwareManager.getDependencies(), softwareManager.getDependencySatisfiers(file));
                if (productArray.length > 0) {
                    String string = ResourceKeys.DEPENDENCIES_MESSAGE.getString(AbstractCommandStepFactory.buildProductListString(productArray, softwareManager));
                    Response response = AbstractCommandStepFactory.this.wizardUI.getResponseToQuestion(ResourceKeys.DEPENDENCIES_TITLE.getString(new Object[0]), string, MessageType.WARNING, OptionType.DEFAULT_NO_YES_NO);
                    return response.equals((Object)Response.NO);
                }
                return true;
            }
        };
    }

    @Override
    public final Step createCheckUninstallerProductDependenciesStep(final Installer installer, final File file) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                Product[] productArray = installer.getProductsThatDependOnProductsToBeUninstalled(file);
                if (productArray.length > 0) {
                    String string = ResourceKeys.DEPENDENCIES_MESSAGE_UNINSTALL.getString(AbstractCommandStepFactory.buildProductListString(productArray, (SoftwareManager)installer));
                    Response response = AbstractCommandStepFactory.this.wizardUI.getResponseToQuestion(ResourceKeys.DEPENDENCIES_TITLE.getString(new Object[0]), string, MessageType.WARNING, OptionType.DEFAULT_NO_YES_NO);
                    return response.equals((Object)Response.NO);
                }
                return true;
            }
        };
    }

    @Override
    public Step createCheckUninstallerControllingProductStep(final Installer installer, final File file) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                Product[] productArray = installer.getProductsThatDependOnProductsToBeUninstalled(file);
                if (productArray.length > 0) {
                    for (AvailableProduct availableProduct : installer.getSelectedAvailableProducts()) {
                        if (!availableProduct.isControlling()) continue;
                        AbstractCommandStepFactory.this.wizardUI.showErrorMessage(ResourceKeys.DEPENDENCIES_TITLE.getString(new Object[0]), ResourceKeys.UNINSTALLER_CONTROLLING_PRODUCTS_MESSAGE.getString(AbstractCommandStepFactory.buildProductListString(productArray, (SoftwareManager)installer), availableProduct.getName() + ' ' + availableProduct.getVersion()));
                        return false;
                    }
                }
                return true;
            }
        };
    }

    @Override
    public final Step createLaunchActivatorStep(final Model<CheckBoxConfiguration> model, final Properties properties) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                if (CheckBoxConfiguration.SELECTED.equals(model.get())) {
                    this.launchActivationApplication();
                }
                return true;
            }

            private void launchActivationApplication() {
                AbstractCommandStepFactory.this.executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        AbstractCommandStepFactory.this.installConfiguration.activateInstallation(properties);
                    }
                });
            }
        };
    }

    @Override
    public final Step createCloseUIStep() {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                AbstractCommandStepFactory.this.wizardUI.closeAndDispose();
                return true;
            }
        };
    }

    @Override
    public Step createApplyInstallationOptionSelection(final Model<Installer> model, final Model<InstallOption[]> model2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                ((Installer)model.get()).setInstallOptions((InstallOption[])model2.get());
                return true;
            }
        };
    }

    @Override
    public final Step createApplyInstallationOptionSelection(final Installer installer, final InstallOption[] installOptionArray) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                installer.setInstallOptions(installOptionArray);
                return true;
            }
        };
    }

    @Override
    public final Step createRunTaskStep(Step step, BackgroundTask backgroundTask) {
        return new TaskStep(step, (Callable)backgroundTask, this.exitHandler, this.workerFactory);
    }

    @Override
    public final Step createConnectToServicesStep() {
        ConnectToServicesCallable connectToServicesCallable = new ConnectToServicesCallable(this.wizardUI, this.exceptionHandler, this.clientString, this.executorService, this.loginService, this.activationService, this.downloadService, this.usageDataCollector, this.archString);
        return this.createServiceTaskStep(connectToServicesCallable, WizardResourceKeys.SERVICE_TITLE.getString(new Object[0]));
    }

    @Override
    public final Step createProxyConnectToServicesStep() {
        ConnectToServicesCallable connectToServicesCallable = new ConnectToServicesCallable(this.wizardUI, this.exceptionHandler, this.clientString, this.executorService, this.loginService, this.activationService, this.downloadService, WizardResourceKeys.PROXY_ERROR_TITLE.getString(new Object[0]), WizardResourceKeys.PROXY_ERROR_MESSAGE.getString(new Object[0]), this.usageDataCollector);
        return this.createServiceTaskStepsWithServiceDialog(connectToServicesCallable, WizardResourceKeys.SERVICE_TITLE.getString(new Object[0]), WizardResourceKeys.SERVICE_PROXY_MESSAGE.getString(new Object[0]));
    }

    @Override
    public final Step createLoginStep(Model<String> model, Model<String> model2, Model<String> model3) {
        LoginCallable loginCallable = new LoginCallable(this.wizardUI, this.exceptionHandler, this.clientString, this.loginService, model, model2, model3, this.archString);
        return this.createServiceTaskStep(loginCallable, WizardResourceKeys.SERVICE_LOGIN_MESSAGE.getString(new Object[0]));
    }

    @Override
    public Step createGenerateEntitlementStep(Model<String> model, Collection<String> collection, String string, Model<MWAEntitlement> model2) {
        GenerateEntitlementCallable generateEntitlementCallable = new GenerateEntitlementCallable(this.wizardUI, this.exceptionHandler, this.clientString, model, this.activationService, collection, model2, this.archString, string);
        return this.createServiceTaskStep(generateEntitlementCallable, WizardResourceKeys.SERVICE_ENTITLEMENT_MESSAGE.getString(new Object[0]));
    }

    @Override
    public final Step createGetEntitlementsStep(Model<String> model, Model<MWAEntitlement[]> model2, Model<String> model3) {
        GetEntitlementsCallable getEntitlementsCallable = new GetEntitlementsCallable(this.wizardUI, this.exceptionHandler, this.clientString, model, this.activationService, this.controllingProducts, model2, model3, this.archString);
        return this.createServiceTaskStep(getEntitlementsCallable, WizardResourceKeys.SERVICE_ENTITLEMENT_MESSAGE.getString(new Object[0]));
    }

    @Override
    public final Step createShowExcessEntitlementsErrorStep(final Model<String> model) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                if (!((String)model.get()).isEmpty()) {
                    AbstractCommandStepFactory.this.wizardUI.showErrorMessage("Service Error", (String)model.get());
                }
                return true;
            }
        };
    }

    @Override
    public final Step createAssociateSelfStep(Model<String> model, Model<String> model2) {
        AssociateSelfCallable associateSelfCallable = new AssociateSelfCallable(this.wizardUI, this.exceptionHandler, this.clientString, this.activationService, model, model2, this.logger, this.archString);
        return this.createServiceTaskStep(associateSelfCallable, WizardResourceKeys.SERVICE_ENTITLEMENT_MESSAGE.getString(new Object[0]));
    }

    @Override
    public final Step createGetEntitlementsButAlwaysProceedStep(Model<String> model, Model<MWAEntitlement[]> model2) {
        GetEntitlementsButAlwaysProceedCallable getEntitlementsButAlwaysProceedCallable = new GetEntitlementsButAlwaysProceedCallable(new GetEntitlementsCallable(this.wizardUI, this.exceptionHandler, this.clientString, model, this.activationService, this.controllingProducts, model2, (Model<String>)new ModelImpl((Object)""), this.archString), model);
        return this.createServiceTaskStep(getEntitlementsButAlwaysProceedCallable, WizardResourceKeys.SERVICE_ENTITLEMENT_MESSAGE.getString(new Object[0]));
    }

    @Override
    public final Step createGetEntitlementByActivationKeyStep(Model<String> model, Model<String> model2, Model<MWAEntitlement> model3) {
        GetEntitlementByActivationKeyCallable getEntitlementByActivationKeyCallable = new GetEntitlementByActivationKeyCallable(this.wizardUI, this.exceptionHandler, this.clientString, this.activationService, model, this.controllingProducts, model2, model3, this.archString);
        return this.createServiceTaskStep(getEntitlementByActivationKeyCallable, WizardResourceKeys.SERVICE_ENTITLEMENT_MESSAGE.getString(new Object[0]));
    }

    @Override
    public final Step createCheckForUpdatesStep(Model<Boolean> model, Model<Boolean> model2, Model<String> model3, Model<MWAEntitlement> model4, Model<ReleaseData[]> model5, Model<ValidatedFik> model6, Model<Boolean> model7) {
        CheckForUpdatesCallable checkForUpdatesCallable = new CheckForUpdatesCallable(this.wizardUI, this.exceptionHandler, this.clientString, this.downloadService, this.archString, model3, model4, model, model2, model5, model6, this.logger);
        return this.createServiceTaskStep(new ConditionalCallable(model7, checkForUpdatesCallable), ResourceKeys.SERVICE_DWS_CHECK_MESSAGE.getString(new Object[0]));
    }

    @Override
    public final Step createCheckForUpdatesInDownloadOnlyStep(Model<Boolean> model, Model<String> model2, Model<ReleaseData[]> model3, Model<EntitledProduct[]> model4, PlatformModel<AvailablePlatform> platformModel) {
        CheckForUpdatesInDownloadOnlyCallable checkForUpdatesInDownloadOnlyCallable = new CheckForUpdatesInDownloadOnlyCallable(this.wizardUI, this.exceptionHandler, this.clientString, this.downloadService, model2, model, model3, this.logger, model4, platformModel, this.archString);
        return this.createServiceTaskStep(checkForUpdatesInDownloadOnlyCallable, ResourceKeys.SERVICE_DWS_CHECK_MESSAGE.getString(new Object[0]));
    }

    @Override
    public final Step createGetUpdatesStep(Model<String> model, Model<Boolean> model2, Model<ReleaseData[]> model3) {
        return this.getUpdatesStep(model, model2, model3, (SoftwareManagerBuilder)this.installerBuilder);
    }

    private Step getUpdatesStep(Model<String> model, Model<Boolean> model2, Model<ReleaseData[]> model3, SoftwareManagerBuilder softwareManagerBuilder) {
        GetUpdatesCallable getUpdatesCallable = new GetUpdatesCallable(this.wizardUI, this.exceptionHandler, this.clientString, model, this.downloadService, softwareManagerBuilder, model3, this.downloader, this.proxyConfiguration, this.io, this.archString);
        return this.createServiceTaskStep(new ConditionalCallable(model2, getUpdatesCallable), ResourceKeys.SERVICE_DWS_UDPATE_MESSAGE.getString(new Object[0]));
    }

    @Override
    public final Step createGetUpdatesInDownloadOnlyFlowStep(Model<String> model, Model<Boolean> model2, Model<ReleaseData[]> model3, Model<DownloaderBuilder> model4) {
        return this.getUpdatesStep(model, model2, model3, (SoftwareManagerBuilder)model4.get());
    }

    @Override
    public final Step createGetInstallerNameForSelectedPlatforms(final Model<DownloaderBuilder> model, final PlatformModel<AvailablePlatform> platformModel, final Model<String[]> model2, final Model<Boolean> model3) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (((Boolean)model3.get()).booleanValue()) {
                    String[] stringArray = ((DownloaderBuilder)model.get()).getAllInstallerNames();
                    for (String string : platformModel.getSelectedPlatforms()) {
                        for (String string2 : stringArray) {
                            if (!string2.contains(string) || !string2.endsWith(".zip")) continue;
                            arrayList.add(string2);
                        }
                    }
                }
                model2.set((Object)arrayList.toArray(new String[arrayList.size()]));
                return true;
            }
        };
    }

    @Override
    public final Step createGetInstallerInDownloadOnlyCallable(Model<Boolean> model, Model<String[]> model2, Model<String> model3, Model<InstallerDownloadURLInfo[]> model4) {
        GetInstallerInDownloadOnlyCallable getInstallerInDownloadOnlyCallable = new GetInstallerInDownloadOnlyCallable(this.wizardUI, this.exceptionHandler, this.clientString, this.downloadService, model2, model3, model4, this.logger, this.archString);
        return this.createServiceTaskStep(new ConditionalCallable(model, getInstallerInDownloadOnlyCallable), ResourceKeys.SERVICE_DWS_CHECK_MESSAGE.getString(new Object[0]));
    }

    @Override
    public Step createGetLanguagesStep(Model<String[]> model, String string) {
        GetLanguageCodesForProfileCallable getLanguageCodesForProfileCallable = new GetLanguageCodesForProfileCallable(this.wizardUI, this.exceptionHandler, this.clientString, this.downloadService, string, this.logger, model, this.archString);
        return this.createServiceTaskStep(getLanguageCodesForProfileCallable, ResourceKeys.SERVICE_DWS_CHECK_MESSAGE.getString(new Object[0]));
    }

    @Override
    public final Step createBuildInstallerStepForInstallAgent(final Model<ValidatedFik> model, final Model<Installer> model2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                Installer installer;
                if (model2.get() == null && (installer = AbstractCommandStepFactory.this.installerBuilder.buildInstaller((ValidatedFik)model.get())).getAvailableProducts().length > 0) {
                    model2.set((Object)installer);
                }
                return true;
            }
        };
    }

    @Override
    public final Step createAlwaysGetUpdatesIfAvailableStep(final Model<Boolean> model, final Model<Boolean> model2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                model2.set(model.get());
                return true;
            }
        };
    }

    @Override
    public final Step createShowQuestionMessageStep(final String string, final String string2, final Model<Boolean> model, final Model<Boolean> model2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                if (((Boolean)model.get()).booleanValue()) {
                    Response response = AbstractCommandStepFactory.this.wizardUI.getResponseToQuestion(string, string2, MessageType.QUESTION, OptionType.YES_NO);
                    if (response.equals((Object)Response.CANCEL)) {
                        return false;
                    }
                    model2.set((Object)response.equals((Object)Response.YES));
                } else {
                    model2.set((Object)false);
                }
                return true;
            }
        };
    }

    @Override
    public final Step createValidateLicenseFileStep(Model<String> model, Model<String> model2) {
        return new ValidateLicenseFileStep(model, model2, this.exceptionHandler, this.wizardUI, this.logger, this.machine);
    }

    @Override
    public final Step createCheckIfOverwriteImpossibleStep(DefaultedModel<String> defaultedModel, Installer installer) {
        return new CheckIfOverwriteImpossibleStep(installer, defaultedModel, this.wizardUI);
    }

    @Override
    public final Step createCheckOverwritesStep(DefaultedModel<String> defaultedModel, Installer installer) {
        return new CheckOverwritesStep(installer, defaultedModel, this.wizardUI);
    }

    @Override
    public final Step createCheckOverwritesForMCRStep(DefaultedModel<String> defaultedModel, Installer installer) {
        return new CheckOverwritesForMCRStep(installer, defaultedModel, this.wizardUI);
    }

    @Override
    public final Step createCheckProductFamilyAndVersionStep(DefaultedModel<String> defaultedModel, Installer installer) {
        return new CheckProductFamilyAndVersionStep(installer, defaultedModel, this.wizardUI);
    }

    @Override
    public final <T extends SoftwareManager> Step createCheckIfNoProductsStep(final Model<T> model) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                if (((SoftwareManager)model.get()).getAvailableProducts().length == 0) {
                    AbstractCommandStepFactory.this.wizardUI.showErrorMessage(ResourceKeys.NOPRODUCTS_TITLE.getString(new Object[0]), ResourceKeys.NOPRODUCTS_MESSAGE.getString(new Object[0]));
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public final <T extends SoftwareManager> Step createCheckIfNoProductsInFIKFlowStep(final Model<T> model) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                if (((SoftwareManager)model.get()).getAvailableProducts().length == 0) {
                    AbstractCommandStepFactory.this.wizardUI.showErrorMessage(ResourceKeys.NOPRODUCTS_TITLE_FIK_FLOW.getString(new Object[0]), ResourceKeys.NOPRODUCTS_MESSAGE_FIK_FLOW.getString(new Object[0]));
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public final Step createGetFikStep(final Model<MWAEntitlement> model, final Model<String> model2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                model2.set((Object)((MWAEntitlement)model.get()).getFIK());
                return true;
            }
        };
    }

    @Override
    public final Step createCreateAccountStep(Model<String> model, Model<String> model2, Model<String> model3, Model<String> model4, Model<String> model5, Model<Boolean> model6) {
        CreateAccountCallable createAccountCallable = new CreateAccountCallable(this.wizardUI, this.exceptionHandler, this.clientString, this.activationService, model, model2, model3, model4, model5, model6, this.archString);
        return this.createServiceTaskStep(createAccountCallable, WizardResourceKeys.SERVICE_CREATE_ACCOUNT_MESSAGE.getString(new Object[0]));
    }

    @Override
    public final Step createConvertKeyToValidFikStep(final Model<String> model, final Model<ValidatedFik> model2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                String string = (String)model.get();
                try {
                    model2.set((Object)AbstractCommandStepFactory.this.installerBuilder.validateFik(string));
                    return true;
                }
                catch (InvalidFikException invalidFikException) {
                    String string2 = this.looksLikeAPLP(string) ? ResourceKeys.FIK_ERROR_PLP.getString(AbstractCommandStepFactory.this.hyperlinkProvider.getLicenseCenterLink()) : ResourceKeys.FIK_ERROR_INVALID.getString(new Object[0]);
                    AbstractCommandStepFactory.this.wizardUI.showErrorMessage(ResourceKeys.FIK_ERROR_TITLE.getString(new Object[0]), string2);
                    return false;
                }
                catch (WrongReleaseFikException wrongReleaseFikException) {
                    AbstractCommandStepFactory.this.wizardUI.showErrorMessage(ResourceKeys.FIK_ERROR_TITLE.getString(new Object[0]), ResourceKeys.FIK_ERROR_VERSION.getString(new Object[0]));
                    return false;
                }
            }

            private boolean looksLikeAPLP(String string) {
                return string.matches("^\\s*1[0-8]\\s*-.+");
            }
        };
    }

    @Override
    public final Step createCheckEnteredKeyIsFikStep(final Model<String> model, final Model<Boolean> model2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                try {
                    AbstractCommandStepFactory.this.installerBuilder.validateFik((String)model.get());
                    model2.set((Object)true);
                }
                catch (InvalidFikException invalidFikException) {
                    model2.set((Object)false);
                }
                catch (WrongReleaseFikException wrongReleaseFikException) {
                    model2.set((Object)true);
                }
                return true;
            }
        };
    }

    @Override
    public final Step createShowErrorMessageStep(final String string, final String string2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                AbstractCommandStepFactory.this.wizardUI.showErrorMessage(string, string2);
                return false;
            }
        };
    }

    @Override
    public final Step createShowWarningMessageStep(final String string, final String string2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                return AbstractCommandStepFactory.this.wizardUI.showWarningMessage(string, string2);
            }
        };
    }

    @Override
    public final Step createDeleteDownloadedArchivesStep(ProductModel<AvailableProduct> productModel, File file) {
        return new DeleteDownloadedArchivesStep(this.wizardUI, this.exceptionHandler, this.io, file, productModel);
    }

    @Override
    public final Step createApplyUninstallOptionSelection(final Installer installer, final InstallOption ... installOptionArray) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                installer.setUninstallOptions(installOptionArray);
                return true;
            }
        };
    }

    @Override
    public final Step createLaunchDeactivationStep(Installer installer, String string, Properties properties) {
        return new LaunchDeactivationStep(installer, properties, string, this.executorService, this.installConfiguration, this.archString);
    }

    @Override
    public Step createConfirmPasswordsMatchStep(final Model<String> model, final Model<String> model2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                if (((String)model.get()).equals(model2.get())) {
                    return true;
                }
                AbstractCommandStepFactory.this.wizardUI.showErrorMessage(ResourceKeys.INSTALL_ALERT_ERROR.getString(new Object[0]), ResourceKeys.ERROR_PASSWORD_MATCH.getString(new Object[0]));
                return false;
            }
        };
    }

    @Override
    public Step createConfirmEmailsMatchStep(final Model<String> model, final Model<String> model2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                if (((String)model.get()).equalsIgnoreCase((String)model2.get())) {
                    return true;
                }
                AbstractCommandStepFactory.this.wizardUI.showErrorMessage(ResourceKeys.INSTALL_ALERT_ERROR.getString(new Object[0]), ResourceKeys.ERROR_EMAILS_MATCH.getString(new Object[0]));
                return false;
            }
        };
    }

    private Step createServiceTaskStep(Callable<Boolean> callable, String string) {
        return this.createServiceTaskStep(callable, WizardResourceKeys.SERVICE_TITLE.getString(new Object[0]), string);
    }

    private Step createServiceTaskStep(Callable<Boolean> callable, String string, String string2) {
        return new ServiceTaskStep(callable, this.workerFactory, this.wizardUI, string, string2, this.logger);
    }

    private Step createServiceTaskStepsWithServiceDialog(Callable<Boolean> callable, String string, String string2) {
        return new ServiceTaskStepForArchives(callable, this.workerFactory, this.wizardUI, string, string2);
    }

    @Override
    public Step createIsDownloadOnlyPermissionAvailableStep(final Model<MWAEntitlement[]> model, final Model<Boolean> model2, final Model<Boolean> model3) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                model2.set((Object)(EntitlementUtility.isDownloadOnlyPermissionAvailable((MWAEntitlement[])((MWAEntitlement[])model.get())) && (Boolean)model3.get() != false ? 1 : 0));
                return true;
            }
        };
    }

    @Override
    public Step createValidStateCheck(final boolean bl, final String string, final String string2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                if (!bl) {
                    AbstractCommandStepFactory.this.wizardUI.showErrorMessage(string2, string);
                    AbstractCommandStepFactory.this.exitHandler.exit(ExitStatus.FAILED);
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public Step setInstallOptionsForPolyspaceStep(final Model<InstallOption[]> model) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                AbstractCommandStepFactory.this.setInstallOptionsForPolyspace((InstallOption[])model.get());
                return true;
            }
        };
    }

    @Override
    public Step setInstallOptionsForPolyspaceStep(final InstallOption[] installOptionArray) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                AbstractCommandStepFactory.this.setInstallOptionsForPolyspace(installOptionArray);
                return true;
            }
        };
    }

    private void setInstallOptionsForPolyspace(InstallOption[] installOptionArray) {
        boolean bl = false;
        boolean bl2 = false;
        for (InstallOption installOption : installOptionArray) {
            if (installOption.getType() == InstallOptionType.DESKTOP_SHORTCUT) {
                bl = installOption.isSelected();
            }
            if (installOption.getType() != InstallOptionType.START_MENU_SHORTCUT) continue;
            bl2 = installOption.isSelected();
        }
        if (bl) {
            for (InstallOption installOption : installOptionArray) {
                if (installOption.getType() != InstallOptionType.POLYSPACE_BF_SHORTCUT && installOption.getType() != InstallOptionType.POLYSPACE_CP_SHORTCUT) continue;
                installOption.setSelected(true);
            }
        }
        if (bl2) {
            for (InstallOption installOption : installOptionArray) {
                if (installOption.getType() != InstallOptionType.POLYSPACE_BF_START_MENU_SHORTCUT && installOption.getType() != InstallOptionType.POLYSPACE_CP_START_MENU_SHORTCUT) continue;
                installOption.setSelected(true);
            }
        }
    }

    @Override
    public Step createSetFrameImagesStep(final List<Image> list) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                AbstractCommandStepFactory.this.wizardUI.setIconImages(list);
                return true;
            }
        };
    }

    @Override
    public Step createIsLNUOnlyStep(final Model<MWAEntitlement> model, final Model<Boolean> model2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                model2.set((Object)EntitlementUtility.isLNUOnly((MWAEntitlement[])new MWAEntitlement[]{(MWAEntitlement)model.get()}));
                return true;
            }
        };
    }

    @Override
    public Step createMarkerFileForLNUEntitlementsStep(final Model<Boolean> model, final File file, final Properties properties) {
        final LModeSwitchingUtility lModeSwitchingUtility = new LModeSwitchingUtility();
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                try {
                    String string = properties.getProperty(PropertyKey.MODE.get(), "interactive");
                    String string2 = properties.getProperty(PropertyKey.ONLINE_LICENSING_FOR_ALL.get(), "no");
                    if (string.equalsIgnoreCase("silent") && (string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("true"))) {
                        lModeSwitchingUtility.installMarkerFile(file.getAbsolutePath(), properties);
                    } else if (((Boolean)model.get()).booleanValue()) {
                        lModeSwitchingUtility.installMarkerFile(file.getAbsolutePath(), properties);
                    }
                }
                catch (Exception exception) {
                    AbstractCommandStepFactory.this.exceptionHandler.handleException((Throwable)exception);
                }
                return true;
            }
        };
    }

    protected DefaultedModelImpl<String> createDownloadFolder(DefaultedModel<File> defaultedModel) {
        return new DefaultedModelImpl((Object)((File)defaultedModel.get()).getPath());
    }

    @Override
    public Step createUdcPingStep(final UsageDataCollector usageDataCollector) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                usageDataCollector.ping();
                return true;
            }
        };
    }

    @Override
    public Step createCollectUdcGpuInfoStep(String string) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                return true;
            }
        };
    }

    @Override
    public Step createCollectUdcCpuInfoStep(String string) {
        return new CollectUdcCpuInfoStep(string, this.usageDataCollector, this.executorService);
    }

    @Override
    public Step createCallDduxSettingExecutableStep(final String string) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                UdcUtil.callDduxSettingsExecutable((String)string, (Platform)new PlatformImpl());
                return true;
            }
        };
    }

    @Override
    public Step createGetFirstEntitlementStep(final Model<MWAEntitlement[]> model, final Model<MWAEntitlement> model2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                model2.set((Object)((MWAEntitlement[])model.get())[0]);
                return true;
            }
        };
    }

    @Override
    public Step createFileSystemStep(final Model<Installer> model, final DefaultedModel<String> defaultedModel, final Model<FileSystem> model2, final InstallModelFactory installModelFactory) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                model2.set((Object)installModelFactory.createFileSystem((SoftwareManager)model.get(), (DefaultedModel<String>)defaultedModel));
                return true;
            }
        };
    }

    @Override
    public Step createProductModelStep(final Model<Installer> model, final Model<ProductModel> model2, final InstallModelFactory installModelFactory) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                model2.set(installModelFactory.createProductModel((SoftwareManager)model.get()));
                return true;
            }
        };
    }

    @Override
    public Step createDownloadTaskStep(final Model<Downloader> model, final File file, final Model<BackgroundTask> model2, final InstallModelFactory installModelFactory) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                model2.set((Object)installModelFactory.createDownloadTask((SoftwareManager)model.get(), file));
                return true;
            }
        };
    }

    @Override
    public Step createInstallOptionsForSelectedProductsStep(final Model<InstallOption[]> model, final Model<Installer> model2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                model.set((Object)((Installer)model2.get()).getInstallOptionsForCurrentProductSelection(new Product[0]));
                return true;
            }
        };
    }

    @Override
    public Step createPreventOverwritesStep(final DefaultedModel<String> defaultedModel, final Model<Installer> model) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                AvailableProduct[] availableProductArray;
                for (AvailableProduct availableProduct : availableProductArray = ((Installer)model.get()).getSelectedProductsAlreadyInstalled(new File((String)defaultedModel.get()))) {
                    availableProduct.setOverwrite(false);
                }
                return true;
            }
        };
    }

    @Override
    public Step createActivationPropertiesFromInstallerProperties(final Model<MWAEntitlement> model, final Properties properties) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                String string;
                System.setProperty("activationKey", ((MWAEntitlement)model.get()).getActivationKey());
                System.setProperty("securityToken", properties.getProperty(PropertyKey.TOKEN.get()));
                System.setProperty("matlabRoot", properties.getProperty(PropertyKey.ROOTDIR.get()));
                System.setProperty("lockingTypeName", LockingTypeConstants.COMPUTER_BASED.getString());
                String string2 = properties.getProperty(PropertyKey.AWS.get(), "");
                if (!string2.isEmpty()) {
                    System.setProperty("activationWebService", string2);
                }
                if (!(string = properties.getProperty(PropertyKey.ACTIVATION_LOG_FILE.get(), "")).isEmpty()) {
                    System.setProperty("logFile", string);
                }
                System.setProperty("isSilent", "true");
                System.setProperty("activateCommand", "activateTrials");
                return true;
            }
        };
    }

    @Override
    public Step createGetEntitlementByIdStep(Model<String> model, Model<MWAEntitlement> model2, String string) {
        GetEntitlementByIdCallable getEntitlementByIdCallable = new GetEntitlementByIdCallable(this.wizardUI, this.exceptionHandler, this.clientString, model, this.activationService, model2, this.archString, string);
        return this.createServiceTaskStep(getEntitlementByIdCallable, WizardResourceKeys.SERVICE_ENTITLEMENT_MESSAGE.getString(new Object[0]));
    }

    @Override
    public Step createSelectDependentProductsStep(final Model<Installer> model) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                HashSet<String> hashSet = new HashSet<String>();
                Installer installer = (Installer)model.get();
                for (Product product : installer.getDependencies()) {
                    if (product.isControlling()) continue;
                    hashSet.add(product.getProductBaseCode());
                }
                for (Product product : installer.getAvailableProducts()) {
                    if (!hashSet.contains(product.getProductBaseCode())) continue;
                    product.setSelected(true);
                }
                return true;
            }
        };
    }

    protected void showWarningMessage() {
        this.wizardUI.showWarningMessage(ResourceKeys.INSTALL_ALERT_ERROR.getString(new Object[0]), ResourceKeys.SHUTDOWN_MATLAB_TEXT.getString(new Object[0]));
    }

    @Override
    public Step createGetAvailableProductsStep(final Model<Product[]> model, final Model<Installer> model2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                model.set((Object)((Installer)model2.get()).getAvailableProducts());
                return true;
            }
        };
    }

    @Override
    public Step createCheckIfControllingProductSelectedToBeUninstalledStep(final ProductModel<AvailableProduct> productModel, final Model<Boolean> model) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                model.set((Object)productModel.isAnyControllingProductSelected());
                return true;
            }
        };
    }

    @Override
    public Step createCheckUninstallerProductDependenciesStep(final Model<Installer> model, final File file, final Model<Boolean> model2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                Installer installer = (Installer)model.get();
                Product[] productArray = installer.getProductsThatDependOnProductsToBeUninstalled(file);
                if (productArray.length > 0) {
                    String string = ResourceKeys.DEPENDENCIES_MESSAGE_UNINSTALL_ADDONS.getString(AbstractCommandStepFactory.buildProductListString(productArray, (SoftwareManager)installer));
                    Response response = AbstractCommandStepFactory.this.wizardUI.getResponseToQuestion(ResourceKeys.DEPENDENCIES_TITLE.getString(new Object[0]), string, MessageType.WARNING, OptionType.DEFAULT_NO_YES_NO_CANCEL);
                    if (response.equals((Object)Response.CANCEL)) {
                        return false;
                    }
                    model2.set((Object)response.equals((Object)Response.YES));
                }
                return true;
            }
        };
    }

    @Override
    public Step createSelectDependentProductsStep(final Model<Installer> model, final Model<Boolean> model2, final File file) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                if (((Boolean)model2.get()).booleanValue()) {
                    HashSet<String> hashSet = new HashSet<String>();
                    Installer installer = (Installer)model.get();
                    for (Product product : installer.getProductsThatDependOnProductsToBeUninstalled(file)) {
                        hashSet.add(product.getProductBaseCode());
                    }
                    for (Product product : installer.getAvailableProducts()) {
                        if (!hashSet.contains(product.getProductBaseCode())) continue;
                        product.setSelected(true);
                    }
                }
                return true;
            }
        };
    }

    @Override
    public Step createCheckUninstallPermissionsStep(final String string) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                File file = new File(string, "appdata");
                String string3 = file.getAbsolutePath();
                if (!AbstractCommandStepFactory.this.io.canWriteToFolder(string3)) {
                    String string2 = ResourceKeys.INSTALL_ADMIN_TITLE.getString(new Object[0]);
                    AbstractCommandStepFactory.this.wizardUI.showErrorMessage(string2, ResourceKeys.CANNOT_UNINSTALL_PRODUCT.getString(string));
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public Step createInstalledProductModelStep(final Installer installer, final DefaultedModel<String> defaultedModel, final InstallModelFactory installModelFactory, final Model<ProductModel<AvailableProduct>> model) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                model.set(installModelFactory.createInstalledProductModel(installer, (DefaultedModel<String>)defaultedModel));
                return true;
            }
        };
    }

    @Override
    public Step createInstallProductTableFormat(final Model<ProductModel<AvailableProduct>> model, final Installer installer, final InstallModelFactory installModelFactory, final Model<ProductTableFormat<AvailableProduct>> model2) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                model2.set(installModelFactory.createInstallProductTableFormat((ProductModel<AvailableProduct>)((ProductModel)model.get()), installer));
                return true;
            }
        };
    }

    @Override
    public Step resetAndDeselectOlderVersionsOfSelectedProducts(final Installer installer) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                AbstractCommandStepFactory.this.installerBuilder.resetAndDeselectOlderVersionsOfSelectedProducts(installer);
                return true;
            }
        };
    }

    @Override
    public Step createGetInstructionSetDependencies(final Model<Map<Product, List<ComponentData>>> model, final Model<List<String>> model2, final Model<Downloader> model3) {
        return new AbstractCommandStep(){

            @Override
            boolean forwardVisitStep() {
                Map map = (Map)model.get();
                Map map2 = ((Downloader)model3.get()).getInstructionSetComponents((List)model2.get());
                for (Map.Entry entry : map2.entrySet()) {
                    map.put(entry.getKey(), entry.getValue());
                }
                return true;
            }
        };
    }
}

