/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.input;

import com.mathworks.install.InputStreamProvider;
import com.mathworks.install.XMLParseException;
import com.mathworks.install.archive.ArchiveFactory;
import com.mathworks.install.archive.MissingEntryException;
import com.mathworks.install.input.AbstractProductArchive;
import com.mathworks.install.input.ArchiveInputStreamProvider;
import com.mathworks.install.input.ComponentSourceFactory;
import com.mathworks.install.input.Contents;
import com.mathworks.install.input.XMLInstallationFileParser;
import com.mathworks.instutil.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;

final class UnifiedProductArchive
extends AbstractProductArchive {
    private final String COMMON_ENTRY = "_common.xml";
    private final String PLATFORM_ENTRY;
    private final String MW_CONTENTS = "mwcontents_";

    UnifiedProductArchive(File file, ArchiveFactory archiveFactory, XMLInstallationFileParser xMLInstallationFileParser, ComponentSourceFactory componentSourceFactory, Platform platform) {
        super(file, xMLInstallationFileParser, componentSourceFactory, archiveFactory);
        this.PLATFORM_ENTRY = "_" + platform.getArchString() + ".xml";
    }

    @Override
    protected InputStream getInputStream(String string) throws IOException {
        return this.archive.getInputStream(this.getAdjustedEntryName(string));
    }

    @Override
    protected InputStreamProvider getInputStreamProvider(String string) {
        return new ArchiveInputStreamProvider(this.archive, this.getAdjustedEntryName(string));
    }

    private String getAdjustedEntryName(String string) {
        String string2 = string;
        for (String string3 : this.archive.getEntries()) {
            if (!string3.endsWith(string)) continue;
            string2 = string3;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void parse() throws IOException, XMLParseException {
        this.open();
        InputStream inputStream = null;
        try {
            for (String string : this.getContentsEntries()) {
                inputStream = this.getInputStream(string);
                Contents contents = this.xmlInstallationFileParser.parseContents(inputStream);
                this.componentFiles.addAll(Arrays.asList(contents.getComponentFiles()));
                this.manifests.addAll(Arrays.asList(contents.getManifests()));
                this.readInDefinitions(contents.getDefinitions());
            }
        }
        catch (MissingEntryException missingEntryException) {
        }
        finally {
            IOUtils.closeQuietly(inputStream);
            this.close();
        }
    }

    private List<String> getContentsEntries() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.archive.getEntries()) {
            if (string.contains("mwcontents_") && string.endsWith("_common.xml")) {
                arrayList.add(string);
                continue;
            }
            if (!string.contains("mwcontents_") || !string.endsWith(this.PLATFORM_ENTRY)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }
}

