/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.input;

import com.google.inject.Inject;
import com.mathworks.install.ContentOptimizer;
import com.mathworks.install.InstallerDownloadInfoContainer;
import com.mathworks.install.archive.ArchiveFactory;
import com.mathworks.install.input.ComponentDownloader;
import com.mathworks.install.input.ComponentSourceFactory;
import com.mathworks.install.input.ComponentURLProvider;
import com.mathworks.install.input.CompressedXMLInstallationInputFile;
import com.mathworks.install.input.ContentsXMLFile;
import com.mathworks.install.input.DWSInstallationInputFile;
import com.mathworks.install.input.InstallationInputFile;
import com.mathworks.install.input.InstallationInputFileFactory;
import com.mathworks.install.input.InstallationInputFileStrategy;
import com.mathworks.install.input.NoOpInstallationInputFile;
import com.mathworks.install.input.XMLInstallationFileParser;
import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.IO;
import com.mathworks.webproxy.ProxyConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;

final class InstallationInputFileFactoryImpl
implements InstallationInputFileFactory {
    private final ArchiveFactory archiveFactory;
    private final ComponentSourceFactory componentSourceFactory;
    private final Downloader downloader;
    private final IO io;
    private final ProxyConfiguration proxyConfiguration;
    private final ContentOptimizer contentOptimizer;
    private final InstallerDownloadInfoContainer installerDownloadInfoContainer;
    private final InstallationInputFileStrategy installationInputFileStrategy;

    @Inject
    InstallationInputFileFactoryImpl(ArchiveFactory archiveFactory, ComponentSourceFactory componentSourceFactory, Downloader downloader, IO iO, ProxyConfiguration proxyConfiguration, ContentOptimizer contentOptimizer, InstallerDownloadInfoContainer installerDownloadInfoContainer, InstallationInputFileStrategy installationInputFileStrategy) {
        this.archiveFactory = archiveFactory;
        this.componentSourceFactory = componentSourceFactory;
        this.downloader = downloader;
        this.io = iO;
        this.proxyConfiguration = proxyConfiguration;
        this.contentOptimizer = contentOptimizer;
        this.installerDownloadInfoContainer = installerDownloadInfoContainer;
        this.installationInputFileStrategy = installationInputFileStrategy;
    }

    @Override
    public InstallationInputFile createInstallationFile(File file, ComponentURLProvider componentURLProvider, XMLInstallationFileParser xMLInstallationFileParser) {
        return new DWSInstallationInputFile(file, this.archiveFactory, xMLInstallationFileParser, new ComponentDownloader(componentURLProvider, this.downloader, this.io, this.proxyConfiguration, this.componentSourceFactory), this.contentOptimizer, this.installerDownloadInfoContainer);
    }

    @Override
    public InstallationInputFile createInstallationFileFromCompressedXML(File file, XMLInstallationFileParser xMLInstallationFileParser) {
        return new CompressedXMLInstallationInputFile(file, this.archiveFactory, xMLInstallationFileParser, this.componentSourceFactory, this.contentOptimizer);
    }

    @Override
    public InstallationInputFile[] createInstallationFiles(File file, final XMLInstallationFileParser xMLInstallationFileParser) throws IOException {
        final ArrayList<InstallationInputFile> arrayList = new ArrayList<InstallationInputFile>();
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                if (file2.isDirectory() && this.contentOptimizer.accept(file2.getName())) {
                    Files.walkFileTree(file2.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                            arrayList.add(InstallationInputFileFactoryImpl.this.createInstallationFile(path.toFile(), xMLInstallationFileParser));
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    continue;
                }
                arrayList.add(this.createInstallationFile(file2, xMLInstallationFileParser));
            }
        } else {
            arrayList.add(this.createInstallationFile(file, xMLInstallationFileParser));
        }
        return arrayList.toArray(new InstallationInputFile[arrayList.size()]);
    }

    private InstallationInputFile createInstallationFile(File file, XMLInstallationFileParser xMLInstallationFileParser) {
        String string = file.getName();
        if (!InstallationInputFileFactoryImpl.isHiddenFile(string)) {
            if (this.isProductArchive(file)) {
                return this.installationInputFileStrategy.createProductArchive(file, this.archiveFactory, xMLInstallationFileParser, this.componentSourceFactory);
            }
            if (InstallationInputFileFactoryImpl.isContentsFile(file)) {
                return new ContentsXMLFile(file, xMLInstallationFileParser, this.componentSourceFactory);
            }
            if (InstallationInputFileFactoryImpl.isXMLFile(string)) {
                return this.installationInputFileStrategy.createProductOrComponentXMLFile(file, xMLInstallationFileParser, this.componentSourceFactory);
            }
        }
        return new NoOpInstallationInputFile(file);
    }

    private static boolean isHiddenFile(String string) {
        return string.startsWith(".");
    }

    private static boolean isContentsFile(File file) {
        String string = file.getName();
        return string.startsWith("mwcontents") && InstallationInputFileFactoryImpl.isXMLFile(string);
    }

    private static boolean isXMLFile(String string) {
        return FilenameUtils.isExtension((String)string, (String)"xml");
    }

    private boolean isProductArchive(File file) {
        return this.installationInputFileStrategy.isProductArchive(file);
    }
}

