/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.Command;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.commons.io.IOCase;

public final class PathdefGeneratorCommand
implements Command {
    static final String TOOLBOX_LOCAL_DIR = "toolbox" + File.separator + "local";
    static final String PATH_DIR = TOOLBOX_LOCAL_DIR + File.separator + "path";
    static final String TEMPLATE_DIR = TOOLBOX_LOCAL_DIR + File.separator + "template";
    static final String PATHDEF_TEMPLATE_FILE = TEMPLATE_DIR + File.separator + "pathdef.m";
    static final String BEGIN_MARKER = "%%% BEGIN ENTRIES %%%";
    static final String END_MARKER = "%%% END ENTRIES %%%";
    static final String TOP_MARKER = "PLEASE FILL IN ONE DIRECTORY";
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final IO io;
    private final String matlabRoot;
    private final String pathDefFileName;
    private String pathdefTemplateFile;

    public PathdefGeneratorCommand(IO iO, String string, String string2) {
        this(iO, string, string2, PATHDEF_TEMPLATE_FILE);
    }

    public PathdefGeneratorCommand(IO iO, String string, String string2, String string3) {
        this.io = iO;
        this.pathDefFileName = string2;
        this.matlabRoot = string;
        this.pathdefTemplateFile = string3;
    }

    @Override
    public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws InterruptedException {
        try {
            this.generatePathdef(file);
        }
        catch (IOException iOException) {
            installFlowControlHandler.exitImmediately(iOException);
        }
    }

    @Override
    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws InterruptedException {
        try {
            this.generatePathdef(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void generatePathdef(File file) throws InterruptedException, IOException {
        String string = TOOLBOX_LOCAL_DIR + File.separator + this.pathDefFileName;
        File file2 = new File(file, string);
        PathdefContent pathdefContent = new PathdefContent(file);
        this.readPathdefFileIfExists(file2, pathdefContent);
        ArrayList<File> arrayList = new ArrayList<File>();
        if (!PathdefGeneratorCommand.getPhlFiles(file, arrayList)) {
            this.io.recursivelyDeleteFileAndParents(file2, file);
            return;
        }
        this.readPhlFiles(arrayList, pathdefContent);
        this.readTemplateFile(pathdefContent);
        this.writePathdefFile(file2, pathdefContent);
    }

    private void readPathdefFileIfExists(File file, PathdefContent pathdefContent) throws IOException {
        if (file.isFile()) {
            this.readPathdefFile(file, pathdefContent);
        }
    }

    private void readPathdefFile(File file, PathdefContent pathdefContent) throws IOException {
        Collection collection = this.io.readLinesFromFile(file, new ArrayList());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && !((String)iterator.next()).contains(BEGIN_MARKER)) {
        }
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            string = string.trim();
            StringBuffer stringBuffer = new StringBuffer(string = string.replace('/', File.separatorChar));
            int n = stringBuffer.lastIndexOf(",...");
            if (n != -1) {
                stringBuffer = stringBuffer.insert(n + 1, ' ');
                string = stringBuffer.toString();
            }
            if (string.contains(END_MARKER)) break;
            pathdefContent.addPath(string);
        }
    }

    private void readPhlFiles(Collection<File> collection, PathdefContent pathdefContent) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        for (File file : collection) {
            String string = file.getName();
            if (string.startsWith("libmatlab")) {
                this.readPhlFile(file, arrayList);
                continue;
            }
            if (string.startsWith("matlab")) {
                this.readPhlFile(file, arrayList2);
                continue;
            }
            if (string.startsWith("simulink")) {
                this.readPhlFile(file, arrayList3);
                continue;
            }
            if (string.startsWith("stateflow")) {
                this.readPhlFile(file, arrayList4);
                continue;
            }
            this.readPhlFile(file, arrayList5);
        }
        pathdefContent.addAllPaths(arrayList);
        pathdefContent.addAllPaths(arrayList2);
        pathdefContent.addAllPaths(arrayList3);
        pathdefContent.addAllPaths(arrayList4);
        pathdefContent.addAllPaths(arrayList5);
    }

    private static boolean getPhlFiles(File file, Collection<File> collection) {
        File file2 = new File(file, PATH_DIR);
        File[] fileArray = file2.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".phl");
            }
        });
        if (fileArray == null || fileArray.length == 0) {
            return false;
        }
        collection.addAll(Arrays.asList(fileArray));
        return true;
    }

    private void readPhlFile(File file, Collection<String> collection) throws IOException {
        Collection collection2 = this.io.readLinesFromFile(file, new ArrayList());
        for (String string : collection2) {
            string = string.trim();
            if ("".equals(string = string.replace('/', File.separatorChar))) continue;
            String string2 = "matlabroot,'" + File.separator + string + File.pathSeparator + "', ...";
            collection.add(string2);
        }
    }

    private void readTemplateFile(PathdefContent pathdefContent) throws IOException {
        String string;
        File file = new File(this.matlabRoot, this.pathdefTemplateFile);
        if (!file.isFile()) {
            throw new FileNotFoundException("Template-file file " + file + "not found");
        }
        Collection collection = this.io.readLinesFromFile(file, new ArrayList());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && !(string = (String)iterator.next()).contains(TOP_MARKER)) {
            pathdefContent.addLineToTop(string);
        }
        while (iterator.hasNext()) {
            pathdefContent.addLineToBottom((String)iterator.next());
        }
    }

    private void writePathdefFile(File file, PathdefContent pathdefContent) throws IOException, InterruptedException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(pathdefContent.getLines().getBytes());
        this.io.createFileFromStream((InputStream)byteArrayInputStream, file, 0L, 292, new IOObserver[0]);
    }

    private static class PathdefContent {
        private final Collection<String> top = new ArrayList<String>();
        private final Collection<String> entries = new LinkedHashSet<String>();
        private final Collection<String> bottom = new ArrayList<String>();
        private final File destinationFolder;

        PathdefContent(File file) {
            this.destinationFolder = file;
        }

        PathdefContent addLineToTop(String string) {
            this.top.add(string);
            return this;
        }

        PathdefContent addLineToBottom(String string) {
            this.bottom.add(string);
            return this;
        }

        PathdefContent addAllPaths(Collection<String> collection) {
            for (String string : collection) {
                this.addPath(string);
            }
            return this;
        }

        PathdefContent addPath(String string) {
            String string2 = PathdefContent.normalizePathToCurrentPlatform(string);
            if (this.isDuplicateEntry(string2)) {
                return this;
            }
            if (this.entryExists(string2)) {
                this.entries.add(string2);
            }
            return this;
        }

        private static String normalizePathToCurrentPlatform(String string) {
            String string2 = string.replaceAll(":', ...", File.pathSeparator + "', ...");
            string2 = string2.replaceAll(";', ...", File.pathSeparator + "', ...");
            return string2;
        }

        private boolean isDuplicateEntry(String string) {
            for (String string2 : this.entries) {
                if (!IOCase.SYSTEM.checkEquals(string, string2)) continue;
                return true;
            }
            return false;
        }

        String getLines() {
            ArrayList<String> arrayList = new ArrayList<String>(this.top);
            arrayList.addAll(this.entries);
            arrayList.addAll(this.bottom);
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : arrayList) {
                stringBuilder.append(string).append(LINE_SEPARATOR);
            }
            return stringBuilder.toString();
        }

        private boolean entryExists(String string) {
            boolean bl;
            String string2 = null;
            if (PathdefContent.startsWithMatlabRoot(string)) {
                int n = string.indexOf(",'");
                int n2 = PathdefContent.getIndexOfEntrySeparator(string, n);
                string2 = string.charAt(n + 2) == File.pathSeparatorChar ? "" : string.substring(n + 3, n2);
                string2 = this.destinationFolder.getAbsolutePath() + File.separator + string2;
            } else if (PathdefContent.isAbsolute(string)) {
                int n = 1;
                int n3 = PathdefContent.getIndexOfEntrySeparator(string, n);
                string2 = string.substring(n, n3);
            }
            if (string2 != null) {
                string2 = string2.replaceAll("''", "'");
                File file = new File(string2);
                bl = file.isDirectory();
            } else {
                bl = true;
            }
            return bl;
        }

        private static boolean isAbsolute(String string) {
            return PathdefContent.startsWithDriveLetter(string) || PathdefContent.isUNCPath(string) || PathdefContent.isUnixFullPath(string);
        }

        private static boolean isUnixFullPath(String string) {
            return string.startsWith("'/");
        }

        private static boolean startsWithMatlabRoot(String string) {
            return string.startsWith("matlabroot,");
        }

        private static boolean isUNCPath(String string) {
            return string.startsWith("'\\\\");
        }

        private static boolean startsWithDriveLetter(String string) {
            return string.startsWith(":\\", 2);
        }

        private static int getIndexOfEntrySeparator(String string, int n) {
            return string.indexOf(File.pathSeparator + "',", n);
        }
    }
}

