/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.Command;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

final class FileAssociationsCommand
implements Command {
    final AppLogger appLogger;
    int[] prodCodes;

    FileAssociationsCommand(int[] nArray, AppLogger appLogger) {
        this.prodCodes = Arrays.copyOfRange(nArray, 0, nArray.length);
        this.appLogger = appLogger;
    }

    @Override
    public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.doFileAssociation(file.getAbsolutePath(), this.prodCodes);
    }

    @Override
    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.undoFileAssociation(file.getAbsolutePath(), this.prodCodes);
    }

    private static native String registerFileAssociations(String var0, int[] var1);

    private void doFileAssociation(String string, int[] nArray) {
        this.appLogger.logMsg("Updating file associations at " + string);
        String string2 = FileAssociationsCommand.registerFileAssociations(string, nArray);
        if (string2 != null && string2.length() != 0) {
            this.appLogger.logMsg("Failed to install file associations at " + string + " with " + string2);
        }
    }

    private static native String unregisterFileAssociations(String var0, int[] var1);

    private void undoFileAssociation(String string, int[] nArray) {
        this.appLogger.logMsg("Deleting file associations at " + string);
        String string2 = FileAssociationsCommand.unregisterFileAssociations(string, nArray);
        if (string2 != null && string2.length() != 0) {
            this.appLogger.logMsg("Failed to remove file associations at " + string + " with " + string2);
        }
    }
}

