/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.archive.zip.commonscompress;

import com.google.inject.Inject;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.archive.zip.commonscompress.ArchiveEntryAdapter;
import com.mathworks.install.archive.zip.commonscompress.ArchiveEntryExtractor;
import com.mathworks.install.status.IOObserverAdapter;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

final class ArchiveEntryExtractorImpl
implements ArchiveEntryExtractor {
    private final IO myIO;

    @Inject
    ArchiveEntryExtractorImpl(IO iO) {
        this.myIO = iO;
    }

    @Override
    public void extract(InputStream inputStream, ArchiveEntryAdapter archiveEntryAdapter, File file, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        if (!archiveEntryAdapter.isDirectory()) {
            File file2 = new File(file, ArchiveEntryExtractorImpl.fixSlashes(archiveEntryAdapter.getName()));
            for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                installStatusObserver.addFile(file2);
            }
            if (archiveEntryAdapter.isSymlink()) {
                this.myIO.createSymLink(archiveEntryAdapter.getLinkName(inputStream), file2.getAbsolutePath());
            } else {
                this.myIO.createFileFromStream(inputStream, file2, archiveEntryAdapter.getTime(), archiveEntryAdapter.getPermissions(), new IOObserver[]{new IOObserverAdapter(installFlowControlHandler, installStatusObserverArray)});
            }
        }
    }

    private static String fixSlashes(String string) {
        return string.replace('/', File.separatorChar);
    }
}

