/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.mathworks.install.ComponentAggregator;
import com.mathworks.install.ComponentContainer;
import com.mathworks.install.ComponentData;
import com.mathworks.install.ComponentSizeAggregator;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallableComponent;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.InstalledProductData;
import com.mathworks.install.Product;
import com.mathworks.install.ProductContainer;
import com.mathworks.install.ProductDownloader;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.instutil.IOObserver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

final class ProductDownloaderImpl
implements ProductDownloader {
    private final InstalledProductData fileList;
    private final InstallStatusObserver installStatusObserver;
    private final UsageDataCollector usageDataCollector;

    @Inject
    ProductDownloaderImpl(InstalledProductData installedProductData, @Named(value="loggingStatusObserver") InstallStatusObserver installStatusObserver, UsageDataCollector usageDataCollector) {
        this.fileList = installedProductData;
        this.installStatusObserver = installStatusObserver;
        this.usageDataCollector = usageDataCollector;
    }

    @Override
    public void downloadProducts(String[] stringArray, File file, InstallableProduct[] installableProductArray, final InstallFlowControlHandler installFlowControlHandler, ComponentContainer componentContainer, ProductContainer productContainer, final InstallStatusObserver ... installStatusObserverArray) throws InterruptedException, IOException {
        Collection<InstallStatusObserver> collection = ProductDownloaderImpl.combineObservers(this.installStatusObserver, installStatusObserverArray);
        Map<String, InstallableComponent> map = ProductDownloaderImpl.getLatestVersionOfInstalledComponentsByName(componentContainer);
        Collection<ComponentData> collection2 = ProductDownloaderImpl.getComponentsOfProducts(installableProductArray, stringArray, productContainer);
        Map<String, ComponentData> map2 = ProductDownloaderImpl.getLatestVersionOfComponentsByName(collection2);
        long l = 0L;
        long l2 = 0L;
        for (InstallableProduct installableProduct : installableProductArray) {
            String string = installableProduct.getProductData().getNameVersionReleaseAndReleaseDescription();
            Collection<InstallableComponent> collection3 = this.getComponentsToDownloadForProduct(stringArray, string, componentContainer, map2, map, productContainer);
            final ComponentSizeAggregator componentSizeAggregator = new ComponentSizeAggregator();
            for (InstallableComponent installableComponent : collection3) {
                componentSizeAggregator.add(installableComponent);
            }
            l += componentSizeAggregator.getTotalDownloadSize();
            final String string2 = ProductDownloaderImpl.getProductNameAndVersion(installableProduct.getProductData());
            long l3 = componentSizeAggregator.getTotalDownloadSize();
            if (l3 > 0L) {
                for (InstallStatusObserver installStatusObserver : collection) {
                    installStatusObserver.downloadingProduct(string2, l3);
                }
            }
            long l4 = System.currentTimeMillis();
            for (InstallableComponent installableComponent : collection3) {
                installableComponent.download(file, installFlowControlHandler, new IOObserver(){

                    public boolean updateBytes(long l) throws InterruptedException {
                        for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                            installStatusObserver.updateDownloadUnits(string2, l, componentSizeAggregator.getTotalDownloadSize());
                        }
                        return installFlowControlHandler.checkTaskState();
                    }
                }, installStatusObserverArray);
            }
            long l5 = System.currentTimeMillis();
            l2 += (l5 - l4) / 1000L;
            for (String string3 : stringArray) {
                InstallableProduct installableProduct2 = productContainer.getInstallableProduct(string, string3);
                if (installableProduct2 == null) continue;
                installableProduct2.writeOutXML(file);
            }
        }
        this.usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_TOTAL_DOWNLOAD_TIME, l2);
        if (l > 0L) {
            for (InstallStatusObserver installStatusObserver : collection) {
                installStatusObserver.finishedDownloading(l);
            }
        }
    }

    private static String getProductNameAndVersion(Product product) {
        return product.getName() + ' ' + product.getVersion();
    }

    private Collection<InstallableComponent> getComponentsToDownloadForProduct(String[] stringArray, String string, ComponentContainer componentContainer, Map<String, ComponentData> map, Map<String, InstallableComponent> map2, ProductContainer productContainer) {
        LinkedHashMap<String, InstallableComponent> linkedHashMap = new LinkedHashMap<String, InstallableComponent>();
        for (String string2 : stringArray) {
            InstallableProduct installableProduct = productContainer.getInstallableProduct(string, string2);
            if (installableProduct == null) continue;
            for (ComponentData componentData : installableProduct.getRequiredComponents(string2)) {
                String string3 = componentData.getName();
                if (!map.containsKey(string3)) continue;
                InstallableComponent installableComponent = componentContainer.getInstallableComponent(map.get(string3));
                if (map2.containsKey(string3) && !map2.get(string3).getComponentData().isOlderThan(installableComponent.getComponentData()) || linkedHashMap.get(string3) != null) continue;
                linkedHashMap.put(string3, installableComponent);
            }
        }
        return linkedHashMap.values();
    }

    private static Map<String, ComponentData> getLatestVersionOfComponentsByName(Collection<ComponentData> collection) {
        LinkedHashMap<String, ComponentData> linkedHashMap = new LinkedHashMap<String, ComponentData>();
        for (ComponentData componentData : collection) {
            String string = componentData.getName();
            if (linkedHashMap.containsKey(string) && !((ComponentData)linkedHashMap.get(string)).isOlderThan(componentData)) continue;
            linkedHashMap.put(string, componentData);
        }
        return linkedHashMap;
    }

    private static Map<String, InstallableComponent> getLatestVersionOfInstalledComponentsByName(ComponentContainer componentContainer) {
        InstallableComponent[] installableComponentArray;
        LinkedHashMap<String, InstallableComponent> linkedHashMap = new LinkedHashMap<String, InstallableComponent>();
        for (InstallableComponent installableComponent : installableComponentArray = componentContainer.getInstalledComponents()) {
            ComponentData componentData = installableComponent.getComponentData();
            String string = componentData.getName();
            if (linkedHashMap.containsKey(string) && !((InstallableComponent)linkedHashMap.get(string)).getComponentData().isOlderThan(componentData)) continue;
            linkedHashMap.put(string, installableComponent);
        }
        return linkedHashMap;
    }

    private static Collection<InstallStatusObserver> combineObservers(InstallStatusObserver installStatusObserver, InstallStatusObserver ... installStatusObserverArray) {
        ArrayList<InstallStatusObserver> arrayList = new ArrayList<InstallStatusObserver>(Arrays.asList(installStatusObserverArray));
        arrayList.add(installStatusObserver);
        return arrayList;
    }

    @Override
    public void calculateSpaceRequired(String[] stringArray, File file, InstallableProduct[] installableProductArray, ComponentAggregator componentAggregator, ProductContainer productContainer, ComponentContainer componentContainer) {
        Object object;
        Collection<ComponentData> collection = ProductDownloaderImpl.getComponentsOfProducts(installableProductArray, stringArray, productContainer);
        Map<String, ComponentData> map = ProductDownloaderImpl.getLatestVersionOfComponentsByName(collection);
        HashMap<String, ComponentData> hashMap = new HashMap<String, ComponentData>();
        for (InstallableComponent installableComponent : componentContainer.getInstalledComponents()) {
            object = installableComponent.getComponentData();
            hashMap.put(object.getName(), (ComponentData)object);
        }
        String string = file.getAbsolutePath();
        for (ComponentData componentData : map.values()) {
            InstallableComponent installableComponent;
            installableComponent = componentContainer.getInstallableComponent(componentData);
            if (installableComponent == null) continue;
            object = componentData.getName();
            if (hashMap.containsKey(object)) {
                ComponentData componentData2 = (ComponentData)hashMap.get(object);
                if (!componentData2.isOlderThan(componentData)) continue;
                String[] stringArray2 = this.fileList.getNonSharedFiles((String)object, string);
                InstallableComponent installableComponent2 = componentContainer.getInstallableComponent(componentData2);
                componentAggregator.add(installableComponent);
                componentAggregator.remove(installableComponent2, stringArray2.length);
                continue;
            }
            componentAggregator.add(installableComponent);
        }
    }

    private static Collection<ComponentData> getComponentsOfProducts(InstallableProduct[] installableProductArray, String[] stringArray, ProductContainer productContainer) {
        LinkedHashMap<String, ComponentData> linkedHashMap = new LinkedHashMap<String, ComponentData>();
        for (InstallableProduct installableProduct : installableProductArray) {
            for (String string : stringArray) {
                ComponentData[] componentDataArray;
                InstallableProduct installableProduct2 = productContainer.getInstallableProduct(installableProduct.getProductData().getNameVersionReleaseAndReleaseDescription(), string);
                if (installableProduct2 == null) continue;
                for (ComponentData componentData : componentDataArray = installableProduct2.getRequiredComponents(string)) {
                    String string2 = componentData.getComponentNameAndVersion();
                    if (linkedHashMap.get(string2) != null) continue;
                    linkedHashMap.put(string2, componentData);
                }
            }
        }
        return linkedHashMap.values();
    }
}

