/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.mathworks.install.CommandContainer;
import com.mathworks.install.ComponentAggregator;
import com.mathworks.install.ComponentContainer;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.ProductContainer;
import com.mathworks.install.ProductInstaller;
import com.mathworks.install.command.Command;
import com.mathworks.install.status.InstallStatusObserver;
import java.io.File;
import java.io.IOException;

class PreProductInstaller
implements ProductInstaller {
    private final CommandContainer commandContainer;

    PreProductInstaller(CommandContainer commandContainer) {
        this.commandContainer = commandContainer;
    }

    @Override
    public void installProducts(String string, File file, File file2, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray, InstallFlowControlHandler installFlowControlHandler, ComponentContainer componentContainer, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        for (InstallStatusObserver object : installStatusObserverArray) {
            object.preInstall();
        }
        for (Command command : this.commandContainer.getPreInstallCommands(installableProductArray)) {
            installFlowControlHandler.checkTaskState();
            command.execute(string, file, installFlowControlHandler);
            PreProductInstaller.update(installStatusObserverArray);
        }
    }

    @Override
    public void downloadProducts(String string, File file, InstallableProduct[] installableProductArray, InstallFlowControlHandler installFlowControlHandler, ComponentContainer componentContainer, InstallStatusObserver ... installStatusObserverArray) throws InterruptedException, IOException {
    }

    private static void update(InstallStatusObserver[] installStatusObserverArray) {
        for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
            installStatusObserver.updateUnits(0x100000L);
        }
    }

    @Override
    public long getInstallUnits(String string, File file, InstallableProduct[] installableProductArray, InstallableProduct[] installableProductArray2, InstallOption[] installOptionArray, ProductContainer productContainer, ComponentContainer componentContainer) {
        return (long)this.commandContainer.getPreInstallCommands(installableProductArray).length * 0x100000L;
    }

    @Override
    public void uninstallProducts(String string, File file, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray, InstallFlowControlHandler installFlowControlHandler, ProductContainer productContainer, ComponentContainer componentContainer, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        Command[] commandArray;
        for (Command command : commandArray = this.commandContainer.getPreUninstallCommands(installOptionArray, installableProductArray)) {
            installFlowControlHandler.checkTaskState();
            command.undo(string, file, installFlowControlHandler);
            PreProductInstaller.update(installStatusObserverArray);
        }
    }

    @Override
    public long getUninstallUnits(String string, File file, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray, ProductContainer productContainer, ComponentContainer componentContainer) {
        Command[] commandArray = this.commandContainer.getPreUninstallCommands(installOptionArray, installableProductArray);
        return (long)commandArray.length * 0x100000L;
    }

    @Override
    public void calculateSpaceRequired(String string, File file, InstallableProduct[] installableProductArray, InstallableProduct[] installableProductArray2, ProductContainer productContainer, ComponentContainer componentContainer, ComponentAggregator componentAggregator) {
    }
}

