/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.mathworks.install.AvailableProduct;
import com.mathworks.install.CorruptedArchivesException;
import com.mathworks.install.SoftwareManager;
import com.mathworks.install.SoftwareManagerBuilder;
import com.mathworks.install.XMLParseException;
import com.mathworks.install.input.ComponentURLProvider;
import com.mathworks.install.input.InstallationInputFile;
import com.mathworks.install.input.InstallationInputFileFactory;
import com.mathworks.install.input.XMLInstallationFileParser;
import com.mathworks.instutil.ExecutorServiceManager;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class AbstractSoftwareManagerBuilder
implements SoftwareManagerBuilder {
    private static final int ZIPFILE_LIST_SIZE = 100;
    private static final String ZIPFILE_PREFIX = "platform_";
    private static final String ZIPFILE_SUFFIX = ".zip";
    protected final ExecutorServiceManager executorServiceManager;
    protected final InstallationInputFileFactory installationInputFileFactory;
    protected final AppLogger appLogger;
    private final XMLInstallationFileParser xmlInstallationFileParser;
    private final Map<File, Exception> corruptedArchives = Collections.synchronizedMap(new HashMap());
    private final Map<Future<?>, File> currentlyReadingArchives = new HashMap();
    private boolean readingArchives = false;
    private Future<?> archivesListFilesFuture;

    public AbstractSoftwareManagerBuilder(ExecutorServiceManager executorServiceManager, InstallationInputFileFactory installationInputFileFactory, AppLogger appLogger, XMLInstallationFileParser xMLInstallationFileParser) {
        this.executorServiceManager = executorServiceManager;
        this.installationInputFileFactory = installationInputFileFactory;
        this.appLogger = appLogger;
        this.xmlInstallationFileParser = xMLInstallationFileParser;
    }

    protected static void deselectOlderVersionsOfSelectedProducts(SoftwareManager softwareManager) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (AvailableProduct availableProduct : softwareManager.getAvailableProducts()) {
            int n = availableProduct.getProductNumber();
            if (hashSet.contains(n)) {
                availableProduct.setSelected(false);
                continue;
            }
            hashSet.add(n);
        }
    }

    @Override
    public synchronized void startReadingArchives(final File[] fileArray) {
        this.readingArchives = true;
        this.archivesListFilesFuture = this.executorServiceManager.submitToSingleThreadedExecutorService((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AbstractSoftwareManagerBuilder.this.appLogger.logMsg("Starting local product/component search in download directory");
                AbstractSoftwareManagerBuilder.this.startParsingInstallationInputFiles(AbstractSoftwareManagerBuilder.this.getFilesToReadIn(fileArray));
                return null;
            }
        });
    }

    private void startParsingInstallationInputFiles(Collection<InstallationInputFile> collection) {
        for (final InstallationInputFile installationInputFile : collection) {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        installationInputFile.parse();
                    }
                    catch (XMLParseException | IOException exception) {
                        AbstractSoftwareManagerBuilder.this.corruptedArchives.put(installationInputFile.getFile(), exception);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    return null;
                }
            };
            this.currentlyReadingArchives.put(this.executorServiceManager.submitToSingleThreadedExecutorService((Callable)callable), installationInputFile.getFile());
        }
        this.executorServiceManager.submitToSingleThreadedExecutorService((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AbstractSoftwareManagerBuilder.this.appLogger.logMsg("Completed local product/component search");
                return null;
            }
        });
    }

    @Override
    public synchronized void finishReadingArchives() throws CorruptedArchivesException {
        if (!this.readingArchives) {
            throw new IllegalStateException("startReadingArchives must be called prior to calling finishReadingArchives");
        }
        try {
            this.archivesListFilesFuture.get();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
            return;
        }
        for (Future<?> future : this.currentlyReadingArchives.keySet()) {
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (ExecutionException executionException) {
                this.corruptedArchives.put(this.currentlyReadingArchives.get(future), executionException);
            }
        }
        if (!this.corruptedArchives.isEmpty()) {
            HashMap hashMap = new HashMap();
            hashMap.putAll(this.corruptedArchives);
            this.corruptedArchives.clear();
            throw new CorruptedArchivesException(hashMap);
        }
    }

    @Override
    public synchronized boolean isFinishedReadingArchives() {
        if (this.archivesListFilesFuture != null && !this.archivesListFilesFuture.isDone()) {
            return false;
        }
        if (this.archivesListFilesFuture == null) {
            return false;
        }
        for (Future<?> future : this.currentlyReadingArchives.keySet()) {
            if (future.isDone()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addReleaseData(File file, ComponentURLProvider componentURLProvider) {
        ArrayList<InstallationInputFile> arrayList = new ArrayList<InstallationInputFile>();
        arrayList.add(this.installationInputFileFactory.createInstallationFile(file, componentURLProvider, this.xmlInstallationFileParser));
        this.startParsingInstallationInputFiles(arrayList);
        try {
            this.finishReadingArchives();
        }
        catch (CorruptedArchivesException corruptedArchivesException) {
            // empty catch block
        }
    }

    private Collection<InstallationInputFile> getFilesToReadIn(File[] fileArray) throws IOException {
        ArrayList<InstallationInputFile> arrayList = new ArrayList<InstallationInputFile>(100);
        this.appLogger.logMsg("Searching for archives...");
        for (File file : fileArray) {
            String string = file.getPath();
            if (file.exists()) {
                this.appLogger.logMsg("Reading " + string);
                File[] fileArray2 = file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return string.startsWith(AbstractSoftwareManagerBuilder.ZIPFILE_PREFIX) && string.endsWith(AbstractSoftwareManagerBuilder.ZIPFILE_SUFFIX);
                    }
                });
                if (fileArray2.length > 0) {
                    for (File file2 : fileArray2) {
                        if (!file2.isFile() || !file2.canRead()) continue;
                        this.appLogger.logMsg("Extracting " + file2.getPath());
                        arrayList.add(this.installationInputFileFactory.createInstallationFileFromCompressedXML(file2, this.xmlInstallationFileParser));
                    }
                    continue;
                }
                Object[] objectArray = this.installationInputFileFactory.createInstallationFiles(file, this.xmlInstallationFileParser);
                arrayList.addAll(Arrays.asList(objectArray));
                this.appLogger.logMsg(objectArray.length + " files found in " + string);
                continue;
            }
            this.appLogger.logMsg(string + " doesn't exist ... skipping.");
        }
        this.appLogger.logMsg("Archive search complete.  " + arrayList.size() + " total files found.");
        return arrayList;
    }
}

