/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.view.welcome;

import com.mathworks.activationclient.resources.CommercialActivationComponentName;
import com.mathworks.activationclient.view.CommercialActivationPanel;
import com.mathworks.activationclient.view.welcome.WelcomePanel;
import com.mathworks.activationclient.view.welcome.WelcomePanelController;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instwiz.ButtonFactory;
import com.mathworks.instwiz.ButtonProperties;
import com.mathworks.instwiz.InstWizardIntf;
import com.mathworks.instwiz.SwingComponentFactory;
import com.mathworks.instwiz.WIButtonProperties;
import com.mathworks.instwiz.WIPanel;
import com.mathworks.instwiz.WIPanelBuilder;
import com.mathworks.instwiz.proxy.ProxyDialog;
import com.mathworks.instwiz.resources.ComponentName;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;

final class WelcomePanelImpl
extends CommercialActivationPanel
implements WelcomePanel {
    private final JButton fNextButton;
    private final JRadioButton fRecommendedRadioButton;
    private final JRadioButton fNotRecommendedRadioButton;
    private ProxyDialog fProxyDialog;
    private final JButton fAdvancedButton;
    private final WelcomePanelController fController;

    WelcomePanelImpl(InstWizardIntf instWizardIntf, final WelcomePanelController welcomePanelController) {
        super(instWizardIntf, CommercialActivationComponentName.AC_WELCOME_PANEL);
        this.fController = welcomePanelController;
        InstUtilResourceBundle instUtilResourceBundle = this.getResources();
        ButtonFactory buttonFactory = instWizardIntf.getButtonFactory();
        JButton jButton = buttonFactory.createButton((ButtonProperties)WIButtonProperties.BACK, null, (ComponentName)CommercialActivationComponentName.AC_WELCOME_BACK_BUTTON);
        jButton.setEnabled(false);
        this.fNextButton = buttonFactory.createButton((ButtonProperties)WIButtonProperties.NEXT, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                welcomePanelController.nextButton();
            }
        }, (ComponentName)CommercialActivationComponentName.AC_WELCOME_NEXT_BUTTON);
        JButton jButton2 = buttonFactory.createCancelButton((ComponentName)CommercialActivationComponentName.AC_WELCOME_CANCEL_BUTTON);
        JButton jButton3 = buttonFactory.createButton((ButtonProperties)WIButtonProperties.HELP, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WelcomePanelImpl.this.fController.helpButton();
            }
        }, (ComponentName)CommercialActivationComponentName.AC_WELCOME_HELP_BUTTON);
        String string = instUtilResourceBundle.getString("welcome.bold");
        SwingComponentFactory swingComponentFactory = instWizardIntf.getSwingComponentFactory();
        JTextComponent jTextComponent = swingComponentFactory.createLabel(string);
        Font font = this.getBoldFont();
        jTextComponent.setFont(font);
        jTextComponent.setName(CommercialActivationComponentName.AC_WELCOME_HEADER_LABEL.toString());
        String string2 = instUtilResourceBundle.getString("welcome.text");
        JTextComponent jTextComponent2 = swingComponentFactory.createLabel(string2);
        String string3 = instUtilResourceBundle.getString("welcome.recommended");
        this.fRecommendedRadioButton = swingComponentFactory.createRadioButton(string3, (ComponentName)CommercialActivationComponentName.AC_WELCOME_ONLINE_RB);
        this.fRecommendedRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    welcomePanelController.activateOnline(true);
                    WelcomePanelImpl.this.fAdvancedButton.setEnabled(true);
                }
            }
        });
        String string4 = instUtilResourceBundle.getString("welcome.not");
        this.fNotRecommendedRadioButton = swingComponentFactory.createRadioButton(string4, (ComponentName)CommercialActivationComponentName.AC_WELCOME_OFFLINE_RB);
        this.fNotRecommendedRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    welcomePanelController.activateOnline(false);
                    WelcomePanelImpl.this.fAdvancedButton.setEnabled(false);
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.fRecommendedRadioButton);
        buttonGroup.add(this.fNotRecommendedRadioButton);
        this.fAdvancedButton = buttonFactory.createButton((ButtonProperties)WIButtonProperties.ADVANCED, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WelcomePanelImpl.this.fProxyDialog.setVisible(true);
            }
        }, (ComponentName)CommercialActivationComponentName.AC_WELCOME_ADVANCED_BUTTON);
        JButton[] jButtonArray = new JButton[]{jButton, this.fNextButton};
        JButton[] jButtonArray2 = new JButton[]{jButton2, jButton3};
        JPanel jPanel = this.layoutButtons(jButtonArray, jButtonArray2);
        this.add(jPanel, "South");
        WIPanelBuilder wIPanelBuilder = this.createPanelBuilder();
        wIPanelBuilder.addRow(new JComponent[]{jTextComponent});
        wIPanelBuilder.addRow(new JComponent[]{jTextComponent2});
        wIPanelBuilder.addLeftWeightedRow(new JComponent[]{this.fRecommendedRadioButton, this.fAdvancedButton});
        wIPanelBuilder.addRow(new JComponent[]{this.fNotRecommendedRadioButton});
        this.add(wIPanelBuilder.buildPanel(), "Center");
        String string5 = instUtilResourceBundle.getString("welcome.title");
        this.setDefaults(this.fNextButton, this.fNextButton, string5);
        this.getAccessibleContext().setAccessibleName(string5 + ". " + string2);
        this.fRecommendedRadioButton.setOpaque(false);
        this.fNotRecommendedRadioButton.setOpaque(false);
    }

    @Override
    public void preDisplay() {
        InstWizardIntf instWizardIntf = this.getApp();
        AccessibleContext accessibleContext = instWizardIntf.getAccessibleContext();
        String string = this.getAccessibleContext().getAccessibleName();
        accessibleContext.setAccessibleName(string);
    }

    @Override
    public WIPanel getPanel() {
        return this;
    }

    public JButton getAdvancedButton() {
        return this.fAdvancedButton;
    }

    public JRadioButton getNotRecommendedRadioButton() {
        return this.fNotRecommendedRadioButton;
    }

    public ProxyDialog getProxyDialog() {
        return this.fProxyDialog;
    }

    @Override
    public void setProxyDialog(ProxyDialog proxyDialog) {
        this.fProxyDialog = proxyDialog;
    }

    public JRadioButton getRecommendedRadioButton() {
        return this.fRecommendedRadioButton;
    }

    public JButton getNextButton() {
        return this.fNextButton;
    }

    @Override
    public void setNextButtonEnabled(boolean bl) {
        this.fNextButton.setEnabled(bl);
    }

    @Override
    public void setRecommended(boolean bl) {
        this.fRecommendedRadioButton.setSelected(bl);
        this.fNotRecommendedRadioButton.setSelected(!bl);
    }

    @Override
    public void setPreLoggedIn() {
        this.fRecommendedRadioButton.setVisible(false);
        this.fNotRecommendedRadioButton.setVisible(false);
        this.fAdvancedButton.setVisible(false);
    }

    @Override
    public void setDcAnonymous(boolean bl) {
        this.fController.setDcAnonymous(bl);
    }

    @Override
    public boolean isDcAnonymous() {
        return this.fController.isDcAnonymous();
    }
}

