/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.view.login;

import com.mathworks.activationclient.resources.CommercialActivationComponentName;
import com.mathworks.activationclient.view.AdapterDocumentListener;
import com.mathworks.activationclient.view.CommercialActivationPanel;
import com.mathworks.activationclient.view.login.LoginPanel;
import com.mathworks.activationclient.view.login.LoginPanelController;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.wizard.ComponentName;
import com.mathworks.instwiz.ButtonFactory;
import com.mathworks.instwiz.ButtonProperties;
import com.mathworks.instwiz.InstWizardIntf;
import com.mathworks.instwiz.SwingComponentFactory;
import com.mathworks.instwiz.WIButtonProperties;
import com.mathworks.instwiz.WIEditorPane;
import com.mathworks.instwiz.WIPanel;
import com.mathworks.instwiz.WIPanelBuilder;
import com.mathworks.instwiz.arch.ArchGui;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

final class LoginPanelImpl
extends CommercialActivationPanel
implements LoginPanel {
    private final JButton nextButton;
    private final JButton backButton;
    private final JTextComponent emailField;
    private final JTextComponent fLicenseTextField;
    private final JButton fBrowseButton;
    private final JPasswordField passwordField;
    private final JRadioButton loginRadioButton;
    private final JRadioButton createAccountRadioButton;
    private final JRadioButton haveLicenseFileRadioButton;
    private final LoginPanelController controller;

    LoginPanelImpl(InstWizardIntf instWizardIntf, final LoginPanelController loginPanelController) {
        super(instWizardIntf, CommercialActivationComponentName.AC_LOGIN_PANEL);
        this.controller = loginPanelController;
        InstUtilResourceBundle instUtilResourceBundle = this.getResources();
        SwingComponentFactory swingComponentFactory = instWizardIntf.getSwingComponentFactory();
        String string = instUtilResourceBundle.getString("label.email");
        JTextComponent jTextComponent = swingComponentFactory.createLabelNonWrapping(string);
        this.emailField = swingComponentFactory.createTextField((ComponentName)CommercialActivationComponentName.AC_LOGIN_EMAIL_FIELD, string);
        Document document = this.emailField.getDocument();
        document.addDocumentListener(new AdapterDocumentListener(this.emailField){

            @Override
            protected void setAdapterField(String string) {
                loginPanelController.setEmailAddress(string);
            }
        });
        String string2 = instUtilResourceBundle.getString("label.password");
        JTextComponent jTextComponent2 = swingComponentFactory.createLabelNonWrapping(string2);
        this.passwordField = swingComponentFactory.createPasswordField((com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.AC_LOGIN_PASSWORD_FIELD);
        Document document2 = this.passwordField.getDocument();
        document2.addDocumentListener(new AdapterDocumentListener(this.passwordField){

            @Override
            protected void setAdapterField(String string) {
                loginPanelController.setPassword(string);
            }
        });
        this.passwordField.getAccessibleContext().setAccessibleName(string2);
        String string3 = instUtilResourceBundle.getString("options.rb2");
        this.fLicenseTextField = swingComponentFactory.createTextField((ComponentName)CommercialActivationComponentName.AC_LOGIN_LICENSE_FIELD, string3);
        this.fLicenseTextField.getDocument().addDocumentListener(new AdapterDocumentListener(this.fLicenseTextField){

            @Override
            protected void setAdapterField(String string) {
                LoginPanelImpl.this.controller.setLicenseFile(string);
            }
        });
        ButtonFactory buttonFactory = instWizardIntf.getButtonFactory();
        this.backButton = buttonFactory.createButton((ButtonProperties)WIButtonProperties.BACK, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                loginPanelController.backButton();
            }
        }, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.AC_LOGIN_BACK_BUTTON);
        this.nextButton = buttonFactory.createButton((ButtonProperties)WIButtonProperties.NEXT, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                loginPanelController.nextButton();
            }
        }, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.AC_LOGIN_NEXT_BUTTON);
        JButton jButton = buttonFactory.createCancelButton((com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.AC_LOGIN_CANCEL_BUTTON);
        JButton jButton2 = buttonFactory.createButton((ButtonProperties)WIButtonProperties.HELP, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoginPanelImpl.this.controller.helpButton();
            }
        }, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.AC_LOGIN_HELP_BUTTON);
        String string4 = instUtilResourceBundle.getString("login.top.bold");
        JTextComponent jTextComponent3 = swingComponentFactory.createLabel(string4);
        Font font = this.getBoldFont();
        jTextComponent3.setFont(font);
        String string5 = instUtilResourceBundle.getString("login.top");
        JTextComponent jTextComponent4 = swingComponentFactory.createLabel(string5);
        swingComponentFactory.setupSelectAllOnFocusListener((JTextComponent)this.passwordField);
        String string6 = instUtilResourceBundle.getString("login.can");
        this.loginRadioButton = swingComponentFactory.createRadioButton(string6, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.AC_LOGIN_LOGIN_RB);
        this.loginRadioButton.setSelected(true);
        this.loginRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    loginPanelController.setLoggingIn();
                }
            }
        });
        String string7 = instUtilResourceBundle.getString("login.create");
        this.createAccountRadioButton = swingComponentFactory.createRadioButton(string7, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.AC_LOGIN_CREATE_ACCOUNT_RB);
        this.createAccountRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    loginPanelController.setCreatingAccount();
                }
            }
        });
        this.haveLicenseFileRadioButton = swingComponentFactory.createRadioButton(string3, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.AC_LOGIN_LICENSE_RB);
        this.haveLicenseFileRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    loginPanelController.setActivatingOnlineFromLicenseFile();
                }
            }
        });
        ArchGui archGui = instWizardIntf.getArchGui();
        this.fBrowseButton = buttonFactory.createButton((ButtonProperties)WIButtonProperties.BROWSE, archGui.createLicenseFileBrowseAction(instWizardIntf, this.fLicenseTextField), (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.AC_LOGIN_BROWSE_BUTTON);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.loginRadioButton);
        buttonGroup.add(this.createAccountRadioButton);
        buttonGroup.add(this.haveLicenseFileRadioButton);
        String string8 = instUtilResourceBundle.getString("forgotpassword");
        WIEditorPane wIEditorPane = new WIEditorPane(instWizardIntf, MessageFormat.format(string8, instWizardIntf.getHyperlinkProvider().getForgotPasswordLink()));
        JButton[] jButtonArray = new JButton[]{this.backButton, this.nextButton};
        JButton[] jButtonArray2 = new JButton[]{jButton, jButton2};
        JPanel jPanel = this.layoutButtons(jButtonArray, jButtonArray2);
        this.add(jPanel, "South");
        WIPanelBuilder wIPanelBuilder = this.createPanelBuilder();
        wIPanelBuilder.addRow(new JComponent[]{jTextComponent3});
        wIPanelBuilder.addRow(new JComponent[]{jTextComponent4});
        wIPanelBuilder.addRow(new JComponent[]{this.loginRadioButton});
        wIPanelBuilder.addSubRow(new JComponent[]{jTextComponent, this.emailField});
        wIPanelBuilder.addSubRow(new JComponent[]{jTextComponent2, this.passwordField});
        wIPanelBuilder.addSubRow(new JComponent[]{new JLabel(), wIEditorPane});
        wIPanelBuilder.addRow(new JComponent[]{this.createAccountRadioButton});
        wIPanelBuilder.addRow(new JComponent[]{this.haveLicenseFileRadioButton});
        wIPanelBuilder.addSubRow(new JComponent[]{swingComponentFactory.createFieldAndButtonWidget((JComponent)this.fLicenseTextField, (JComponent)this.fBrowseButton)});
        this.add(wIPanelBuilder.buildPanel(), "Center");
        String string9 = instUtilResourceBundle.getString("login.title");
        this.setDefaults(this.nextButton, this.emailField, string9);
        this.loginRadioButton.setOpaque(false);
        this.createAccountRadioButton.setOpaque(false);
        this.haveLicenseFileRadioButton.setOpaque(false);
    }

    @Override
    public WIPanel getPanel() {
        return this;
    }

    @Override
    public void setLoggingInOption() {
        this.emailField.setEnabled(true);
        this.passwordField.setEnabled(true);
        this.createAccountRadioButton.setSelected(false);
        this.haveLicenseFileRadioButton.setSelected(false);
        this.fLicenseTextField.setEnabled(false);
        this.fBrowseButton.setEnabled(false);
    }

    @Override
    public void setCreateAccountOption() {
        this.emailField.setEnabled(false);
        this.passwordField.setEnabled(false);
        this.haveLicenseFileRadioButton.setSelected(false);
        this.fLicenseTextField.setEnabled(false);
        this.fBrowseButton.setEnabled(false);
    }

    @Override
    public void setProvideLicenseFile() {
        this.fLicenseTextField.setEnabled(true);
        this.fBrowseButton.setEnabled(true);
        this.loginRadioButton.setSelected(false);
        this.emailField.setEnabled(false);
        this.passwordField.setEnabled(false);
        this.createAccountRadioButton.setSelected(false);
    }

    @Override
    public void setLicenseTextFieldEnabled(boolean bl) {
        this.fLicenseTextField.setEnabled(bl);
    }

    @Override
    public void setBrowseButtonEnabled(boolean bl) {
        this.fBrowseButton.setEnabled(bl);
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    @Override
    public void setEmailTextFieldEnabled(boolean bl) {
        this.emailField.setEnabled(bl);
    }

    @Override
    public void setNextButtonEnabled(boolean bl) {
        this.nextButton.setEnabled(bl);
    }

    @Override
    public void setPasswordFieldEnabled(boolean bl) {
        this.passwordField.setEnabled(bl);
    }

    JButton getBackButton() {
        return this.backButton;
    }

    JTextComponent getEmailField() {
        return this.emailField;
    }

    JPasswordField getPasswordField() {
        return this.passwordField;
    }

    JRadioButton getLoginRadioButton() {
        return this.loginRadioButton;
    }

    JRadioButton getCreateAccountRadioButton() {
        return this.createAccountRadioButton;
    }

    JButton getBrowseButton() {
        return this.fBrowseButton;
    }

    JTextComponent getLicenseTextField() {
        return this.fLicenseTextField;
    }

    JRadioButton getLicenseFileRadioButton() {
        return this.haveLicenseFileRadioButton;
    }
}

