/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.view.key;

import com.mathworks.activationclient.resources.CommercialActivationComponentName;
import com.mathworks.activationclient.view.AdapterDocumentListener;
import com.mathworks.activationclient.view.CommercialActivationPanel;
import com.mathworks.activationclient.view.key.ActivationKeyPanel;
import com.mathworks.activationclient.view.key.ActivationKeyPanelController;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.wizard.ComponentName;
import com.mathworks.instwiz.ButtonFactory;
import com.mathworks.instwiz.ButtonProperties;
import com.mathworks.instwiz.InstWizardIntf;
import com.mathworks.instwiz.SwingComponentFactory;
import com.mathworks.instwiz.WIButtonProperties;
import com.mathworks.instwiz.WIEditorPane;
import com.mathworks.instwiz.WIPanel;
import com.mathworks.instwiz.WIPanelBuilder;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

final class ActivationKeyPanelImpl
extends CommercialActivationPanel
implements ActivationKeyPanel {
    private final JButton fNextButton;
    private final ActivationKeyPanelController controller;
    private final JTextComponent keyField;
    private final JButton backButton;

    ActivationKeyPanelImpl(InstWizardIntf instWizardIntf, final ActivationKeyPanelController activationKeyPanelController) {
        super(instWizardIntf, CommercialActivationComponentName.AC_KEY_PANEL);
        this.controller = activationKeyPanelController;
        InstUtilResourceBundle instUtilResourceBundle = this.getResources();
        String string = instUtilResourceBundle.getString("label.key");
        SwingComponentFactory swingComponentFactory = instWizardIntf.getSwingComponentFactory();
        JTextComponent jTextComponent = swingComponentFactory.createLabel(string);
        this.keyField = swingComponentFactory.createTextField((ComponentName)CommercialActivationComponentName.AC_KEY_AK_FIELD, string);
        Document document = this.keyField.getDocument();
        document.addDocumentListener(new AdapterDocumentListener(this.keyField){

            @Override
            protected void setAdapterField(String string) {
                activationKeyPanelController.updateActivationKey(string);
            }
        });
        ButtonFactory buttonFactory = instWizardIntf.getButtonFactory();
        this.backButton = buttonFactory.createButton((ButtonProperties)WIButtonProperties.BACK, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                activationKeyPanelController.backButton();
            }
        }, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.AC_KEY_BACK_BUTTON);
        this.fNextButton = buttonFactory.createButton((ButtonProperties)WIButtonProperties.NEXT, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                activationKeyPanelController.nextButton();
            }
        }, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.AC_KEY_NEXT_BUTTON);
        JButton jButton = buttonFactory.createCancelButton((com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.AC_KEY_CANCEL_BUTTON);
        JButton jButton2 = buttonFactory.createButton((ButtonProperties)WIButtonProperties.HELP, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActivationKeyPanelImpl.this.controller.helpButton();
            }
        }, (com.mathworks.instwiz.resources.ComponentName)CommercialActivationComponentName.AC_KEY_HELP_BUTTON);
        String string2 = instUtilResourceBundle.getString("key.top");
        JTextComponent jTextComponent2 = swingComponentFactory.createLabel(string2);
        Font font = this.getBoldFont();
        jTextComponent2.setFont(font);
        String string3 = instUtilResourceBundle.getString("key.bottom");
        MessageFormat messageFormat = new MessageFormat(string3);
        Object[] objectArray = new Object[]{new PlatformImpl().getLocalizedHelpPath(instUtilResourceBundle.getString("help.key"), this.controller.getRootDir())};
        String string4 = messageFormat.format(objectArray);
        WIEditorPane wIEditorPane = new WIEditorPane(instWizardIntf, string4);
        JButton[] jButtonArray = new JButton[]{this.backButton, this.fNextButton};
        JButton[] jButtonArray2 = new JButton[]{jButton, jButton2};
        JPanel jPanel = this.layoutButtons(jButtonArray, jButtonArray2);
        this.add(jPanel, "South");
        WIPanelBuilder wIPanelBuilder = this.createPanelBuilder();
        wIPanelBuilder.addRow(new JComponent[]{jTextComponent2});
        wIPanelBuilder.addRow(new JComponent[]{jTextComponent, this.keyField});
        wIPanelBuilder.addRow(new JComponent[]{wIEditorPane});
        this.add(wIPanelBuilder.buildPanel(), "Center");
        String string5 = instUtilResourceBundle.getString("key.title");
        this.setDefaults(this.fNextButton, this.keyField, string5);
    }

    @Override
    public void preDisplay() {
        this.controller.updateActivationKey(this.keyField.getText());
        super.preDisplay();
    }

    public JButton getNextButton() {
        return this.fNextButton;
    }

    @Override
    public void setNextButtonEnabled(boolean bl) {
        this.fNextButton.setEnabled(bl);
    }

    @Override
    public WIPanel getPanel() {
        return this;
    }

    JButton getBackButton() {
        return this.backButton;
    }

    JTextComponent getKeyField() {
        return this.keyField;
    }
}

