/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.view.confirm;

import com.mathworks.activationclient.resources.CommercialActivationComponentName;
import com.mathworks.activationclient.view.CommercialActivationPanel;
import com.mathworks.activationclient.view.confirm.ConfirmationPanel;
import com.mathworks.activationclient.view.confirm.ConfirmationPanelController;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instwiz.ButtonFactory;
import com.mathworks.instwiz.ButtonProperties;
import com.mathworks.instwiz.InstWizardIntf;
import com.mathworks.instwiz.SwingComponentFactory;
import com.mathworks.instwiz.WIButtonProperties;
import com.mathworks.instwiz.WIPanel;
import com.mathworks.instwiz.WIPanelBuilder;
import com.mathworks.instwiz.resources.ComponentName;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.text.JTextComponent;

final class ConfirmationPanelImpl
extends CommercialActivationPanel
implements ConfirmationPanel {
    private final JTextComponent fEditorPane;
    private final JButton fNextButton;
    private final JButton fBackButton;

    ConfirmationPanelImpl(InstWizardIntf instWizardIntf, final ConfirmationPanelController confirmationPanelController) {
        super(instWizardIntf, CommercialActivationComponentName.CONFIRM_PANEL);
        ButtonFactory buttonFactory = instWizardIntf.getButtonFactory();
        this.fBackButton = buttonFactory.createButton((ButtonProperties)WIButtonProperties.BACK, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                confirmationPanelController.backButton();
            }
        }, (ComponentName)CommercialActivationComponentName.CONFIRM_BACK_BUTTON);
        final InstUtilResourceBundle instUtilResourceBundle = this.getResources();
        ButtonProperties buttonProperties = new ButtonProperties(){

            public String getText(InstUtilResourceBundle instUtilResourceBundle2) {
                return instUtilResourceBundle.getString("button.activate");
            }

            public int getMnemonic(InstUtilResourceBundle instUtilResourceBundle2) {
                return 65;
            }

            public String getAccessibleName(InstUtilResourceBundle instUtilResourceBundle2) {
                return this.getText(instUtilResourceBundle2);
            }
        };
        this.fNextButton = buttonFactory.createButton(buttonProperties, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                confirmationPanelController.nextButton();
            }
        }, (ComponentName)CommercialActivationComponentName.CONFIRM_NEXT_BUTTON);
        JButton jButton = buttonFactory.createCancelButton((ComponentName)CommercialActivationComponentName.CONFIRM_CANCEL_BUTTON);
        JButton jButton2 = buttonFactory.createButton((ButtonProperties)WIButtonProperties.HELP, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                confirmationPanelController.helpButton();
            }
        }, (ComponentName)CommercialActivationComponentName.CONFIRM_HELP_BUTTON);
        String string = instUtilResourceBundle.getString("confirm.bold");
        SwingComponentFactory swingComponentFactory = instWizardIntf.getSwingComponentFactory();
        JTextComponent jTextComponent = swingComponentFactory.createLabel(string);
        Font font = this.getBoldFont();
        jTextComponent.setFont(font);
        this.fEditorPane = swingComponentFactory.createPrintableEditorPane(instWizardIntf, "", (ComponentName)CommercialActivationComponentName.CONFIRM_TEXT_PANE);
        JScrollPane jScrollPane = new JScrollPane(this.fEditorPane);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setPreferredSize(new Dimension(0, 0));
        JButton[] jButtonArray = new JButton[]{this.fBackButton, this.fNextButton};
        JButton[] jButtonArray2 = new JButton[]{jButton, jButton2};
        JPanel jPanel = this.layoutButtons(jButtonArray, jButtonArray2);
        this.add(jPanel, "South");
        WIPanelBuilder wIPanelBuilder = this.createPanelBuilder();
        wIPanelBuilder.addRow(new JComponent[]{jTextComponent});
        wIPanelBuilder.addVerticalFillRow(new JComponent[]{jScrollPane});
        this.add(wIPanelBuilder.buildPanel(), "Center");
        String string2 = instUtilResourceBundle.getString("confirm.title");
        this.setDefaults(this.fNextButton, this.fNextButton, string2);
    }

    @Override
    public void setConfirmationText(String string) {
        this.fEditorPane.setText(string);
        this.fEditorPane.setCaretPosition(0);
    }

    public JButton getNextButton() {
        return this.fNextButton;
    }

    @Override
    public void setNextButtonEnabled(boolean bl) {
        this.fNextButton.setEnabled(bl);
    }

    @Override
    public WIPanel getPanel() {
        return this;
    }

    JTextComponent getEditorPane() {
        return this.fEditorPane;
    }

    JButton getBackButton() {
        return this.fBackButton;
    }
}

