/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.view;

import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.MachineInfo;
import com.mathworks.instwiz.OptionPaneHandler;
import java.text.MessageFormat;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;

public class UserNameDocument
extends PlainDocument {
    private InstUtilResourceBundle resources;
    private OptionPaneHandler optionPaneHandler;
    private boolean sure;
    private String arch;

    public UserNameDocument(InstUtilResourceBundle instUtilResourceBundle, OptionPaneHandler optionPaneHandler) {
        this.resources = instUtilResourceBundle;
        this.optionPaneHandler = optionPaneHandler;
        this.arch = MachineInfo.getArch();
    }

    public UserNameDocument(InstUtilResourceBundle instUtilResourceBundle, OptionPaneHandler optionPaneHandler, String string) {
        this.resources = instUtilResourceBundle;
        this.optionPaneHandler = optionPaneHandler;
        this.arch = string;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.areYouSure()) {
            super.insertString(n, string, attributeSet);
        }
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        if (this.areYouSure()) {
            super.remove(n, n2);
        }
    }

    @Override
    public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.areYouSure()) {
            super.replace(n, n2, string, attributeSet);
        }
    }

    private boolean areYouSure() {
        if (!this.sure) {
            String string = this.resources.getString("other.warn.title");
            String string2 = this.getFormattedText(string, false);
            String string3 = this.resources.getString("other.warn.message");
            String string4 = this.getFormattedText(string3, true);
            int n = this.optionPaneHandler.show(string4, string2, 3, 0);
            if (n == 0) {
                this.sure = true;
                return true;
            }
            return false;
        }
        return true;
    }

    public void setTextWithoutCheck(String string) throws BadLocationException {
        int n = this.getLength();
        super.remove(0, n);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        if (string.equalsIgnoreCase("administrator") || string.equalsIgnoreCase("root")) {
            super.insertString(0, "", simpleAttributeSet);
            this.sure = true;
        } else {
            super.insertString(0, string, simpleAttributeSet);
        }
    }

    private String getFormattedText(String string, boolean bl) {
        String[] stringArray;
        MessageFormat messageFormat = new MessageFormat(string);
        String string2 = this.resources.getString("label.user." + this.arch);
        if (bl) {
            String string3 = string2.toLowerCase().replaceAll("windows", "Windows");
            stringArray = new String[]{string3};
        } else {
            stringArray = new String[]{string2};
        }
        return messageFormat.format(stringArray);
    }
}

