/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.silent;

import com.mathworks.activationclient.silent.SilentActivationController;
import com.mathworks.instutil.FileIO;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.FilePermissionsUtil;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.InstUtilExceptionHandler;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.InstallerUtilities;
import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.Machine;
import com.mathworks.instutil.MachineInfo;
import com.mathworks.instutil.licensefiles.LicenseFileParser;
import com.mathworks.instutil.licensefiles.LicenseFileParserImpl;
import com.mathworks.instutil.licensefiles.LicenseFileWriter;
import com.mathworks.instutil.licensefiles.LicenseLocationFactory;
import com.mathworks.instutil.licensefiles.LicenseUtilityFactory;
import com.mathworks.instutil.licensefiles.MarkerUtilityFactory;
import com.mathworks.instutil.licensefiles.OverrideableLicenseLocationFactory;
import com.mathworks.instwiz.WILogger;
import com.mathworks.instwiz.WIResourceBundle;
import com.mathworks.internal.mwaws.client.v6.ArrayOfMWMessage;
import com.mathworks.internal.mwaws.client.v6.MWAActivateResponse;
import com.mathworks.internal.mwaws.client.v6.MWAEnableHostedLicenseManagementResponse;
import com.mathworks.internal.mwaws.client.v6.MWMessage;
import com.mathworks.mlwebservices.ActivationService;
import com.mathworks.mlwebservices.LicenseManagementTypes;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class SilentActivationControllerImpl
implements SilentActivationController,
LicenseFileWriter {
    private final Properties properties;
    private IO io;
    private String lockingTypeName;
    private ActivateCommand activateCommand = null;
    private ActivationService aws = null;
    private final Map<String, ActivateCommand> activateCommandMap = new HashMap<String, ActivateCommand>();
    private String activationKey = "";
    private final String[] arches;
    private final String clientVersion;
    private String matlabRoot;
    private Machine info;
    private final WIResourceBundle resourceBundle;
    private FilePermissionsUtil filePermUtil;
    private String licenseFilePath;
    private String licenseString;
    private WILogger logger;
    private final LicenseLocationFactory licenseLocationFactory;
    private String token;
    private String username = "";
    private boolean onlineActivation = false;

    public SilentActivationControllerImpl(WIResourceBundle wIResourceBundle, WILogger wILogger, Properties properties, ActivationService activationService) {
        this.logger = wILogger;
        this.aws = activationService;
        this.resourceBundle = wIResourceBundle;
        this.setupActivateCommandMap();
        this.properties = properties;
        this.handleProperties(properties);
        this.clientVersion = InstallerUtilities.getClientVersion((InstUtilResourceBundle)this.resourceBundle);
        String string = InstallerUtilities.getLibDirPath((String)this.matlabRoot);
        this.info = this.getMachineInfo(string);
        this.filePermUtil = this.getFilePermissionUtil(string);
        this.io = this.getIO(string);
        this.arches = new String[]{MachineInfo.getArch()};
        this.licenseLocationFactory = new OverrideableLicenseLocationFactory(properties);
    }

    @Override
    public boolean activate() {
        String string;
        boolean bl;
        block6: {
            bl = false;
            if (null != this.activateCommand) {
                try {
                    this.activateCommand.execute();
                    if (this.licenseString != null && !"".equals(this.licenseString)) {
                        this.logger.info(this.resourceBundle.getString("log.silent.installingLicenseFile"));
                        string = LicenseUtilityFactory.createDefaultLicenseUtilityForTSUR((LicenseFileWriter)this, (String)this.licenseString);
                        LicenseFileParserImpl licenseFileParserImpl = new LicenseFileParserImpl();
                        bl = string.installLicense((LicenseFileParser)licenseFileParserImpl);
                        break block6;
                    }
                    if (this.onlineActivation) {
                        this.logger.info("Installing Marker File");
                        string = MarkerUtilityFactory.createOnlineMarkerUtility((String)"", (String)this.matlabRoot, (String)this.getHostName(), (Properties)this.properties);
                        string.installMarkerFile();
                        break block6;
                    }
                    this.logger.severe("Activation failed: no license file");
                }
                catch (Exception exception) {
                    this.exception(exception);
                }
            } else {
                this.logger.severe(this.resourceBundle.getString("log.silent.noCommandDefined"));
            }
        }
        string = bl ? this.resourceBundle.getString("log.silent.success") : MessageFormat.format(this.resourceBundle.getString("log.silent.fail"), this.logger.getLogPath());
        this.logger.info(string);
        System.out.println(string);
        return bl;
    }

    void activateDcAnon() throws RemoteException {
        this.logger.info(this.resourceBundle.getString("log.silent.activatingDcAnon"));
        if ("".equalsIgnoreCase(this.activationKey)) {
            this.logger.severe(this.resourceBundle.getString("log.silent.missingAK"));
            return;
        }
        MWAActivateResponse mWAActivateResponse = this.aws.activateAnonymous(this.info.getMachineAttributes(), this.activationKey, null, this.arches, this.clientVersion);
        this.handleActivateResponse(mWAActivateResponse);
    }

    void activateOffline() {
        this.logger.info(this.resourceBundle.getString("log.silent.activatingOffline"));
        if (this.licenseFilePath != null) {
            this.licenseString = InstallerUtilities.readFileIntoString((String)this.licenseFilePath, (InstUtilExceptionHandler)this);
        } else {
            this.logger.severe("Offline activation failed: Missing license file");
        }
    }

    void activateTrials() throws RemoteException {
        this.logger.info("Activating Trial");
        MWAActivateResponse mWAActivateResponse = this.aws.activateSelf(this.info.getMachineAttributes(), this.token, null, this.arches, this.clientVersion, this.username, this.getActivationKey(), this.lockingTypeName);
        this.handleActivateResponse(mWAActivateResponse);
    }

    void activateDcOnline() throws RemoteException {
        this.logger.info("Activating DC Online");
        MWAEnableHostedLicenseManagementResponse mWAEnableHostedLicenseManagementResponse = this.aws.activateINUManaged(this.token, null, this.getActivationKey(), this.lockingTypeName, LicenseManagementTypes.IS_MLS_FLEX.getKey(), this.clientVersion);
        this.handleActivateResponse(mWAEnableHostedLicenseManagementResponse);
    }

    void handleActivateResponse(MWAActivateResponse mWAActivateResponse) {
        if (0 != mWAActivateResponse.getResult()) {
            this.logger.severe(this.resourceBundle.getString("log.silent.serviceFailure"));
            ArrayOfMWMessage arrayOfMWMessage = mWAActivateResponse.getMessages();
            if (null != arrayOfMWMessage) {
                MWMessage[] mWMessageArray;
                for (MWMessage mWMessage : mWMessageArray = arrayOfMWMessage.getMessage()) {
                    String string = String.format("Error %d: %s", mWMessage.getCode(), mWMessage.getDescription());
                    this.logger.severe(string);
                }
            }
        } else {
            this.licenseString = mWAActivateResponse.getLicenseFileString();
        }
    }

    void handleActivateResponse(MWAEnableHostedLicenseManagementResponse mWAEnableHostedLicenseManagementResponse) {
        if (0 != mWAEnableHostedLicenseManagementResponse.getResult()) {
            this.logger.severe(this.resourceBundle.getString("log.silent.serviceFailure"));
            ArrayOfMWMessage arrayOfMWMessage = mWAEnableHostedLicenseManagementResponse.getMessages();
            if (null != arrayOfMWMessage) {
                MWMessage[] mWMessageArray;
                for (MWMessage mWMessage : mWMessageArray = arrayOfMWMessage.getMessage()) {
                    String string = String.format("Error %d: %s", mWMessage.getCode(), mWMessage.getDescription());
                    this.logger.severe(string);
                }
            }
        }
    }

    public void setActivationKey(String string) {
        this.activationKey = string;
    }

    public String getActivationKey() {
        return this.activationKey;
    }

    void setActivateCommand(String string) {
        this.activateCommand = this.activateCommandMap.get(string);
    }

    public void exception(Throwable throwable) {
        this.exception(throwable, true);
    }

    public void exception(Throwable throwable, boolean bl) {
        this.logger.severe(this.resourceBundle.getString("log.silent.exception"));
        this.logger.severe(throwable.getMessage());
    }

    public FilePermissions getFilePermissionsUtility() {
        return this.filePermUtil;
    }

    public Machine getMachineInfo() {
        return this.info;
    }

    public WIResourceBundle getResources() {
        return this.resourceBundle;
    }

    public String getRootDir() {
        return this.matlabRoot;
    }

    public boolean isNetworkBased() {
        return false;
    }

    public boolean isNetworkClient(LicenseFileParser licenseFileParser) {
        return false;
    }

    public boolean isNetworkServer() {
        return false;
    }

    public void sendMessage(String string, String string2) {
    }

    public void setMachineInfo(Machine machine) {
        this.info = machine;
    }

    private FilePermissionsUtil getFilePermissionUtil(String string) {
        FilePermissionsUtil filePermissionsUtil = null;
        try {
            filePermissionsUtil = new FilePermissionsUtil(string);
        }
        catch (JNIException jNIException) {
            this.logger.warning(this.resourceBundle.getString("log.silent.missinglib"));
        }
        return filePermissionsUtil;
    }

    private IO getIO(String string) {
        FileIO fileIO = null;
        try {
            fileIO = new FileIO(string, (FilePermissions)this.filePermUtil);
        }
        catch (JNIException jNIException) {
            this.logger.warning(this.resourceBundle.getString("log.silent.missinglib"));
        }
        return fileIO;
    }

    private MachineInfo getMachineInfo(String string) {
        MachineInfo machineInfo = null;
        try {
            machineInfo = new MachineInfo(string);
        }
        catch (JNIException jNIException) {
            this.logger.warning(this.resourceBundle.getString("log.silent.missinglib"));
        }
        return machineInfo;
    }

    private void handleProperties(Properties properties) {
        for (PropertyHandler propertyHandler : PropertyHandler.values()) {
            if (!properties.stringPropertyNames().contains(propertyHandler.name)) continue;
            propertyHandler.action.execute(this, properties.getProperty(propertyHandler.name));
        }
    }

    private void setupActivateCommandMap() {
        this.activateCommandMap.put("activateDcAnon", new ActivateCommand(){

            @Override
            public void execute() throws RemoteException {
                SilentActivationControllerImpl.this.activateDcAnon();
            }
        });
        this.activateCommandMap.put("activateOffline", new ActivateCommand(){

            @Override
            public void execute() {
                SilentActivationControllerImpl.this.activateOffline();
            }
        });
        this.activateCommandMap.put("activateTrials", new ActivateCommand(){

            @Override
            public void execute() throws RemoteException {
                SilentActivationControllerImpl.this.activateTrials();
            }
        });
        this.activateCommandMap.put("activateDCOnline", new ActivateCommand(){

            @Override
            public void execute() throws RemoteException {
                SilentActivationControllerImpl.this.activateDcOnline();
            }
        });
    }

    public LicenseLocationFactory getLicenseLocationFactory() {
        return this.licenseLocationFactory;
    }

    public String getUName() {
        return this.getMachineInfo().getUName();
    }

    public String getHostName() {
        return this.getMachineInfo().getHostName();
    }

    public String getEthernetAddress() {
        return this.getMachineInfo() == null ? "" : this.getMachineInfo().getEthernetAddress();
    }

    public String getIpAddress() {
        return this.getMachineInfo() == null ? "" : this.getMachineInfo().getIpAddress();
    }

    public IO getIO() {
        return this.io;
    }

    private static interface ActivateCommand {
        public void execute() throws RemoteException;
    }

    static enum PropertyHandler {
        ACTIVATE_COMMAND("activateCommand", new PropertyAction(){

            @Override
            public void execute(SilentActivationControllerImpl silentActivationControllerImpl, String string) {
                silentActivationControllerImpl.setActivateCommand(string);
            }
        }),
        LICENSE_FILE("licenseFile", new PropertyAction(){

            @Override
            public void execute(SilentActivationControllerImpl silentActivationControllerImpl, String string) {
                silentActivationControllerImpl.licenseFilePath = string;
            }
        }),
        ACTIVATION_KEY("activationKey", new PropertyAction(){

            @Override
            public void execute(SilentActivationControllerImpl silentActivationControllerImpl, String string) {
                silentActivationControllerImpl.setActivationKey(string);
            }
        }),
        MATLAB_ROOT("matlabRoot", new PropertyAction(){

            @Override
            public void execute(SilentActivationControllerImpl silentActivationControllerImpl, String string) {
                silentActivationControllerImpl.matlabRoot = string;
            }
        }),
        TOKEN("securityToken", new PropertyAction(){

            @Override
            public void execute(SilentActivationControllerImpl silentActivationControllerImpl, String string) {
                silentActivationControllerImpl.token = string;
            }
        }),
        LOCKING_TYPE("lockingTypeName", new PropertyAction(){

            @Override
            public void execute(SilentActivationControllerImpl silentActivationControllerImpl, String string) {
                silentActivationControllerImpl.lockingTypeName = string;
            }
        }),
        ONLINE_ACTIVATION("onlineActivation", new PropertyAction(){

            @Override
            public void execute(SilentActivationControllerImpl silentActivationControllerImpl, String string) {
                silentActivationControllerImpl.onlineActivation = Boolean.valueOf(string);
            }
        }),
        USERNAME("username", new PropertyAction(){

            @Override
            public void execute(SilentActivationControllerImpl silentActivationControllerImpl, String string) {
                silentActivationControllerImpl.username = string;
            }
        });

        private final String name;
        private final PropertyAction action;

        private PropertyHandler(String string2, PropertyAction propertyAction) {
            this.name = string2;
            this.action = propertyAction;
        }

        public String getName() {
            return this.name;
        }
    }

    static interface PropertyAction {
        public void execute(SilentActivationControllerImpl var1, String var2);
    }
}

