/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.controller;

import com.mathworks.activationclient.command.ControllerCommand;
import com.mathworks.activationclient.command.ControllerCommandFactory;
import com.mathworks.activationclient.controller.ApplicationController;
import com.mathworks.activationclient.controller.BasePanelController;
import com.mathworks.activationclient.model.ActivationModel;
import com.mathworks.activationclient.model.message.ActivatingOnline;
import com.mathworks.activationclient.model.message.DcAnonymous;
import com.mathworks.activationclient.model.message.StartStateId;
import com.mathworks.activationclient.model.message.StartStateKey;
import com.mathworks.activationclient.model.message.StartStateStandard;
import com.mathworks.activationclient.model.message.StartStateToken;
import com.mathworks.activationclient.model.message.StartStateTokenId;
import com.mathworks.activationclient.model.message.StartStateTokenKey;
import com.mathworks.activationclient.view.welcome.WelcomePanel;
import com.mathworks.activationclient.view.welcome.WelcomePanelController;

public class WelcomePanelControllerImpl
extends BasePanelController
implements WelcomePanelController {
    private WelcomePanel fPanel;
    private ControllerCommand fNextCommand;
    private ControllerCommand fNonAnonNextCommand;

    public WelcomePanelControllerImpl(ApplicationController applicationController, ActivationModel activationModel, ControllerCommandFactory controllerCommandFactory) {
        super(applicationController, activationModel, controllerCommandFactory);
    }

    @Override
    public final void setPanel(WelcomePanel welcomePanel) {
        assert (null == this.fPanel);
        this.fPanel = welcomePanel;
        boolean bl = this.model.isActivatingOnline();
        this.fPanel.setRecommended(bl);
        super.setPanel(welcomePanel);
    }

    @Override
    public void activateOnline(boolean bl) {
        this.model.setActivatingOnline(bl);
    }

    @Override
    public void setDcAnonymous(boolean bl) {
        this.model.setDcAnonymous(bl);
        this.model.clearAccountForDCAnonSelection();
    }

    @Override
    public boolean isDcAnonymous() {
        return this.model.isDcAnonymous();
    }

    void dispatch(ActivatingOnline activatingOnline) {
        if (activatingOnline.getValue()) {
            ControllerCommand controllerCommand = this.commandFactory.createConnectToServiceCommand(this.fNextCommand);
            this.setNextButtonCommand(controllerCommand);
        } else {
            ControllerCommand controllerCommand = this.commandFactory.createShowActivationOptionsPanelCommand();
            this.setNextButtonCommand(controllerCommand);
        }
    }

    void dispatch(StartStateStandard startStateStandard) {
        this.fNextCommand = this.fNonAnonNextCommand = this.commandFactory.createShowLoginPanelCommand();
    }

    void dispatch(StartStateToken startStateToken) {
        this.fNonAnonNextCommand = this.commandFactory.createGetEntitlementsCommand();
        this.fPanel.setPreLoggedIn();
        this.fNextCommand = this.fNonAnonNextCommand;
    }

    void dispatch(StartStateKey startStateKey) {
        this.fNextCommand = this.fNonAnonNextCommand = this.commandFactory.createShowLoginPanelCommand();
    }

    void dispatch(StartStateTokenKey startStateTokenKey) {
        ControllerCommand controllerCommand = this.commandFactory.createShowLoginPanelCommand();
        this.fNonAnonNextCommand = this.commandFactory.createValidateEntitlementCommand(controllerCommand);
        this.fPanel.setPreLoggedIn();
        this.fNextCommand = this.fNonAnonNextCommand;
    }

    void dispatch(StartStateTokenId startStateTokenId) {
        this.fNonAnonNextCommand = this.commandFactory.createShowActivationKeyPanelCommand();
        this.fPanel.setPreLoggedIn();
        this.fNextCommand = this.fNonAnonNextCommand;
    }

    void dispatch(StartStateId startStateId) {
        this.fNextCommand = this.fNonAnonNextCommand = this.commandFactory.createShowLoginPanelCommand();
    }

    void dispatch(DcAnonymous dcAnonymous) {
        this.fNextCommand = dcAnonymous.getValue() ? (this.model.activationKeyPassedIntoClient() ? this.commandFactory.createValidateEntitlementCommand() : this.commandFactory.createShowActivationKeyPanelCommand()) : this.fNonAnonNextCommand;
        ControllerCommand controllerCommand = this.commandFactory.createConnectToServiceCommand(this.fNextCommand);
        this.setNextButtonCommand(controllerCommand);
    }

    @Override
    String getHelpPath() {
        return "help.welcome";
    }

    ControllerCommand getNextCommand() {
        return this.fNextCommand;
    }

    @Override
    public String getServiceLocation() {
        return this.model.getServiceLocation();
    }
}

