/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.controller;

import com.mathworks.activationclient.command.ControllerCommand;
import com.mathworks.activationclient.command.ControllerCommandFactory;
import com.mathworks.activationclient.controller.ApplicationController;
import com.mathworks.activationclient.controller.BasePanelController;
import com.mathworks.activationclient.model.ActivationModel;
import com.mathworks.activationclient.model.message.CreatingAccountForSelf;
import com.mathworks.activationclient.model.message.StartStateKey;
import com.mathworks.activationclient.model.message.StartStateTokenKey;
import com.mathworks.activationclient.model.message.ValidDataForOnlineActivateLicenseFile;
import com.mathworks.activationclient.model.message.ValidEmailAndPassword;
import com.mathworks.activationclient.view.login.LoginPanel;
import com.mathworks.activationclient.view.login.LoginPanelController;

public class LoginPanelControllerImpl
extends BasePanelController
implements LoginPanelController {
    private LoginPanel panel;
    private ControllerCommand nextCommand;
    private String emailAddress;
    private String password;

    public LoginPanelControllerImpl(ApplicationController applicationController, ActivationModel activationModel, ControllerCommandFactory controllerCommandFactory) {
        super(applicationController, activationModel, controllerCommandFactory);
    }

    @Override
    public final void setPanel(LoginPanel loginPanel) {
        assert (null == this.panel);
        this.panel = loginPanel;
        this.panel.setLoggingInOption();
        super.setPanel(loginPanel);
        this.setNextButtonCommand(null);
    }

    @Override
    public void setPassword(String string) {
        this.password = string;
        this.model.validateEmailPassword(this.emailAddress, this.password);
    }

    @Override
    public void setEmailAddress(String string) {
        this.emailAddress = string;
        this.model.validateEmailPassword(this.emailAddress, this.password);
    }

    @Override
    public void setLoggingIn() {
        this.model.setLoggingIn();
        this.panel.setLoggingInOption();
        this.model.validateEmailPassword(this.emailAddress, this.password);
    }

    @Override
    public void setCreatingAccount() {
        this.model.setCreatingAccount();
        this.panel.setCreateAccountOption();
    }

    void dispatch(ValidEmailAndPassword validEmailAndPassword) {
        if (validEmailAndPassword.getValue()) {
            ControllerCommand controllerCommand = this.commandFactory.createLoginCommand(this.emailAddress, this.password, this.nextCommand);
            this.setNextButtonCommand(controllerCommand);
        } else {
            this.setNextButtonCommand(null);
        }
    }

    void dispatch(CreatingAccountForSelf creatingAccountForSelf) {
        boolean bl = creatingAccountForSelf.getValue();
        if (bl) {
            ControllerCommand controllerCommand = this.commandFactory.createShowCreateAccountPanelCommand();
            this.setNextButtonCommand(controllerCommand);
        }
    }

    void dispatch(StartStateKey startStateKey) {
        ControllerCommand controllerCommand = this.commandFactory.createShowActivationKeyPanelCommand();
        this.nextCommand = this.commandFactory.createValidateEntitlementCommand(controllerCommand);
    }

    void dispatch(StartStateTokenKey startStateTokenKey) {
        ControllerCommand controllerCommand = this.commandFactory.createShowActivationKeyPanelCommand();
        this.nextCommand = this.commandFactory.createValidateEntitlementCommand(controllerCommand);
    }

    @Override
    public void setActivatingOnlineFromLicenseFile() {
        this.model.activatingFromLicenseFile();
        this.panel.setProvideLicenseFile();
    }

    @Override
    public void setLicenseFile(String string) {
        this.model.setLicenseFile(string);
    }

    void dispatch(ValidDataForOnlineActivateLicenseFile validDataForOnlineActivateLicenseFile) {
        boolean bl = validDataForOnlineActivateLicenseFile.getValue();
        if (bl) {
            ControllerCommand controllerCommand = this.commandFactory.createActivateCommand();
            this.setNextButtonCommand(controllerCommand);
        } else if (!this.model.isLoggingIn() && !this.model.isCreatingAccount()) {
            this.setNextButtonCommand(null);
        }
    }

    @Override
    String getHelpPath() {
        return "help.login";
    }

    ControllerCommand getNextCommand() {
        return this.nextCommand;
    }
}

