/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.controller;

import com.mathworks.activationclient.command.ControllerCommand;
import com.mathworks.activationclient.command.ControllerCommandFactory;
import com.mathworks.activationclient.controller.ApplicationController;
import com.mathworks.activationclient.controller.BasePanelController;
import com.mathworks.activationclient.model.ActivationModel;
import com.mathworks.activationclient.view.type.ActivationTypePanel;
import com.mathworks.activationclient.view.type.ActivationTypePanelController;
import com.mathworks.mlwebservices.InstallerEntitlement;
import com.mathworks.mlwebservices.LockingTypeConstants;

public class ActivationTypePanelControllerImpl
extends BasePanelController
implements ActivationTypePanelController {
    private ActivationTypePanel panel;

    public ActivationTypePanelControllerImpl(ApplicationController applicationController, ActivationModel activationModel, ControllerCommandFactory controllerCommandFactory) {
        super(applicationController, activationModel, controllerCommandFactory);
    }

    @Override
    public final void setPanel(ActivationTypePanel activationTypePanel) {
        assert (null == this.panel);
        this.panel = activationTypePanel;
        super.setPanel(activationTypePanel);
    }

    @Override
    String getHelpPath() {
        return "help.type";
    }

    @Override
    public void updateModelSNU() {
        this.model.setActivationTypeSnu();
        this.updateUserNameRequired(LockingTypeConstants.USER_BASED);
    }

    @Override
    public void updateModelDc() {
        this.model.setActivationTypeDc();
        this.updateUserNameRequired(LockingTypeConstants.COMPUTER_BASED);
    }

    protected void updateUserNameRequired(LockingTypeConstants lockingTypeConstants) {
        ControllerCommand controllerCommand;
        InstallerEntitlement installerEntitlement = this.model.getAccount().getSelectedEntitlement();
        boolean bl = installerEntitlement.isNamedUserLicense();
        installerEntitlement.setSelectedLockingType(lockingTypeConstants);
        if (installerEntitlement.isOnlineOnly()) {
            this.model.setInuSelected(true);
        } else {
            this.model.setInuSelected(false);
        }
        if (installerEntitlement.isOnlineActivatableLicense()) {
            controllerCommand = this.commandFactory.createShowActivationModeOptionsPanelCommand();
        } else if (installerEntitlement.checkIfUsernameRequired()) {
            if (installerEntitlement.isAdmin() && bl) {
                this.model.getPeople();
                controllerCommand = this.commandFactory.createShowActivateOtherPanelCommand();
            } else {
                this.model.activatingForSelf();
                controllerCommand = this.commandFactory.createShowUserNamePanelCommand();
            }
        } else {
            this.model.activatingForSelf();
            controllerCommand = this.model.getIsStudent() ? this.commandFactory.createShowStudentGuiltPanelCommand() : this.commandFactory.createShowConfirmationPanelCommand();
        }
        this.model.validateActivateState();
        this.setNextButtonCommand(controllerCommand);
    }
}

