/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient.command;

import com.mathworks.activationclient.command.ControllerCommand;
import com.mathworks.activationclient.command.ControllerCommandFactory;
import com.mathworks.activationclient.controller.ApplicationController;
import com.mathworks.activationclient.model.ActivationModel;
import com.mathworks.activationclient.model.WebServiceResponse;
import com.mathworks.instutil.services.ServiceThreadState;
import com.mathworks.mlwebservices.Account;
import com.mathworks.mlwebservices.InstallerEntitlement;

final class ValidateEntitlementCommand
implements ControllerCommand {
    private ControllerCommand nextCommand;

    ValidateEntitlementCommand() {
    }

    ValidateEntitlementCommand(ControllerCommand controllerCommand) {
        this.nextCommand = controllerCommand;
    }

    @Override
    public void execute(ApplicationController applicationController) {
        Account account;
        String string;
        ActivationModel activationModel = applicationController.getModel();
        WebServiceResponse<InstallerEntitlement> webServiceResponse = activationModel.getEntitlementByActivationKey(string = (account = activationModel.getAccount()).getActivationKey());
        if (webServiceResponse.getState() != ServiceThreadState.CANCELLED) {
            InstallerEntitlement installerEntitlement = webServiceResponse.getResult();
            if (installerEntitlement != null) {
                ControllerCommandFactory controllerCommandFactory = applicationController.getCommandFactory();
                if (installerEntitlement.isGuiltScreenRequired()) {
                    activationModel.setIsStudent(true);
                } else {
                    activationModel.setIsStudent(false);
                }
                if (installerEntitlement.isOnlineOnly()) {
                    activationModel.setInuSelected(true);
                } else {
                    activationModel.setInuSelected(false);
                }
                if (activationModel.isDcAnonymous()) {
                    activationModel.activatingForSelf();
                    this.nextCommand = controllerCommandFactory.createShowConfirmationPanelCommand();
                } else if (installerEntitlement.isUNSETEntitlement()) {
                    this.nextCommand = controllerCommandFactory.createShowActivationTypePanelCommand();
                } else if (installerEntitlement.isOnlineActivatableLicense()) {
                    this.nextCommand = controllerCommandFactory.createShowActivationModeOptionsPanelCommand();
                } else if (installerEntitlement.checkIfUsernameRequired()) {
                    if (account.isAdmin(account.getSelectedEntitlement().getId())) {
                        activationModel.getPeople();
                        this.nextCommand = controllerCommandFactory.createShowActivateOtherPanelCommand();
                    } else {
                        activationModel.activatingForSelf();
                        this.nextCommand = controllerCommandFactory.createShowUserNamePanelCommand();
                    }
                } else {
                    activationModel.activatingForSelf();
                    this.nextCommand = activationModel.getIsStudent() ? controllerCommandFactory.createShowStudentGuiltPanelCommand() : controllerCommandFactory.createShowConfirmationPanelCommand();
                }
                this.nextCommand = controllerCommandFactory.createIsNetworkCommand(this.nextCommand, installerEntitlement);
            }
            if (this.nextCommand != null) {
                this.nextCommand.execute(applicationController);
            }
        }
    }
}

