/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient;

import com.mathworks.activationclient.ActivationClient;
import com.mathworks.activationclient.ActivationClientComponentFactory;
import com.mathworks.activationclient.command.ControllerCommandFactory;
import com.mathworks.activationclient.controller.ApplicationController;
import com.mathworks.activationclient.controller.ApplicationView;
import com.mathworks.activationclient.model.ActivationModel;
import com.mathworks.activationclient.model.WebServiceCaller;
import com.mathworks.activationclient.model.message.ActivatingPolyspace;
import com.mathworks.activationclient.model.message.StartedFromMatlab;
import com.mathworks.instutil.InstallerUtilities;
import com.mathworks.instwiz.WILogger;
import com.mathworks.instwiz.WIResourceBundle;
import com.mathworks.net.transport.MWTransportClientProperties;
import java.util.Properties;

class ActivationClientImpl
implements ActivationClient {
    private MWTransportClientProperties tcp = null;
    private ApplicationView view = null;
    private ActivationModel model = null;
    private ApplicationController controller = null;

    ActivationClientImpl(final WIResourceBundle wIResourceBundle, final WILogger wILogger, Properties properties, final ActivationClientComponentFactory activationClientComponentFactory) {
        ControllerCommandFactory controllerCommandFactory = activationClientComponentFactory.createControllerCommandFactory();
        InstallerUtilities.doNowOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                ActivationClientImpl.this.view = activationClientComponentFactory.createApplicationView(wIResourceBundle, wILogger, true, true);
            }
        });
        WebServiceCaller webServiceCaller = activationClientComponentFactory.createWebServiceCaller(this.view);
        this.model = activationClientComponentFactory.createActivationModel(this.view, webServiceCaller);
        this.controller = activationClientComponentFactory.createApplicationController(controllerCommandFactory, this.view, this.model);
        this.tcp = this.view.getTransportClientProperties();
        for (PropertyHandler propertyHandler : PropertyHandler.values()) {
            if (!properties.containsKey(propertyHandler.name)) continue;
            propertyHandler.command.set(this, properties.getProperty(propertyHandler.name));
        }
        this.view.setApplicationController(this.controller);
    }

    @Override
    public void start() {
        this.controller.start();
    }

    public void exception(Throwable throwable) {
        this.view.exception(throwable);
    }

    public void exception(Throwable throwable, boolean bl) {
        this.view.exception(throwable, bl);
    }

    static enum PropertyHandler {
        LICENSE_FILE("licenseFile", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
                activationClientImpl.model.setLicenseFile(string);
            }
        }),
        ACTIVATE_COMMAND("activateCommand", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
            }
        }),
        ANONYMOUS("isAnonymous", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
                Boolean bl = Boolean.valueOf(string);
                activationClientImpl.model.setDcAnonymous(bl);
            }
        }),
        ENTITLEMENT("entitlementId", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
                activationClientImpl.model.setEntitlement(string);
            }
        }),
        ACTIVATION_KEY("activationKey", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
                activationClientImpl.model.setInitialActivationKey(string);
            }
        }),
        ACTIVATION_TYPE("activationType", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
                activationClientImpl.model.setActivationTypeDc();
                activationClientImpl.model.activatingForSelf();
                activationClientImpl.model.validateActivateState();
            }
        }),
        AWS("activationWebService", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
                activationClientImpl.model.setActivationServiceLocation(string);
            }
        }),
        LWS("loginWebService", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
                activationClientImpl.model.setLoginServiceLocation(string);
            }
        }),
        NO_MATLAB("nomatlab", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
                Boolean bl = Boolean.valueOf(string);
                if (bl.booleanValue()) {
                    activationClientImpl.model.sendMessage(new StartedFromMatlab());
                }
            }
        }),
        PROTOCOL("protocol", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
                activationClientImpl.model.setWebServiceProtocol(string);
            }
        }),
        PROXY_PASSWD("proxyPasswd", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
                activationClientImpl.tcp.setProxyPassword(string);
            }
        }),
        PROXY_HOST("proxyHost", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
                activationClientImpl.tcp.setProxyHost(string);
            }
        }),
        PROXY_USER("proxyUser", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
                activationClientImpl.tcp.setProxyUser(string);
            }
        }),
        PROXY_PORT("proxyPort", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
                activationClientImpl.tcp.setProxyPort(string);
            }
        }),
        MATLAB_ROOT("matlabRoot", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
                activationClientImpl.model.setRootDir(string);
            }
        }),
        SECURITY_TOKEN("securityToken", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
                activationClientImpl.model.setSecurityToken(string);
            }
        }),
        TRACK("track", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
                activationClientImpl.model.setWebServiceTrack(string);
            }
        }),
        USER_EMAIL("userEmail", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
                activationClientImpl.model.setEmailAddress(string);
            }
        }),
        VERBOSE("verbose", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
                Boolean bl = Boolean.valueOf(string);
                activationClientImpl.view.setVerbose(bl);
            }
        }),
        WS_TIMEOUT("wsTimeout", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
                activationClientImpl.view.setServiceTimeout(string);
            }
        }),
        POLYSPACE("polyspace", new PropertyAction(){

            @Override
            public void set(ActivationClientImpl activationClientImpl, String string) {
                Boolean bl = Boolean.valueOf(string);
                if (bl.booleanValue()) {
                    activationClientImpl.model.sendMessage(new ActivatingPolyspace());
                }
            }
        });

        private final String name;
        private final PropertyAction command;

        private PropertyHandler(String string2, PropertyAction propertyAction) {
            this.name = string2;
            this.command = propertyAction;
        }

        String getName() {
            return this.name;
        }

        PropertyAction getCommand() {
            return this.command;
        }
    }

    static interface PropertyAction {
        public void set(ActivationClientImpl var1, String var2);
    }
}

