/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.activationclient;

import com.mathworks.activationclient.ActivationClientImpl;
import com.mathworks.activationclient.DefaultActivationClientComponentFactory;
import com.mathworks.activationclient.PropertiesFileSeparatorStream;
import com.mathworks.activationclient.silent.SilentActivationControllerImpl;
import com.mathworks.instutil.InstUtilExceptionHandler;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.InstallerUtilities;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.services.ProxyTester;
import com.mathworks.instutil.services.ServiceThread;
import com.mathworks.instutil.services.ServiceThreadFactoryImpl;
import com.mathworks.instutil.services.ServiceThreadView;
import com.mathworks.instwiz.WILogger;
import com.mathworks.instwiz.WIResourceBundle;
import com.mathworks.instwiz.arch.ArchGui;
import com.mathworks.instwiz.arch.ArchGuiFactoryImpl;
import com.mathworks.mlwebservices.ActivationService;
import com.mathworks.mlwebservices.DefaultActivationService;
import com.mathworks.mlwebservices.DefaultLoginService;
import com.mathworks.mlwebservices.LoginService;
import com.mathworks.mlwebservices.Service;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.webproxy.SystemProxySettings;
import com.mathworks.webproxy.WebproxyFactory;
import java.awt.GraphicsEnvironment;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

public final class ActivationApplication
implements InstUtilExceptionHandler,
ServiceThreadView {
    private static final String DEFAULT_SWITCH_VALUE = "true";
    private static final String RESOURCES = "com.mathworks.activationclient.resources.RES_activationclient";
    private ExecutorService executor;
    private static WIResourceBundle resources;
    private LoginService lws = null;
    private ActivationService aws = null;
    private ProxyConfiguration proxyConfiguration;
    private boolean isStandalone = false;
    private final Properties properties = new Properties(System.getProperties());
    private String awsUrl;
    private InstUtilExceptionHandler exceptionHandler;
    private WILogger logger;
    private final String release;
    private final String clientVersion;
    private static final Map<String, String> COMMAND_LINE_PROPERTY_SHORTHAND_MAP;

    public static void main(String[] stringArray) {
        ActivationApplication activationApplication = new ActivationApplication(Arrays.asList(stringArray));
        activationApplication.go();
        if (activationApplication.isStandalone) {
            System.exit(0);
        }
    }

    public static void mainWithServiceOverrides(ActivationService activationService, LoginService loginService, String[] stringArray) {
        ActivationApplication activationApplication = new ActivationApplication(activationService, loginService, Arrays.asList(stringArray));
        activationApplication.go();
    }

    private ActivationApplication(ActivationService activationService, LoginService loginService, List<String> list) {
        this(list);
        this.overrideWebServices(activationService, loginService);
    }

    private void overrideWebServices(ActivationService activationService, LoginService loginService) {
        this.aws = activationService;
        this.lws = loginService;
    }

    private ActivationApplication(List<String> list) {
        ArchGuiFactoryImpl archGuiFactoryImpl = new ArchGuiFactoryImpl();
        ArchGui archGui = archGuiFactoryImpl.create();
        this.createResourceBundle(archGui);
        resources.addResource("com.mathworks.activationclient.resources.RES_activationclient_notranslation");
        this.release = resources.getString("releasenum.text");
        this.logger = new WILogger("com.mathworks.activationclient.ActivationApplication", resources.getString("log.name"));
        ActivationApplication.argv2Properties(this.properties, list);
        for (PropertyHandler propertyHandler : PropertyHandler.values()) {
            for (String string : this.properties.stringPropertyNames()) {
                if (!string.equalsIgnoreCase(propertyHandler.name)) continue;
                this.executeAction(propertyHandler, string);
            }
        }
        this.clientVersion = InstallerUtilities.getClientVersion((InstUtilResourceBundle)resources);
        this.proxyConfiguration = this.createProxyConfiguration();
        this.aws = this.createActivationService(this.proxyConfiguration);
        this.lws = new DefaultLoginService(this.proxyConfiguration);
    }

    private ProxyConfiguration createProxyConfiguration() {
        SystemProxySettings systemProxySettings = WebproxyFactory.createSystemProxySettings((String)new PlatformImpl().getNativeLibraryPath(this.properties.getProperty("matlabRoot")));
        return WebproxyFactory.createDefaultProxyConfiguration((SystemProxySettings)systemProxySettings);
    }

    private DefaultActivationService createActivationService(ProxyConfiguration proxyConfiguration) {
        return new DefaultActivationService(this.release, InstallerUtilities.getOsVersionString(), this.properties, proxyConfiguration);
    }

    private void executeAction(PropertyHandler propertyHandler, String string) {
        propertyHandler.action.execute(this, this.properties.getProperty(string));
    }

    private void createResourceBundle(ArchGui archGui) {
        resources = new WIResourceBundle(RESOURCES, (InstUtilExceptionHandler)this, archGui);
    }

    private void go() {
        Boolean bl = Boolean.valueOf(this.properties.getProperty("isSilent"));
        if (!bl.booleanValue() && !ActivationApplication.isDisplayAvailable()) {
            return;
        }
        this.logger.start(resources.getString("log.activationclient.start"));
        if (bl.booleanValue()) {
            this.goSilent(resources, this.logger);
        } else {
            this.goInteractive(resources, this.logger);
        }
        this.logger.exit();
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    private void goInteractive(WIResourceBundle wIResourceBundle, WILogger wILogger) {
        wILogger.info(resources.getString("log.activationclient.goInteractive"));
        DefaultActivationClientComponentFactory defaultActivationClientComponentFactory = new DefaultActivationClientComponentFactory(this.properties, this.aws, this.lws, this.proxyConfiguration);
        ActivationClientImpl activationClientImpl = new ActivationClientImpl(wIResourceBundle, wILogger, this.properties, defaultActivationClientComponentFactory);
        this.exceptionHandler = activationClientImpl;
        activationClientImpl.start();
    }

    private void goSilent(WIResourceBundle wIResourceBundle, WILogger wILogger) {
        wILogger.info(resources.getString("log.activationclient.goSilent"));
        if (null != this.awsUrl && !this.awsUrl.isEmpty()) {
            this.aws.setEndpointURL(this.awsUrl);
        }
        ServiceThreadFactoryImpl serviceThreadFactoryImpl = new ServiceThreadFactoryImpl();
        ServiceThread serviceThread = serviceThreadFactoryImpl.createBindingThread((ServiceThreadView)this, new Service[]{this.aws}, null, true);
        serviceThread.run();
        try {
            SilentActivationControllerImpl silentActivationControllerImpl = new SilentActivationControllerImpl(wIResourceBundle, wILogger, this.properties, this.aws);
            this.exceptionHandler = silentActivationControllerImpl;
            silentActivationControllerImpl.activate();
        }
        catch (Throwable throwable) {
            this.exception(throwable, true);
        }
    }

    private static boolean isDisplayAvailable() {
        Object object;
        boolean bl = true;
        try {
            object = GraphicsEnvironment.getLocalGraphicsEnvironment();
            boolean bl2 = ((GraphicsEnvironment)object).isHeadlessInstance();
            if (bl2) {
                bl = false;
            }
        }
        catch (Throwable throwable) {
            bl = false;
        }
        if (!bl) {
            object = resources.getString("error.display");
            System.out.print((String)object);
        }
        return bl;
    }

    static void argv2Properties(Properties properties, List<String> list) {
        assert (list != null);
        assert (properties != null);
        LinkedList<String> linkedList = new LinkedList<String>(list);
        while (!linkedList.isEmpty()) {
            String string;
            String string2 = "";
            while (!string2.startsWith("-") && !linkedList.isEmpty()) {
                string2 = (String)linkedList.poll();
            }
            if (!string2.startsWith("-")) continue;
            if (COMMAND_LINE_PROPERTY_SHORTHAND_MAP.containsKey(string2 = string2.substring(1))) {
                string2 = COMMAND_LINE_PROPERTY_SHORTHAND_MAP.get(string2);
            }
            string = null != (string = (String)linkedList.peek()) ? (string.startsWith("-") ? DEFAULT_SWITCH_VALUE : (String)linkedList.poll()) : DEFAULT_SWITCH_VALUE;
            properties.put(string2, string);
        }
    }

    private void loadIniFile(InputStream inputStream) {
        Properties properties = new Properties();
        if (null != inputStream) {
            try {
                properties.load(inputStream);
                this.properties.putAll((Map<?, ?>)properties);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static InputStream getIniFileStream(String string) {
        if (null != string) {
            try {
                return new PropertiesFileSeparatorStream(new FileInputStream(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public void exception(Throwable throwable) {
        this.exception(throwable, false);
    }

    public void exception(Throwable throwable, boolean bl) {
        this.exceptionHandler.exception(throwable, bl);
    }

    public void error(String string, String string2) {
        this.logger.severe(string);
        this.logger.severe(string2);
    }

    public void warning(String string, String string2) {
    }

    public String getClientString() {
        return this.clientVersion;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ProxyTester getProxyTester() {
        return null;
    }

    public ExecutorService getExecutor() {
        if (this.executor == null || this.executor.isShutdown()) {
            this.executor = Executors.newCachedThreadPool();
        }
        return this.executor;
    }

    public String intlString(String string) {
        return resources.getString(string);
    }

    public void logFine(String string) {
        this.logger.fine(string);
    }

    public void logInfo(String string) {
        this.logger.info(string);
    }

    public void logSevere(String string) {
        this.logger.severe(string);
    }

    public void logWarning(String string) {
        this.logger.warning(string);
    }

    public void serviceCallDone() {
    }

    public void serviceCallRunning() {
    }

    public void serviceCallStarted(ServiceThread serviceThread, String string, String string2) {
        this.logger.info(string);
        this.logger.info(string2);
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        this.exceptionHandler.exception(throwable, true);
    }

    static {
        COMMAND_LINE_PROPERTY_SHORTHAND_MAP = new HashMap<String, String>();
        COMMAND_LINE_PROPERTY_SHORTHAND_MAP.put("root", "matlabRoot");
        COMMAND_LINE_PROPERTY_SHORTHAND_MAP.put("v", "verbose");
        COMMAND_LINE_PROPERTY_SHORTHAND_MAP.put("logFile", "logFile");
        COMMAND_LINE_PROPERTY_SHORTHAND_MAP.put("key", "activationKey");
        COMMAND_LINE_PROPERTY_SHORTHAND_MAP.put("token", "securityToken");
        COMMAND_LINE_PROPERTY_SHORTHAND_MAP.put("lws", "loginWebService");
        COMMAND_LINE_PROPERTY_SHORTHAND_MAP.put("aws", "activationWebService");
        COMMAND_LINE_PROPERTY_SHORTHAND_MAP.put("id", "entitlementId");
        COMMAND_LINE_PROPERTY_SHORTHAND_MAP.put("email", "userEmail");
        COMMAND_LINE_PROPERTY_SHORTHAND_MAP.put("file", "licenseFile");
        COMMAND_LINE_PROPERTY_SHORTHAND_MAP.put("anon", "isAnonymous");
        COMMAND_LINE_PROPERTY_SHORTHAND_MAP.put("type", "activationType");
        COMMAND_LINE_PROPERTY_SHORTHAND_MAP.put("silent", "isSilent");
        COMMAND_LINE_PROPERTY_SHORTHAND_MAP.put("isStandalone", "isStandalone");
    }

    private static enum PropertyHandler {
        PROP_FILE("propertiesFile", new PropertyAction(){

            @Override
            public void execute(ActivationApplication activationApplication, String string) {
                InputStream inputStream = ActivationApplication.getIniFileStream(string);
                activationApplication.loadIniFile(inputStream);
            }
        }),
        AWS("activationWebService", new PropertyAction(){

            @Override
            public void execute(ActivationApplication activationApplication, String string) {
                activationApplication.awsUrl = string;
            }
        }),
        LWS("loginWebService", new PropertyAction(){

            @Override
            public void execute(ActivationApplication activationApplication, String string) {
            }
        }),
        POLYSPACE("polyspace", new PropertyAction(){

            @Override
            public void execute(ActivationApplication activationApplication, String string) {
                resources.addResource("com.mathworks.activationclient.resources.RES_Polyspace");
                resources.addResource("com.mathworks.activationclient.resources.RES_Polyspace_notranslation");
            }
        }),
        USE_SYSTEM_PROXIES("useSystemProxies", new PropertyAction(){

            @Override
            public void execute(ActivationApplication activationApplication, String string) {
                WebproxyFactory.setUseSystemProxiesEnabled((boolean)Boolean.parseBoolean(string));
            }
        }),
        LOG_FILE("logFile", new PropertyAction(){

            @Override
            public void execute(ActivationApplication activationApplication, String string) {
                activationApplication.logger.setLogPath(string);
            }
        }),
        DEBUG("debug", new PropertyAction(){

            @Override
            public void execute(ActivationApplication activationApplication, String string) {
                activationApplication.logger.setLevel(string);
            }
        }),
        IS_STANDALONE("isStandalone", new PropertyAction(){

            @Override
            public void execute(ActivationApplication activationApplication, String string) {
                activationApplication.isStandalone = true;
            }
        });

        private final String name;
        private final PropertyAction action;

        private PropertyHandler(String string2, PropertyAction propertyAction) {
            this.name = string2;
            this.action = propertyAction;
        }

        public String getName() {
            return this.name;
        }
    }

    private static interface PropertyAction {
        public void execute(ActivationApplication var1, String var2);
    }
}

