	subroutine wc_center_finder(cpa_lat, cpa_lon,cpa_track,
     +		ac_lat, ac_lon, wspd,wdir, npts, wspd_thresh,
     +		ctr_lat, ctr_lon, det, err_code)
	implicit none
	real cpa_lat, cpa_lon,cpa_track,wspd_thresh
	integer npts, err_code
	real ac_lat(npts), ac_lon(npts), wspd(npts), wdir(npts)
	real ctr_lat, ctr_lon
C
	real xn, yn, w, sin_ang, cos_ang
	real wsin_sum,	wcos_sum, wsincos_sum
	real xsin_sum, xsincos_sum, ycos_sum, ysincos_sum 
	real det, tolerance, pi180, fac_lat, fac_lon
	real xc, yc, rlat
	integer i
C
	parameter(tolerance = 0.0001)
C Implementation of Willoughby and Chelmow (1982) center finder
C See their MWR article for details. Note I exlcude obs with wind speed below
C threshold to keep thing general. P Dodge, HRD 11 Oct 2007
C fins xc, yc suchta dSl/dx = dSl/dy = 0.0
C Sl = sum(sn**2 * w) / sum (w)
C and s(n) = (x(n) - xc)sin(wdir(n)) +
C	    (y(n) - yc)cos(wdir(n))
	pi180 = acos(-1.0) / 180.0
	rlat = cpa_lat * pi180
	fac_lat = 111.13209 - 0.56605 * cos(2.*rlat)
     +            + 0.00012*cos(4.0*rlat) - 0.000002*cos(6.*rlat)
	fac_lon = 111.41513*cos(rlat) - 0.09455*cos(3.*rlat)
     +            + 0.00012*cos(5.*rlat)
C Initialize summs with cpa values
	w = 10.0
	sin_ang = sin(cpa_track * pi180)
	cos_ang = cos(cpa_track * pi180)
	wsin_sum = w * sin_ang**2
	wcos_sum = w * cos_ang**2
	wsincos_sum = w * sin_ang * cos_ang
	xsin_sum = 0.0
	xsincos_sum = 0.0
	ycos_sum = 0.0
	ysincos_sum = 0.0
C
	do i = 1, npts
	   if( wspd(i) .gt. wspd_thresh) then
	     xn = (ac_lon(i) - cpa_lon) * fac_lon
	     yn = (ac_lat(i) - cpa_lat) * fac_lat
	     w = 1.0
	     sin_ang = sin(wdir(i) * pi180)
	     cos_ang = cos(wdir(i) * pi180)
	     wsin_sum = wsin_sum + w * sin_ang**2
	     wcos_sum = wcos_sum + w * cos_ang**2
	    wsincos_sum = wsincos_sum + w * sin_ang * cos_ang
	    xsin_sum = xsin_sum + w*xn*sin_ang**2
	    xsincos_sum = xsincos_sum + w*xn*sin_ang * cos_ang
	    ycos_sum = ycos_sum + w*yn*cos_ang**2
	    ysincos_sum = ysincos_sum + w*yn*sin_ang * cos_ang
	   end if
	end do
C Solve this linear system
C		a xc +	b yc = c
C	wsin_sum * xc + wsincos_sum * yc =
C		xsin_sum + ysincos_sum
C		d xc + e yc = f
C	wsincos_sum * xc + wcos_sum * yc =
C		xsincos_sum + ycos_sum
C		det = ae - bd
	det = wsin_sum * wcos_sum - wsincos_sum * wsincos_sum
C return if det crappy
	if(det .eq. 0.0) then
		err_code = -1
		return 
	else if ( abs(det) .lt. tolerance) then
		err_code = -2
		return
	end if
C		xc = (ec - bf) / det
	xc = wcos_sum * (xsin_sum + ysincos_sum) -
     +		 wsincos_sum *(xsincos_sum + ycos_sum)
	xc = xc /det
C		yc = (af - dc ) / det
	yc = wsin_sum *(xsincos_sum + ycos_sum) -
     +		wsincos_sum * (xsin_sum + ysincos_sum)
	yc = yc / det
C turn back into lat and lon
	ctr_lat = cpa_lat + yc / fac_lat
	ctr_lon = cpa_lon + xc / fac_lon
	err_code = 1
	return
	end
