      SUBROUTINE SWEEPIN(SWEEP,SWEEPZ,MAX_RAYS,MAX_GATES,NUM_RAYS,RDTAI,
     + AZ_EL,ICALLSWEEPIN,NUMREC,VRRAD,UNFVEL,TMP1,TMP2,JINDEX,
     + JIINDEX,NYQ,ILATERSWEEP,SWEEPSAVE,U,V,W,IMX,JMX,KMX,SX,SY,SZ,
     + OLAT,OLON,XZ,YZ,ZZ,IUSEWIND,EAZM,EEV,TMSWEEP,RRLAT,RRLON,RRA,
     + SMOTIONU0,SMOTIONV0,CENTIME0,PELEV,MAXI,ANGTEST,AZMSLOPE,IAZM,
     + ZLOW,ZHIGH,HB2,DPB2)
C 
C     Doppler/Reflectivity processing program. 
C     This program reads the radar tapes and writes rays of Doppler data on
C     disc.  The file contains time in seconds, radar altitude in meters, 
C     latitude and longitude in degrees, earth relative azimuths in degrees,
C     earth relative elevation in degrees and 256 doppler velocities at 300
C     meter intervals.  The data is written to disc and then transfer via 
C     ftp to NCEP.
C 
C     To use: ncepwrite_file ncepwrite_file.job
C     ncepwrite_file.job - data file containing input information. 
C 
C  Subroutines use: 
C     READTAPE - Reads merged tapes and returns 1 record.
C 
C  Logical units: 
C     unit(1) - user's terminal 
C     unit(LUNR) - tape drive LU #
C     unit(LP) - line printer LU #. (6/7 dot-matrix printer)
C  Variables in Common Block and Main Program:
C     NIX - Flag for end-of-file/end-of-tape.(NIX=-100).
C     NGATE1 - Gate number to start mapping the data, for negative range del.
C     IFLT/INM - Flight date/ project name.
C     STIME/ETIME - Starting/Ending times of disc file in seconds.
C     WD/WS - Wind direction(deg) and Wind Speed (m/s).
C     IVT - flag to calculate  and subtract the terminal velocity (y/n).
C     RAMFL - flag to open and read the ram data with the GPS information.
C     XR,YR,ZR - east-west,north-south,and vertical distances of radar gate
C      from the radar
C 
      COMMON /AREA1/ INM,IFLT,STIME,ETIME,WD,WS,NIX,NGATE1,LP,LUNR,
     +               IVT,RAMFL
      COMMON /TAPEHEADER/ nbytesheader,ntape,nversion,ihheader,imheader,
     +                    isheader,ine,ndrive,naircraft,flightid,stmname
     +                    ,nsamplelf,nsampleta,refslopelf,refslopeta,
     +                    refnoisethreslf,refnoisethresta,sqilf,sqita,
     +                    widththreslf,widththresta,caliblf,calibta,
     +                    modedatalf,modedatata,noisetmlf,noisetmta,
     +                    rpmlf,rpmta,gtlnlf,ivrangelf,ivrangeta,
     +                    gtlnta(3),rdellf,rdelta,rdelcorlf,rdelcorta,
     +                    nbinlf,nbinta,nbins,rmaxlf,rmaxta,
     +                    radiita(512),radiilf(512),prf_flaglf,
     +                    prf_flagta,prf_highlf,prf_highta,xniqlf,
     +                    xniqta,iheader(1024)
      COMMON /RAYHEADER / nbytesdata,nlfsweep,ntasweep,numrecord,
     +                    irecflag,idradar,nbytesray,icode,idsp,mdata,
     +                    iyear,month,iday,iraycode,radtime,ih,im,is,
     +                    is100,radlat,radlon,radalt,gse,gsn,radgs,
     +                    radvgs,ucom,vcom,radwd,radws,radvws,ircu,
     +                    elev,radazm,pitch,roll,drift,heading,
     +                    dbzbuffer(512),velbuffer(512),widthbuffer(512)
      COMMON /PARAMS/ trakazm,trakelev,driftnew,
     +                rot,track,htbb,dbb,thresh,swthresh,dbzrs,ibst(2),
     +                inob(2),ileg,xniq,irsw,maxnbins,v0,
     +                pcor,dcor,rcor,azmcor,elcor,dbzcor,dbzslope,
     +                iunfoldflag,iattenflag,
     +                badstabflag,surfelimflag,echoflag,atmflag
      common /tsearch/ kountrec,firstsweep(2),keylf(1024,2),
     +                 keyta(4096,2),
     +                 numsweep(2),itimex(2),lastpoint(2),
     +                 iheadertime,ioldsweep(2),kwords,nwords,krays,
     +                 ibuf(2048)
      LOGICAL badstabflag, surfelimflag, echoflag, atmflag
      REAL TIMEONE,RLATONE,RLONONE,RAONE,AZMONE,EVONE
      REAL BINONE(512),REFONE(512)
      REAL RDVWS(800)
      REAL SWEEPVT(512,800)
      INTEGER FASTON
      INTEGER IAZM(800)
      INTEGER*2 IHEADER
      INTEGER OLDTIME,IITEST(5),JJTEST(5),IKEEP(512,800)
      INTEGER PRF_FLAGLF, PRF_FLAGTA
      REAL UNFVEL(MAX_GATES,MAX_RAYS)
      REAL TMP1(MAX_GATES,MAX_RAYS),TMP2(MAX_GATES,MAX_RAYS)
      INTEGER JINDEX(MAX_GATES,MAX_RAYS),JIINDEX(MAX_GATES,MAX_RAYS)
      REAL SWEEP(MAX_GATES,MAX_RAYS),RDTAI(512),AZ_EL(2,MAX_RAYS)
      REAL PAZM(MAX_RAYS)
      REAL PELEV(MAX_RAYS),RDTAIIN(512)
      REAL SWEEPSAVE(MAX_GATES,MAX_RAYS)
      REAL PCORS(2),DCORS(2),RCORS(2)
      REAL AZMCORS(2),RDELCORTAS(2),ELCORS(2)
      REAL RAY(512),URAY(512),V0SAVE(800)
      REAL VRRAD(512,800),NYQ(512,800)
      REAL VROUT(512,800)
      INTEGER*2 ISWEEP(512,800)
      REAL XRSWEEP(512,800),YRSWEEP(512,800),ZRSWEEP(512,800)
      REAL RADSWEEP(512,800)
      REAL XRMIN(512,800),YRMIN(512,800),ZRMIN(512,800)
      REAL XRMAX(512,800),YRMAX(512,800),ZRMAX(512,800)
      REAL AZMIN(512,800),AZMAX(512,800)
      REAL SWEEPZ(512,800),ZDIFF(512,800)
      REAL ZMIN(512,800),ZMAX(512,800)
      REAL XR(512),YR(512),ZR(512)
      REAL U(IMX,JMX,KMX),V(IMX,JMX,KMX),W(IMX,JMX,KMX)
      REAL EAZM(800),EEV(800),RRLAT(800),RRLON(800),RRA(800)
      REAL TRACKSTORE(800),HEADSTORE(800)
      REAL TMSWEEP(800)
      INTEGER ISEG(512,800),ISEGB(512,800),ISEGE(512,800)
      CHARACTER*1 CAIRCRAFT(3)
      CHARACTER CDUMMY*80
      CHARACTER FLIGHTID*8,STMNAME*16,DUMMYREAD*1
      CHARACTER IFLT*8, INM*12
      CHARACTER *1 TAPE, RAMFL, IVT, IATTEN
      CHARACTER *80 NAMERAM, IFILE, NAMEO
      CHARACTER*80 RADARFILE
      CHARACTER*7 IFLTCHK,IFLTCHK2
      DIMENSION BIN(512),REF(512),BIN1(512),REF1(512)
      SAVE ISWEEPCHECK,BINONE,REFONE,TIMEONE,RLATONE,RLONONE
      SAVE RAONE,AZMONE,EVONE,RCAZM,AZELONE,AZELTWO,PELEVONE
      SAVE ICONSERVE,ITAPEOPEN,RDTAIIN,RADTEST,RADTEST2
      SAVE V0ONE,PAZMONE,IFRANCE
      SAVE PCORS,DCORS,RCORS,RDELCORTAS,AZMCORS,ELCORS
      SAVE TIME,TIMES,WFLAG
      SAVE IHS,IMS,ISS,IHE,IME,ISE,IADD86400
      SAVE IFASTCHECK,RDVWS,RDVWSONE,IFLIGHTCHECK
      SAVE AZIIN,AZIOUT
      DATA AT1/5.33E-5/, AT2/0.889/
      IMAXBINS=512
      JMAXRAYS=800
      SXBIG=SX
      CAIRCRAFT(1)='H'
      CAIRCRAFT(2)='I'
      CAIRCRAFT(3)='?'
      IF(ABS(XZ).GE.ABS(YZ))THEN
       RADMAX=ABS(XZ)
      ELSE
       RADMAX=ABS(YZ)
      ENDIF
      WRITE(6,*)RADMAX
      IF(SY.GT.SXBIG)SXBIG=SY
      IF(ICALLSWEEPIN.EQ.0)THEN
       IFASTCHECK=0
       IFILECHECK=0
       RADTEST=-1.
       RADTEST2=-1.
       IFRANCE=0
       IFLIGHTCHECK=0
       OPEN(95,FILE='inoutradazi.txt')
      ELSE
       IFILECHECK=1
       IFLIGHTCHECK=1
      ENDIF
      IF(IUSEWIND.EQ.1)THEN
       SMOTIONU=SMOTIONU0
       SMOTIONV=SMOTIONV0
       CENTIME=CENTIME0
      ELSE
       SMOTIONU=0.
       SMOTIONV=0.
       CENTIME=CENTIME0
      ENDIF
      DO I=1,800
       RDVWS(I)=-999.9
      ENDDO
      deg2rad = acos(-1.0) / 180.0
      rad2deg = 1.0 / deg2rad
      half_beam_ta = 0.8 ! degrees, vertical
      half_beam_lf = 2.05 ! degrees, vertical
      beam_wid = 2.0 * half_beam_ta
      WFLAG=-1.0E+10
C 
C DOPPLER processing program
c      write(6,*)'icallsweepin = ',icallsweepin
      ISWEEPSET=2
      SWEEPOLD=0.
      NUM_RAYS=0
      DO I=1,MAX_GATES
       DO J=1,MAX_RAYS
        SWEEP(I,J)=-888.8
        SWEEPZ(I,J)=-32.0
       ENDDO
      ENDDO
      IF(ICALLSWEEPIN.EQ.1)THEN
       NUM_RAYS=1
       RLAT=RLATONE
       RLON=RLONONE
       EAZM(1)=AZMONE
       EEV(1)=EVONE
       TRACKSTORE(1)=TRACK
       HEADSTORE(1)=HEADING
       RRLAT(1)=RLAT
       RRLON(1)=RLON
       RRA(1)=RAONE
       RDVWS(1)=RDVWSONE
       TMSWEEP(1)=TIMEONE
       RA=RAONE
       RDVWSONE=RADVWS
       AZM=AZMONE
       EV=EVONE
       V0SAVE(1)=V0ONE
       IF(IBST(1).GE.1)THEN
        DO I=1,IBST(1)
         SWEEP(I,1)=-888.8
         SWEEPZ(I,1)=-32.
        ENDDO
       ENDIF
       DO I=IBST(1)+1,NBINS
        SWEEP(I,1)=BINONE(I)
        SWEEPZ(I,1)=REFONE(I)
       ENDDO
       IF(NBINS.LT.512)THEN
        DO I=NBINS+1,512
         SWEEP(I,1)=-888.8
         SWEEPZ(I,1)=-32.
        ENDDO
       ENDIF
       OOLAT=RLAT
       OOLON=RLON
       TIMES=TIME
       IF(IUSEWIND.NE.1)CENTIME=TIMES
       ISCANDIM=NBINS
       IBINS=512
       AZ_EL(1,1)=AZELONE
       AZ_EL(2,1)=AZELTWO
       PELEV(1)=PELEVONE
       PAZM(1)=PAZMONE
       IF(IUSEWIND.EQ.1)THEN
        CALL VRLOCATER(TIMES,OLAT,OLON,
     +  RLAT,RLON,RA,EV,AZM,RDTAIIN,XR,YR,ZR,
     +  ISCANDIM,SMOTIONU,SMOTIONV,CENTIME,BIN,REF)
        RADIANEV=EV*3.14159/180.
        RADIANAZM=AZM*3.14159/180.
        DIRCOSX=COS(RADIANEV)*COS(RADIANAZM)
        DIRCOSY=COS(RADIANEV)*SIN(RADIANAZM)
        DIRCOSZ=SIN(RADIANEV)
        XMIN=-XZ
        YMIN=-YZ
        XMAX=-XZ+IMX*SX
        YMAX=-YZ+JMX*SY
        ZZMAX=ZZ+(KMX-1)*SZ
        DO IR=1,NBINS
          IINT=INT((XR(IR)+XZ+.5*SX)/SX)
          JINT=INT((YR(IR)+YZ+.5*SY)/SY)
          KINT=1+INT((ZR(IR)-ZZ)/SZ)
          VRRAD(IR,1)=0.
          VRSUM=0.
          RADSWEEP(IR,1)=SQRT(XR(IR)*XR(IR)+YR(IR)*YR(IR))
          DO I=IINT,IINT+1
           DO J=JINT,JINT+1
            DO K=KINT,KINT+1
             IF(I.GE.1.AND.I.LE.IMX)THEN
              IF(J.GE.1.AND.J.LE.JMX)THEN
               IF(K.GE.1.AND.K.LE.KMX)THEN
                IF(U(I,J,K).GT.WFLAG)THEN
                 XG=(I-1)*SX-XZ+.5*SX
                 YG=(J-1)*SY-YZ+.5*SY
                 ZG=(K-1)*SZ+ZZ
                 XI=XR(IR)-XG
                 YI=YR(IR)-YG
                 ZI=ZR(IR)-ZG
                 RADR=SQRT(XR(IR)*XR(IR)+YR(IR)*YR(IR))
                 RADG=SQRT(XG*XG+YG*YG)
                 VRAD=(U(I,J,K)*XG+V(I,J,K)*YG)/RADG
                 VTAN=(V(I,J,K)*XG-U(I,J,K)*YG)/RADG
                 URAD=(VRAD*XR(IR)-VTAN*YR(IR))/RADR
                 VRAD=(VRAD*YR(IR)+VTAN*XR(IR))/RADR
                 DISTPOINT=SQRT(XI*XI+YI*YI+ZI*ZI)
                 IF(DISTPOINT.GT.0.)THEN
                  RINT=1./DISTPOINT
                 ELSE
                  RINT=1000000.
                 ENDIF
                 VRRAD(IR,1)=VRRAD(IR,1)+
     1              RINT*(URAD*DIRCOSX+VRAD*DIRCOSY+
     1              W(I,J,K)*DIRCOSZ)
                 VRSUM=VRSUM+RINT
                ENDIF
               ENDIF
              ENDIF
             ENDIF
            ENDDO
           ENDDO
          ENDDO
          IF(VRSUM.GT.0..AND.ABS(PELEVONE).GT..001)THEN
           VRRAD(IR,1)=VRRAD(IR,1)/VRSUM
          ELSE
           VRRAD(IR,1)=-888.8
          ENDIF
        ENDDO
        ISCANONE=1
        RDTAONE=.0001
        BINNONE=0.
        REFFONE=0.
        CALL VRLOCATER(TIMES,OLAT,OLON,
     +  RLAT,RLON,RA,EV,AZM,RDTAONE,XR,YR,ZR,
     +  ISCANONE,SMOTIONU,SMOTIONV,CENTIME,BINNONE,REFFONE)
        IF(NAIRCRAFT.NE.42)GO TO 76543
        DO IR=1,1
         I=1
         IF(I.EQ.1)THEN
          IINT=INT((XR(IR)+XZ+.5*SX)/SX)
          JINT=INT((YR(IR)+YZ+.5*SY)/SY)
          KINT=1+INT((ZR(IR)-ZZ)/SZ)
          UFILE=0.
          VFILE=0.
          UFILESUM=0.
          DO I=IINT,IINT+1
           DO J=JINT,JINT+1
            DO K=KINT,KINT+1
             IF(I.GE.1.AND.I.LE.IMX)THEN
              IF(J.GE.1.AND.J.LE.JMX)THEN
               IF(K.GE.1.AND.K.LE.KMX)THEN
                IF(U(I,J,K).GT.WFLAG)THEN
                 XG=(I-1)*SX-XZ+.5*SX
                 YG=(J-1)*SY-YZ+.5*SY
                 ZG=(K-1)*SZ+ZZ
                 XI=XR(IR)-XG
                 YI=YR(IR)-YG
                 ZI=ZR(IR)-ZG
                 RADR=SQRT(XR(IR)*XR(IR)+YR(IR)*YR(IR))
                 RADG=SQRT(XG*XG+YG*YG)
                 VRAD=(U(I,J,K)*XG+V(I,J,K)*YG)/RADG
                 VTAN=(V(I,J,K)*XG-U(I,J,K)*YG)/RADG
                 URAD=(VRAD*XR(IR)-VTAN*YR(IR))/RADR
                 VRAD=(VRAD*YR(IR)+VTAN*XR(IR))/RADR
                 DISTPOINT=SQRT(XI*XI+YI*YI+ZI*ZI)
                 IF(DISTPOINT.GT.0.)THEN
                  RINT=1./DISTPOINT
                 ELSE
                  RINT=1000000.
                 ENDIF
                 UFILE=UFILE+RINT*URAD
                 UFILESUM=UFILESUM+RINT
                 VFILE=VFILE+RINT*VRAD
                ENDIF
               ENDIF
              ENDIF
             ENDIF
            ENDDO
           ENDDO
          ENDDO
          IF(UFILESUM.GT.0.)THEN
           UFILE=UFILE/UFILESUM
           VFILE=VFILE/UFILESUM
           WDFILE=180./3.14159*ATAN2(-UFILE,-VFILE)
           IF(WDFILE.LT.0.)WDFILE=WDFILE+360.
           WSFILE=SQRT(UFILE*UFILE+VFILE*VFILE)
          ELSE
           UFILE=UCOM
           VFILE=VCOM
           WDFILE=RADWD
           WSFILE=RADWS
          ENDIF
         ELSE
          UFILE=UCOM
          VFILE=VCOM
          WDFILE=RADWD
          WSFILE=RADWS
         ENDIF
        ENDDO
        HEADSTORM=ATAN2(XR(1),YR(1))
        HEADSTORM=HEADSTORM*180./3.14159
        IF(HEADSTORM.LT.0.)HEADSTORM=HEADSTORM+360.
        IF(HEADSTORM.GE.360.)HEADSTORM=HEADSTORM-360.
        TANDIR=HEADSTORM+90.
        IF(TANDIR.GE.360.)TANDIR=TANDIR-360.
        IFLAGGING=0
        TANDIF=ABS(TANDIR-RADWD)
        IF(TANDIF.GT.180.)TANDIF=360.-TANDIF
        WSTANTEST=RADWS*TANDIF
        IF(WSTANTEST.GT.1200.)THEN
         IFLAGGING=1
        ENDIF
        IF(UFILESUM.GT.0.)THEN
         DIFFVECT=SQRT((UFILE-UCOM)*(UFILE-UCOM)+
     +                 (VFILE-VCOM)*(VFILE-VCOM))
         DIFFDIR=ABS(RADWD-WDFILE)
         IF(DIFFVECT.GT.40.)THEN
          IFLAGGING=1
         ELSEIF((DIFFVECT.GT.15..AND.DIFFVECT.LE.40)
     +           .AND.DIFFDIR.GT.15.)THEN
          IFLAGGING=1
         ENDIF
        ENDIF 
        IFLAGGING=0
        IF(IFLAGGING.EQ.1)THEN
         WRITE(6,*)'FLAGGING RAY'
         write(6,*)'headstorm,tandir = ',headstorm,tandir
         write(6,*)'ucom,ufile,vcom,vfile = ',ucom,ufile,vcom,vfile
         write(6,*)'radws,wsfile,radwd,wdfile = ',
     +             radws,wsfile,radwd,wdfile
         DO I=1,512
          BIN(I)=-888.8
         ENDDO
        ENDIF
76543   CALL VRLOCATER(TIMES,OOLAT,OOLON,
     +  RLAT,RLON,RA,EV,AZM,RDTAIIN,XR,YR,ZR,
     +  ISCANDIM,SMOTIONU,SMOTIONV,CENTIME,BIN,REF)
        DO I=1,NBINS
         XRSWEEP(I,1)=XR(I)
         YRSWEEP(I,1)=YR(I)
         ZRSWEEP(I,1)=ZR(I)
        ENDDO
       ENDIF
      ENDIF
      IF(ICALLSWEEPIN.EQ.0)THEN
       ISWEEPSET=0
       IF(IUSEWIND.NE.1)THEN
        ICONSERVE=1
       ELSE
        ICONSERVE=0
       ENDIF
       IFILE='jobfile_radar'
       OPEN(84,FILE=IFILE,IOSTAT=IERR,ERR=998,STATUS='OLD')
C The Following Parameters are read from input file  - ncepwrite_file.job
C Read Flight ID and Storm Name
      READ(84,'(A8)')IFLT
      READ(84,'(A12)')INM
      DO JIJ=1,7
       READ(84,'(A1)')DUMMYREAD
      ENDDO
C Read Line Printer LU#, Tape LU# & flag for printing parameters
       LP=6
       READ(84,*)LUNRT
       RADARFILE='DUMMY'
       IF(LUNRT.GT.6)THEN
        ITAPEOPEN=1
       ELSE
        ITAPEOPEN=0
       ENDIF
       WRITE(LP,'(1X,"NCEP program to write doppler on disc: ",A)')
     +      IFILE
       WRITE(LP,'(2X,"Date:",1X,A8,2X,"Name: ",A12,/,
     +        2X,"Line-Printer:",1X,I2,2X,"Tape-LU#:",I2)')
     + IFLT,INM,LP,LUNRT
C Read Ram File Flag{Y/N} and the Ram File Name 
       RAMFL='N'
C Open the Ram File 
       IF (RAMFL .EQ. 'Y') THEN
          CALL OPENRAMFILE(NAMERAM,LP,STIMERAM,ETIMERAM,DATARATE,IERR)
          IF (IERR .NE. 0) GO TO 1050
          WRITE(LP,'(2X,"RAMFL= ",A1,1X,A80)') RAMFL,NAMERAM
       ENDIF 
C Read Unfolding Flag{Y/N},first guess wind and speed
       WD=0.
       WS=1.
       iunfoldflag=0
       WRITE(LP,'(2X,"IUNFOLDFLAG= ",I1," WD= ",F6.1," WS= ",F6.1)')
     +      IUNFOLDFLAG,WD,WS
C Read the starting bin and the number of bins for averaging
       READ(84,*,IOSTAT=IERR,ERR=999) IBST(1),INOB(1) 
       WRITE(LP,'(2X,"IBST= ",I4," INOB= ",I4)') IBST(1),INOB(1)
C Enter AZM, Elevation & rdel corrs.
       READ (84,*,IOSTAT=IERR,ERR=999) AZMCORS(1),ELCORS(1),
     +                                  RDELCORTA
       WRITE(LP,'(2X,"TA AZMCOR=",F6.2,2X,"ELCOR= ",F6.2,
     +      2X,"RDELCORTA= ",F6.2)') AZMCORS(1),ELCORS(1),
     +                               RDELCORTA
C Enter Pitch, drift and roll corrections:
       READ (84,*,IOSTAT=IERR,ERR=999) PCORS(1),DCORS(1),RCORS(1)
       WRITE(LP,'(2X,"TA PCOR= ",F5.1,2X,"DCOR= ",F5.1,
     +      2X,"RCOR= ",F5.1)') PCORS(1),DCORS(1),RCORS(1)
C Enter AZM, Elevation & rdel corrs.
       READ (84,*,IOSTAT=IERR,ERR=999) AZMCORS(2),ELCORS(2),
     +                                  RDELCORTA
       WRITE(LP,'(2X,"TF AZMCOR=",F6.2,2X,"ELCOR= ",F6.2,
     +      2X,"RDELCORTA= ",F6.2)') AZMCORS(2),ELCORS(2),
     +                               RDELCORTA
C Enter Pitch, drift and roll corrections:
       READ (84,*,IOSTAT=IERR,ERR=999) PCORS(2),DCORS(2),RCORS(2)
       WRITE(LP,'(2X,"TF PCOR= ",F5.1,2X,"DCOR= ",F5.1,
     +      2X,"RCOR= ",F5.1)') PCORS(2),DCORS(2),RCORS(2)
       RDELCORTAS(1)=RDELCORTA
       RDELCORTAS(2)=RDELCORTA
C Read threshold value
       READ (84,*,IOSTAT=IERR,ERR=999) THRESH,DBZRS,DBZCOR,DBZSLOPE
       WRITE(LP,'(2X,"NOISE VALUE= ",F5.1,2X,"DBZRS= ",F5.1,
     +          "DBZSLOPE= ",F5.1,2X,"DBZCOR= ",F5.1)')
     +       THRESH,DBZRS,DBZSLOPE,DBZCOR
C Read spectral width threshold value
       READ (84,*,IOSTAT=IERR,ERR=999) swthresh
       IF (SWTHRESH.LE.0.0 .OR. SWTHRESH.GT.13.0) SWTHRESH=99.0
       WRITE(LP,'(2X,"SPECTRAL WIDTH THRESHOLD= ",F5.1)') swthresh
C Read Flag for adding the Terminal Velocity Corr. Value, the height &
C depth of the bright band, P. Willis or Joss VT.
       IVT='N'
       IRSW=0
       IF(IVT.EQ.'n')IVT='N'
       IF(IVT.EQ.'y')IVT='Y'
       WRITE(LP,'(2X,''VT= '',A1," HTBB= ",F6.2," DBB= ",F6.2, 
     +           " IRSW= ",I1)') 
     +      IVT,HTBB,DBB,IRSW
      IF (IVT .EQ. 'N') HTBB= -99.0
C Read flag to add the intervening attenuation
      IATTEN='N'
       IF(IATTEN.EQ.'y')IATTEN='Y'
       IF(IATTEN.EQ.'n')IATTEN='N'
       IF (IATTEN .EQ. 'Y') THEN 
C compute attenuation table if flag is on 
          CALL MAKEATTENTABLE1(2)
          WRITE(LP,'(1X,"Intervening attenuation: A=",E10.2, 
     +   "*Z**",F4.2)') AT1,AT2
          IATTENFLAG = 1
       ELSE
          IATTENFLAG = 0
       ENDIF   
C Read Start Time and End Time
       READ(84,'(3I2,1X,3I2)',IOSTAT=IERR,ERR=999)
     +     IHS,IMS,ISS,IHE,IME,ISE
       WRITE(LP,'(2X,"Start Time:",3I2.2,2X,"End Time:",3I2.2)')
     +IHS,IMS,ISS,IHE,IME,ISE
C Read a second tape:
       TAPE='N'
       IF(TAPE.EQ.'y')TAPE='Y'
       IF(TAPE.EQ.'n')TAPE='N'
C 
C Read Disk File Name 
      READ(84,*)DUMMY
      READ(84,*)HB2,DPB2
      READ(84,*)ZLOW,ZHIGH
      READ(84,'(A80)')CDUMMY
      READ(84,*)AZIIN,AZIOUT
      READ(84,'(A80)')RADARFILE
      IF(LUNRT.GT.6)THEN
       ITAPEOPEN=1
      ELSE
       ITAPEOPEN=0
      ENDIF
      READ(84,*)IFRANCE
      WRITE(6,*)'IFRANCE = ',IFRANCE
      IF(ITAPEOPEN.EQ.1)THEN
       CALL TAPEOPEN(LUNRT,0,LUNR)
       CALL TAPECONTROL(LUNR,2,1) !back up 1 file
      ELSE
       LUNR=80
       CALL OPENRADARFILE(RADARFILE,LUNR,1,IERROPEN)
      ENDIF
      CLOSE(84)
      NAMEO='DUMMY'
      ENDIF
C Open Disk File
      OPEN(83,FILE='editfile',IOSTAT=IERR,ERR=1000,STATUS='UNKNOWN',
     +     FORM='unformatted') 
      OPEN(82,FILE='editfile.txt')
      OPEN(86,FILE='passeditfile',IOSTAT=IERR,ERR=1000,
     +     STATUS='UNKNOWN',FORM='unformatted') 
      OPEN(85,FILE='passeditfile.txt')
C 
      STIME=FLOAT(IHS)*3600.0 + FLOAT(IMS)*60.0 + FLOAT(ISS)
      ETIME=FLOAT(IHE)*3600.0 + FLOAT(IME)*60.0 + FLOAT(ISE)
C
C Search for the start time:
971   IF(ICALLSWEEPIN.EQ.0)THEN
97100  ROLDTIME=200000.
       kwords=0
       nwords=-1
       CALL READTAPE(TIME,RLAT,RLON,RA,AZM,EV,BIN,REF,BIN1,REF1,RCAZM,
     +  ITAPEOPEN,RADARFILE,NUMREC,PCORS,DCORS,RCORS,AZMCORS,
     +  RDELCORTAS,ELCORS)
       IF(IFLIGHTCHECK.EQ.0)THEN
        IFLIGHTCHECK=1
        IF(NAIRCRAFT.EQ.42)THEN
         INAIR=1
        ELSEIF(NAIRCRAFT.EQ.43)THEN
         INAIR=2
        ELSE
         WRITE(6,*)'NAIRCRAFT = ',NAIRCRAFT
         WRITE(6,*)'NAIRCRAFT DOES NOET EQUAL 42 OR 43'
         INAIR=3
        ENDIF
        write(6,6104)iyear,month,iday,caircraft(inair)
        write(IFLTCHK,6104)iyear,month,iday,caircraft(inair)
6104    FORMAT(3I2.2,A)
        read(IFLT,'(A7)')IFLTCHK2
        WRITE(6,'(A7)')IFLTCHK
        write(6,'(A7)')IFLTCHK2
        CALL FINDIDAYS(IDAYSCHK,NAIRCHK,IFLTCHK)
        CALL FINDIDAYS(IDAYSCHK2,NAIRCHK2,IFLTCHK2)
        WRITE(6,*)'IDAYS FROM JOBFILE = ',IFLTCHK2
        WRITE(6,*)'IDAYS FROM TAPE = ',IFLTCHK
        IDAYSDIFF=IDAYSCHK-IDAYSCHK2
        IF(IDAYSDIFF.EQ.1)THEN
         IADD86400=1
        ELSE
         IADD86400=0
        ENDIF
        IF(IFLTCHK2.NE.IFLTCHK)THEN
         write(6,*)'flight id on jobfile inconsistent with tape'
        ENDIF
       ENDIF
       IF(IADD86400.EQ.1)TIME=TIME+86400.
       IF(IRCU.EQ.6.OR.IFRANCE.EQ.1)THEN
        FASTON=1
       ELSEIF(IRCU.EQ.2)THEN
        FASTON=0
       ELSE
        write(6,*)'faston not determine correctly'
        FASTON=1
       ENDIF
       IF(TIME.EQ.ROLDTIME)GO TO 97100
       TIMEMSTIME=TIME-STIME
       IF(TIMEMSTIME.LT.-72000..AND.ITAPEOPEN.EQ.1)THEN
        WRITE(6,*)'BACKSPACING'
        CALL TAPECONTROL(LUNR,2,1)
        CALL TAPECONTROL(LUNR,2,1)
        ROLDTIME=TIME
        GO TO 97100
       ENDIF
       write(6,*)'calling tapesearch'
97101  IF(IADD86400.EQ.1)THEN
        STIMESEARCH=STIME-86400.
       ELSE
        STIMESEARCH=STIME
       ENDIF
       IF(LUNR.NE.80)THEN
        CALL TAPESEARCH(LUNR,2,2,STIMESEARCH,IERR)
        ELSE
         CALL DISCSEARCH(LUNR,2,2,STIMESEARCH,IERR)
        NTIMER=0
        write(6,*)'called discsearch'
        timetest=itimex(2)
        if(timetest.gt.etime)then
         itimex(2)=1
         time=itimex(2)
         ierr=20
         go to 97101
        endif
       ENDIF
       IF (IERR.LT.0) GO TO 970
      CALL READTAPE(TIME,RLAT,RLON,RA,AZM,EV,BIN,REF,BIN1,REF1,RCAZM,
     +ITAPEOPEN,RADARFILE,NUMREC,PCORS,DCORS,RCORS,AZMCORS,
     +RDELCORTAS,ELCORS)
       IF(IADD86400.EQ.1)TIME=TIME+86400
       WRITE(6,*)'IRCU = ',IRCU
       IF(IRCU.EQ.6.OR.IFRANCE.EQ.1)THEN
        FASTON=1
       ELSEIF(IRCU.EQ.2)THEN
        FASTON=0
       ELSE
        write(6,*)'faston not determine correctly'
        FASTON=1
       ENDIF
       IF((TIME-STIME).LT.-60000.)THEN
        CALL TAPECONTROL(LUNR,2,1) !back up 1 file
        CALL TAPECONTROL(LUNR,2,1) !back up 1 file
        GO TO 97101
       ELSEIF((TIME-STIME).LT.1.)THEN
        IFILECHECK=1
       ENDIF
      ENDIF
      OLDTIME=0
      ITIMECHECK=0
7040  CALL READTAPE(TIME,RLAT,RLON,RA,AZM,EV,BIN,REF,BIN1,REF1,RCAZM,
     +ITAPEOPEN,RADARFILE,NUMREC,PCORS,DCORS,RCORS,AZMCORS,
     +RDELCORTAS,ELCORS)
      IF(IFRANCE.EQ.0)THEN
       DO I=1,512
        IF(REF(I).GT.-31.99)REF(I)=REF(I)+7.
       ENDDO
      ENDIF
      TRACKLATLON=180./3.14159*ATAN2(GSE,GSN)
      IF(TRACKLATLON.LT.0.)TRACKLATLON=TRACKLATLON+360.
      TRACKDIFF=TRACK-TRACKLATLON
      IF(TRACKDIFF.GT.180.)TRACKDIFF=TRACKDIFF-360.
      IF(TRACKDIFF.LT.-180.)TRACKDIFF=TRACKDIFF+360.
      IF(ABS(TRACKDIFF).GT.2.)THEN
       DO I=1,512
        BIN(I)=-888.8
        BIN1(I)=-888.8
        REF(I)=-32.
        REF1(I)=-32.
       ENDDO
      ENDIF
      IF(IADD86400.EQ.1)TIME=TIME+86400.
       IF(ABS(HEADING).LT..1)GO TO 7040
       DIFFHDTRK=HEADING-TRACK
       IF(ABS(DIFFHDTRK).LT..1)GO TO 7040
       IF(ABS(ELEV).LT..001.OR.ABS(ROLL).GT.5.)THEN
        DO I=1,512
         BIN(I)=-888.88
        ENDDO
       ENDIF
       IF(ABS(ELEV).LT..001)THEN
        DO I=1,512
         REF(I)=-888.88
        ENDDO
       ENDIF
       IF(ABS(RADVGS).GT.15)THEN
        DO I=1,NBINS
         BIN(I)=-888.88
        ENDDO
       ENDIF
       DO I=1,NBINS
        IF(REF(I).GT.60.)THEN
         REF(I)=-32.
         BIN(I)=-888.88
        ENDIF
       ENDDO
       IF(IRCU.EQ.6.OR.IFRANCE.EQ.1)THEN
        FASTON=1
       ELSEIF(IRCU.EQ.2)THEN
        FASTON=0
        IF(IFASTCHECK.EQ.0)THEN
         WRITE(6,*)'ANTENNA NOT IN FAST'
         WRITE(6,*)'DO YOU WANT TO CONTINUE? IF SO TYPE go'
         FASTON=1
         IFASTCHECK=1
        ENDIF
       ELSE
        write(6,*)'faston not determined correctly'
        FASTON=1
       ENDIF
      IF(TIME.GT.ETIME)THEN
       IF(TIME-ETIME.GT.1000..AND.NTIMER.LT.100)THEN
        TIME=1
        ITIMEX(2)=1
        NTIMER=NTIMER+1
        GO TO 7040
       ELSE
        NTIMER=0
       ENDIF
      ENDIF
      IF(TIME.GT.STIME.AND.IFILECHECK.EQ.0.AND.ITAPEOPEN.EQ.1)THEN
       WRITE(6,*)'BACKING UP TWO FILES LOOKING FOR STARTIME'
       CALL TAPECONTROL(LUNR,2,1) !back up 1 file
       CALL TAPECONTROL(LUNR,2,1) !back up 1 file
       IFILECHECK=1
       GO TO 971
      ELSE
       IFILECHECK=1
      ENDIF
      OOLAT=RLAT
      OOLON=RLON
      ALAT=.5*(RLAT+OLAT)
      ALON=.5*(RLON+OLON)
      XMOVE=(CENTIME-TIME)*SMOTIONU/1000.
      YMOVE=(CENTIME-TIME)*SMOTIONV/1000.
      DELX=XMOVE+(111.1*COS(ALAT*3.14159/180.)*(RLON-OLON))
      DELY=YMOVE+(111.1*(RLAT-OLAT))
      OLATDRIFT=OLAT-YMOVE/111.1
      OLONDRIFT=OLON-XMOVE/111.1/COS(ALAT*3.14159/180.)
      STORMRADIUS=SQRT(DELX*DELX+DELY*DELY)  
      STORMAZIMUTH=180./3.14159*ATAN2(DELY,DELX)
      VRAD=(UCOM*DELX+VCOM*DELY)/STORMRADIUS
      VTAN=(VCOM*DELX-UCOM*DELY)/STORMRADIUS
      IF(STORMAZIMUTH.LT.0.)STORMAZIMUTH=STORMAZIMUTH+360.
      TIMES=TIME
      TIMESINCE=TIMES-TIMESLAST
      AZITEST1=90.-AZIIN
      IF(AZITEST1.LT.0.)AZITEST1=AZITEST1+360.
      AZITEST2=90.-AZIOUT
      IF(AZITEST2.LT.0.)AZITEST2=AZITEST2+360.
      AZIDIFF1=STORMAZIMUTH-AZITEST1
      IF(AZIDIFF1.GT.180.)AZIDIFF1=AZIDIFF1-360.
      IF(AZIDIFF1.LT.-180.)AZIDIFF1=AZIDIFF1+360.
      AZIDIFF1=ABS(AZIDIFF1)
      AZIDIFF2=STORMAZIMUTH-AZITEST2
      IF(AZIDIFF2.GT.180.)AZIDIFF2=AZIDIFF2-360.
      IF(AZIDIFF2.LT.-180.)AZIDIFF2=AZIDIFF2+360.
      AZIDIFF2=ABS(AZIDIFF2)
      IF(AZIDIFF1.LT.45.)THEN
       INOUT=1
      ELSEIF(AZIDIFF2.LT.45.)THEN
       INOUT=2
      ELSE
       INOUT=0
      ENDIF
      INTTIME=INT(TIMES)
      ITH=INTTIME/3600
      ITM=(INTTIME-IH*3600)/60
      ITM1=ITM/10
      ITM2=ITM-ITM1*10
      ITS=INTTIME-IH*3600-IM*60
      ITS1=ITS/10
      ITS2=ITS-ITS1*10
      IF(TIMESINCE.GE.1.)THEN
       WRITE(95,5207)INOUT,STORMRADIUS,STORMAZIMUTH,
     + ITH,ITM1,ITM2,ITS1,ITS2
       WRITE(96,5207)INOUT,STORMRADIUS,STORMAZIMUTH,ITH,ITM1,ITM2,
     + ITS1,ITS2,VRAD,VTAN,DELX,DELY,UCOM,VCOM,OLATDRIFT,OLONDRIFT,
     + RADVWS,RADGS,RADVGS
5207   FORMAT(I1,2F8.2,X,I2,4I1,6F8.2,5F10.4)
       TIMESLAST=TIMES
      ENDIF
      IF(IUSEWIND.NE.1)CENTIME=TIME
      ISCANDIM=NBINS
      IBINS=512
      IF((RADIITA(3)-RADIITA(2)).GT..145)THEN
       I150=1
      ELSE
       I150=0
      ENDIF
      IF(RADTEST.GT.0..AND.RADIITA(50).NE.RADTEST)THEN
       INEWRAD=1
       RADTEST=RADIITA(50)
      ELSE
       INEWRAD=0
      ENDIF     
      IF(TIME.LT.STIME)THEN
       ITIME=INT(TIME)
       IF(ITIME.GT.ITIMECHECK)THEN
        ITIMECHECK=ITIME
       ENDIF
       GO TO 7040
      ENDIF
      TANAZM=TAN(TRAKAZM*3.14159/180.)
      COSAZM=COS(TRAKAZM*3.14159/180.)
      COSEV=COS(TRAKELEV*3.14159/180.)
      RALTITUDE=RA*.001
      IF(COSAZM.GT.0.)THEN
       VLENGTH=20.-RALTITUDE
       IEV=1
       XLENGTH=VLENGTH*TANAZM*COSEV
      ELSEIF(COSAZM.LT.0.)THEN
       VLENGTH=RALTITUDE
       IEV=-1
       XLENGTH=-VLENGTH*TANAZM*COSEV
      ELSE
       IEV=0
       XLENGTH=1000.
      ENDIF
      IF(NUM_RAYS.GT.1)THEN
       XDIFF=XLENGTH-XLENGTHOLD
       IF(ABS(XDIFF).LT.SXBIG)THEN
        IAZM(NUM_RAYS)=0
       ELSE
        XLENGTHOLD=XLENGTH
        IAZM(NUM_RAYS)=1
       ENDIF
      ELSE
       XLENGTHOLD=XLENGTH
      ENDIF       
29654 CALL VRLOCATER(TIMES,OLAT,OLON,
     + RLAT,RLON,RA,EV,AZM,RDTAIIN,XR,YR,ZR,
     + ISCANDIM,SMOTIONU,SMOTIONV,CENTIME,BIN,REF)
       IF(NUM_RAYS.GT.0.AND.IUSEWIND.EQ.1)THEN
        RADIANEV=EV*3.14159/180.
        RADIANAZM=AZM*3.14159/180.
        DIRCOSX=COS(RADIANEV)*COS(RADIANAZM)
        DIRCOSY=COS(RADIANEV)*SIN(RADIANAZM)
        DIRCOSZ=SIN(RADIANEV)
        XMIN=-XZ
        YMIN=-YZ
        XMAX=-XZ+IMX*SX
        YMAX=-YZ+JMX*SY
        ZZMAX=ZZ+(KMX-1)*SZ
        DO IR=1,NBINS
         RADSWEEP(IR,NUM_RAYS)=SQRT(XR(IR)*XR(IR)+YR(IR)*YR(IR))
          IINT=INT((XR(IR)+XZ+.5*SX)/SX)
          JINT=INT((YR(IR)+YZ+.5*SY)/SY)
          KINT=1+INT((ZR(IR)-ZZ)/SZ)
          VRRAD(IR,NUM_RAYS)=0.
          VRSUM=0.
          if(num_rays.ge.398.and.num_rays.le.400.and.ir.eq.1)then
           write(6,*)num_rays,pazm(num_rays),pelev(num_rays),
     1               heading,track,
     1               ev,azm,dircosx,dircosy,dircosz
          endif
          DO I=IINT,IINT+1
           DO J=JINT,JINT+1
            DO K=KINT,KINT+1
             IF(I.GE.1.AND.I.LE.IMX)THEN
              IF(J.GE.1.AND.J.LE.JMX)THEN
               IF(K.GE.1.AND.K.LE.KMX)THEN
                IF(U(I,J,K).GT.WFLAG)THEN
                 XG=(I-1)*SX-XZ+.5*SX
                 YG=(J-1)*SY-YZ+.5*SY
                 ZG=(K-1)*SZ+ZZ
                 XI=XR(IR)-XG
                 YI=YR(IR)-YG
                 ZI=ZR(IR)-ZG
                 RADR=SQRT(XR(IR)*XR(IR)+YR(IR)*YR(IR))
                 RADG=SQRT(XG*XG+YG*YG)
                 VRAD=(U(I,J,K)*XG+V(I,J,K)*YG)/RADG
                 VTAN=(V(I,J,K)*XG-U(I,J,K)*YG)/RADG
                 URAD=(VRAD*XR(IR)-VTAN*YR(IR))/RADR
                 VRAD=(VRAD*YR(IR)+VTAN*XR(IR))/RADR
                 DISTPOINT=SQRT(XI*XI+YI*YI+ZI*ZI)
                 IF(DISTPOINT.GT.0.)THEN
                  RINT=1./DISTPOINT
                 ELSE
                  RINT=1000000.
                 ENDIF
                 VRRAD(IR,NUM_RAYS)=VRRAD(IR,NUM_RAYS)+
     1              RINT*(URAD*DIRCOSX+VRAD*DIRCOSY+
     1              W(I,J,K)*DIRCOSZ)
                 VRSUM=VRSUM+RINT
                ENDIF
               ENDIF
              ENDIF
             ENDIF
            ENDDO
           ENDDO
          ENDDO
          IF(VRSUM.GT.0..AND.ABS(PELEV(NUM_RAYS)).GT..001)THEN
           VRRAD(IR,NUM_RAYS)=VRRAD(IR,NUM_RAYS)/VRSUM
          ELSE
           VRRAD(IR,NUM_RAYS)=-888.8
          ENDIF
        ENDDO
        ISCANONE=1
        RDTAONE=.0001
        BINNONE=0.
        REFFONE=0.
        CALL VRLOCATER(TIMES,OLAT,OLON,
     +  RLAT,RLON,RA,EV,AZM,RDTAONE,XR,YR,ZR,
     +  ISCANONE,SMOTIONU,SMOTIONV,CENTIME,BINNONE,REFFONE)
        IF(NAIRCRAFT.NE.42)GO TO 76542
        DO IR=1,1
         I=1
         IF(I.EQ.1)THEN
          IINT=INT((XR(IR)+XZ+.5*SX)/SX)
          JINT=INT((YR(IR)+YZ+.5*SY)/SY)
          KINT=1+INT((ZR(IR)-ZZ)/SZ)
          UFILE=0.
          VFILE=0.
          UFILESUM=0.
          DO I=IINT,IINT+1
           DO J=JINT,JINT+1
            DO K=KINT,KINT+1
             IF(I.GE.1.AND.I.LE.IMX)THEN
              IF(J.GE.1.AND.J.LE.JMX)THEN
               IF(K.GE.1.AND.K.LE.KMX)THEN
                IF(U(I,J,K).GT.WFLAG)THEN
                 XG=(I-1)*SX-XZ+.5*SX
                 YG=(J-1)*SY-YZ+.5*SY
                 ZG=(K-1)*SZ+ZZ
                 XI=XR(IR)-XG
                 YI=YR(IR)-YG
                 ZI=ZR(IR)-ZG
                 RADR=SQRT(XR(IR)*XR(IR)+YR(IR)*YR(IR))
                 RADG=SQRT(XG*XG+YG*YG)
                 VRAD=(U(I,J,K)*XG+V(I,J,K)*YG)/RADG
                 VTAN=(V(I,J,K)*XG-U(I,J,K)*YG)/RADG
                 URAD=(VRAD*XR(IR)-VTAN*YR(IR))/RADR
                 VRAD=(VRAD*YR(IR)+VTAN*XR(IR))/RADR
                 DISTPOINT=SQRT(XI*XI+YI*YI+ZI*ZI)
                 IF(DISTPOINT.GT.0.)THEN
                  RINT=1./DISTPOINT
                 ELSE
                  RINT=1000000.
                 ENDIF
                 UFILE=UFILE+RINT*URAD
                 UFILESUM=UFILESUM+RINT
                 VFILE=VFILE+RINT*VRAD
                ENDIF
               ENDIF
              ENDIF
             ENDIF
            ENDDO
           ENDDO
          ENDDO
          IF(UFILESUM.GT.0.)THEN
           UFILE=UFILE/UFILESUM
           VFILE=VFILE/UFILESUM
           WDFILE=180./3.14159*ATAN2(-UFILE,-VFILE)
           IF(WDFILE.LT.0.)WDFILE=WDFILE+360.
           WSFILE=SQRT(UFILE*UFILE+VFILE*VFILE)
          ELSE
           UFILE=UCOM
           VFILE=VCOM
           WDFILE=RADWD
           WSFILE=RADWS
          ENDIF
         ELSE
          UFILE=UCOM
          VFILE=VCOM
          WDFILE=RADWD
          WSFILE=RADWS
         ENDIF
        ENDDO
        HEADSTORM=ATAN2(XR(1),YR(1))
        HEADSTORM=HEADSTORM*180./3.14159
        IF(HEADSTORM.LT.0.)HEADSTORM=HEADSTORM+360.
        IF(HEADSTORM.GE.360.)HEADSTORM=HEADSTORM-360.
        TANDIR=HEADSTORM+90.
        IF(TANDIR.GE.360.)TANDIR=TANDIR-360.
        IFLAGGING=0
        TANDIF=ABS(TANDIR-RADWD)
        IF(TANDIF.GT.180.)TANDIF=360-TANDIF
        WSTANTEST=RADWS*TANDIF
        IF(WSTANTEST.GT.1200.)THEN
         IFLAGGING=1
        ENDIF
        IF(UFILESUM.GT.0.)THEN
         DIFFVECT=SQRT((UFILE-UCOM)*(UFILE-UCOM)+
     +                 (VFILE-VCOM)*(VFILE-VCOM))
         DIFFDIR=ABS(RADWD-WDFILE)
         IF(DIFFVECT.GT.40.)THEN
          IFLAGGING=1
         ELSEIF((DIFFVECT.GT.15..AND.DIFFVECT.LE.40)
     +           .AND.DIFFDIR.GT.15.)THEN
          IFLAGGING=1
         ENDIF
        ENDIF 
        IFLAGGING=0
        IF(IFLAGGING.EQ.1)THEN
         WRITE(6,*)'FLAGGING RAY'
         write(6,*)'headstorm,tandir = ',headstorm,tandir
         write(6,*)'ucom,ufile,vcom,vfile = ',ucom,ufile,vcom,vfile
         write(6,*)'radws,wsfile,radwd,wdfile = ',
     +             radws,wsfile,radwd,wdfile
         DO I=1,512
          BIN(I)=-888.8
         ENDDO
        ENDIF
76542 ENDIF
      IF(NUM_RAYS.GT.0)THEN
      CALL VRLOCATER(TIMES,OOLAT,OOLON,
     + RLAT,RLON,RA,EV,AZM,RDTAIIN,XR,YR,ZR,
     + ISCANDIM,SMOTIONU,SMOTIONV,CENTIME,BIN,REF)
       DO I=1,NBINS
        XRSWEEP(I,NUM_RAYS)=XR(I)
        YRSWEEP(I,NUM_RAYS)=YR(I)
        ZRSWEEP(I,NUM_RAYS)=ZR(I)
       ENDDO
      ENDIF
      SWEEPTEST=1.
      IF(ABS(ELEV).GT.0.)THEN
       SWEEPTEST=ELEV*SWEEPOLD
       SWEEPOLD=ELEV
      ENDIF
      IF(IFRANCE.NE.1.AND.ISWEEPCHECK.NE.NTASWEEP)SWEEPTEST=-1.
      IF(IFRANCE.NE.1.AND.ISWEEPCHECK.EQ.NTASWEEP)SWEEPTEST=1.
      IF(ISWEEPSET.EQ.0)THEN
       ISWEEPCHECK=NTASWEEP
       ISWEEPSET=1
       GO TO 7040
      ELSEIF(ISWEEPSET.EQ.1.AND.SWEEPTEST.GE.0.)THEN
       GO TO 7040
      ELSEIF(ISWEEPSET.EQ.1.AND.SWEEPTEST.LT.0.)THEN
       IF(IBST(1).GE.1)THEN
        DO I=1,IBST(1)
         RDTAIIN(I)=1000.
        ENDDO
       ENDIF
       DO I=IBST(1)+1,NBINS
        RDTAIIN(I)=RADIITA(I)
       ENDDO
       IF(NBINS.LT.512)THEN
        DO I=NBINS+1,512
         RDTAIIN(I)=1000.
        ENDDO
       ENDIF
       ISWEEPSET=2
       ISWEEPCHECK=NTASWEEP
      ELSEIF((ISWEEPSET.EQ.2.AND.SWEEPTEST.LT.0.).
     1       OR.NUM_RAYS.EQ.800)THEN
       ISWEEPCHECK=NTASWEEP
       CALL CTME1(TIME,IIHH,IIMM,IISS)
       WRITE(6,*)'SWEEP END TIME IS '
       WRITE(6,'(3I2)')IIHH,IIMM,IISS
       TIMEONE=TIME
       RLATONE=RLAT
       RLONONE=RLON
       RAONE=RA
       AZMONE=AZM
       EVONE=EV
       V0ONE=V0
       RDVWSONE=RADVWS
       AZELONE=TRAKAZM
       AZELTWO=TRAKELEV
       PELEVONE=ELEV
       PAZMONE=RADAZM
       IF(IBST(1).GE.1)THEN
        DO I=1,IBST(1)
         BINONE(I)=-888.8
         REFONE(I)=-32.
        ENDDO
       ENDIF
       DO I=IBST(1)+1,NBINS
        BINONE(I)=BIN(I)
        REFONE(I)=REF(I)
       ENDDO
       IF(TRAKAZM.GT.80..AND.TRAKAZM.LT.280.)THEN
        IBST1=IBST(1)
        CALL FIND_GROUND(RDTAIIN,DEG2RAD,BEAM_WID,RS_TH,RS_M,
     + DBZ_MAX,IBEG,NG2,IBST1)
        IBEGNEW=IBEG
        REFL=-32.
        IF(IBEG.GT.1)THEN
         DO L=1,20
          IBEGL=IBEG-L+1
          IF((IBEGL-1).GE.5)THEN
           IF(DBZBUFFER(IBEGL).GT.-31.95)REFL=DBZBUFFER(IBEGL)
           IF(REFL.GT.-31.95.AND.DBZBUFFER(IBEGL-1).GT.-31.95)THEN
            IF(REFL-DBZBUFFER(IBEGL-1).GT.5.)THEN
             IBEGNEW=IBEGL
            ENDIF
           ENDIF
          ENDIF
         ENDDO
         IBEG=IBEGNEW
         DO I=IBEG,NBINS
          BIN(I)=-999.9
          REF(I)=-999.9
         ENDDO
        ELSEIF(IBEG.EQ.-1)THEN
        WRITE(6,*)'TRAKAZM, REMOVING RAY ',TRAKAZM
         DO I=1,NBINS
          BIN(I)=-999.9
          REF(I)=-999.9
         ENDDO 
        ENDIF
       ENDIF
       GO TO 2000
      ENDIF
      NUM_RAYS=NUM_RAYS+1
      RRLAT(NUM_RAYS)=RLAT
      RRLON(NUM_RAYS)=RLON
      RRA(NUM_RAYS)=RA
      EAZM(NUM_RAYS)=AZM
      EEV(NUM_RAYS)=EV
      TRACKSTORE(NUM_RAYS)=TRACK
      HEADSTORE(NUM_RAYS)=HEADING
      RDVWS(NUM_RAYS)=RADVWS
      TMSWEEP(NUM_RAYS)=TIME
      IF(TRAKAZM.GT.80..AND.TRAKAZM.LT.280.)THEN
       IBST1=IBST(1)
       CALL FIND_GROUND(RDTAIIN,DEG2RAD,BEAM_WID,RS_TH,RS_M,
     + DBZ_MAX,IBEG,NG2,IBST1)
       IBEGNEW=IBEG
       REFL=-32.
       IF(IBEG.GT.1)THEN
        DO L=1,20
         IBEGL=IBEG-L+1
         IF((IBEGL-1).GE.5)THEN
          IF(DBZBUFFER(IBEGL).GT.-31.95)REFL=DBZBUFFER(IBEGL)
          IF(REFL.GT.-31.95.AND.DBZBUFFER(IBEGL-1).GT.-31.95)THEN
           IF(REFL-DBZBUFFER(IBEGL-1).GT.5.)THEN
            IBEGNEW=IBEGL
           ENDIF
          ENDIF
         ENDIF
        ENDDO
        IBEG=IBEGNEW
        DO I=IBEG,NBINS
         BIN(I)=-999.9
         REF(I)=-999.9
        ENDDO
       ELSEIF(IBEG.EQ.-1.AND.(TRAKAZM.GT.91..AND.TRAKAZM.LT.269.))THEN
        WRITE(6,*)'TRAKAZM, REMOVING RAY ',TRAKAZM
        DO I=1,NBINS
         BIN(I)=-999.9
         REF(I)=-999.9
        ENDDO 
       ENDIF
      ENDIF
2222  IF (NIX.EQ.-100)GO TO 2000
      IF (TAPE .EQ. 'Y') THEN 
          write(6,*)'should not get here'
          stop
          WRITE(6,'("Change Radar Tape; RETURN to continue")')
7060      PAUSE
          WRITE(6,'("1-continue, 2-pause:",nn)')
          READ(5,*,err=7060) irewind
          if (irewind .ne. 1) go to 7060
          TAPE='N'
          GO TO 7040
      ENDIF 
C 
C Write Radar Information To Disk  
      ITIME=TIME
      AZ_EL(1,NUM_RAYS)=TRAKAZM
      AZ_EL(2,NUM_RAYS)=TRAKELEV
      PELEV(NUM_RAYS)=ELEV
      PAZM(NUM_RAYS)=RADAZM
      V0SAVE(NUM_RAYS)=V0
      IF(IBST(1).GE.1)THEN
       DO I=1,IBST(1)
        BIN(I)=-888.8
        REF(I)=-32.
       ENDDO
      ENDIF
      DO I=1,NBINS
       SWEEP(I,NUM_RAYS)=BIN(I)
       SWEEPZ(I,NUM_RAYS)=REF(I)
      ENDDO
      IF(NBINS.LT.512)THEN
       DO I=NBINS+1,512
        SWEEP(I,NUM_RAYS)=-888.8
        SWEEPZ(I,NUM_RAYS)=-32.
       ENDDO
      ENDIF
5675  FORMAT(4(I3,F10.4))
      IF (MOD(ITIME,60).EQ.0 .AND. itime.NE.OLDTIME) THEN
         CALL CTME1(TIME,IH,IM,IS)
         WRITE(6,'(" Writing: ",3i2.2,1x,2(f8.3,1x),3(f12.4,1x))')
     +        IH,IM,IS,RLAT,RLON,RA,AZM,EV
      ENDIF
      OLDTIME=ITIME
      GO TO 7040
C 
C <<<<<<Error Conditions<<<<<<
970   WRITE(LP,'(1X," Error searching for start time:",i6)') IERR
      GO TO 2000
998   WRITE(LP,'(1X,"Error Opening Input File: ",A,1X,"IERR= ",I6)')
     +      IFILE,IERR
      GO TO 2000
999   WRITE(LP,'(1X,"Bad Input Data",I4)') IERR 
      GO TO 2000
1000  WRITE(LP,1030)IERR,NAMEO
1030  FORMAT(1X,'Error on Creating Output File= ',I5,1X,A) 
      GO TO 2000
1040  WRITE(LP,1045)IERR,NAMEO
1045  FORMAT(1X,'Error on Write= ',I5,1X,A)
      GO TO 2000
1050  WRITE(LP,'("Error on opening Ram File: ",I5,1X,A80)') IERR,NAMERAM 
2000  NUM_RAYS=NUM_RAYS-1
      if(num_rays.ge.1)then
       radvwmax=0.
       sumvw=0.
       do j=1,num_rays
        radvwtest=abs(rdvws(j))
        sumvw=sumvw+rdvws(j)
        if(radvwtest.gt.radvwmax)radvwmax=radvwtest
       enddo
       radvwmean=sumvw/num_rays
       radvwmean=abs(radvwmean)
       if(radvwmax.gt.30..or.radvwmean.gt.15.)then
        do j=1,num_rays
         do i=1,nbins
          sweep(i,j)=-888.8
         enddo
        enddo
       endif
      endif
      write(6,*)'num_rays = ',num_rays
      RATEST=RA/1000.
      JSTART=0
      DO J=1,NUM_RAYS
       IF(AZ_EL(1,J).GT.90..AND.AZ_EL(1,J).LT.271.)THEN
        JSTART=J
        GO TO 18187
       ENDIF
      ENDDO
      GO TO 19187
18187 JEND=0
      DO J=JSTART+1,NUM_RAYS
       IF(AZ_EL(1,J).GT.270.)THEN
        JEND=J-1
        GO TO 18181
       ENDIF
      ENDDO
18181 CONTINUE
      IRINSIDE=0
      RADIFFTEST=RATEST/1.5
      DO I=1,NBINS
       RALTDIFF=RDTAIIN(I)-RATEST
       IF(RALTDIFF.GT.-RADIFFTEST.AND.IRINSIDE.EQ.0)THEN
        IRINSIDE=I
       ENDIF
       IF(RALTDIFF.GT.RADIFFTEST)THEN
        IROUTSIDE=I-1
        GO TO 18182
       ENDIF
      ENDDO
18182 CONTINUE
      DO I=IRINSIDE,IROUTSIDE
       DO J=1,NUM_RAYS
        IF(SWEEPZ(I,J).LT.0..OR.ZRSWEEP(I,J).LE.0.5)THEN
         SWEEP(I,J)=-999.9
         SWEEPZ(I,J)=-32.
        ENDIF
       ENDDO
      ENDDO
      DO I=1,NBINS
       IF(RDTAIIN(I).GT.RATEST)THEN
        IGTEST=0
        J=NUM_RAYS+1
        JJ=JSTART
        DO WHILE(JJ.LE.NUM_RAYS.AND.AZ_EL(1,JJ).LT.180.)
         IF(SWEEPZ(I,JJ).GT.-32.)THEN
          J=JJ+1
         ENDIF
         JJ=JJ+1
        ENDDO
6498    IF(J.LE.NUM_RAYS.AND.AZ_EL(1,J).LT.180.)THEN
         ICHECK=1
         CALL GROUNDCHECK(SWEEP,SWEEPZ,NUM_RAYS,I,J,ICHECK,ZRSWEEP,
     +    RDTAIIN)
        ENDIF
        J=0
        JJ=JEND
        JAZTEST=1
        DO WHILE(JJ.GE.1.AND.JAZTEST.EQ.1)
         IF(AZ_EL(1,JJ).GT.180.)THEN
          IF(SWEEPZ(I,JJ).GT.-32.)THEN
           J=JJ-1
          ENDIF
          JJ=JJ-1
          JAZTEST=1
         ELSE
          JAZTEST=0
         ENDIF
        ENDDO
6499    IF(J.GE.1)THEN
         IF(AZ_EL(1,J).GT.180.)THEN
          ICHECK=2
          CALL GROUNDCHECK(SWEEP,SWEEPZ,NUM_RAYS,I,J,ICHECK,ZRSWEEP,
     +    RDTAIIN)
         ENDIF
        ENDIF
       ENDIF
      ENDDO
19187 DO ICHECKSWEEP=1,3
       DO I=1,NBINS
        DO J=1,NUM_RAYS
         IKEEP(I,J)=1
         IF(SWEEP(I,J).GT.-800.)THEN
          DO I1=1,5
           II=I+I1-3
           IF(II.GT.0.AND.II.LE.NBINS)THEN
            IF(SWEEP(II,J).GT.-800)THEN
             IITEST(I1)=1
            ELSE
             IITEST(I1)=0
            ENDIF
           ELSE
            IITEST(I1)=0
           ENDIF
          ENDDO
          DO J1=1,5
           JJ=J+J1-3
           IF(JJ.GT.0.AND.JJ.LE.NUM_RAYS)THEN
            IF(SWEEP(I,JJ).GT.-800)THEN
             JJTEST(J1)=1
            ELSE
             JJTEST(J1)=0
            ENDIF
           ELSE
            JJTEST(J1)=0
           ENDIF
          ENDDO
          IKEEPER=0
          IF(IITEST(2).EQ.1.AND.IITEST(4).EQ.1)THEN
           IKEEPER=1
          ELSEIF(IITEST(1).EQ.1.AND.IITEST(2).EQ.1)THEN
           IKEEPER=1
          ELSEIF(IITEST(4).EQ.1.AND.IITEST(5).EQ.1)THEN
           IKEEPER=1
          ENDIF
          JKEEPER=0
          IF(JJTEST(2).EQ.1.AND.JJTEST(4).EQ.1)THEN
           JKEEPER=1
          ELSEIF(JJTEST(1).EQ.1.AND.JJTEST(2).EQ.1)THEN
           JKEEPER=1
          ELSEIF(JJTEST(4).EQ.1.AND.JJTEST(5).EQ.1)THEN
           JKEEPER=1
          ENDIF
          IF(IKEEPER.EQ.0.OR.JKEEPER.EQ.0)THEN
           IKEEP(I,J)=0
          ENDIF
         ENDIF
        ENDDO
       ENDDO
       DO I=1,NBINS
        DO J=1,NUM_RAYS
         IF(IKEEP(I,J).EQ.0)SWEEP(I,J)=-999.9
        ENDDO
       ENDDO
      ENDDO
      IF(ICONSERVE.EQ.1)THEN
       DO J=1,NUM_RAYS
        RADSAVER=0.
        I=1
        DO WHILE(I.LT.NBINS)
         IF(SWEEP(I,J).GT.-98..OR.RDTAIIN(I).LT.2.)THEN
          RADSAVER=RDTAIIN(I)
          I=I+1
         ELSEIF(RDTAIIN(I).LE.RADMAX.AND.
     1          (RDTAIIN(I)-RADSAVER).GT.1.)THEN
          DO L=I,NBINS
           SWEEP(L,J)=-888.8
          ENDDO
          GO TO 6305
         ELSE
          I=I+1
         ENDIF
        ENDDO
6305   ENDDO
      ENDIF
      XNIQTA1=XNIQTA
      CALL DEFRECKLE(IMAXBINS,JMAXRAYS,
     1 NUM_RAYS,PAZM,SWEEP,VROUT,XNIQTA1)
      DO J=1,NUM_RAYS
       DO I=2,511
        IF(SWEEP(I,J).GT.-800..AND.SWEEP(I-1,J).LT.-799..AND.
     1     SWEEP(I+1,J).LT.-799.)THEN
         SWEEP(I,J)=-888.88
        ENDIF
       ENDDO
      ENDDO
      DO J=1,NUM_RAYS
       V00=V0SAVE(J)
       M=INOB(1)
       IRS=IBST(1)
       NB=NBINS
       VN=XNIQTA
       DO I=1,NBINS
        RAY(I)=SWEEP(I,J)
        IF(ABS(HEADSTORE(J)).LT..1)THEN
         RAY(I)=-888.8
         SWEEP(I,J)=-888.8
        ENDIF
        DIFFHDTRK=HEADSTORE(J)-TRACKSTORE(J)
        IF(ABS(DIFFHDTRK).LT..1)THEN
         RAY(I)=-888.8
         SWEEP(I,J)=-888.8
        ENDIF
        IF(IUSEWIND.NE.1)THEN
         VRRAD(I,J)=-888.8
        ELSEIF(IUSEWIND.EQ.1)THEN
         IF(VRRAD(I,J).LT.-800..AND.RADSWEEP(I,J).LT.RADMAX)THEN
          RAY(I)=-888.88
         ENDIF
        ENDIF
        URAY(I)=VRRAD(I,J)
       ENDDO
       NB1=NBINS
       NB2=NBINS
       do i=1,8
        if(ray(i).ne.uray(i).and.ray(i).gt.-800.)iraytest=1
       enddo
      ENDDO
      XXNIQTA=XNIQTA*.7
      XXNIQ=XNIQTA
      DO I=1,MAX_GATES
       DO J=1,NUM_RAYS
        NYQ(I,J)=XXNIQ
       ENDDO
      ENDDO
      NB=NBINS
      write(6,*)'calling varunfld'
      CALL VARUNFLD(SWEEP,MAX_GATES,NBINS,MAX_RAYS,
     1 RDTAIIN,AZ_EL,NUM_RAYS,VRRAD,PAZM,XXNIQ)
      write(6,*)'returned from varunfld'
      FLAGVAL=-888.8
      IVADFLAG=10
      IMINRNG=1
      NRANG=NBINS
      DO J=1,NUM_RAYS
       DO I=1,NBINS
        SWEEPSAVE(I,J)=SWEEP(I,J)
       ENDDO
      ENDDO
      ILATERSWEEP=1
      PELEVMAX=0.
      DO J=1,NUM_RAYS
       PELEVTEST=ABS(PELEV(J))
       IF(PELEVTEST.GT.PELEVMAX)PELEVMAX=PELEVTEST
      ENDDO
      IF(PELEVMAX.LT.15..AND.FASTON.NE.0)THEN
       DO J=1,10
        WRITE(6,*)'PELEVMAX = ',PELEVMAX
       ENDDO
      ENDIF
      DO J=1,MAX_RAYS
       DO I=1,MAX_GATES
        IF(ABS(PELEV(J)).GT..0001.AND.
     1   SWEEP(I,J).GT.-400..AND.SWEEPZ(I,J).GT.-32.)THEN
         H=ZRSWEEP(I,J)
         ZDBZ=SWEEPZ(I,J)
         VTSUB1=VTERM_NEW(ZDBZ,H,HB2,DPB2,IRSW,ZLOW,ZHIGH)
         VTSUB=VTSUB1*SIN(EEV(J)*3.14159/180.)
         SWEEPVT(I,J)=SWEEP(I,J)-VTSUB
        ELSE
         SWEEP(I,J)=-888.88
         SWEEPVT(I,J)=-888.88
        ENDIF
       ENDDO
      ENDDO
      MAXIOLD=MAXI
      IF(SXBIG.LT.20.)THEN
       IF(I150.EQ.1)THEN
        ITEST1=NBINS
        ITEST2=-1
        ITEST3=-1
        ITEST4=-1
        MULT1=1
        MULT2=-1
        MULT3=-1
        MULT4=-1
        KSTART1=1
        KSTART2=-1000
        KSTART3=-1000
        MAXI=NBINS
       ELSE
        MULT1=4
        MULT2=2
        MULT3=1
        KSTART1=1
        KSTART2=257
        KSTART3=385
        ITEST1=64
        ITEST2=65
        ITEST3=128
        ITEST4=129
        MAXI=256
       ENDIF
      ELSE
       IF(I150.EQ.1)THEN
        ITEST1=32
        ITEST2=33
        ITEST3=33
        ITEST4=33
        MULT1=16
        MULT2=-1
        MULT3=-1
        MULT4=-1
        KSTART1=1
        KSTART2=-1000
        KSTART3=-1000
       ELSE
        MULT1=32
        MULT2=16
        MULT3=8
        KSTART1=1
        KSTART2=257
        KSTART3=385
        ITEST1=8
        ITEST2=9
        ITEST3=16
        ITEST4=17
       ENDIF
       MAXI=32
      ENDIF
      DO J=1,NUM_RAYS
       DO I=1,MAXI
        IF(I.LE.ITEST1)THEN
         K=KSTART1+(I-1)*MULT1
         M=I*MULT1
        ELSEIF(I.GE.ITEST2.AND.I.LE.ITEST3)THEN
         K=KSTART2+(I-ITEST2)*MULT2
         M=K+MULT2-1
        ELSEIF(I.GE.ITEST4)THEN
         K=KSTART3+(I-ITEST4)*MULT3
         M=K+MULT3-1
        ENDIF
        SUMVT=0.
        SUM=0.
        SUMD=0.
        SUMND=0.
        SUMN=0.
        RADSUM=0.
        RADSUMN=0.
        DO L=K,M
         IF((ICALLSWEEPIN.EQ.0..OR.INEWRAD.EQ.1).AND.J.EQ.1)THEN
          IF(RDTAIIN(L).LT.200.)THEN
           RADSUMN=RADSUMN+1
           RADSUM=RADSUM+RDTAIIN(L)
          ENDIF
         ENDIF
         IF(SWEEP(L,J).GT.-888.8)THEN
          SUM=SUM+SWEEP(L,J)
          SUMVT=SUMVT+SWEEPVT(L,J)
          SUMN=SUMN+1.
         ENDIF
         IF(SWEEPZ(L,J).GT.-20.)THEN
          SUMD=SUMD+SWEEPZ(L,J)
          SUMND=SUMND+1.
         ENDIF
        ENDDO
        IF(SUMN.GT.0.)THEN
         SWEEPVT(I,J)=SUMVT/SUMN
        ELSE
         SWEEPVT(I,J)=-888.8
        ENDIF
        IF((ICALLSWEEPIN.EQ.0..OR.INEWRAD.EQ.1).AND.J.EQ.1)THEN
         IF(RADSUMN.GT.0.)THEN
          RDTAI(I)=RADSUM/RADSUMN
         ELSE
          RDTAI(I)=1000.
         ENDIF
        ENDIF
       ENDDO
      ENDDO
      DO I=2,MAXI
       IF(RDTAI(I).GT.0..AND.RDTAI(I).LT.500.)THEN
        MAXI2=I
       ENDIF
      ENDDO
      WRITE(6,*)'MAXI2 = ',MAXI2
      MAXI=MAXI2
      IF(ICALLSWEEPIN.EQ.0)THEN
       WRITE(86)IYEAR,MONTH,IDAY,MAXI
       WRITE(85,'(3I2,X,I3)')IYEAR,MONTH,IDAY,MAXI
       WRITE(6,'(3I2,X,I3)')IYEAR,MONTH,IDAY,MAXI
      ENDIF
      IF(RDTAI(10).NE.RADTEST2)THEN
       INEWRAD2=1
       WRITE(86)(RDTAI(I),I=1,MAXI)
       WRITE(85,'(8F10.3)')(RDTAI(I),I=1,MAXI)
      ELSE
       INEWRAD2=0
      ENDIF
      RADTEST2=RDTAI(10)
      write(6,*)'MAXI,MAXI2,MAXIOLD = ',MAXI,MAXI2,MAXIOLD
      IF(ICALLSWEEPIN.NE.0.AND.INEWRAD2.EQ.1)THEN
       J=1
       TIMERAD=-1.
       DO I=1,NBINS
        ISWEEP(I,J)=NINT(SWEEP(I,J)*10)
       ENDDO
       WRITE(86,IOSTAT=IERR,ERR=1040)TIMERAD,RRLAT(J),RRLON(J),
     +    RRA(J),EAZM(J),EEV(J),(SWEEPVT(I,J),I=1,MAXIOLD)
       WRITE(85,'(8F10.3)')TIMRAD,RRLAT(J),RRLON(J),
     +    RRA(J),EAZM(J),EEV(J),(SWEEPVT(I,J),I=1,MAXIOLD)
       WRITE(85,'(I3)')MAXI
       WRITE(86)MAXI
       WRITE(86)(RDTAI(I),I=1,MAXI)
       WRITE(85,'(8F10.3)')(RDTAI(I),I=1,MAXI)
      ENDIF
      DO J=1,NUM_RAYS
       IF(J.EQ.1.AND.ICALLSWEEPIN.EQ.0)THEN
        WRITE(6,*)(RDTAI(I),I=1,MAXI)
       ENDIF
       DO I=1,NBINS
        ISWEEP(I,J)=NINT(SWEEP(I,J)*10)
       ENDDO
        WRITE(85,'(8F10.3)')TMSWEEP(J),RRLAT(J),RRLON(J),
     +    RRA(J),EAZM(J),EEV(J),(SWEEPVT(I,J),I=1,MAXI)
      ENDDO
      MAXIOLD=MAXI
      IF(SXBIG.LT.2.4)THEN
       IF(I150.EQ.1)THEN
        ITEST1=64
        ITEST2=-1
        ITEST3=-1
        ITEST4=-1
        MULT1=8
        MULT2=-1
        MULT3=-1
        MULT4=-1
        KSTART1=1
        KSTART2=-1000
        KSTART3=-1000
       ELSE
        MULT1=16
        MULT2=8
        MULT3=4
        KSTART1=1
        KSTART2=257
        KSTART3=385
        ITEST1=16
        ITEST2=17
        ITEST3=32
        ITEST4=33
       ENDIF
       MAXI=64
      ELSE
       IF(I150.EQ.1)THEN
        ITEST1=32
        ITEST2=33
        ITEST3=33
        ITEST4=33
        MULT1=16
        MULT2=-1
        MULT3=-1
        MULT4=-1
        KSTART1=1
        KSTART2=-1000
        KSTART3=-1000
       ELSE
        MULT1=32
        MULT2=16
        MULT3=8
        KSTART1=1
        KSTART2=257
        KSTART3=385
        ITEST1=8
        ITEST2=9
        ITEST3=16
        ITEST4=17
       ENDIF
       MAXI=32
      ENDIF
      DO J=1,NUM_RAYS
       DO I=1,MAXI
        IF(I.LE.ITEST1)THEN
         K=KSTART1+(I-1)*MULT1
         M=I*MULT1
        ELSEIF(I.GE.ITEST2.AND.I.LE.ITEST3)THEN
         K=KSTART2+(I-ITEST2)*MULT2
         M=K+MULT2-1
        ELSEIF(I.GE.ITEST4)THEN
         K=KSTART3+(I-ITEST4)*MULT3
         M=K+MULT3-1
        ENDIF
        SUM=0.
        SUMD=0.
        SUMND=0.
        SUMN=0.
        RADSUM=0.
        RADSUMN=0.
        DO L=K,M
         IF(L.GT.NBINS)GO TO 56652
         IF((ICALLSWEEPIN.EQ.0..OR.INEWRAD.EQ.1).AND.J.EQ.1)THEN
          IF(RDTAIIN(L).LT.200.)THEN
           RADSUMN=RADSUMN+1
           RADSUM=RADSUM+RDTAIIN(L)
          ENDIF
         ENDIF
         IF(SWEEP(L,J).GT.-888.8)THEN
          SUM=SUM+SWEEP(L,J)
          SUMN=SUMN+1.
         ENDIF
         IF(SWEEPZ(L,J).GT.-20.)THEN
          SUMD=SUMD+SWEEPZ(L,J)
          SUMND=SUMND+1.
         ENDIF
        ENDDO
56652   IF(SUMN.GT.0.)THEN
         SWEEP(I,J)=SUM/SUMN
        ELSE
         SWEEP(I,J)=-888.8
        ENDIF
        IF((ICALLSWEEPIN.EQ.0..OR.INEWRAD.EQ.1).AND.J.EQ.1)THEN
         IF(RADSUMN.GT.0.)THEN
          RDTAI(I)=RADSUM/RADSUMN
         ELSE
          RDTAI(I)=1000.
         ENDIF
        ENDIF
        IF(SUMND.GT.0.)THEN
         SWEEPZ(I,J)=SUMD/SUMND
        ELSE
         SWEEPZ(I,J)=-32.
        ENDIF
       ENDDO
      ENDDO
      DO I=2,MAXI
       IF(RDTAI(I).GT.0..AND.RDTAI(I).LT.500.)THEN
        MAXI2=I
       ENDIF
      ENDDO
      WRITE(6,*)'MAXI2 = ',MAXI2
      MAXI=MAXI2
      IF(ICALLSWEEPIN.EQ.0)THEN
       WRITE(83)IYEAR,MONTH,IDAY,MAXI
       WRITE(82,'(3I2,X,I3)')IYEAR,MONTH,IDAY,MAXI
      ENDIF
      IF(RDTAI(10).NE.RADTEST2)THEN
       INEWRAD2=1
       WRITE(83)(RDTAI(I),I=1,MAXI)
       WRITE(82,'(8F10.3)')(RDTAI(I),I=1,MAXI)
      ELSE
       INEWRAD2=0
      ENDIF
      RADTEST2=RDTAI(10)
      IF(ICALLSWEEPIN.NE.0.AND.INEWRAD2.EQ.1)THEN
       J=1
       TIMERAD=-1.
       DO I=1,NBINS
        ISWEEP(I,J)=NINT(SWEEP(I,J)*10)
       ENDDO
       WRITE(82,'(8F10.3)')TIMRAD,RRLAT(J),RRLON(J),
     +    RRA(J),EAZM(J),EEV(J),(SWEEP(I,J),I=1,MAXI)
      ENDIF
      DO J=1,NUM_RAYS
       IF(J.EQ.1.AND.ICALLSWEEPIN.EQ.0)THEN
        WRITE(6,*)(RDTAI(I),I=1,MAXI)
       ENDIF
       DO I=1,NBINS
        ISWEEP(I,J)=NINT(SWEEP(I,J)*10)
       ENDDO
       IF(IAZM(J).EQ.1)THEN
        WRITE(82,'(8F10.3)')TMSWEEP(J),RRLAT(J),RRLON(J),
     +    RRA(J),EAZM(J),EEV(J),(SWEEP(I,J),I=1,MAXI)
       ENDIF
      ENDDO
      ANGTEST=-999.9
      AZMSLOPE=-999.9
      RETURN
      END 
      SUBROUTINE GROUNDCHECK(SWEEP,SWEEPZ,NUM_RAYS,I,JSTART,ICHECK,
     + ZRSWEEP,RD)
      REAL SWEEP(512,800),SWEEPZ(512,800),ZRSWEEP(512,800)
      REAL RD(512)
      IF(ICHECK.LT.1.OR.ICHECK.GT.2)THEN
       WRITE(6,*)'PROBLEM WITH ICHECK IN GROUNDCHECK'
       STOP
      ENDIF
      IF(SWEEPZ(I,JSTART).GT.-32.)THEN
       WRITE(6,*)'SWEEP(I,JSTART) GT -999.'
       WRITE(6,*)'ICHECK,I,JSTART,SWEEP,SWEEPZ = ',
     +  ICHECK,I,JSTART,SWEEP(I,JSTART),SWEEPZ(I,JSTART)
       STOP
      ENDIF
      IDBZTEST=0
      IF(ICHECK.EQ.1)THEN
       IF(JSTART.LT.5)THEN
        DO J=JSTART,1,-1
         SWEEPZ(I,J)=-32.
         SWEEP(I,J)=-888.8
        ENDDO
        RETURN
       ELSE
        IF(SWEEPZ(I,JSTART-1).GT.40..OR.
     +     SWEEPZ(I,JSTART-4).GT.40.)IDBZTEST=1
       ENDIF
       DO J=JSTART-1,JSTART-3,-1
        IF(SWEEPZ(I,J).GT.-32..AND.SWEEPZ(I,J-1).GT.-32.AND.
     +      SWEEPZ(I,J)-SWEEPZ(I,J-1).GT.5.)THEN
         DO JJ=J,JSTART
          SWEEPZ(I,JJ)=-32.
          SWEEP(I,JJ)=-888.8
         ENDDO
        ENDIF
       ENDDO
      ELSE
       IF(NUM_RAYS-JSTART.LT.4)THEN
        DO J=JSTART,NUM_RAYS
         SWEEPZ(I,J)=-32.
         SWEEP(I,J)=-888.8
        ENDDO
        RETURN
       ELSE
        IF(SWEEPZ(I,JSTART+1).GT.40..OR.
     +     SWEEPZ(I,JSTART+4).GT.40.)IDBZTEST=1
       ENDIF
       DO J=JSTART+1,JSTART+3
        IF(SWEEPZ(I,J).GT.-32..AND.SWEEPZ(I,J+1).GT.-32.AND.
     +      SWEEPZ(I,J)-SWEEPZ(I,J+1).GT.5.)THEN
         DO JJ=J,JSTART,-1
          SWEEPZ(I,JJ)=-32.
          SWEEP(I,JJ)=-888.8
         ENDDO
        ENDIF
       ENDDO
      ENDIF
      RETURN
      END
C ********************
      SUBROUTINE SVGROUNDCHECK(SWEEP,SWEEPZ,NUM_RAYS,I,JSTART,ICHECK)
      REAL SWEEP(512,800),SWEEPZ(512,800)
      IF(ICHECK.LT.1.OR.ICHECK.GT.2)THEN
       WRITE(6,*)'PROBLEM WITH ICHECK IN GROUNDCHECK'
       STOP
      ENDIF
      IF(SWEEPZ(I,JSTART).GT.-32.)THEN
       WRITE(6,*)'SWEEP(I,JSTART) GT -999.'
       WRITE(6,*)'ICHECK,I,JSTART,SWEEP,SWEEPZ = ',
     +  ICHECK,I,JSTART,SWEEP(I,JSTART),SWEEPZ(I,JSTART)
       STOP
      ENDIF
      IF(ICHECK.EQ.1)THEN
       IF(JSTART.LT.5)RETURN
       J=JSTART-4
      SWTEST1=SWEEPZ(I,JSTART-1)-SWEEPZ(I,JSTART-3)
      SWTEST2=SWEEPZ(I,JSTART-2)-SWEEPZ(I,JSTART-3)
      IF(SWTEST1.GT.5..OR.SWTEST2.GT.5.)THEN
        SWEEPZ(I,JSTART-1)=-32.
        SWEEPZ(I,JSTART-2)=-32.
        SWEEPZ(I,JSTART-3)=-32.
        SWEEP(I,JSTART-1)=-888.8
        SWEEP(I,JSTART-2)=-888.8
        SWEEP(I,JSTART-3)=-888.8
       ENDIF
      ELSE
       IF(NUM_RAYS-JSTART.LT.4)RETURN
       JEND=JSTART+4
       SWTEST1=SWEEPZ(I,JSTART+1)-SWEEPZ(I,JSTART+3)
       SWTEST2=SWEEPZ(I,JSTART+2)-SWEEPZ(I,JSTART+3)
       IF(SWTEST1.GT.5..OR.SWTEST2.GT.5.)THEN
        SWEEPZ(I,JSTART+1)=-32.
        SWEEPZ(I,JSTART+2)=-32.
        SWEEPZ(I,JSTART+3)=-32.
        SWEEP(I,JSTART+1)=-888.8
        SWEEP(I,JSTART+2)=-888.8
        SWEEP(I,JSTART+3)=-888.8
       ENDIF
      ENDIF
      RETURN
      END
C ********************
      SUBROUTINE READTAPE(TIME,RLAT,RLON,RA,AZM,EV,BIN,REF,BIN1,REF1,
     +                    RCAZM,ITAPEOPEN,RADARFILE,NUMREC,
     +                    PCORS,DCORS,RCORS,AZMCORS,
     +                    RDELCORTAS,ELCORS)
      COMMON /AREA1/ INM,IFLT,STIME,ETIME,WD,WS,NIX,NGATE1,LP,LUNR,
     +               IVT,RAMFL
      COMMON /TAPEHEADER/ nbytesheader,ntape,nversion,ihheader,imheader,
     +                    isheader,ine,ndrive,naircraft,flightid,stmname
     +                    ,nsamplelf,nsampleta,refslopelf,refslopeta,
     +                    refnoisethreslf,refnoisethresta,sqilf,sqita,
     +                    widththreslf,widththresta,caliblf,calibta,
     +                    modedatalf,modedatata,noisetmlf,noisetmta,
     +                    rpmlf,rpmta,gtlnlf,ivrangelf,ivrangeta,
     +                    gtlnta(3),rdellf,rdelta,rdelcorlf,rdelcorta,
     +                    nbinlf,nbinta,nbins,rmaxlf,rmaxta,
     +                    radiita(512),radiilf(512),prf_flaglf,
     +                    prf_flagta,prf_highlf,prf_highta,xniqlf,
     +                    xniqta,iheader(1024)
      COMMON /RAYHEADER / nbytesdata,nlfsweep,ntasweep,numrecord,
     +                    irecflag,idradar,nbytesray,icode,idsp,mdata,
     +                    iyear,month,iday,iraycode,radtime,ih,im,is,
     +                    is100,radlat,radlon,radalt,gse,gsn,radgs,
     +                    radvgs,ucom,vcom,radwd,radws,radvws,ircu,
     +                    elev,radazm,pitch,roll,drift,heading,
     +                    dbzbuffer(512),velbuffer(512),widthbuffer(512)
      COMMON /PARAMS/ trakazm,trakelev,driftnew,
     +                rot,track,htbb,dbb,thresh,swthresh,dbzrs,ibst(2),
     +                inob(2),ileg,xniq,irsw,maxnbins,v0,
     +                pcor,dcor,rcor,azmcor,elcor,dbzcor,dbzslope,
     +                iunfoldflag,iattenflag,
     +                badstabflag,surfelimflag,echoflag,atmflag
      LOGICAL badstabflag, surfelimflag, echoflag, atmflag
      INTEGER*2 IHEADER
      INTEGER RTYPE
      INTEGER PRF_FLAGLF, PRF_FLAGTA
      REAL PCORS(2),DCORS(2),RCORS(2),AZMCORS(2)
      REAL RDELCORTAS(2),ELCORS(2)
      CHARACTER FLIGHTID*8,STMNAME*16 
      CHARACTER IFLT*8, INM*12
      CHARACTER *1 RAMFL, IVT
      CHARACTER*80 RADARFILE
      DIMENSION BIN(512),REF(512),BIN1(512),REF1(512)
      DATA RTYPE/6/
C Subroutine to read doppler and Reflectivity data from the new 1988
C format radar tapes.  Reads refl/doppler when rtype=6 and dop/ref/sw when
C rtype=7.  It returns one ray per call.
C NIX = -100 determines an end-of-file
C Read data from tape:
      IHEADERFLAG=1
      DO I=1,512
       BIN(I)=-888.8
       REF(I)=-32.
       BIN1(I)=-888.8
       REF1(I)=-32.
      ENDDO
      IF (SWTHRESH.GT.0.0 .AND. SWTHRESH.LE.13.0) RTYPE=7
50    IF(ITAPEOPEN.EQ.0)THEN
       CALL RADARDISCREAD1(LUNR,2,IHEADERFLAG,RTYPE,IERR)
      ELSE
       CALL RADARTAPEREAD(LUNR,2,0,RTYPE,IERR)
       IF(IERR.NE.0)THEN
        write(6,*)'returned from radartaperead ierr = ',ierr
       ENDIF
      ENDIF
      IF(NBINS.LT.512)THEN
       DO I=NBINS+1,512
        RADIITA(I)=0.
       ENDDO
      ENDIF
      IF (IERR .LT. 0) THEN
         NIX= -100
         RETURN
      ENDIF
      IF(ELEV.LT.0.)THEN
       PCOR=PCORS(1)
       DCOR=DCORS(1)
       RCOR=RCORS(1)
       AZMCOR=AZMCORS(1)
       ELCOR=ELCORS(1)
      ELSE
       PCOR=PCORS(2)
       DCOR=DCORS(2)
       RCOR=RCORS(2)
       AZMCOR=AZMCORS(2)
       ELCOR=ELCORS(2)
      ENDIF
C    clear nix variable
      NIX= 0
C    time in seconds  
      TIME=RADTIME
C    raw azimuth
      TRAKAZM=RADAZM
c    roll corrected azimuth but in heading rather than track
      RCAZM=RADAZM+RCOR+ROLL
C    raw elevation
      TRAKELEV=ELEV
C    raw drift
      DRIFTNEW=DRIFT
C    nyquist velocity
      XNIQ=XNIQTA
      track = AMOD(heading + driftnew + 360.0, 360.0)
C ANGLECOR corrects the aircraft pitch,drift,roll,azimuth,elevation and
C adds the roll to the azimuth.
      CALL ANGLECOR(PITCH,DRIFTNEW,ROLL,TRAKAZM,TRAKELEV,2,PCOR,
     +              DCOR,RCOR,AZMCOR,ELCOR)
C Convert aircraft angles to earth relative shperical coordinates
      IUNFOLDFLAG=0
      CALL RAYCOR1(BIN1,REF1)
      IUNFOLDFLAG=0
      CALL RAYCOR1(BIN,REF)
      IUNFOLDFLAG=0
       CALL CONVERTANGLES(TRACK,TRAKAZM,TRAKELEV,HORAZM,HORELEV)
C    azimuth earth relative
      AZM=HORAZM
C    elevation earth relative
      EV=HORELEV
C get information from the ram files.
      IF (RAMFL .EQ. 'Y')
     *   CALL READRAMFILE(TIME,TIMERAM,RADLAT,RADLON,RADALT,
     *                    RADWD,RADWS,UCOM,VCOM,RADVWS,RADVGS,IOS)
C get information from the radar tape or the standard tape
      GS=RADGS                       !ground speed
      VGS=RADVGS                     !vertical ground speed
      VWS=RADVWS                     !vertical wind speed
      RLAT=RADLAT                    !latitude(deg)
      RLON=RADLON                    !longitude(deg)
      RA=RADALT                      !radar altitude(meters) 
      WD=RADWD                       !wind direction
      WS=RADWS                       !wind speed
C RAYCOR corrects the velocities one ray at a time.  It returns the airplane
C track, the first guess wind, the stabilized, vt corrected and unfolded
c velocities as well as the dbz values from the tail radar.
      RETURN
      END 
C ********************
      BLOCK DATA
      COMMON /AREA1/ INM,IFLT,STIME,ETIME,WD,WS,NIX,NGATE1,LP,LUNR,
     +               IVT,RAMFL
      COMMON /PARAMS/ trakazm,trakelev,driftnew,
     +                rot,track,htbb,dbb,thresh,swthresh,dbzrs,ibst(2),
     +                inob(2),ileg,xniq,irsw,maxnbins,v0,
     +                pcor,dcor,rcor,azmcor,elcor,dbzcor,dbzslope,
     +                iunfoldflag,iattenflag,
     +                badstabflag,surfelimflag,echoflag,atmflag
      LOGICAL badstabflag, surfelimflag, echoflag, atmflag
      CHARACTER IFLT*8, INM*12
      CHARACTER *1 RAMFL, IVT
      DATA NIX/0/, NGATE1/5/, IVT/'N'/, RAMFL/'N'/ 
      DATA rot/0.0/, htbb/-99./, dbb/2.0/, thresh/-99.0/, swthresh/99./,
     1     dbzrs/-99./, ibst/2*0/, inob/2*0/, ileg/1/, xniq/12.8/,
     2     irsw/0/, maxnbins/512/, 
     3     pcor,dcor,rcor,azmcor,elcor,dbzcor/6*0.0/, dbzslope/1.0/,
     4     iunfoldflag/0/, iattenflag/0/,
     5     badstabflag/.true./, surfelimflag/.false./,
     6     echoflag/.false./, atmflag/.true./
      END 
      SUBROUTINE VRLOCATER(TIMES,OLAT,OLON,
     + RLAT,RLON,ALT,ELEV,AZIM,RANGE,XR,YR,ZR,
     + ISCANDIM,SMOTIONU,SMOTIONV,CENTIME,BIN,REF)
      REAL RANGE(ISCANDIM),XR(ISCANDIM),YR(ISCANDIM),ZR(ISCANDIM)
      REAL SUM(1024),WSUM(1024),WEIGHT(200),VR(1024)
      REAL BIN(ISCANDIM),REF(ISCANDIM)
      RALT=ALT/1000.
      PI=ASIN(1.0)*2.
      DTR=PI/180.
      REARTH=6366.
      TDIFF=TIMES-CENTIME
      XSHIFT=TDIFF*SMOTIONU/1000.
      YSHIFT=TDIFF*SMOTIONV/1000.     
      RAZIM=AZIM*DTR
      RELEV=ELEV*DTR
      DO I=1,ISCANDIM
c xradar=horizontal distance from aircraft
c yradar=vertical distance from center of earth
       XRADAR=RANGE(I)*COS(RELEV)
       YRADAR=REARTH+RALT+RANGE(I)*SIN(RELEV)
c radnew=distance of datum from center of earth
       RADNEW=SQRT(XRADAR*XRADAR+YRADAR*YRADAR)
c delangle=angle between vertical at aircraft and vertical at datum
       DELANGLE=ATAN(XRADAR/YRADAR)
c distance along great circle from radar to datum
       DISTANCE=.5*(RADNEW+REARTH+RALT)*DELANGLE
c height=altitude of datum
       HEIGHT=RADNEW-REARTH
c distance2=xradar
       DISTANCE2=RANGE(I)*COS(RELEV)
c height2=altitude of datum not accounting for earth's curvature
       HEIGHT2=RALT+RANGE(I)*SIN(RELEV)
c delx=distance (aircraft/datum) along great circle due to east west
       DELY=DISTANCE*SIN(RAZIM)
c dely=distance(aircraft/datum)along great circle due to north-south
       DELX=DISTANCE*COS(RAZIM)
c dx=east west distance from origin to aircraft
       XLAT=.5*(RLAT+OLAT)*DTR
       DX=(RLON-OLON)*DTR*REARTH*COS(XLAT)
c dy=north south distance from origin to aircraft
       DY=(RLAT-OLAT)*DTR*REARTH
c xshift=east-west distance from lower left corner to origin
c yshift=north-south distance from lower left corner to origin
c XR=distance of datum from lower left corner
c YR=distance of datum from lower left corner
       XR(I)=DELX+DX-XSHIFT
c yshift=distance from lower left corner to origin
       YR(I)=DELY+DY-YSHIFT
       ZR(I)=HEIGHT
      ENDDO
      CONTINUE
      RETURN
      END
	subroutine find_ground(rdtai,deg2rad, beam_wid, 
     +		rs_th, rs_m, dBz_max, ibeg, Ng2, ibst)
C Find the surface, as in Testud's memo.
      COMMON /TAPEHEADER/ nbytesheader,ntape,nversion,ihheader,imheader,
     +                    isheader,ine,ndrive,naircraft,flightid,stmname
     +                    ,nsamplelf,nsampleta,refslopelf,refslopeta,
     +                    refnoisethreslf,refnoisethresta,sqilf,sqita,
     +                    widththreslf,widththresta,caliblf,calibta,
     +                    modedatalf,modedatata,noisetmlf,noisetmta,
     +                    rpmlf,rpmta,gtlnlf,ivrangelf,ivrangeta,
     +                    gtlnta(3),rdellf,rdelta,rdelcorlf,rdelcorta,
     +                    nbinlf,nbinta,nbins,rmaxlf,rmaxta,
     +                    radiita(512),radiilf(512),prf_flaglf,
     +                    prf_flagta,prf_highlf,prf_highta,xniqlf,
     +                    xniqta,iheader(1024)
C
      COMMON /RAYHEADER / nbytesdata,nlfsweep,ntasweep,numrecord,
     +                    irecflag,idradar,nbytesray,icode,idsp,mdata,
     +                    iyear,month,iday,iraycode,time,ih,im,
     +                    is,is100,rlat,rlon,ra,gse,gsn,gs,vgs,
     +                    ucom,vcom,wd,ws,vws,ircu,
     +                    elev,azm,pitch,roll,drift,heading,
     +                    dbzbuffer(512),velbuffer(512),widthbuffer(512)
	CHARACTER FLIGHTID*8,STMNAME*16
	integer*2 iheader
	real lambda
        real rdtai(512)
C
	theta = elev * deg2rad ! tilt relative to plane perp to radar axis
	beta = pitch * deg2rad
C In Testud's form, 0 is down, -90 port, 90 starboard:
	phi = (180 - (azm + roll) ) * deg2rad 
	epsilon = beam_wid * deg2rad
C Now get elevation of beam rel to horizontal plane through radar
	sn_lambda = sin(theta) * sin(beta) - 
     *			cos(theta) * cos(beta) * cos(phi)
	lambda = asin(sn_lambda)
C Find theoretical range of surface. - sign because lambda neg
	rs_th = -ra / sn_lambda ! ra in m, radiita in km
C Find # of gates intersecting surface at theoretical range
C This would be formula if dR was constant:
C	Ng = rs_th * epsilon / (dR * tan(lambda) )
C But we may have varying beamwidths, so
Cout	slant_depth = -rs_th * epsilon / tan(lambda) ! slight approximation
Cout	rs_th_in = ( rs_th - slant_depth * 0.5 ) * 0.001
Cout	rs_th_out = ( rs_th + slant_depth * 0.5 ) * 0.001
C mod dec 8 92:
	rs_th_in = -ra / sin(lambda - epsilon * 0.75) * 0.001
	rs_th_out = -ra / sin(lambda + epsilon * 0.75) * 0.001
	rs_km = rs_th * 0.001
	in = nbins-100
        iout = nbins
        Nr = nbins-50
	do i = 1, nbins
	    if( radiita(i) .gt. 0.0 )then
		if(radiita(i) .lt. rs_th_in) in = i
		if(radiita(i) .le. rs_th_out) iout = i
		if(radiita(i) .le. rs_km) Nr = i
	    end if
	end do
	if(in .eq. -1.or.iout.eq.-1)then
		ibeg = -1
		return
	end if
	Ng = iout - in + 1
        Ng2 = Ng
	if (Ng2 .eq. 0) Ng2 = 1
C changed radius of check to 30 bins = 2.25 km, because of huge
C range delays in Andrew 8 dec 92
C Then search the gates within +- 30 of gate at theoretical
C range to find the swath Ng/2 wide with greatest Total Ze.
C Return bounding bins.
	dBz_max = -1.0
	ibeg = -1
        if(ng2.gt.30)then
         n30=ng2
        else
         n30=30
        endif
	ist = max(1, Nr - n30)
	ien = min(nbins-Ng2, Nr + n30 -Ng2)
	do i = ist, ien
	   dBzsum = 0.0
	   do j = i, i + Ng2
               if(j.gt.ibst.and.dbzbuffer(j).gt.-32.)then
		dBzsum = dBzsum + dbzbuffer(j)
               endif
	   end do
	   if( dBzsum .gt. dBz_max)then
		dBz_max = dBzsum
		ibeg = i
	   end if
	end do
	iradius = ibeg + Ng2 * 0.5
	if( iradius .le.0) iradius = 1
        if( iradius .gt.nbins) iradius = nbins
	rs_m = radiita( iradius ) * 1000.0
	return
	end
