	subroutine rz_average(array, nvar, imax, jmax,
     +	  idim, jdim, kdim,
     +	  sx,sy,xc,yc,shift_center, xc_shift, yc_shift,
     +	  rad_max, rad_min, dr,
     +	  iDBZ, rz_av, irmax, bad_val, arc_min_frac)
C General purpose radius-height average. Accumulate data in
C data in rings dr km wide, from rad_min to rad_max, and average.
C sx, sy: grid dimensions in km
C xc, yc: center in km, relative to lower left corner (0,0)
C shift_center: if true, then shift center for averaging by
C	xc_shift, yc_shift in km.
C idBZ indicate position of
C dbz in array (0 if none ) so that averaging is done in Z
C If the fraction of good data points in the ring < arc_min_frac
C then the average is not computed.
	real array(nvar, imax, jmax, kdim)
	real rz_av(2,nvar,0:irmax,0:kdim) 
	integer possible_pts(0:511) ! how many possible points each ring?
	logical shift_center
C Initialize r-z mean array
	do j = 0, kdim
	  do i = 0, irmax
		possible_pts(i) = 0
		do iv = 1, nvar
			rz_av(1,iv,i,j) = 0.0
			rz_av(2,iv,i,j) = 0.0
		end do
	  end do 
	end do
	div = 1.0 / dr
C Compute # of possible points for each ring:
	    do j = 1, jdim, 1
		y = j * sy
		if( shift_center ) then
			ysq = (y - yc + yc_shift)**2
		else
			ysq = (y-yc)**2
		end if
	    	do i = 1, idim , 1
		    x = i * sx
		    if( shift_center ) then
		    	radius = (x - xc + xc_shift)**2 + ysq
		    else
		    	radius = (x - xc)**2 + ysq
		    end if
		    radius = sqrt( radius)
		    ir = (radius - rad_min) * div
		    if((ir .lt. irmax) .and. (ir.ge. 0) ) then
			possible_pts(ir) = possible_pts(ir) +1
		    end if
		end do
	end do
C Accumulate data in rings ( no interpolation...)
	do k = 1, kdim, 1
	    do j = 1, jdim, 1
		y = j * sy
		if( shift_center ) then
			ysq = (y - yc + yc_shift)**2
		else
			ysq = (y-yc)**2
		end if
	    	do i = 1, idim , 1
		    x = i * sx
		    if( shift_center ) then
		    	radius = (x - xc + xc_shift)**2 + ysq
		    else
		    	radius = (x - xc)**2 + ysq
		    end if
		    radius = sqrt( radius)
		    ir = (radius - rad_min) * div
		    if((ir .lt. irmax) .and. (ir.ge. 0) ) then
		      do iv = 1, nvar ! -> -> -> -> -> -> -> -> -> ->
			if( iv .eq. iDBZ) then
			 if( array(idBZ, i,j,k) .gt. bad_val) then
			  z = 10.0**(array(idBZ, i,j,k) * 0.1)
			  rz_av(1,iDBZ,ir,k) = rz_av(1,iDBZ,ir,k) + z
			  rz_av(2,iDBZ,ir,k) = rz_av(2,iDBZ,ir,k) + 1
			 end if
			else if( array(iv, i,j,k) .gt. bad_val) then
			  rz_av(1,iv,ir,k) = rz_av(1,iv,ir,k) + 
     +					array(iv, i,j,k)
			  rz_av(2,iv,ir,k) = rz_av(2,iv,ir,k) + 1
			end if
		      end do ! <- <- <- <- <- <- <- <- <- <- <- <- 
		     end if
		end do
	     end do
	end do
C now get averages:
	do k = 1 , kdim
		do ir = 0, irmax
		   do iv = 1, nvar
			if(rz_av(2,iv,ir,k) .gt. 0.0) then
			  frac = rz_av(2,iv,ir,k) / 
     +				possible_pts(ir)
			  if( frac .ge. arc_min_frac ) then
			    rz_av(1,iv,ir,k) = rz_av(1,iv,ir,k) /
     +			     rz_av(2,iv,ir,k)
		            if(iv .eq. iDBZ ) then ! put back in dBZ
			       rz_av(1,iDBZ,ir,k) = 
     +				10*log10(rz_av(1,iDBZ,ir,k))
			    end if
			  else
			    rz_av(1,iv,ir,k) = bad_val
			  end if
			else
			  rz_av(1,iv,ir,k) = bad_val
			end if
		   end do 
		end do
	end do
C
	return
	end
C ****
	subroutine get_rmin(idim, jdim, xs,ys, sx, sy, rmax, rmin)
C given box idim*sx by jdim*sy, determine min and max distance from 
C 0,0 where lower left corner of box is located at -xs, -ys
C - signs because in radar software xs, ys is distance to storm from
C lower left corner of box.
	xr = -xs + idim * sx
	yt = -ys + jdim * sy
	r1 = xs**2 + ys**2
	r2 = xr**2 + ys**2
	r3 = xr**2 + yt**2
	r4 = xs**2 + yt**2
	if( (-xr*xs .le. 0.0 ) .and. (-yt*ys .le. 0.0) )then ! box includes 0,0
		rmin = 0.0 
	else
		rmin = min(r1, r2, r3, r4)
		rmin = sqrt(rmin)
	end if
	rmax = max(r1, r2, r3, r4)
	rmax = sqrt(rmax)
	return
	end


