C		plot10_ps_subs.f
C Called by routines in my_plot10_subs to 
C generate Postscript code from plot 10 calls.
C ------------------------------------- 
	subroutine my_ps_newpn(ipen, ipst_file, updown, ibkgd_fgd)
	real red(0:8), green(0:8), blue(0:8)
	save red, green, blue
	integer updown
C 	"Black", "Red", "Orange", "Yellow", "Green",
C		"Blue", "DarkTurquoise", "Violet", "White"
	data red/0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.61, 1.0/
	data green/0.0, 0.0, 0.53, 1.0, 1.0, 0.0, 0.65, 0.24, 1.0/
	data blue/0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.65, 0.81, 1.0/
	ip = ipen
	if( ipen .gt. 8) then
		ip = mod(ipen,8)
	end if
	if( (updown .eq. 2) .or. (updown.eq.3) )then 
C Stroke, otherwise the changes will apply to segments already drawn!
		write(ipst_file,*)' stroke'
	end if
C change pen color or width 
      if( ipen .gt. 0)then ! set line width in points
              write(ipst_file, *)ip,' setlinewidth' 
      else
	if( ipen .ge. -8)then
Cout              gray = -ipen * 0.1 
Cout	        write(ipst_file,*)gray, ' setgray' 
	  if(ibkgd_fgd .ne. 2) then
		write(ipst_file,*)red(-ip), green(-ip),
     +			blue(-ip), ' setrgbcolor' 
	  else
	    if( ipen .eq. 0) then ! swap black to white
		write(ipst_file,*)red(8), green(8),
     +			blue(8), ' setrgbcolor' 
	    else if( ipen .eq. -8) then ! swap white to black
		write(ipst_file,*)red(0), green(0),
     +			blue(0), ' setrgbcolor' 
	    else ! just use color specified
		write(ipst_file,*)red(-ip), green(-ip),
     +			blue(-ip), ' setrgbcolor' 
	    end if
	  end if
	else
	  if(ibkgd_fgd .eq. 2) then
		gray = 1.0 ! White
	  else
		gray = 0.0 ! Black
	  end if
	  write(ipst_file,*)gray, ' setgray' 
	end if
      end if
      return
      end 
C --------------------------------------
      subroutine my_ps_plot(x, y, updown, ipst_file, xp0, yp0,
     +		scale, last_pen) 
      real x, y 
      real xpt, ypt
      integer updown, last_pen
C 
	xpt = xp0 + scale * x * 72 ! convert to points (1/72 of inch unit)
	ypt = yp0 + scale * y * 72
        if( updown .eq. 2) then ! just do a line to xy 
		write(ipst_file,'( 2(f8.3,1x), " d" )') xpt,ypt 
		last_pen = 2
        else if(updown .eq. 3) then ! stroke (in case unfinished) and move to xy 
		write(ipst_file,'( 2(f8.3,1x), " m" )') xpt,ypt 
		last_pen = 3
	else if( updown .eq. -3) then ! do above, then shift origin
		write(ipst_file,'( 2(f8.3,1x), " m" )') xpt,ypt 
		xp0 = xp0 + x * 72 * scale
		yp0 = yp0 + y * 72 * scale
		last_pen = 3
        else if( updown .eq. 0) then ! just redefine origin
		xp0 = xp0 + x * 72 * scale
		yp0 = yp0 + y * 72 * scale
        else if( updown .eq. -2) then ! just do a line to xy , redefine origin
		write(ipst_file,'( 2(f8.3,1x), " d" )') xpt,ypt 
		xp0 = xp0 + x * 72 * scale
		yp0 = yp0 + y * 72 * scale
		last_pen = 2
        else if( updown .eq.1) then ! move or draw
		if( last_pen .eq. 2) then
			write(ipst_file,'( 2(f8.3,1x), " d" )') xpt,ypt 
		else if( last_pen .eq. 3) then
			write(ipst_file,'( 2(f8.3,1x), " m" )') xpt,ypt 
		end if
        else if( updown .eq.-1) then ! move  and redefine origin
		if( last_pen .eq. 2) then
			write(ipst_file,'( 2(f8.3,1x), " d" )') xpt,ypt 
		else if( last_pen .eq. 3) then
			write(ipst_file,'( 2(f8.3,1x), " m" )') xpt,ypt 
		end if
		xp0 = xp0 + x * 72 * scale
		yp0 = yp0 + y * 72 * scale
 	else if( updown .eq. 998) then ! show the page, close file
	        write(ipst_file,*)' stroke' ! in case some line left to draw 
C BEWARE, following line will screw up EPSF
        	write(ipst_file,*)' showpage'
		close(ipst_file)
	end if
	return
	end 
C --------------------------------------------- 
      subroutine my_ps_symbl(x, y, nchar, string, rotang, ipst_file,
     +		xp0, yp0, scale)
      real x, y, rotang 
      integer nchar
      integer xpt, ypt
      character string*(*) 
C plot a string.
      xpt = nint(xp0 + scale * x * 72) ! convert to points (1/72 of inch unit)
      ypt = nint(yp0 + scale * y * 72)
      write(ipst_file,'(2(i4,1x)," m" )')xpt,ypt  
	if( rotang .ne. 0.0 ) then
		write(ipst_file, 90)xpt, ypt
90		format(i5, 1x, i5, ' translate')
		write(ipst_file, 100)rotang
100		format(f6.1,1x,'rotate')
	end if
        if( nchar .lt. 0) then ! x,y is pos of right side of string
                nc = -nchar
      write(ipst_file,*)'(' // string(1:nc) // ')' // ' rs'
      write(ipst_file,*)'(' // string(1:nc) // ')' // ' show'
        else
                nc = nchar
      write(ipst_file,*)'(' // string(1:nc) // ')' // ' show'
        end if
	if( rotang .ne. 0.0 ) then
		write(ipst_file, 100)-rotang
		write(ipst_file, 90)-xpt, -ypt
	end if
      return
      end 
C ----------
C code for circle, clipped to window
	subroutine my_ps_circle(x, y, radius, w, ipst_file, scale)
	real x, y, w(4)
C
	ixl = w(1) * 72 * scale
	ixr = w(3) * 72 * scale
	iyb = w(2) * 72 * scale
	iyt = w(4) * 72 * scale
	ixc = x * 72 * scale
	iyc = y *72 * scale
	irad = radius * 72 * scale
C save graphics state so can restore after circle drawn
	write(ipst_file,*)'gsave '
C set current path to be window, and define new clip region
	write(ipst_file,*)' newpath ',ixl,iyb,' moveto'
	write(ipst_file,*)ixr,iyb,' lineto'
	write(ipst_file,*)ixr,iyt,' lineto'
	write(ipst_file,*)ixl,iyt,' lineto'
	write(ipst_file,*)' closepath clip'
C Now use arc to make circular path, clip and draw,
C assuming line weight and color have been set before calling this 
C code, and restore graphics state.
	write(ipst_file,*)'newpath ',ixc, iyc, irad,' 0 360 arc '
        write(ipst_file,*)' clip stroke grestore '
	return
	end
C ---------------------------------
	subroutine ps_comment(ipst_file,comment)
C Use this to add comments to ps file, to delineate maps, for example
	integer ipst_file
	character*(*) comment
C
	write(ipst_file,*)'% ',comment
	return
	end
C --------------------------------
	subroutine my_ps_circle_fill(x, y, radius, w, ipst_file, scale)
	real x, y, w(4)
C
	ixl = w(1) * 72 * scale
	ixr = w(3) * 72 * scale
	iyb = w(2) * 72 * scale
	iyt = w(4) * 72 * scale
	ixc = x * 72 * scale
	iyc = y *72 * scale
	irad = radius * 72 * scale
C save graphics state so can restore after circle drawn
	write(ipst_file,*)'gsave '
C set current path to be window, and define new clip region
	write(ipst_file,*)' newpath ',ixl,iyb,' moveto'
	write(ipst_file,*)ixr,iyb,' lineto'
	write(ipst_file,*)ixr,iyt,' lineto'
	write(ipst_file,*)ixl,iyt,' lineto'
	write(ipst_file,*)' closepath clip'
C Now use arc to make circular path, clip and draw,
C assuming line weight and color have been set before calling this 
C code, and restore graphics state.
	write(ipst_file,*)'newpath ',ixc, iyc, irad,' 0 360 arc '
        write(ipst_file,*)' clip fill grestore '
	return
	end


