      SUBROUTINE ANGLECOR(pitch, drift, roll, azm, elev, idradar,
     +  pcor, dcor, rcor, azmcor, elcor)
C     CORRECTS AIRCRAFT AZM AND ELEV ANGLES FOR PITCH, DRIFT, AND ROLL.  THE
C     RESULTING AZIMUTH AND ELEVATION ANGLES ARE RELATIVE TO AIRCRAFT TRACK.
C     SEE AIRBORNE RADAR GEOMETRY NOTES BY PETER DODGE.
      DATA             ctr/0.01745329/

C     MAKE DESIRED CORRECTIONS TO RAW PITCH, DRIFT, ROLL, AZIMUTH, AND ELEVATION
C     PITCH ANGLE >0=POINTING UP, <0 POINTING DOWN
C     DRIFT >0=HEADING LEFT OF TRACK, <0 HEADING RIGHT OF TRACK
C     ROLL ANGLE CORRECTION IN DEG. (+ CLOCKWISE - DIP STARBOARD WING)
C     AZMCOR > 0:CLOCKWISE, <0:COUNTERCLOCKWISE
C     ELCOR IS THE ELEVATION ANGLE CORRECTION (>0:FORWARD, <0:AFT)
      pitch = pitch + pcor
      drift = drift + dcor
      roll = roll + rcor
      azm = AMOD(azm + azmcor + 360.0, 360.0)
      elev = elev + elcor

C     CALCULATE FUNCTIONS USED REPEATEDLY
      cel = COS(elev * ctr)
      sel = SIN(elev * ctr)
      cpt = COS(pitch * ctr)
      spt = SIN(pitch * ctr)
      cdr = COS(drift * ctr)
      sdr = SIN(drift * ctr)

C     COMPUTE GEOMETRY FOR THE TAIL ANTENNA FIRST
      IF (idradar.EQ.2) THEN
C       CALCULATE OTHER FUNCTIONS USED REPEATEDLY HERE
C       CORRECT AZIMUTH FOR ROLL
        razm = AMOD(azm + roll + 360.0, 360.0) 
        caz = COS(razm * ctr)
        saz = SIN(razm * ctr)

C       SINE IS THE SIN OF THE CORRECTION ANGLE TO GET TAIL ANTENNA
C       PERPENDICULAR TO THE AIRCRAFT TRACK 
        sine = sel * cpt * cdr - cel * caz * spt * cdr + cel * saz * sdr

C       ELEVATION(RELATIVE TO A/C HEADING) (>0 POINTS FORWARD, <0 POINTING AFT)
        elev = ASIN(sine) / ctr

C       COMPUTE EARTH RELATIVE AZIMUTH FROM THE PLANE RELATIVE AZIMUTH      
        bigy = cel * cdr * saz - sdr * (sel * cpt - cel * spt * caz)  ! CPT CHANGED FROM SPT (P.DODGE 6FEB92)
        bigz = sel * spt + cel * cpt * caz
        azm = ATAN2(bigy, bigz) / ctr
c        write(6,*)'anglecor1,azm,bigy,bigz = ',azm,bigy,bigz
        IF (azm.LT.0.0)  azm = 360.0 + azm

      ELSE  ! COMPUTE THE GEOMETRY FOR THE LOWER FUSELAGE RADAR
C       CALCULATE OTHER FUNCTIONS USED REPEATEDLY - AZIMUTH NOT CORRECTED FOR ROLL
        caz = COS(azm * ctr)
        saz = SIN(azm * ctr)
        crl = COS(roll * ctr)
        srl = SIN(roll * ctr)

C       NOW AZIMUTH IS RELATIVE TO HEADING OR TRACK(0 IS FORWARD, 90 IS RIGHT)
        sdr = -sdr
        bigx = cel * caz * cpt * cdr +
     +    cel * saz * (srl * spt * cdr - crl * sdr) -
     +    sel * (crl * spt * cdr + srl * sdr)
        bigy = cel * caz * cpt * sdr +
     +    cel * saz * (srl * spt * sdr + crl * cdr) -
     +    sel * (crl * spt * sdr - srl * cdr)
        bigz = - cel * caz * spt + cel * saz * srl * cpt -
     +    sel * crl * cpt

C       ELEVATION(RELATIVE TO AIRCRAFT) (<0 POINTS DOWNWARD, >0 POINTS UPWARD)
        elev = - ASIN(bigz) / ctr
        azm = ATAN2(bigy, bigx) / ctr
c        write(6,*)'anglecor1,azm,bigy,bigx = ',azm,bigy,bigx
        azm = AMOD(360.0 + azm, 360.0)
ccc        azm = ASIN(bigy / COS(elev * ctr)) / ctr
      ENDIF

      RETURN
      END 
