C jobfile_maker_2006.f, modified from John Gamache's jobfile_maker.f
C modified for 2006 Hurricane Field Program, in accord with changes
C John made to the jobfiles. One major change that John made is to optionally
C generate radar and nav angle corrections.
C For 2006 is only installed on 42. If this program is to be used in subsequent
C years it should be modified to accept 62 or 43 (or 49~) as another 
C runstring argument. 1 May 2006
C My intent is to group the flight specific questions (so maybe they can
C be read from a setup file) and also to make it easier to enter 
C default values, to minimize typing as we bounce around...
C p dodge 13 June 2005
      PROGRAM jobfile_maker_2006
      CHARACTER FLT*8,EXP*12,CPLANE*2,OFILNAM*80
      CHARACTER OFILNAM_IN*80, OFILNAM_OUT*80
	character*80 radar_FILNAM
	logical airborne_wkstn, exist
	character*1 platform ! W = wkstn, G = ground
	character*1 yesno
        character*5 dummyradarfilename
	real spd_convt 
C 
	spd_convt = 1.0 / 1.9438 ! kts to m/s
C
	call getarg(1,platform)
	if( platform .eq.'W' .or. platform .eq. 'w') then
		airborne_wkstn = .true.
		write(6,*)' Airborne workstation'
	else if( platform .eq.'G'  .or. platform .eq. 'g') then
		airborne_wkstn = .false.
		write(6,*)'Not running on Airborne workstation'
	else
		write(6,*)' You did not specify platform.'
		write(6,*)' Assume running on airborne workstation'
		airborne_wkstn = .true.
	end if
C Flight specific
	call get_flight_params(IY, IM, ID, IAIR, FLT, EXP, IFRANCE,
     +		ISTORMNO, ibst, aft_AZMCOR, aft_ELCOR,aft_RDELCOR,
     +		aft_PCOR, aft_DCOR, aft_RCOR, fore_AZMCOR, fore_ELCOR,
     +		fore_RDELCOR,fore_PCOR, fore_DCOR, fore_RCOR,
     +		airborne_wkstn)
C
C
      WRITE(6,'("FLIGHT ID IS ", a8)')flt
102   FORMAT(A6,A2)
C
C Flight leg specific:
	if(.not.airborne_wkstn)then
1101  WRITE(6,*)'Enter LU number for tape drive'
      WRITE(6,*)'Enter a negative number if using a disk file'
      READ(5,*,err=1101)lu_tape
      IF(lu_tape.LT.6)THEN
       WRITE(6,*)'Enter radar file name'
       READ(5,'(A80)')radar_FILNAM
      ENDIF
	else
C LU number meaningless (but >6 for logic below!)
c        write(6,*)'Since you are running this on thor with a '
c        write(6,*)'Enter the tape drive lu number'
c        read(5,*)lu_tape
		lu_tape = 12
	end if
111      WRITE(6,*)'Enter begin time (HHMMSS)'
      READ(5,203,err=111)IHB,IMB,ISB
112      WRITE(6,*)'Enter end time (HHMMSS)'
      READ(5,203,err=112)IHE,IME,ISE
201   FORMAT(A6,X,A6)
	if(airborne_wkstn) then
1102            write(6,*)'Enter storm motion in degrees nav and kts'
		read(5,*,err=1102)storm_dir, storm_kts
        	ang = (90.0 - storm_dir)*acos(-1.0)/180 ! conversion to math angle 
        	u = storm_kts * spd_convt * cos(ang) 
		v = storm_kts * spd_convt * sin(ang) 
	else
1103    	WRITE(6,*)'Enter storm motion (u,v) in m per s'
		READ(5,*,err=1103)U,V
	end if
114      WRITE(6,*)'Enter composite center time (HHMMSS)'
      WRITE(6,*)'This will usually be the fix time'
      WRITE(6,*)'Assume this is true unless you have some reason'
      Write(6,*)'to think otherwise.'
      READ(5,203,err=114)IHC,IMC,ISCC
203   FORMAT(3I2)
	if(airborne_wkstn)then
C hardwire to deg and min because that is how nav reports it on the aircraft
		IDEG = 1
	else
1104  WRITE(6,*)'Would you prefer decimal (0) or minutes (1)'
      WRITE(6,*)'to enter storm latitude and longitude?'
      READ(5,*,err=1104)IDEG
	end if
      WRITE(6,*)'Enter storm lat, lon at center time'
      WRITE(6,*)'This will usually be the fix position'
      WRITE(6,*)'Assume this is true unless you have some reason'
      Write(6,*)'to think otherwise.'
      IF(IDEG.EQ.0)THEN
2104	WRITE(6,*)'Enter latitude and longitude'
	WRITE(6,*)'West longitude should be negative'
	READ(5,*,err=2104)OLAT,OLON
      ELSE
116	WRITE(6,*)'Enter degrees, minutes of latitude (North +)'
	READ(5,*,err=116)DEG,RMIN
	if(RMIN .gt. 60 .or. RMIN.lt.0) then
		write(6,*)' Minutes > 60! Do not enter decimal fraction.'
		go to 116
	end if
C Warning This could screw up if within 1 deg of equator ...
	If( deg .gt. 0.0) then
		OLAT = DEG + RMIN/60.0
	else
		OLAT = DEG - RMIN/60.0
	end if
117	WRITE(6,*)'Enter degrees (W positive), minutes of longitude '
C Note we do west postive for one less keystroke required on the plane
	READ(5,*,err=117)DEG,RMIN
	if(RMIN .gt. 60 .or. RMIN.lt.0) then
		write(6,*)' Minutes > 60! Do not enter decimal fraction.'
		go to 117
	end if
C Warning: Following could screw up within 1 deg of Greenwuch or Date line
        If( deg .gt. 0.0) then
                OLON = DEG + RMIN/60.0
        else
                OLON = DEG - RMIN/60.0
        end if
	olon = -olon ! flip for jobfile so west < 0.0
      ENDIF
C
      WRITE(6,204)OLAT,OLON
204   FORMAT(2F10.3)
C
C Get Analysis specific paramters
	call get_analysis_params(RADIUS, HREZ, ZRES, TREZ, 
     +		HREZPROFILE, ZRESPROFILE, HEIGHTBOT, ROT,
     +		INOB, THRESH, DBZRS, DBZCOR, DBZSLOPE,
     +		SWTHRESH, FACTZ, HB2, DPB2, ZLOW, ZHIGH,
     +		airborne_wkstn)
      TREZ=15.
      HREZPROFILE=1.5
      HEIGHTBOT=0.
      ROT=0.
      IMAX=NINT(RADIUS*2./HREZ)
      JMAX=IMAX
      KMAX=1+NINT(18./ZRES)
C JG changed so will do deep profile
Cout      KMAXPROFILE=1+NINT(3./ZRESPROFILE)
      KMAXPROFILE=1+NINT(18./ZRESPROFILE)
      IMAX = NINT(RADIUS/HREZ)
      IMAXPROFILE=NINT(RADIUS/HREZPROFILE)
      IF(IMAXPROFILE.GT.14)IMAXPROFILE=140
      JMAX=24
C here calculate from times and radar data, then ask if ok
	inquire(file = 'radar_legs.dat', exist = exist)
	if( exist) then
	  open(89,file = 'radar_legs.dat', form ='formatted')
          read(89,*)idumdummy
          read(89,*)idumdummy
          read(89,*)idumdummy
          read(89,*)rdumdummy
	  read(89,*)track_inbound, azimuth_inbound
	  read(89,*)track_outbound, azimuth_outbound
	  close(89)
	  write(6,*)'Inbound track :',track_inbound,' Azimuth: ',
     +		azimuth_inbound
	  write(6,*)'Outbound track :',track_outbound,' Azimuth: ',
     +		azimuth_outbound
	  write(6,*)' Use these for vertical profiles?'
          write(6,*)' yes (y) or no (n)?'
	  read(5,'(a)')yesno
	  if(yesno .eq.'n' .or. yesno .eq.'N')then
1105		WRITE(6,*)'Enter nominal inbound,outbound azimuths '
      		WRITE(6,*)'from storm center'
      		WRITE(6,*)'Use navigation degrees (NW = 315 etc)'
      		READ(5,*,err=1105)AZIIN,AZIOUT
	  else
		aziin = azimuth_inbound
		aziout = azimuth_outbound
	  end if
	else
1106		WRITE(6,*)'Enter nomimal inbound,outbound azimuths '
      		WRITE(6,*)'from storm center'
      		WRITE(6,*)'Use navigation degrees (NW = 315 etc)'
                WRITE(6,*)'Normally this will be the aircraft track '
                WRITE(6,*)'for the outbound leg '
                WRITE(6,*)'and the aircraft track plus/minus 180 '
                WRITE(6,*)'for the inbound leg.'
      		READ(5,*,err=1106)AZIIN,AZIOUT
	end if	  
C      WRITE(6,*)'Enter an output wind file name'
C      READ(5,'(A80)')OFILNAM
Cout      WRITE(6,*)'Enter name of final cartesian wind file'
Cout      READ(5,'(A80)')OFILNAM
C Label output files by center time
C open output files:
      OPEN(80,FILE='jobfile_radar')
      OPEN(81,FILE='jobfile_radar_rt')
      OPEN(82,FILE='jobfile_radar_profile')
      OPEN(83,FILE='jobfile_radar_fourier')
      OPEN(84,FILE='jobfile_radar_profile_in')
      OPEN(85,FILE='jobfile_radar_profile_out')
      OPEN(86,FILE='jobfile_radar_in')
      OPEN(87,FILE='jobfile_radar_out')
	do lu = 80, 87
		write(lu,'(a8)')flt
		write(lu,'(A12)')EXP
	end do
	do lu = 80,83
		write(lu,'(3i2.2,1x,3i2.2)')IHB,IMB,ISB,IHE,IME,ISE
	end do
	write(84,'(3i2.2,1x,3i2.2)')IHB,IMB,ISB,IHC,IMC,ISCC
	write(86,'(3i2.2,1x,3i2.2)')IHB,IMB,ISB,IHC,IMC,ISCC
	write(85,'(3i2.2,1x,3i2.2)')IHC,IMC,ISCC,IHE,IME,ISE
	write(87,'(3i2.2,1x,3i2.2)')IHC,IMC,ISCC,IHE,IME,ISE
	do lu = 80,87
		write(lu,202)u,v
	end do
202   FORMAT(2F8.2)
	do lu = 80,87
		write(lu,'(3i2.2)')IHC,IMC,ISCC
	end do
	do lu = 80,87
		write(lu, 204)OLAT,OLON
	end do
      WRITE(80,205)HREZ,HREZ,ZRES
      WRITE(81,205)HREZ,TREZ,ZRES
      WRITE(86,205)HREZ,TREZ,ZRES
      WRITE(87,205)HREZ,TREZ,ZRES
      WRITE(83,205)HREZ,TREZ,ZRES
      WRITE(82,205)HREZPROFILE,TREZ,ZRESPROFILE
      WRITE(84,205)HREZPROFILE,TREZ,ZRESPROFILE
      WRITE(85,205)HREZPROFILE,TREZ,ZRESPROFILE
205   FORMAT(4F8.2)
      WRITE(80,205)RADIUS,RADIUS,HEIGHTBOT,ROT
      WRITE(86,205)RADIUS,RADIUS,HEIGHTBOT,ROT
      WRITE(87,205)RADIUS,RADIUS,HEIGHTBOT,ROT
      WRITE(81,205)HREZ,ROT,HEIGHTBOT,ROT
      WRITE(82,205)HREZPROFILE,ROT,HEIGHTBOT,ROT
      WRITE(84,205)HREZPROFILE,ROT,HEIGHTBOT,ROT
      WRITE(85,205)HREZPROFILE,ROT,HEIGHTBOT,ROT
      WRITE(83,205)HREZ,ROT,HEIGHTBOT,ROT
      IMAX=NINT(RADIUS*2./HREZ)
      JMAX=IMAX
      KMAX=1+NINT(18./ZRES)
      KMAXPROFILE=1+NINT(18./ZRESPROFILE)
      WRITE(80,206)IMAX,JMAX,KMAX
      WRITE(86,206)IMAX,JMAX,KMAX
      WRITE(87,206)IMAX,JMAX,KMAX
      IMAX = NINT(RADIUS/HREZ)
      IMAXPROFILE=NINT(RADIUS/HREZPROFILE)
      IF(IMAXPROFILE.GT.130)IMAXPROFILE=130
      JMAX=24
      WRITE(81,206)IMAX,JMAX,KMAX
      WRITE(82,206)IMAXPROFILE,JMAX,KMAXPROFILE
      WRITE(84,206)IMAXPROFILE,JMAX,KMAXPROFILE
      WRITE(85,206)IMAXPROFILE,JMAX,KMAXPROFILE
      WRITE(83,206)IMAX,JMAX,KMAX
206   FORMAT(3I4)
	do lu = 80, 87
		WRITE(lu,206)lu_tape
		WRITE(lu,206)IBST,INOB
C Attitude and antenna angle corrections:
		WRITE(lu,205)aft_AZMCOR, aft_ELCOR, aft_RDELCOR
		WRITE(lu,205)aft_PCOR, aft_DCOR, aft_RCOR
		WRITE(lu,205)fore_AZMCOR, fore_ELCOR, fore_RDELCOR
		WRITE(lu,205)fore_PCOR, fore_DCOR, fore_RCOR
C Analysis params: 
		WRITE(lu,205)THRESH,DBZRS,DBZCOR,DBZSLOPE
		WRITE(lu,205)SWTHRESH
      IF(LU.LE.83)THEN
		write(lu,'(3i2.2,1x,3i2.2)')IHB,IMB,ISB,IHE,IME,ISE
      ELSEIF(LU.EQ.84.OR.LU.EQ.86)THEN
		write(lu,'(3i2.2,1x,3i2.2)')IHB,IMB,ISB,IHC,IMC,ISCC
      ELSEIF(LU.EQ.85.OR.LU.EQ.87)THEN
		write(lu,'(3i2.2,1x,3i2.2)')IHC,IMC,ISCC,IHE,IME,ISE
      ENDIF
Cout		WRITE(lu,201)STARTTIME,ENDTIME
		WRITE(lu,'(F10.1)')FACTZ
		WRITE(lu,'(2F10.2)')HB2,DPB2
		WRITE(lu,'(2F10.2)')ZLOW,ZHIGH
	end do
	OFILNAM = ''
	write(OFILNAM(1:18),"(a8,'_',2i2.2,'_xy.w')")flt,ihc,imc
      WRITE(80,'(A80)')OFILNAM
      WRITE(80,'(2F10.2)')AZIIN,AZIOUT
      WRITE(86,'(A80)')OFILNAM
      WRITE(86,'(2F10.2)')AZIIN,AZIOUT
      WRITE(87,'(A80)')OFILNAM
      WRITE(87,'(2F10.2)')AZIIN,AZIOUT
      IF(lu_tape .LT. 6)THEN
       WRITE(80,'(A80)')radar_FILNAM
       WRITE(86,'(A80)')radar_FILNAM
       WRITE(87,'(A80)')radar_FILNAM
C Change for 2006...so all jobfiles have same # of lines:
      else
        dummyradarfilename='dummy'
	write(80,'(A5)')dummyradarfilename
	write(86,'(A5)')dummyradarfilename
	write(87,'(A5)')dummyradarfilename
      ENDIF
      OFILNAM='first_guess_rt.w'
      WRITE(81,'(A80)')OFILNAM
Cout      WRITE(6,*)'Enter name of vertical profile output file'
Cout      READ(5,'(A80)')OFILNAM
	OFILNAM = ''
	OFILNAM_IN = ''
	OFILNAM_OUT = ''
	write(OFILNAM(1:20),"(a8,'_',2i2.2,'_vert.w')")flt,ihc,imc
	write(OFILNAM_IN(1:28),
     1   "(a8,'_',2i2.2,'_inbound_vert.w')")flt,ihc,imc
	write(OFILNAM_OUT(1:29),
     1    "(a8,'_',2i2.2,'_outbound_vert.w')")flt,ihc,imc
      WRITE(82,'(A80)')OFILNAM
      WRITE(84,'(A80)')OFILNAM_IN
      WRITE(85,'(A80)')OFILNAM_OUT
      WRITE(80,'(I1)')IFRANCE
      WRITE(86,'(I1)')IFRANCE
      WRITE(87,'(I1)')IFRANCE
c      WRITE(6,*)'Enter name of fourier output file'
c      READ(5,'(A80)')OFILNAM
      OFILNAM='first_guess_fourier.w'
      WRITE(83,'(A80)')OFILNAM
      WRITE(82,'(I2)')ISTORMNO
      WRITE(84,'(I2)')ISTORMNO
      WRITE(85,'(I2)')ISTORMNO
      WRITE(82,'(2F10.2)')AZIIN,AZIOUT
      WRITE(84,'(2F10.2)')AZIIN,AZIOUT
      WRITE(85,'(2F10.2)')AZIIN,AZIOUT
      WRITE(80,'(I2)')ISTORMNO
      WRITE(86,'(I2)')ISTORMNO
      WRITE(87,'(I2)')ISTORMNO
C close the job files 
	do lu = 80,87
		CLOSE(lu)
	end do
	write(6,*)' Job files have been created.'
      END
C =====================================================================
	subroutine get_flight_params(IY, IM, ID, IAIR, FLT, EXP,
     +		IFRANCE, ISTORMNO, ibst, aft_AZMCOR, 
     +          aft_ELCOR,aft_RDELCOR,
     +		aft_PCOR, aft_DCOR, aft_RCOR, fore_AZMCOR, fore_ELCOR,
     +		fore_RDELCOR,fore_PCOR, fore_DCOR, fore_RCOR, 
     +          airborne_wkstn)

	integer IY,IM,ID,IAIR,IFRANCE,ISTORMNO
	character flt*8, exp*12, cplane*2, yesno*1
	logical exist, changed,airborne_wkstn, jg_corrs
C
	lu = 89 
	changed = .false.
C
	inquire(file = 'angtest.txt', exist = exist)
	if(exist) then
		jg_corrs = .true.
		open(lu,file='angtest.txt',form='formatted')
		read(lu,*)ibst_jg
		read(lu,*)idum,tilt_cor_aft_jg
		tilt_cor_aft_jg = -tilt_cor_aft_jg
		read(lu,*)idum,az_cor_aft_jg
		read(lu,*)idum,rdel_aft_jg
		read(lu,*)idum,tilt_cor_fore_jg
		tilt_cor_fore_jg = -tilt_cor_fore_jg
		read(lu,*)idum,az_cor_fore_jg
		read(lu,*)idum,rdel_fore_jg
		close(lu)
	else
		jg_corrs = .false.
	end if
C
 	inquire(file = 'radar_flt_params.dat', exist = exist)
	if( .not.exist) then
		write(6,*)'radar_flt_params.dat does not exist.'
		write(6,*)"We'll make it now."
C
1108  WRITE(6,*)'ENTER YEAR AS 2 DIGITS'
      READ(5,*,err=1108)IY
1109  WRITE(6,*)'ENTER MONTH AS 2 DIGITS'
      READ(5,*,err=1109)IM
1110  WRITE(6,*)'ENTER DAY AS 2 DIGITS'
      READ(5,*,err=1110)ID
	if(airborne_wkstn) then ! Hardwire for 2006 !!!!!
		iair = 42
		CPLANE='H1'
	else
22    		WRITE(6,*)'ENTER AIRCRAFT (EITHER 42 OR 43)'
      		READ(5,*,err=22)IAIR
      		IF(IAIR.EQ.42)THEN
       			CPLANE='H1'
      		ELSEIF(IAIR.EQ.43)THEN
       			CPLANE='I1'
      		ELSE
       			WRITE(6,*)'NUMBER MUST BE 42 OR 43'
       			GO TO 22
      		ENDIF
	end if
      write(flt,'(3i2.2,a2)')IY, IM, ID, CPLANE
      WRITE(6,*)'ENTER EXPERIMENT (EXAMPLE Isabel 03)'
      READ(5,'(A12)')EXP
1112  WRITE(6,*)'Enter ATCF Storm Number'
      READ(5,*,err=1112)ISTORMNO
	if(airborne_wkstn) then
		ifrance = 1
	else
1113   		WRITE(6,*)'Enter 0 for NOAA and 1 for French antenna'
      		READ(5,*,err=1113)IFRANCE
	end if
C correction factors:
	write(6,*)'Want anglecheck software to find corrections?'
        write(6,*)'yes (y) or no (n)?'
	read(5,'(a1)')yesno
	if(yesno.eq.'y' .or. yesno.eq.'Y')then ! >>>>>>>>>>>>>>>>>>>>>>>>>>
C Set all to zero so John's software finds them.
                ibst = 0
		aft_AZMCOR = 0.0
		aft_ELCOR = 0.0
		aft_RDELCOR = 0.0
		aft_PCOR = 0.0
		aft_DCOR = 0.0
		aft_RCOR = 0.0
		fore_AZMCOR = 0.0
		fore_ELCOR = 0.0
		fore_RDELCOR = 0.0
		fore_PCOR  = 0.0
		fore_DCOR = 0.0
		fore_RCOR  = 0.0
	else ! >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
C
1115  WRITE(6,*)'Enter IBST'
      READ(5,*,err=1115)IBST
1116  WRITE(6,*)'Enter azimuth and elevation corrections for aft'
      READ(5,*,err=1116)aft_AZMCOR, aft_ELCOR
1117  WRITE(6,*)'Enter aft range delay in km'
      READ(5,*,err=1117)aft_RDELCOR
1118  WRITE(6,*)'Enter pitch, drift, and roll corrections for aft'
      READ(5,*,err=1118)aft_PCOR, aft_DCOR, aft_RCOR
1119  WRITE(6,*)'Enter azimuth and elevation corrections for fore'
      READ(5,*,err=1119)fore_AZMCOR, fore_ELCOR
1120  WRITE(6,*)'Enter fore range delay in km'
      READ(5,*,err=1120)fore_RDELCOR
1121  WRITE(6,*)'Enter pitch, drift, and roll corrections for fore'
      READ(5,*,err=1121)fore_PCOR, fore_DCOR, fore_RCOR
	end if ! <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
		open(lu,file = 'radar_flt_params.dat', 
     +			form = 'formatted')
		write(lu,*)iair, ' Aircraft'
		write(lu,'(3i2.2," Date")')IY, IM, ID
		write(lu,'(A12)')EXP
		write(lu,*)ISTORMNO, ' ATCF Storm number'
		write(lu,*)IFRANCE, ' Antenna type, 1 = French'
		write(lu,*)aft_AZMCOR, aft_ELCOR, ' aft AZMCOR,_ELCOR'
		write(lu,*)aft_RDELCOR, ' aft RDELCOR'
		write(lu,*)aft_PCOR, aft_DCOR, aft_RCOR,
     +             ' Aft pcor, dcor, elcor'
		write(lu,*)fore_AZMCOR, fore_ELCOR, 
     +             ' Fore AZMCOR,_ELCOR'    
		write(lu,*)fore_RDELCOR, ' fore RDELCOR'
		write(lu,*)fore_PCOR, fore_DCOR, fore_RCOR, 
     +             ' FB ore pcor, dcor, elcor'
                write(lu,*)ibst, ' IBST'
		close(lu)
C
C 
C Following is to modify existing file
	else
		write(6,*)'Here are values from radar_flt_params.dat.'
		open(lu,file = 'radar_flt_params.dat', 
     +			form = 'formatted', status ='old')
		read(lu,*)iair
		read(lu,'(3i2.2)')IY, IM, ID
		IF(IAIR.EQ.42)THEN
		  write(flt,'(3i2.2,a2)')IY, IM, ID,'H1'
		else IF(IAIR.EQ.43) then
		  write(flt,'(3i2.2,a2)')IY, IM, ID,'I1'
		else
		  write(6,*)iair,' is bad plane id'
		  flt = 'garbage'
		end if
		read(lu,'(A12)')EXP
		read(lu,*)ISTORMNO
		read(lu,*)IFRANCE
		read(lu,*)aft_AZMCOR, aft_ELCOR
		read(lu,*)aft_RDELCOR
		read(lu,*)aft_PCOR, aft_DCOR, aft_RCOR
		read(lu,*)fore_AZMCOR, fore_ELCOR
		read(lu,*)fore_RDELCOR
		read(lu,*)fore_PCOR, fore_DCOR, fore_RCOR
                read(lu,*)ibst
		close(lu)
C
C Non Nav info:
		write(6,*)' Flight specific info:'
		write(6,*)'Aircraft: ',iair
		write(6,'("Date: ",3i2.2)')IY, IM, ID
		write(6,'("Experiment: ", A12)')EXP
		write(6,*)"ATCF Storm Number: ",ISTORMNO
		write(6,*)"Antenna type (1=French): ",IFRANCE
C
                write(6,*)' This step allows you to change jobfile'
                write(6,*)' parameters specific to a flight and'
                write(6,*)' aircraft using a simple menu'
             write(6,*)' do you want to change anything listed above?'
1130		write(6,*)' Change? yes(y)/no(n)'
		read(5,'(a1)',err=1130)yesno
		if(yesno.eq.'y' .or. yesno.eq.'Y')then
		  changed = .true.
100		write(6,*)'1 Aircraft: ',iair
		write(6,'("2 Date: ",3i2.2)')IY, IM, ID
		write(6,'("3 Experiment: ", A12)')EXP
		write(6,*)"4 ATCF Storm Number: ",ISTORMNO
		write(6,*)"5 Antenna type (1=French): ",IFRANCE
1131		write(6,*)'Pick parameter, -1 to quit'
		 read(5,*,err=1131)ipar
		 if(ipar.eq.1) then
120		   write(6,*)'Enter 42 or 43)'
		   read(5,*,err=120)iair
		IF(IAIR.EQ.42)THEN
		  write(flt,'(3i2.2,a2)')IY, IM, ID,'H1'
		else IF(IAIR.EQ.43) then
		  write(flt,'(3i2.2,a2)')IY, IM, ID,'I1'
		else
		  write(6,*)iair,' is bad plane id'
		  go to 120
		end if
		 else if(ipar.eq.2 ) then
1531		   write(6,*)'Enter Date yymmdd'
		   read(5,'(3i2.2)',err=1531)IY, IM, ID
		 else if(ipar.eq. 3) then
1132		   write(6,*)'Enter Experiment: '
		   read(5,'(a)',err=1132)exp
		 else if(ipar.eq. 4) then
1133		   write(6,*)' Enter ATCF Storm Number: '
		   read(5,*,err=1133)ISTORMNO
		 else if(ipar.eq. 5) then
1134		   write(6,*)' Enter Antenna type (1=French)'
		   read(5,*,err=1134)IFRANCE
		   if(IFRANCE .ne. 1)IFRANCE = 0
		 else if(ipar.le. -1) then
			go to 130
		 end if
		 go to 100
		end if
C
130		write(6,*)" Present angle and radial Correction Factors:"
                write(6,*)" IBST: ",ibst
		write(6,*)" aft AZMCOR, ELCOR: ",aft_AZMCOR, aft_ELCOR
		write(6,*)" aft RDELCOR: ",aft_RDELCOR
		write(6,*)" aft p, d, r COR: ",aft_PCOR, aft_DCOR, 
     +                      aft_RCOR
		write(6,*)" fore AZMCOR, ELCOR: ",fore_AZMCOR, 
     +                        fore_ELCOR
		write(6,*)" fore RDELCOR: ",fore_RDELCOR
		write(6,*)"fore p, d, r COR: ",fore_PCOR, 
     +                     fore_DCOR, fore_RCOR
C
		if(jg_corrs)then
		  write(6,*)' Here are corrections previously '
                  write(6,*)' calculated automatically by anglecheck:'
                  write(6,*)" ibst = ",ibst_jg
		  write(6,*)" aft AZMCOR, ELCOR: ",az_cor_aft_jg, 
     +			tilt_cor_aft_jg
		  write(6,*)" aft RDELCOR: ",rdel_aft_jg
		  write(6,*)" fore AZMCOR, ELCOR: ",az_cor_fore_jg, 
     +			tilt_cor_fore_jg
		  write(6,*)" fore RDELCOR: ",rdel_fore_jg
		  write(6,*)'Use these calculated by the last run of '
                  write(6,*)'anglecheck (2nd block above) '
                  write(6,*)'instead of the present stored values '
                  write(6,*)'(1st block above)?' 
                  write(6,*)'yes(y)/no(n)'
		  read(5,'(a1)')yesno
		  if(yesno.eq.'y' .or. yesno.eq.'Y')then
                        ibst = ibst_jg
			aft_AZMCOR = az_cor_aft_jg
			aft_ELCOR = tilt_cor_aft_jg
			aft_RDELCOR = rdel_aft_jg
			fore_AZMCOR = az_cor_fore_jg
			fore_ELCOR = tilt_cor_fore_jg
			fore_RDELCOR = rdel_fore_jg
			changed = .true.
		  end if
		end if
C
		write(6,*)' manually change any of the correction '
                write(6,*)' factors using a simple menu?'
                write(6,*)' yes(y)/no(n)?'
		read(5,'(a1)')yesno
		if(yesno.eq.'y' .or. yesno.eq.'Y')then
		 changed = .true.
150		 write(6,*)"6 aft AZMCOR, ELCOR: ",aft_AZMCOR, aft_ELCOR
		 write(6,*)"7 aft RDELCOR: ",aft_RDELCOR
		 write(6,*)"8 aft p, d, r COR: ",aft_PCOR, 
     +                        aft_DCOR, aft_RCOR
		 write(6,*)"9 fore AZMCOR, ELCOR: ",fore_AZMCOR, 
     +                        fore_ELCOR
		 write(6,*)"10 fore RDELCOR: ",fore_RDELCOR
		 write(6,*)"11 fore p, d, r COR: ",fore_PCOR, 
     +                      fore_DCOR, fore_RCOR
                 write(6,*)"12 IBST: ",ibst
1151		 write(6,*)'Pick parameter, -1 to quit'
		 read(5, *, err=1151) ipar
		 if(ipar.eq. 6) then
1152		   write(6,*)'Enter aft AZMCOR, ELCOR:'
		   read(5,*,err=1152)aft_AZMCOR, aft_ELCOR
		 else if(ipar.eq. 7) then
1153		   write(6,*)'Enter aft RDELCOR:'
		   read(5,*,err=1153)aft_RDELCOR
		 else if(ipar.eq. 8) then
1154		   write(6,*)'Enter aft pitch, drift, roll corrs:'
		   read(5,*,err=1154)aft_PCOR, aft_DCOR, aft_RCOR
		 else if(ipar.eq. 9) then
1155		   write(6,*)'Enter fore AZMCOR, ELCOR:'
		   read(5,*,err=1155)fore_AZMCOR, fore_ELCOR
		 else if(ipar.eq. 10) then
1156		   write(6,*)'Enter fore RDELCOR:'
		   read(5,*,err=1156)fore_RDELCOR
		 else if(ipar.eq. 11) then
1157		   write(6,*)'Enter fore pitch, drift, roll corrs:'
		   read(5,*,err=1157)fore_PCOR, fore_DCOR, fore_RCOR
                 else if(ipar.eq.12) then
1158               write(6,*)'Enter IBST:'
                   read(5,*,err=1158)ibst
		 else if(ipar .le. -1) then
		   go to 200
		 end if
		 go to 150
		end if
200	      if(changed) then
		open(lu,file = 'radar_flt_params.dat', 
     +			form = 'formatted')
		write(lu,*)iair, ' Aircraft'
		IF(IAIR.EQ.42)THEN
		  write(flt,'(3i2.2,a2)')IY, IM, ID,'H1'
		else IF(IAIR.EQ.43) then
		  write(flt,'(3i2.2,a2)')IY, IM, ID,'I1'
		end if
		write(lu,'(3i2.2," Date")')IY, IM, ID
		write(lu,'(A12)')EXP
		write(lu,*)ISTORMNO, ' ATCF Storm number'
		write(lu,*)IFRANCE, ' Antenna type, 1 = French'
		write(lu,*)aft_AZMCOR, aft_ELCOR, ' aft AZMCOR,_ELCOR'
		write(lu,*)aft_RDELCOR, ' aft RDELCOR'
		write(lu,*)aft_PCOR, aft_DCOR, aft_RCOR,' 
     +                     Aft pcor, dcor, elcor'
		write(lu,*)fore_AZMCOR, fore_ELCOR, ' Fore AZMCOR,_ELCOR'
		write(lu,*)fore_RDELCOR, ' fore RDELCOR'
		write(lu,*)fore_PCOR, fore_DCOR, fore_RCOR, 
     +                     ' FB ore pcor, dcor, elcor'
                write(lu,*)ibst, ' IBST'
		close(lu)

	      end if
	end if
	return
	end 
C =================================================================
	subroutine get_analysis_params(RADIUS, HREZ, ZRES, TREZ,
     +          HREZPROFILE, ZRESPROFILE, HEIGHTBOT, ROT,
     +          INOB, THRESH,DBZRS,DBZCOR,DBZSLOPE,SWTHRESH,
     +          FACTZ, HB2, DPB2, ZLOW, ZHIGH, airborne_wkstn)
	logical airborne_wkstn, exist
	character*1 yesno
C
	lu = 89 
C Temporarily, hardwire FACTZ:
	if (airborne_wkstn) then
		FACTZ = 1000.0
	end if
C
	inquire(file = 'radar_analysis_params.dat', exist = exist)
	if( .not.exist) then
		write(6,*)'radar_analysis_params.dat does not exist.'
C
2222  WRITE(6,*)'Enter distance out to go from center in km'
      READ(5,*,err=2222)RADIUS
      HREZSUGGEST=RADIUS/22.
2223  if(airborne_wkstn)THEN
       WRITE(6,*)'Horizontal resolution must be'
       WRITE(6,*)'greater than or equal to ',HREZSUGGEST
      ENDIF
      WRITE(6,*)'Enter horizontal resolution in km'
      READ(5,*,err=2223)HREZ
      ZRES=.5
      IMAXIMPLIED=NINT(RADIUS*2./HREZ)
      IF(IMAXIMPLIED.GT.44.AND.airborne_wkstn)THEN
       WRITE(6,*)'Re-enter max radius and horizontal resolution'
       WRITE(6,*)'Because max radius divided by horizontal resolution'
       WRITE(6,*)'May not be more than 22'
       GO TO 2222
      ENDIF
      TREZ=15.
	if(airborne_wkstn) then ! Hardwired values
		HREZPROFILE = 1.5
		ZRESPROFILE = 0.15
		HEIGHTBOT=0.
		ROT=0.
		INOB = 5
		THRESH = -99
		DBZRS = -99
		DBZCOR = 0
		DBZSLOPE = 1
		SWTHRESH = 6.25
		FACTZ = 1000.
		HB2 = 5.5
		DPB2 = 2.0
		ZLOW = 99.
		ZHIGH = 100.
	else
1211  WRITE(6,*)'Enter vertical resolution for vertical profiles'
      WRITE(6,*)'A value of .15 km is suggested'
      HREZPROFILE=1.5
      READ(5,*,err=1211)ZRESPROFILE
      HEIGHTBOT=0.
      ROT=0.
1212  WRITE(6,*)'Enter first good gate, number of gates to avg ',
     +'for doppler unfolding (2,5 if not sure)'
      READ(5,*,err=1212)IBST,INOB
1213  WRITE(6,*)'Enter THRESH, DBZRS, DBZCOR, DBZSLOPE'
      WRITE(6,*)'If you dont know enter "-99, -99, 0, 1"'
      READ(5,*,err=1213)THRESH,DBZRS,DBZCOR,DBZSLOPE
1214  WRITE(6,*)'Enter spectral width threshold in m per s'
	WRITE(6,*)'If you dont know use 6.25'
      READ(5,*,err=1214)SWTHRESH
1215  WRITE(6,*)'Enter continuity factor ',
     + ' (if you dont know enter 1000.)'      
      READ(5,*,err=1215)FACTZ
1216  WRITE(6,*)'Enter height and depth of melting layer in km'
      WRITE(6,*)'If you dont know, enter 5.5,2.0'
      READ(5,*,err=1216)HB2,DPB2
1217  WRITE(6,*)'Enter dBZ value below which fallspeed all from snow'
      WRITE(6,*)'If you dont know enter 99.'
      READ(5,*,err=1217)ZLOW
1218  WRITE(6,*)'Enter dBZ value above which fallspeed all from water'
      WRITE(6,*)'IF you dont know enter 100.'
      READ(5,*,err=1218)ZHIGH
	end if
C
	open(lu,file = 'radar_analysis_params.dat', 
     +			form = 'formatted')
      write(lu,*)RADIUS,' distance out to go from center in km'
      write(lu,*)HREZ,ZRES,' horizontal, vertical resolution in km'
      write(lu,*)TREZ, ' Trez'
                                                                       
      write(lu,*)HREZPROFILE,
     +	' horizontal resolution for vertical profiles'
      write(lu,*)ZRESPROFILE,
     +	' vertical resolution for vertical profiles'
      write(lu,*)HEIGHTBOT, ROT, 
     +	' height of bottom, coordinate rotation'
      write(lu,*)INOB,
     +	' 1st good gate, # gates to avg for doppler unfolding'
      write(lu,*)THRESH,DBZRS,DBZCOR,DBZSLOPE, 
     +	' THRESH, DBZRS, DBZCOR, DBZSLOPE'
      write(lu,*)SWTHRESH,' spectral width threshold in m per s'
      write(lu,*)HB2,DPB2,' height and depth of melting layer in km'
      write(lu,*)ZLOW, ' dBZ value below which fallspeed all from snow'
      write(lu,*)ZHIGH, 
     +	' dBZ value above which fallspeed all from water'
	write(lu,*)FACTZ, ' Continuity factor'
		close(lu)
C
	else
		open(lu,file = 'radar_analysis_params.dat', 
     +			form = 'formatted', status ='old')
      read(lu,*)RADIUS
      read(lu,*)HREZ,ZRES
      read(lu,*)TREZ
      read(lu,*)HREZPROFILE
      read(lu,*)ZRESPROFILE
      read(lu,*)HEIGHTBOT, ROT
      read(lu,*)INOB
      read(lu,*)THRESH,DBZRS,DBZCOR,DBZSLOPE
      read(lu,*)SWTHRESH
      read(lu,*)HB2,DPB2
      read(lu,*)ZLOW
      read(lu,*)ZHIGH
	read(lu,*)factz
		close(lu)
	WRITE(6,*)' values from radar_analysis_params.dat;'
	write(6,*)RADIUS,' distance out to go from center in km'
      write(6,*)HREZ,ZRES,' horizontal, vertical resolution in km'
      write(6,*)TREZ, ' Trez'
      write(6,*)HREZPROFILE,
     +	' horizontal resolution for vertical profiles'
      write(6,*)ZRESPROFILE,' vertical resolution for vertical profiles'      
      write(6,*)HEIGHTBOT, ROT, ' height of bottom, coordinate rotation'
      write(6,*)INOB,
     +	' # gates to avg for doppler unfolding'
      write(6,*)THRESH,DBZRS,DBZCOR,DBZSLOPE, 
     +	' THRESH, DBZRS, DBZCOR, DBZSLOPE'
      write(6,*)SWTHRESH,' spectral width threshold in m per s'
      write(6,*)HB2,DPB2,' height and depth of melting layer in km'
      write(6,*)ZLOW, ' dBZ value below which fallspeed all from snow'
      write(6,*)ZHIGH, ' dBZ value above which fallspeed all from water'
      write(6,*)factz,' Continuity factor'
C
	write(6,*)' Change any of the above using a simple menu? '
        write(6,*)' (These should be mostly defaults but can be '
        write(6,*)' changed if you need to.)'
        write(6,*)' yes(y)/no(n)?'
	read(5,'(a1)')yesno
	if(yesno .eq. 'y' .or. yesno .eq. 'Y') then
100	write(6,*)'1 distance out to go from center in km',RADIUS
      write(6,*)'2 horizontal, vertical resolution in km',HREZ,ZRES
      write(6,*)'3 Trez', TREZ
      write(6,*)'4 horiz res for vertical profiles',HREZPROFILE
      write(6,*)'5 vert res for vertical profiles',ZRESPROFILE
      write(6,*)'6 height of bottom, coordinate rotation',HEIGHTBOT, 
     +	ROT
      write(6,*)'7 # gates to avg for dop unfld',
     +	INOB
      write(6,*)'8 THRESH, DBZRS, DBZCOR, DBZSLOPE',THRESH,DBZRS,
     +		DBZCOR,DBZSLOPE
      write(6,*)'9 spectral width threshold in m/s', SWTHRESH
      write(6,*)'10 ht, depth of melting layer in km',HB2,DPB2
      write(6,*)'11 dBZ value below which fallspeed all from snow',ZLOW
                                                                       
      write(6,*)'12 dBZ value above which fallspeed all from water',
     +	ZHIGH
	write(6,*)'13 Continuity Factor ',factz
	   Write(6,*)'enter parameter #, -1 to quit:'
	   read(5,*)ipar
	   if(ipar.eq. 1) then
22221           write(6,*)' Enter distance out to go from center in km'
		read(5,*)RADIUS
      IMAXIMPLIED=NINT(RADIUS*2./HREZ)
      IF(IMAXIMPLIED.GT.44)THEN
       WRITE(6,*)'Re-enter max radius'
       WRITE(6,*)'Because max radius divided by horizontal resolution'
       WRITE(6,*)'May not be more than 22'
       GO TO 22221
      ENDIF
	   else if(ipar.eq. 2) then
22222           write(6,*)' Enter horizontal, vertical resolution in km'
                read(5,*)HREZ,ZRES
      ZRESTEST=.5-ZRES
      ZRESTEST=ABS(ZRESTEST)
      WRITE(6,*)'ZRESTEST = ',ZRESTEST
      IF(ZRESTEST.GT..0001)THEN
1301   WRITE(6,*)'It is not recommended that you change vertical '
       WRITE(6,*)'resolution from .5 km.  Consider changing it back'
       WRITE(6,*)'enter .5 now or enter new value again to confirm'
       read(5,*,err=1301)ZRES
      ENDIF
      IMAXIMPLIED=NINT(RADIUS*2./HREZ)
      IF(IMAXIMPLIED.GT.44)THEN
       WRITE(6,*)'Re-enter horizontal resolution'
       WRITE(6,*)'Because max radius divided by horizontal resolution'
       WRITE(6,*)'May not be more than 22'
       GO TO 22222
      ENDIF
	   else if(ipar.eq. 3) then
1302            write(6,*)' Enter Trez'
                read(5,*,err=1302)TREZ
	   else if(ipar.eq.4) then
1303                write(6,*)' Enter horiz res for vertical profiles'
                read(5,*,err=1303)HREZPROFILE
	   else if(ipar.eq. 5) then
1304            write(6,*)' Enter vert res for vertical profiles'
                read(5,*,err=1304)ZRESPROFILE
	   else if(ipar.eq. 6) then
1305            write(6,*)' Enter height of bottom, coordinate rotation'
                read(5,*,err=1305)HEIGHTBOT, ROT
	   else if(ipar.eq. 7) then
1306            write(6,*)' Enter # gates to avg for dop unfld'
                read(5,*,err=1306)INOB
	   else if(ipar.eq. 8) then
1307            write(6,*)' Enter THRESH, DBZRS, DBZCOR, DBZSLOPE'
                read(5,*,err=1307)THRESH, DBZRS, DBZCOR, DBZSLOPE
	   else if(ipar.eq. 9) then
1308            write(6,*)' Enter spectral width threshold in m/s'
                read(5,*,err=1308)SWTHRESH
	   else if(ipar.eq. 10) then
1309            write(6,*)' Enter ht, depth of melting layer in km'
                read(5,*,err=1309)HB2,DPB2
	   else if(ipar.eq. 11) then
1310            write(6,*)' Enter dBZ value below which fallspeed',
     +			' all from snow'
                read(5,*,err=1310)ZLOW
	   else if(ipar.eq.12) then
1311            write(6,*)' Enter dBZ value above which fallspeed',
     +			' all from water'
                read(5,*,err=1311)ZHIGH
	   else if(ipar .eq. 13) then
1312  		WRITE(6,*)'Enter continuity factor ',
     + ' (if you dont know enter 1000.)'      
                read(5,*,err=1312)zfact
	   else if(ipar.eq.-1) then
                go to 200
	   end if
	   go to 100
200	open(lu,file = 'radar_analysis_params.dat', 
     +			form = 'formatted')
      write(lu,*)RADIUS,' distance out to go from center in km'
      write(lu,*)HREZ,ZRES,' horizontal, vertical resolution in km'
      write(lu,*)TREZ, ' Trez'
                                                                       
      write(lu,*)HREZPROFILE,
     +	' horizontal resolution for vertical profiles'
      write(lu,*)ZRESPROFILE,
     +	' vertical resolution for vertical profiles'
      write(lu,*)HEIGHTBOT, ROT, 
     +	' height of bottom, coordinate rotation'
      write(lu,*)INOB,
     +	' # gates to avg for doppler unfolding'
      write(lu,*)THRESH,DBZRS,DBZCOR,DBZSLOPE, 
     +	' THRESH, DBZRS, DBZCOR, DBZSLOPE'
      write(lu,*)SWTHRESH,' spectral width threshold in m per s'
      write(lu,*)HB2,DPB2,' height and depth of melting layer in km'
      write(lu,*)ZLOW, ' dBZ value below which fallspeed all from snow'
      write(lu,*)ZHIGH, 
     +	' dBZ value above which fallspeed all from water'
	write(lu,*)FACTZ, ' Continuity Factor.'
		close(lu)
	end if ! change block
C 
	end if ! new or old file block
C

	return
	end
