      SUBROUTINE INTERVENATTEN1(bin, nbins, radii) 
C     CALCULATE INTERVENING ATTENUATION
C     BIN - HOLDS CURRENT DBZ VALUES ALONG THE BEAM
C     NBINS - NUMBER OF BINS ALONG THE BEAM
C     RADII - RANGE ALONG THE BEAM IN KILOMETERS
C     ZLOW - LOWEST DBZ LEVEL ATTENUATION IS ADDED FOR
C     ZHIGH - HIGHEST DBZ LEVEL ATTENUATION IS ADDED FOR
C     INDEX - INDEX TO DBZ LEVEL ATTENUATION TABLE
C     INDEXMAX - INDEX TO HIGHEST DBZ LEVEL ATTENUATION IS ADDED FOR
C     ATTENMAX - HIGHEST ATTENUATION VALUE ALLOWED TO BE ADDED
C     ATTENTABLE - ATTENUATION TABLE FOR DBZ VALUES OF 0 TO 64 IN QUARTER DBZ
C     ATTEN - ATTENUATION VALUE FROM TABLE TIMES THE GATE LENGTH(KM) OF THE BIN
C     TOTATTEN - TOTAL ATTENUATION VALUE ADDED UP TO PREVIOUS BIN

      DIMENSION       bin(nbins), radii(nbins)
      PARAMETER       (zlow = 20.0, zhigh = 55.25, indexmax = zhigh * 4,
     +                attenmax = 5.0)
      COMMON /INTATT/ attentable(256)

      totatten = 0.0
      prevradii = 0.0
      DO j = 1, nbins
        IF (bin(j).GT.-31.5) THEN
          bin(j) = bin(j) + totatten
          IF (totatten.LT. attenmax) THEN
            IF (bin(j).GT.zlow) THEN
              index = NINT(bin(j) * 4.0)
              IF (index.GT.indexmax) index = indexmax
              atten = attentable(index) * (radii(j) - prevradii)
              IF (atten.GT.attenmax) atten = attenmax
              prevradii = radii(j)
              bin(j) = bin(j) + atten
              totatten = totatten + atten
              IF (totatten.GT.attenmax) totatten = attenmax
            ENDIF
          ENDIF
        ENDIF
      ENDDO

      RETURN
      END 
