      PROGRAM LEASTWIND
C
C     MAIN PROGRAM OF WIND_FOURIER_AUTO_FIRST
C       
C ... FUNCTION:   
C       
C          THIS PROGRAM UTILIZES THE QC'D DOPPLER DATA AND SUMMATIONS
C          INVOLVING DIRECTION COSINES TO FIND A VARIATIONAL LEAST 
C          SQUARES WIND SOLUTION. IN THIS VERSION OF THE SYNTHESIS CODE, 
C          THE WAVENUMBER 0 AND 1 FOURIER COEFFICIENTS OF RADIAL, TANGENTIAL, 
C          AND VERTICAL WIND ARE SOUGHT. AS IN WIND_INTERPOLATE_RT_AUTO_FIRST_DEFRECKLE, 
C          THE GOVERNING EQUATIONS ARE FORMULATED IN R-THETA-Z COORDINATES RELATIVE 
C          TO THE STORM CENTER. 
C       
C ... LEASTWIND SUBPROGRAM REFERENCES:      
C       
C          NON-SYSTEM     WZERO, SPARSE, WRITEHEADER, WRPLN, SOLVESPARSE
C
C ... IMPORTANT FLAGS: <()> INDICATES DEFAULT
C          
C          COMYES         USE COMMAND FILE (N) NO <(Y)> YES
C          IDBZONLY       DBZ ONLY <(0)> NO (1) YES
C          IVTSUB         SUBTRACT VT FROM FILE (0) NO <(1)> YES
C          IACROSS        AZI-COVERAGE (0) SECTOR <(1)> FULL
C          IGUESS         USE A GUESS WIND FIELD (0) NO <(1)> YES
C          IGUESSER       STARTING GUESS ONLY A MASK <(0)> NO (1) YES
C          IBOTTOP        SET A BOTTOM BOUNDARY CONDITION (0) NO <(1)> YES
C          IRSW           MICROPHYSICS <(0)> JOSS AND WALDVOGEL (1) WILLIS GAMMA
C
C     VERSION:  <TBD>
C       
C     CODE WRITTEN BY:  JOHN GAMACHE   
C                       HRD/AOML/NOAA          
C                       MIAMI, FL 33149      
C       
C     FOR ADDITIONAL DETAILS ON THE ALGORITHM SEE TBD
C       
C     BASED ON THEORY BY:  <TBD>
C       
C     REFERENCE THE BOOK:  <TBD>
C       
C     **************************************************  
C     *               IMPORTANT NOTE                   *  
C     *                                                *  
C     *                    <TBD>                       *  
C     *                                                *  
C     **************************************************  
C       
C     SPECIFICATIONS FOR LOCAL VARIABLES
C       
C **** HEADER RECORD OF AN HRD-TYPE DOPPLER WIND FILE 
C 
      INTEGER IB,JB,KB,IE,JE,KE,IH,IM,IS
      INTEGER IMAXB,JMAXB,KMAXB
      INTEGER IDUMMY,IDUMMY1,IDUMMY2
      REAL STIME,ETIME,OLAT,OLON,XZB,YZB,ZZB,ROTB
      REAL SMOTIONU,SMOTIONV
      REAL DUMMY1,DUMMY2,DUMMY3,DUMMY4
      REAL FACTZ,HB2,DPB2,ZLOW,ZHIGH
      DOUBLE PRECISION SXBD,SYBD,SZBD
      CHARACTER FLTNAME*8,EXPERIMENT*32
      CHARACTER FILNAM(40)*80,OFILNAM*80
C 
C **** REMAINING 
C 
      INTEGER N,NNN1,N4,NN1,NINSIDE,IJK,JKI
      INTEGER LUIN,LUOUT,LU,LUO,LUSCAN,NFILE,NF
      INTEGER KMIN2,KMAX2,IPOS,INDXN,IUVB,IUVD
      INTEGER KOUNT,NMOSM,IUNFLD,IATTEN,FLAG,EXTRA2,EXTRA3
      INTEGER IDBZONLY,IGUESS,IGUESSER,IRSW,IBOTTOP
      INTEGER ITMAX,ITMAXDIV,IVRTEST,ISETZERO,IACROSS
      INTEGER KT(100000),IVTSUB(80)
C
C     IF YOU WANT TO INCREASE AVAILABLE POINTS, MULTIPLY EACH OF THE
C     PARAMETERS (NXYZ,N1,N2,NARRAY,NWORK,NPOINTS) BY THE SAME FACTOR.
C     N1 TELLS YOU HOW MANY GRIDPOINTS ARE ALLOWED IN YOUR ANALYSIS
C     DOMAIN. YOU CAN TRY DECREASING NARRAY OR NWORK RELATIVE TO THE 
C     OTHERS, BUT YOU WON'T BE ABLE TO DO IT MUCH.
C
C     FOR 2 MEGS OF MEMORY:
C     PARAMETER(NXYZ=200000,N1=32000,N2=32000)
C     PARAMETER(NARRAY=10000000,NWORK=4000000)
C     PARAMETER (NPOINTS=608000)
C 
C     FOR 1 MEG OF MEMORY:
      PARAMETER(NXYZ=400000,N1=64000,N2=64000)
      PARAMETER(NARRAY=20000000,NWORK=8000000)
      PARAMETER (NPOINTS=2432000)
C 
      INTEGER IWORK(NARRAY)
      INTEGER IA(NPOINTS)
      INTEGER JA(NARRAY)
      INTEGER INDEX1(NPOINTS),INDEX2(NPOINTS),INDEX4(NXYZ)
      INTEGER*2 ICAST(NXYZ)
      REAL RFLAG,CTR,TSTART,TEND,CENTIME
      REAL RA,CO1,CO2,AZMCOR,ELCOR,THRESH,POWERT,BIEL,AZBIEL
      REAL ETIME1,STIME2,EXTRA6,EXTRA7
      REAL TSTARTARRAY(40),TENDARRAY(40)
      REAL XSHIFT(80),YSHIFT(80),DBZFACT(80)
      REAL SXB,SYB,SZB
      REAL RHMAX,RZMAX,EHMAX,EZMAX
      REAL XACC,YACC,ZACC
      REAL SINTOL,FACTRH,FACTRZ,FACTFILL
      REAL FACTWP,FACTVR,FACTVR2,FACTWBOT,FACTWTOP
      REAL BOUND,WBOUND,WTOP,DBZTEST
      REAL SUM1(NXYZ),SUM2(NXYZ),SUM3(NXYZ)
      REAL SUM4(NXYZ),SUM5(NXYZ),SUM6(NXYZ)
      REAL SUM7(NXYZ),SUM8(NXYZ),SUM9(NXYZ)
      REAL SUM10(NXYZ),SUM11(NXYZ),SUM12(NXYZ)
      REAL SUM13(NXYZ),SUMWTSAVE(NXYZ)
      REAL SUMDBZ(NXYZ),SUMDB(NXYZ)
      REAL UGUESS(NPOINTS)
      REAL XWEIGHT(NXYZ),YWEIGHT(NXYZ),ZWEIGHT(NXYZ)
      REAL UXYZ(NXYZ),VXYZ(NXYZ),WXYZ(NXYZ)
      REAL U(NPOINTS),BAND1(NPOINTS)
      REAL DIV(NXYZ)
      REAL VELS(NPOINTS),WATE(80)
      DOUBLE PRECISION DOTMIN
      DOUBLE PRECISION RHS(NPOINTS)
      DOUBLE PRECISION X12(NPOINTS),NORM(NPOINTS)
      DOUBLE PRECISION M(NARRAY)
      DOUBLE PRECISION WORK(NWORK)
      CHARACTER STMNAME*12,RADAR*4
      CHARACTER CREATIME*32,EXTRA1*28
      CHARACTER KEYWORDOUT*4,KEYWORDD
      CHARACTER KEYWORDB*4
      CHARACTER COMYES*1
      CHARACTER OSUMFILENAME(80)*80
      CHARACTER RAMSFILES(80)*80,DIVERFILE*80
C 
      COMMON /ONE/M,WORK,IWORK,IA,JA
C
C ... DESCRIPTION OF VARIABLES PASSED TO SUBROUTINES
C
C **** WZERO
C
C     IMAXB,JMAXB,KMAXB    - RADIAL,AZI,VERTICAL ARRAY DIMENSION
C     KMAX2                -
C     SUM1-13              - SUMS OF PRODUCTS ACCUMULATED DURING INTERP. PROCESS
C     INDEX4               -
C     OSUMFILENAME         -
C     NFILE                -
C     SUMWTSAVE            - ACCUMULATED WEIGHT AT GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN
C     SUMDBZ               - WEIGHTED AVG. REFLECTIVITY AT GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN
C     SUMDB                -
C     X/Y/ZWEIGHT          -
C     XACC,YACC,ZACC       - MAX ALLOWED RADIAL,AZI,VERTICAL DIST. BETWEEN AVG. OBS POS. AND GRID POINT
C     IVRTEST              -
C     SINTOL               - SIN OF MAX ALLOWED DOPPLER RADIAL ANGLE FROM HORIZ.
C     ISETZERO             -
C     UXYZ,VXYZ,WXYZ       -
C     VELS                 - WEIGHTED AVG. R,THETA,Z DIST. BETWEEN DATUM AND GRIDPOINT
C
C **** SPARSE
C
C     M                    -
C     RHS                  -
C     SXBD,SYBD,SZBD       - RADIAL,AZI,VERTICAL GRID SPACING (KM,DEG,KM)
C     N1                   -
C     NPOINTS              -
C     INDEX1               -
C     INDEX2               -
C     IPOS                 -
C     NARRAY               -
C     IWORK                -
C     NWORK                -
C     FACTZ                -
C     FACTRH               -
C     RACTRZ               -
C     FACTFILL             -
C     ICAST                -
C     BOUND                -
C     WBOUND               -
C     DBZTEST              - MIN DBZ TO INCLUDE
C     NORM                 -
C     INDXN                -
C     WTOP                 -
C     IA,JA                -
C     BAND1                -
C     HB2                  -
C     DPB2                 -
C     IRSW                 -
C     ZLOW,ZHIGH           -
C     FACTWP               -
C     DUMMY1               -
C     FACTVR               -
C     FACTVR2              -
C     FACTWTOP             -
C     FACTWBOT             -
C     KT                   -
C     NUMWAVE              -
C     WATE                 -
C
C **** WRITEHEADER
C
C     LUO                  -
C     DIVERFILE            -
C     KEYWORDD             -
C     FLTNAME              - FLIGHT NAME
C     STMNAME              -
C     RADAR                -
C     EXPERIMENT           -
C     CREATIME             -
C     EXTRA1-7             -
C     KOUNT                -
C     NMOSM                -
C     IUNFLD               -
C     IATTEN               -
C     FLAG                 -
C     STIME,ETIME          - START,END TIME (S)
C     OLAT,OLON            - LAT,LON OF GRID ORIGIN (STORM CENTER)
C     SXB,SYB,SZB          - RADIAL,AZI,VERTICAL GRID SPACING (KM,DEG,KM)
C     XZB,YZB,ZZB          - MIN RADIUS,AZI,HEIGHT (KM,DEG,KM)
C     ROTB                 - COORD. ROTATION (ALWAYS ZERO IN CYL COORDS)
C     RA                   -
C     CO1,CO2              -
C     AZMCOR               -
C     ELCOR                -
C     THRESH               -
C     POWERT               -
C     BIEL                 -
C     AZBIEL               -
C     ETIME1               -
C     STIME2               -
C
C **** WRPLN
C
C     DIV                  -
C     IUVD                 -
C
C **** SOLVESPARSE
C
C     LUOUT                -
C     DOTMIN               -
C     OFILNAM              -
C     KEYWORDB             -
C     X12                  -
C     IUVB                 -
C     WORK                 -
C     ITMAXDIV             -
C     JKI                  -
C     NXYZ                 -
C 
      OPEN(1,FILE='/dev/null')
C 
      LUOUT=6
      LU=90
      LUO=91
      LUSCAN=96 
      RFLAG=-1.0E+10
      CTR=3.14159/180.
C
C     HEADER PARAMETERS
C 
      OFILNAM='purgeme.w'
      KEYWORDB='RUV '
      KEYWORDOUT='RUV '
      RA=-999.
      CO1=-999.
      CO2=-999.
      AZMCOR=-999.
      CREATIME='unknown'
      EXTRA1='SVN VERSION 65'
      RADAR='TAIL'
      ELCOR=-999.
      THRESH=-999.
      POWERT=-999.
      BIEL=-999.
      AZBIEL=-999.
      ETIME1=-999.
      STIME2=-999.
      EXTRA6=-999.
      EXTRA7=-999.
      IUNFLD=1
      IATTEN=0
      FLAG=0
      EXTRA2=-999
      EXTRA3=-999
C
C     INITIALIZE DBZ,U VECTORS TO FLAGGED VALUE AND ZERO U/V/WXYZ,DIV,VELS VECTORS 
C 
      DO N=1,NXYZ
       UXYZ(N)=0
       VXYZ(N)=0
       WXYZ(N)=0
       DIV(N)=0.     
       SUMDBZ(N)=RFLAG
      ENDDO
      DO N=1,NPOINTS
       VELS(N)=0.
      ENDDO
      DO N=1,NPOINTS
       U(N)=RFLAG
      ENDDO
C
C **** REFLECTIVITY ONLY FLAG
C 
      WRITE(6,*)'DBZ ONLY Y(1)/N(0)?'
      IDBZONLY=0
C
C **** COMMAND FILE FLAG AND FILE NAME
C 
      COMYES='Y'
      IF(COMYES.EQ.'Y'.OR.COMYES.EQ.'y')THEN
       LUIN=16
       WRITE(6,*)'Enter command file name'
C       READ(1,'(A)')FILNAM(1)
       FILNAM(1)='jobfile_radar_fourier'
       OPEN(16,FILE=FILNAM(1),STATUS='OLD')
      ELSE
       LUIN=1
      ENDIF
C
C **** FLIGHT NAME
C 
      READ(LUIN,'(A8)')FLTNAME
      WRITE(6,1501)FLTNAME
1501  FORMAT('FLIGHT ID IS ',A8)
C
C **** EXPERIMENT NAME (32 CHARACTERS OR LESS)
C 
      READ(LUIN,'(A32)')EXPERIMENT
      WRITE(6,1502)EXPERIMENT
1502  FORMAT('EXPERIMENT NAME IS ',A32)
      STMNAME=EXPERIMENT(1:12)
C
C **** NUMBER OF DOP3D FILES
C 
      NFILE=2
      WRITE(6,1503)NFILE
1503  FORMAT('NUMBER OF UF FILES TO BE INTERPOLATED IN THIS RUN '/
     + 'WILL BE ',I3)
      IF(NFILE.GT.40)THEN
       WRITE(6,*)'Too many files'
       STOP
      ENDIF
C
C **** BEGIN AND END TIMES
C 
      WRITE(6,*)'Enter beginning and ending times to use data in',
     +  ' HHMMSS HHMMSS'
      READ(LUIN,'(3I2,X,3I2)')IB,JB,KB,IE,JE,KE
      WRITE(6,1506)NF,IB,JB,KB
1506  FORMAT('BEGINNING TIME FOR FILE NO. ',I3,' WILL BE ',3I2)
      WRITE(6,1507)NF,IE,JE,KE
1507  FORMAT('ENDING TIME FOR FILE NO. ',I3,' WILL BE ',3I2)
      TSTART=IB*3600.+JB*60+KB
      STIME=TSTART
      ETIME=IE*3600.+JE*60.+KE
      IF(ETIME.LT.STIME)THEN
       TEND=ETIME+86400.
      ELSE
       TEND=ETIME
      ENDIF
      WRITE(6,*)'STIME,ETIME,TSTART,TEND = ',
     +            STIME,ETIME,TSTART,TEND     
C
C **** SUMMATION FILE NAMES
C                 
      OSUMFILENAME(1)='SUMFILE_aft_rt_auto_first'
      OSUMFILENAME(2)='SUMFILE_fore_rt_auto_first'
C
C     SUMMARY LOOP 
C            

      DO NF=1,NFILE
       TSTARTARRAY(NF)=TSTART
       TENDARRAY(NF)=TEND
C
C **** SUBTRACT VT FLAG
C 
       IVTSUB(NF)=1
       IF(IVTSUB(NF).EQ.1)THEN
        WRITE(6,*)'VT projection will be subtracted'
       ELSE
        WRITE(6,*)'Assumed that VT projection has already been removed'
       ENDIF
       WRITE(6,1508)NF,OSUMFILENAME(NF)
1508   FORMAT('INPUT INTERPOLATION SUMFILE NO. ',I3/
     + 'WILL BE ',A80)
      ENDDO
C
C **** E-W AND N-S STORM MOTION
C 
      READ(LUIN,*)SMOTIONU,SMOTIONV
C
C **** COMPOSITE TIME
C 
      READ(LUIN,'(3I2)')IH,IM,IS
      CENTIME=IH*3600+IM*60+IS
      IF(CENTIME.LT.STIME)CENTIME=CENTIME+86400.
C
C **** LATITUDE AND LONGITUDE OF ORIGIN
C 
      READ(LUIN,*)OLAT,OLON
C      WRITE(6,*)'OLAT = ',OLAT,'   OLON = ',OLON
      WRITE(6,1511)OLAT,OLON
1511  FORMAT('LATITUDE AND LONGITUDE OF ORIGIN WILL BE ',2F8.3)
C
C **** RADIAL, AZIMUTHAL, AND VERTICAL RESOLUTIONS
C 
      READ(LUIN,*)SXBD,SYBD,SZBD
      WRITE(6,1512)SXBD,SYBD,SZBD
1512  FORMAT('RADIAL-, AZIMUTHAL-, AND VERTICAL-DIRECTION GRID '/
     + 'RESOLUTIONS ARE ',F6.2,' KM, ',F6.2,' DEGREES, AND '/
     + F6.2,' KM, RESPECTIVELY')
      SXB=SXBD
      SYB=SYBD
      SZB=SZBD
C
C **** MINIMUM RADIUS FROM STORM CENTER, MINIMUM AZIMUTH CCW FROM
C **** EAST, AND LOWEST HEIGHT
C 
      READ(LUIN,*)XZB,YZB,ZZB
C 
C     ROTATION IS SET TO ZERO SINCE CYLINDRICAL COORDINATES
C 
      ROTB=0.
      WRITE(6,1513)XZB
1513  FORMAT('MINIMUM RADIUS FROM STORM CENTER WILL BE ',F8.3)
      WRITE(6,1514)YZB
1514  FORMAT('MINIMUM AZIMUTH COUNTERCLOCKWISE FROM EAST WILL BE ',
     + F8.3,' DEGREES')
      WRITE(6,1515)ZZB
1515  FORMAT('HEIGHT OF LEVEL 1 WILL BE ',F8.3,' KM')
C
C **** RADIAL, AZIMUTHAL, AND VERTICAL DIMENSIONS
C 
      READ(LUIN,*)IMAXB,JMAXB,KMAXB
      WRITE(6,1516)IMAXB,JMAXB,KMAXB
1516  FORMAT('RADIAL, AZIMUTHAL, AND VERTICAL DIMENSIONS OF ARRAYS '/
     + 'WILL BE ',3I4)
C
C **** MAXIMUM ALLOWABLE RADIAL, AZIMUTHAL, AND VERTICAL DISPLACEMENT 
C **** OF WEIGHTED AVERAGE POSITION OF OBSERVATIONS FROM NOMINAL GRID 
C **** POSITION
C 
      XACC=SXB
      YACC=99.
      ZACC=SZB*2
      WRITE(6,1519)XACC,YACC,ZACC
1519  FORMAT('MAXIMUM ALLOWABLE RADIAL, AZIMUTHAL, AND VERTICAL '/
     + 'DISPLACEMENT OF WEIGHTED AVERAGE POSITION OF OBSERVATIONS '/
     + 'FROM NOMINAL GRID POSITION WILL BE ',3F8.2,' KM')
C 
      write(6,*)'Enter name of output file'
      READ(LUIN,*)IDUMMY
      READ(LUIN,*)IDUMMY,IDUMMY2
      READ(LUIN,*)DUMMY1,DUMMY2,DUMMY3
      READ(LUIN,*)DUMMY1,DUMMY2,DUMMY3
      READ(LUIN,*)DUMMY1,DUMMY2,DUMMY3
      READ(LUIN,*)DUMMY1,DUMMY2,DUMMY3
      READ(LUIN,*)DUMMY1,DUMMY2,DUMMY3,DUMMY4
      READ(LUIN,*)DUMMY1
      READ(LUIN,*)IDUMMY1,IDUMMY2
      READ(LUIN,*)FACTZ
      READ(LUIN,*)HB2,DPB2
      READ(LUIN,*)ZLOW,ZHIGH
      READ(LUIN,'(A80)')OFILNAM
C
C **** ALLOWS A DIFFERENT NUMBER OF LEVELS BETWEEN SYNTHESIS AND 
C **** ORIGINAL INTERPLOATION (LEGACY)
C 
      WRITE(6,*)'Enter kmin and kmax for computation'
      KMIN2=1
      KMAX2=KMAXB
C      READ(LUIN,*)KMIN2,KMAX2
      IF(KMAX2.GT.KMAXB)KMAX2=KMAXB
      WRITE(6,1521)KMIN2,KMAX2
1521  FORMAT('MINIMUM AND MAXIMUM LEVELS OF INTERPOLATION FILE ',
     + 'TO BE FILLED ARE ',2I4)
C
C **** SET MAXIMUM ANGLE OF DOPPLER RADIAL RELATIVE TO HORIZONTAL 
C **** (EARTH-RELATIVE ELEVATION ANGLE) TO BE ACCEPTABLE FOR 
C **** INTERPOLATION (THEN TAKE SIN)...SIN(90 DEG) = 1.
C 
      SINTOL=1.
C
C **** HORIZONTAL, VERTICAL, AND FILLED SMOOTHING FACTORS
C 
      FACTRH=10.
      RACTRZ=10.
      FACTFILL=10.
      WRITE(6,1580)FACTRH,FACTRZ
1580  FORMAT('HORIZONTAL AND VERTICAL SMOOTHING FACTORS ARE ',2F8.4)
      WRITE(6,1581)FACTFILL
1581  FORMAT('WHILE FILLED SMOOTHING FACTOR IS ',2F8.4)
C
C **** 2ND ORDER CONTINUITY FACTOR (FACTWP), BOTTOM/TOP BOUNDARY 
C **** FACTORS (FACTWBOT,FACTWTOP), TOP THICKNESS (FACTVR),
C **** AND DOPPLER RADIAL WEIGHT (FACTVR2).
C 
      FACTWP=0.
      FACTWBOT=1.
      FACTVR=0.
      FACTVR2=1.
      FACTWTOP=1.
      WRITE(6,*)'4th order continuity factor is ',FACTZ
      WRITE(6,*)'2nd order continuity factor is ',FACTWP
      WRITE(6,*)'bottom,top boundary factors are ',FACTWBOT,FACTWTOP
      WRITE(6,*)'Doppler radial weight is ',FACTVR2
      WRITE(6,*)'Thickness of top in meters is ',FACTVR
C
C **** USE STARTING GUESS ONLY AS A MASK FLAG
C 
      IGUESSER=0
C
C **** MICROPHYSICS FLAG
C 
      IRSW=0
C
C **** MELTING BAND HEIGHT AND DEPTH
C 
      WRITE(6,1570)HB2,DPB2
1570  FORMAT('Melting-band height, depth are ',2F8.3,' km')
C
C **** DOTMIN
C 
      DOTMIN=.9999999
C
C **** WEIGHT FOR U-V AND W BOUNDARY CONDITION NORMAL
C 
      BOUND=0.
      WBOUND=0.
      WTOP=0.
C
C **** MINIMUM DBZ TO INCLUDE
C 
      DBZTEST=-2000.
C
C **** REFLECTIVITY BELOW WHICH ALL ICE (WATER) AT T<0: ZLOW (ZHIGH)
C 
      WRITE(6,1560)ZLOW
1560  FORMAT('Reflecitivity below which all ice at T<0 is ',F8.3)
      WRITE(6,1561)ZHIGH
1561  FORMAT('Reflecitivity below which all water at T<0 is ',F8.3)
C
C **** BOTTOM BOUNDARY CONDITION FLAG
C 
      IBOTTOP=1
C
C **** MAX NO. OF ITERATIONS AND NO. OF ITERATIONS BETWEEN WRITING INTERIM SOLUTION
c **** NOTE: VALUES BELOW WILL YIELD A SINGLE ITERATION
C 
      ITMAX=50000 
      ITMAXDIV=50000
C
C **** NO. OF INDEPENDENT VRS NEEDED TO FIND WIND SOLUTION
C 
      WRITE(6,*)'How many independent VRs are needed to find a '
      WRITE(6,*)'wind solution (should be greater than or equal to 2)'
      IVRTEST=2
C
C **** HIGHEST AZIMUTHAL WAVENUMBER TO CONSIDER
C 
      WRITE(6,*)'Enter the highest wavenumber to consider'
      NUMWAVE=1
C
C **** USE STARTING GUESS WIND FIELD FLAG
C 
      IGUESS=1
C 
      NNN1=N1
      N4=NNN1
      NN1=NPOINTS
C 
C ... ??  
C 
      CALL WZERO(IMAXB,JMAXB,KMAXB,KMAX2,SUM1,SUM2,SUM3,SUM4,
     + SUM5,SUM6,SUM7,SUM8,SUM9,SUM10,SUM11,SUM12,SUM13,INDEX4,
     + OSUMFILENAME,NFILE,SUMWTSAVE,SUMDBZ,SUMDB,XWEIGHT,YWEIGHT,
     + ZWEIGHT,XACC,YACC,ZACC,IVRTEST,SINTOL,ISETZERO,
     + UXYZ,VXYZ,WXYZ,VELS(1),VELS(1+NXYZ),VELS(1+NXYZ+NXYZ))
C 
      NINSIDE=ITMAX/ITMAXDIV
C 
C ... IF RETRIEVING THE WIND FIELD
C 
      IF(IDBZONLY.NE.1)THEN
C 
C ...  ??
C 
       CALL SPARSE(M,RHS,UXYZ,IMAXB,JMAXB,KMAXB,
     +  SXBD,SYBD,SZBD,N1,NPOINTS,      
     +  INDEX1,INDEX2,IPOS,SUM1,SUM2,SUM3,SUM4,SUM5,SUM6,SUM7,SUM8,
     +  SUM9,SUM10,SUM11,SUM12,SUM13,
     +  XWEIGHT,YWEIGHT,ZWEIGHT,XACC,YACC,ZACC,
     +  OSUMFILENAME,NARRAY,NFILE,IWORK,NWORK,INDEX4,
     +  FACTZ,FACTRH,FACTRZ,FACTFILL,ICAST,BOUND,WBOUND,ZZB,
     +  SUMDBZ,SUMDB,SUMWTSAVE,DBZTEST,NORM,INDXN,WTOP,IBOTTOP,
     +  IA,JA,IGUESSER,
     +  BAND1,HB2,DPB2,IRSW,ZLOW,ZHIGH,
     1  FACTWP,DUMMY1,FACTVR,FACTVR2,FACTWTOP,
     1  IGUESS,FACTWBOT,KT,KMAX2,IACROSS,NUMWAVE,SINTOL,XZB,WATE,
     1  IVTSUB)
C 
       write(6,*)'index1(1) = ',index1(1)
C 
       KEYWORDB=KEYWORDOUT
       IF(KEYWORDB.EQ.'ruv '.OR.KEYWORDB.EQ.'RUV ')THEN
        IUVB=1
       ELSE
        IUVB=0
       ENDIF
C 
       DIVERFILE='diverfile'
       KEYWORDD='WIND'
       IUVD=0
C
C ...  WRITE HEADER
C 
       CALL WRITEHEADER(LUO,DIVERFILE,KEYWORDD,FLTNAME,
     +  STMNAME,RADAR,EXPERIMENT,
     +  CREATIME,EXTRA1,IMAXB,JMAXB,KMAXB,KOUNT,NMOSM,
     +  IUNFLD,IATTEN,FLAG,EXTRA2,EXTRA3,STIME,ETIME,OLAT,OLON,
     +  SXB,SYB,SZB,XZB,YZB,ZZB,ROTB,RA,CO1,CO2,AZMCOR,ELCOR,THRESH,
     +  POWERT,BIEL,AZBIEL,ETIME1,STIME2,EXTRA6,EXTRA7)
C
C ...  WRITE RESULT TO OUTPUT FILE
C 
        CALL WRPLN(LUO,IMAXB,JMAXB,KMAXB,UXYZ,VXYZ,WXYZ,
     +   DIV,SUMDBZ,IUVD,ZZB,SZB)
        CLOSE(LUO)
C 
       IF(IGUESSER.EQ.1)THEN
        DO IJK=1,NPOINTS
         UGUESS(IJK)=0.
        ENDDO
       ENDIF
C 
C      (JKI) LOOPS (SOLUTION ITERATION)
C 
       DO JKI=1,NINSIDE
C 
        WRITE(6,*)'BEGINNING SOLUTION LOOP NUMBER ',JKI
C 
        DO IJK=1,NPOINTS
         IF((JKI.EQ.1.AND.IGUESSER.EQ.1).OR.JKI.GT.1)THEN
          VELS(IJK)=UGUESS(IJK)
         ENDIF
        ENDDO
        KEYWORDB=KEYWORDOUT
        IF(KEYWORDB.EQ.'ruv '.OR.KEYWORDB.EQ.'RUV ')THEN
         IUVB=1
        ELSE
         IUVB=0
        ENDIF
        write(6,*)'n4 = ',n4
        write(6,*)'calling solvesparse'
C
C ...   ??
C 
        CALL SOLVESPARSE(N1,NPOINTS,IPOS,SXB,
     +   SYB,SZB,VELS,LUOUT,M,RHS,INDEX1,INDEX2,DOTMIN,
     +   LUO,OFILNAM,KEYWORDB,FLTNAME,
     +   STMNAME,RADAR,EXPERIMENT,
     +   CREATIME,EXTRA1,KOUNT,NMOSM,
     +   IUNFLD,IATTEN,FLAG,EXTRA2,EXTRA3,STIME,ETIME,OLAT,OLON,
     +   XZB,YZB,ZZB,ROTB,RA,CO1,CO2,AZMCOR,ELCOR,THRESH,
     +   POWERT,BIEL,AZBIEL,ETIME1,STIME2,EXTRA6,EXTRA7,
     +   IGUESS,X12,IUVB,NORM,
     +   INDXN,NARRAY,NWORK,
     +   IA,JA,IWORK,WORK,ITMAXDIV,JKI,INDEX4,NXYZ)
C 
        DO IJK=1,NPOINTS
         U(IJK)=VELS(IJK)
        ENDDO
C 
        LUO=91
        KEYWORDB=KEYWORDOUT
C
C ...   WRITE HEADER 
C 
        CALL WRITEHEADER(LUO,OFILNAM,KEYWORDB,FLTNAME,
     +   STMNAME,RADAR,EXPERIMENT,
     +   CREATIME,EXTRA1,IMAXB,JMAXB,KMAXB,KOUNT,NMOSM,
     +   IUNFLD,IATTEN,FLAG,EXTRA2,EXTRA3,STIME,ETIME,OLAT,OLON,
     +   SXB,SYB,SZB,XZB,YZB,ZZB,ROTB,RA,CO1,CO2,AZMCOR,ELCOR,THRESH,
     +   POWERT,BIEL,AZBIEL,ETIME1,STIME2,EXTRA6,EXTRA7)
C
C ...   WRITE RESULT TO OUTPUT FILE
C 
        CALL WRPLN(LUO,IMAXB,JMAXB,KMAXB,UXYZ,VXYZ,WXYZ,DIV,SUMDBZ,
     +   IUVB,ZZB,SZB)
        CLOSE(LUO)
C 
        DO IJK=1,NPOINTS
         UGUESS(IJK)=U(IJK)
        ENDDO
C 
       ENDDO
C
C      END JKI LOOP
C 
      ELSE
C 
       DO IJK=1,NPOINTS
        U(IJK)=1.
        DIV(IJK)=0.
       ENDDO
C 
      ENDIF
C
C     END WIND RETRIEVAL CONDITION
C 
      LUO=91
      KEYWORDB=KEYWORDOUT
C
C ... WRITE HEADER
C 
      CALL WRITEHEADER(LUO,OFILNAM,KEYWORDB,FLTNAME,
     + STMNAME,RADAR,EXPERIMENT,
     + CREATIME,EXTRA1,IMAXB,JMAXB,KMAXB,KOUNT,NMOSM,
     + IUNFLD,IATTEN,FLAG,EXTRA2,EXTRA3,STIME,ETIME,OLAT,OLON,
     + SXB,SYB,SZB,XZB,YZB,ZZB,ROTB,RA,CO1,CO2,AZMCOR,ELCOR,THRESH,
     + POWERT,BIEL,AZBIEL,ETIME1,STIME2,EXTRA6,EXTRA7)
C
C ... WRITE RESULT TO OUTPUT FILE
C 
      CALL WRPLN(LUO,IMAXB,JMAXB,KMAXB,UXYZ,VXYZ,WXYZ,DIV,SUMDBZ,
     + IUVB,ZZB,SZB)
      CLOSE(LUO)
C 
      STOP
      END
C
C  *********************************************************************
C 
      SUBROUTINE WZERO(IMAXB,JMAXB,KMAXB,KMAX2,SUM1,SUM2,SUM3,
     + SUM4,SUM5,SUM6,SUM7,SUM8,SUM9,SUM10,SUM11,SUM12,SUM13,INDEX1,
     + OSUMFILENAME,NFILE,SUMWTSAVE,SUMDBZ,SUMDB,
     + XWSAVE,YWSAVE,ZWSAVE,XACC,YACC,ZACC,IVRTEST,SINTOL,
     + ISETZERO,U,V,W,UTEST,VTEST,WTEST)
C
C     SUBROUTINE CALLED BY PROGRAM LEASTWIND
C       
C ... FUNCTION:   
C       
C     THIS SUBROUTINE...
C
C ... WZERO SUBPROGRAM REFERENCES:      
C       
C          NON-GRAPHICS     READABCD
C 
C ... IMPORTANT FLAGS: <()> INDICATES DEFAULT
C          

C      
C     VERSION:  <TBD>
C       
C     CODE WRITTEN BY:  JOHN GAMACHE   
C                       HRD/AOML/NOAA          
C                       MIAMI, FL 33149      
C       
C     FOR ADDITIONAL DETAILS ON THE ALGORITHM SEE <TBD>
C       
C     BASED ON THEORY BY:  <TBD>
C       
C     REFERENCE THE BOOK:  <TBD>
C       
C     **************************************************  
C     *               IMPORTANT NOTE                   *  
C     *                                                *  
C     *                    <TBD>                       *  
C     *                                                *  
C     **************************************************         
C
C     SPECIFICATIONS FOR ARGUMENTS
C 
      INTEGER IMAXB,JMAXB,KMAXB,KMAX2,NFILE
      INTEGER IVRTEST,ISETZERO
      INTEGER INDEX1(IMAXB,JMAXB,KMAXB)
      REAL SINTOL      
      REAL XACC,YACC,ZACC
      REAL SUM1(IMAXB,JMAXB,KMAXB),SUM2(IMAXB,JMAXB,KMAXB)
      REAL SUM3(IMAXB,JMAXB,KMAXB),SUM4(IMAXB,JMAXB,KMAXB)
      REAL SUM5(IMAXB,JMAXB,KMAXB),SUM6(IMAXB,JMAXB,KMAXB)
      REAL SUM7(IMAXB,JMAXB,KMAXB),SUM8(IMAXB,JMAXB,KMAXB)
      REAL SUM9(IMAXB,JMAXB,KMAXB)
      REAL SUMWTSAVE(IMAXB,JMAXB,KMAXB)
      REAL SUM10(IMAXB,JMAXB,KMAXB),SUM11(IMAXB,JMAXB,KMAXB)
      REAL SUM12(IMAXB,JMAXB,KMAXB),SUM13(IMAXB,JMAXB,KMAXB)
      REAL SUMDBZ(IMAXB,JMAXB,KMAXB),SUMDB(IMAXB,JMAXB,KMAXB)
      REAL XWSAVE(IMAXB,JMAXB,KMAXB),YWSAVE(IMAXB,JMAXB,KMAXB)
      REAL ZWSAVE(IMAXB,JMAXB,KMAXB)
      REAL U(IMAXB,JMAXB,KMAXB),V(IMAXB,JMAXB,KMAXB)
      REAL W(IMAXB,JMAXB,KMAXB),UTEST(IMAXB,JMAXB,KMAXB)
      REAL VTEST(IMAXB,JMAXB,KMAXB),WTEST(IMAXB,JMAXB,KMAXB)
      CHARACTER*80 OSUMFILENAME(80)
C
C ... DESCRIPTION OF ARGUMENTS
C
C     IMAXB,JMAXB,KMAXB    - RADIAL,AZI,VERTICAL ARRAY DIMENSION
C     KMAX2                -
C     SUM1-13              - SUMS OF PRODUCTS ACCUMULATED DURING INTERP. PROCESS
C     INDEX4               -
C     OSUMFILENAME         -
C     NFILE                -
C     SUMWTSAVE            - ACCUMULATED WEIGHT AT GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN
C     SUMDBZ               - WEIGHTED AVG. REFLECTIVITY AT GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN
C     SUMDB                -
C     X/Y/ZWEIGHT          -
C     XACC,YACC,ZACC       - MAX ALLOWED RADIAL,AZI,VERTICAL DIST. BETWEEN AVG. OBS POS. AND GRID POINT
C     IVRTEST              -
C     SINTOL               - SIN OF MAX ALLOWED DOPPLER RADIAL ANGLE FROM HORIZ.
C     ISETZERO             -
C     U,V,W                -
C     (U,V,W)TEST          - WEIGHTED AVG. R,THETA,Z DIST. BETWEEN DATUM AND GRIDPOINT
C
C     SPECIFICATIONS FOR LOCAL VARIABLES 
C 
      INTEGER I,J,K
      REAL SINMIN
C
C ... DESCRIPTION OF VARIABLES PASSED BETWEEN SUBROUTINES
C 
C **** READABCD
C
C      LUW                 -
C      X/Y/Z/WSAVE         -
C
C     SIN OF MINIMUM ANGULAR SEPARATION REQUIRED BETWEEN FORE AND AFT (AVERAGE) BEAMS 
C 
      SINMIN=SIN(10.*3.14159/180.)
C 
      write(6,*)'kmax2 = ',kmax2
C 
      write(6,*)'Out to what radial grid point should you set to zero?' 
      ISETZERO=0
C 
      DO K=1,KMAXB
       DO J=1,JMAXB
        DO I=1,IMAXB
         INDEX1(I,J,K)=0
         SUMWTSAVE(I,J,K)=0.
        ENDDO
       ENDDO
      ENDDO
C 
      LUW=95
C
C ... READ IN THE DIRECTION COSINE INFO, ETC. FROM SUMFILES
C 
      DO NF=1,NFILE
C 
       OPEN(LUW,FILE=OSUMFILENAME(NF),FORM='UNFORMATTED')
C 
       CALL READABCD(LUW,IMAXB,JMAXB,KMAXB,SUM1,SUM2,SUM3,SUM4,
     +  SUM5,SUM6,SUM7,SUM8,SUM9,SUM10,SUM11,SUM12,SUM13,SUMDB,
     +  KMAX2,XWSAVE,YWSAVE,ZWSAVE)
C 
C      OF INTEREST BELOW ARE THE FOLLOWING SUM MATRICES:
C
C      SUM3   = DELTA_IJKM1*BETAI_IJKM1*BETAI_IJKM1
C      SUM5   = DELTA_IJKM1*ALPHAI_IJKM1*ALPHAI_IJKM1
C      SUM8   = DELTA_IJKM1*GAMMA_M1*GAMMA_M1
C      SUM10  = DELTA_IJKM1*ALPHAI_IJKM1
C      SUM11  = DELTA_IJKM1*BETAI_IJKM1
C      SUM12  = DELTA_IJKM1*GAMMA_M1
C      SUMDB  = DELTA_IJKM1*DBZ_IJKM1
C      SUMDBZ = (SET TO NEGATIVE FLAG IN MAIN PROGRAM)
C
C      WHERE DELTA_IJKM1 IS WEIGHT OF FORE DOPPLER OBS M1 AT GRIDPOINT IJK 
C                       
C           ALPHA_M1 = SIN(TAU_M1)
C           BETA_M1  = COS(PHI_M1)*COS(TAU_M1)
C           GAMMA_M1 = SIN(PHI_M1)*COS(TAU_M1)
C
C           ALPHAI_IJKM1 = COS(PHI_IJK)*SIN(TAU_M1) + SIN(PHI_IJK)*COS(PHI_M1)*COS(TAU_M1)
C           BETAI_IJKM1  = -SIN(PHI_IJK)*SIN(TAU_M1) + COS(PHI_IJK)*COS(PHI_M1)*COS(TAU_M1)
C
C           WHERE PHI_M1 AND TAU_M1 ARE EARTH-RELATIVE FORE DOPPLER AZIMUTH AND ELEVATION ANGLES, RESPECTIVELY
C                 PHI_IJK IS THE AZIMUTHAL ANGLE OF GRIDPOINT ABOUT THE GRID ORIGIN (X-AXIS IS ZERO)
C     
C      LOOP OVER ALL POLAR GRIDPOINTS
C 
       DO K=1,KMAX2
        DO J=1,JMAXB
         DO I=1,IMAXB
C 
C         IF THE FIRST SUMFILE, THEN INITIALIZE VELOCITY TO ZERO 
C 
          IF(NF.EQ.1)THEN
           UTEST(I,J,K)=0. 
           VTEST(I,J,K)=0.
           WTEST(I,J,K)=0.
           U(I,J,K)=0.
           V(I,J,K)=0.
           W(I,J,K)=0.
          ENDIF
C 
C         IF SOME DOPPLER VELOCITY EXISTED WITHIN THE INFLUENCE DOMAIN, THE AVERAGE POINTING DIRECTION
C         HAS AN ELEVATION WITHIN THE ELEVATION TOLERANCE (90 DEG), THE RADIAL,AZI,VERTICAL 
C         DIST. BETWEEN AVG. OBS POS. AND GRID POINT IS LESS THAN ACCEPTABLE VALUE, AND ARE BEYOND 
C         RADIUS WITHIN WHICH VELOCITY IS SET TO ZERO (DEFAULT RADIUS OF ZERO), THEN CONTINUE...
C 
C         NOT SATISFIED --> SINTEST=0
C   
          IF((SUM3(I,J,K).EQ.0.AND.SUM5(I,J,K).EQ.0.AND.
     +     SUM8(I,J,K).EQ.0.).OR.
     +      ABS(SUM12(I,J,K)).GT.SINTOL.OR.
     +      ABS(XWSAVE(I,J,K)).GT.XACC.OR.
     +      ABS(YWSAVE(I,J,K)).GT.YACC.OR.
     +      ABS(ZWSAVE(I,J,K)).GT.ZACC.OR.
     +      ISETZERO.GE.I)THEN
           SINTEST=0.
C
C         SECOND SUMFILE
C 
C         RLENGTH12 IS THE SUM OF THE SQUARES OF THE DIRECTION COSINES FROM FIRST SUMFILE
C         RLENGTH22 IS THE SUM OF THE SQUARES OF THE DIRECTION COSINES FROM SECOND SUMFILE
C 
          ELSEIF(NF.EQ.2)THEN
           RLENGTH12=UTEST(I,J,K)*UTEST(I,J,K)+
     +      VTEST(I,J,K)*VTEST(I,J,K)+WTEST(I,J,K)*WTEST(I,J,K)
           RLENGTH22=SUM10(I,J,K)**2.+SUM11(I,J,K)**2.+SUM12(I,J,K)**2.
           IF(RLENGTH12.GT.0..AND.RLENGTH22.GT.0.)THEN
            RLENGTH1=SQRT(RLENGTH12)
            RLENGTH2=SQRT(RLENGTH22)
            U1=UTEST(I,J,K)/RLENGTH1
            V1=VTEST(I,J,K)/RLENGTH1
            W1=WTEST(I,J,K)/RLENGTH1
            U2=SUM10(I,J,K)/RLENGTH2
            V2=SUM11(I,J,K)/RLENGTH2
            W2=SUM12(I,J,K)/RLENGTH2
            UX=V1*W2-W1*V2
            VX=W1*U2-U1*W2
            WX=U1*V2-V1*U2
            UVW2=UX*UX+VX*VX+WX*WX
            RLENGTH=SQRT(UVW2)
            SINTEST=RLENGTH
           ELSE
            SINTEST=0.
           ENDIF
C
C         FIRST SUMFILE: ASSIGN DIRECTION COSINES SQUARED (SUM5,3,8) AND DIRECTION 
C         COSINES (SUM10,11,12) TO (U,V,W) AND (U,V,W)TEST MATRICES, RESPECTIVELY
C 
          ELSEIF(NF.EQ.1)THEN
           U(I,J,K)=U(I,J,K)+SUM5(I,J,K)
           V(I,J,K)=V(I,J,K)+SUM3(I,J,K)
           W(I,J,K)=W(I,J,K)+SUM8(I,J,K)
           UTEST(I,J,K)=UTEST(I,J,K)+SUM10(I,J,K)
           VTEST(I,J,K)=VTEST(I,J,K)+SUM11(I,J,K)
           WTEST(I,J,K)=WTEST(I,J,K)+SUM12(I,J,K)
C 
          ENDIF
C 
C         IF REACHED THE SECOND SUMFILE (BY DEFAULT, THE LAST ONE), SET INDEX1 TO THE
C         MAXIMUM NUMBER OF RADARS REQUIRED FOR SOLUTION (BY DEFAULT, TWO) WHEN
C         THE ANGULAR SEPARATION BETWEEN AVERAGE POINTING DIRECTIONS FOR FORE AND 
C         AFT MEASUREMENTS EXCEEDS THE THRESHOLD. OTHERWISE INDEX1 IS FLAGGED WITH
C         ZERO VALUE.
C 
          IF(NF.EQ.2)THEN
           IF(SINTEST.GT.SINMIN)THEN
            INDEX1(I,J,K)=IVRTEST
           ELSE
            INDEX1(I,J,K)=0
           ENDIF
          ENDIF
C 
C         IF THE AVERAGE REFLECTIVITY IS NOT FLAGGED, THEN POPULATE SUMDBZ WITH
C         THE VALUES STORED IN SUMDB. CAP THE VALUE OF AVERAGE REFLECTIVITY AT 75 DBZ.
C 
          IF(SUMDB(I,J,K).GT.SUMDBZ(I,J,K))SUMDBZ(I,J,K)=SUMDB(I,J,K)
          IF(SUMDBZ(I,J,K).GT.75.)SUMDBZ(I,J,K)=75.
C 
         ENDDO
        ENDDO
       ENDDO
C 
C      END LOOP OVER GRIDPOINTS
C 
       CLOSE(LUW)
C 
      ENDDO
C
C     END LOOP OVER SUMFILES
C 
C     IF THE ANGULAR SEPARATION TEST IS NOT MET FOR TWO RADAR LOOKS, OR ONLY ONE RADAR
C     LOOK IS AVAILABLE (OR NO RADAR LOOKS ARE PRESENT), THEN INDEX1 IS FLAGGED WITH
C     ZERO VALUE. OTHERWISE INDEX1 IS REASSIGNED A VALUE OF ONE.
C 
      DO K=1,KMAXB
       DO J=1,JMAXB
        DO I=1,IMAXB
         IF(INDEX1(I,J,K).GE.IVRTEST)THEN
          INDEX1(I,J,K)=1
         ELSEIF(INDEX1(I,J,K).GT.0)THEN
          INDEX1(I,J,K)=0
         ELSE
          INDEX1(I,J,K)=0
         ENDIF
        ENDDO
       ENDDO
      ENDDO
C 
      RETURN
      END

