      SUBROUTINE DCOMPRESS1(RADARID,IBUF,Z,V,W)
C 
C   This subroutine inserts runs of zeros and unpacks the radar data.   
C All radar data is compressed before it is written to tape.  The data below
C a specified threshold value is set to zero by the signal processor. 
C The compression algorithm is word based.  Runs of less than 3 zeros 
C are not removed, they are treated as data.  The data field starts with a  
C compression code value.  The code either indicates the number of zeros
C that were skipped, or it indicates the number of packed data words which
C follow.  In the case of a zero skipped code, it is immediately followed 
C with another code value.  In the case of a data code, the next code 
C follows the data. 
C        CODE:       # OF POINTS: 
C        Bit 15      Bit 0 thru 14     Meaning
C        ------      -------------     -------
C          0             0             unused (there are none 0 skipped zeros)
C          0             1             end of ray 
C          0             2             unused (2 zeros are treated as data) 
C          0          3-32767          3 to 32767 zeros skipped 
C          1             0             unused (none 0 data words follow)
C          1          1-32767          1 to 32767 data words follow 
C 
C RADARID - contains a code that determines which type of data was recorded.
C           The code is as follows: 
C           bit 15 is on if the ray contains dbZ's
C           bit 14 is on if the ray contains velocities 
C           bit 13 is on if the ray contains spectral width 
C IBUF - integer array containing the packed and compressed radar data. 
C Z - integer array that returns unpacked and uncorrected Reflectivities. 
C V - integer array that returns unpacked and uncorrected velocities. 
C W - integer array that returns unpacked and uncorrected spectral width. 
C 
      IMPLICIT INTEGER(A-Z) 
      INTEGER*2 IBUF(*)
      LOGICAL REF, VEL, WID 
      DIMENSION Z(512), V(512), W(512), IBIN(1536) 
C 
      REF=.FALSE. 
      VEL=.FALSE. 
      WID=.FALSE. 
      MAX=0 
      CODE=0
      BPR= 0      !bytes per range bins 
      DO I=1, 512 !clear all bin arrays 
         Z(I)=0 
         V(I)=0 
         W(I)=0 
      END DO
C The fortran function ibits(a,b,c) extracts a subfield of c bits in
C length from a starting with position b and extending left c bits. 
C The subroutine unpk8(ibuf,ibin,max) unpacks data stored 2 values per
C 16 bit word in (ibuf) which is (max) words long and return them in  
C (ibin) which must be 2*max long.
C Determine which radar was recorded and initialize several variables.
      IF (IBITS(RADARID,15,1) .EQ. 1) THEN
         REF= .TRUE.    !reflectivity data was recorded 
         BPR= BPR + 1   !bytes per range is equal to 1
         IZ= 1          !reflectivity pointer in the ibuf array 
         ZCOUNT= 0      !counter for the reflectivity bins
      ENDIF 
      IF (IBITS(RADARID,14,1) .EQ. 1) THEN
         VEL= .TRUE.    !velocities were recorded 
         BPR = BPR + 1  !bytes per range bins equals 2
         IV= 2          !velocity pointer in the ibuf array 
         VCOUNT= 0      !counter for the doppler bins 
      ENDIF 
      IF (IBITS(RADARID,13,1) .EQ. 1) THEN
         WID= .TRUE.    !spectral width was recorded
         BPR= BPR + 1   !bytes per range bins equals 3
         IW= 3          !spectral w. pointer in the ibuf array
         WCOUNT= 0      !counter for the spectral width bins
      ENDIF 
C Start unpacking the data
      J= 0
100   J= (J+MAX*CODE) + 1 
C Decode the compression code value 
      CODE= IBITS(IBUF(J),15,1) !0=zeros, 1=data
      MAX= IBITS(IBUF(J),0,15)  !# of zeros skipped or # of data words follows
      MAXDATA= MAX*2            !total # of skipped zeros & unpacked words
      IF (MAXDATA .GT. 1536) THEN 
         WRITE(6,'("more than 1536 data words;increase array size.")')
         RETURN 
      ENDIF 
      IF (CODE .EQ. 0) THEN 
         IF (MAX .EQ. 1) RETURN       !end of ray 
         DO I= 1, MAXDATA 
            IBIN(I)= 0
         END DO 
         NUMDATA= 1             !zero counter 
      ELSE
         CALL UNPK81(IBUF(J+1),IBIN,MAX)  !ibin= unpacked data 
         NUMDATA= 1                      !data counter
      ENDIF 
C 
C fill reflectivity, velocity and spectral width arrays.
c      WRITE(6,*)'BPR,MAXDATA,ZCOUNT = ',BPR,MAXDATA,ZCOUNT
c      WRITE(6,*)'ZCOUNT,VCOUNT,WCOUNT = ',ZCOUNT,VCOUNT,WCOUNT
c      ZTEST=ZCOUNT+VCOUNT+WCOUNT+MAXDATA
c      IF(ZTEST.GT.1536)PAUSE
      DO WHILE (NUMDATA .LE. MAXDATA) 
         IF (REF .AND. (IZ.LE.MAXDATA)) THEN
            ZCOUNT= ZCOUNT + 1
C            IF(ZCOUNT.GT.512)THEN
C             WRITE(6,*)'ZCOUNT,NUMDATA = ',ZCOUNT,NUMDATA
C             PAUSE
C            ENDIF
            IF(ZCOUNT.LE.512)Z(ZCOUNT)= IBIN(IZ)       !IZ is the refl. pointer in the array.
            IZ= IZ + BPR
            NUMDATA= NUMDATA + 1
         ENDIF
         IF (VEL .AND. (IV.LE.MAXDATA)) THEN
            VCOUNT= VCOUNT + 1
            IF(VCOUNT.LE.512)V(VCOUNT)= IBIN(IV)       !IV velocity pointer. 
            IV= IV + BPR
            NUMDATA= NUMDATA + 1
         ENDIF
         IF (WID .AND. (IW.LE.MAXDATA)) THEN
            WCOUNT= WCOUNT + 1
            IF(WCOUNT.LE.512)W(WCOUNT)= IBIN(IW) 
            IW= IW + BPR
            NUMDATA= NUMDATA + 1
         ENDIF
      END DO
      IF (REF) IZ= IZ - MAXDATA 
      IF (VEL) IV= IV - MAXDATA 
      IF (WID) IW= IW - MAXDATA 
      GO TO 100 
      END 
      

