      SUBROUTINE ABCD(U,V,W,
     1   RHMAX,RZMAXIN,EHMAX,EZMAX,XACC,YACC,ZACC,NF,NFILE,
     2   SUM1,SUM2,SUM3,SUM4,SUM5,SUM6,SUM7,SUM8,SUM9,
     2   SUM10,SUM11,SUM12,SUM13,EVRCOR,
     3   SUMWEIGHT,TOLERANCE,KMIN2,KMAX2,
     4   SINTOL,SXB,SYB,SZB,XZB,YZB,ZZB,
     5   ROTB,IMAXB,JMAXB,KMAXB,SUMDBZ,
     6   BETATEST,SUMWTSAVE,XWSAVE,YWSAVE,ZWSAVE,UNEW,IGUESS,FACTR,
     7   ICONTINUITY,IVWIND,FACTZ,IREADABCD,OLAT,OLON,LUSCAN,
     9   IRSW,HB1,DPB1,HB2,DPB2,SLOPE1,IFFILTER,CENTIME,TSTART,TEND,
     1   SMOTIONU,SMOTIONV,FLIGHTID,RDEL,DBZTEST,RRRR,ZLOW,ZHIGH,INDEX1,
     1   UG,VG,WG,IREVERSE,IRAMSFILES,XSHIFT,YSHIFT,IECHO,
     1   DISTXYZ,CHARV,CHARDBZ,LINUXYES,IW0,ICRESS,TATF,
     1   RRMAX,RTMAX,ERMAX,ETMAX,RADIUS2,THETA2,IGRAPHICS)
C
C     MAIN SUBROUTINE OF PROGRAM LEASTWIND (DNEWBIG_INTERPOLATE_AUTO_GUESS_XYRT_VAR.F)
C       
C ... FUNCTION:   
C       
C     THIS SUBROUTINE CALLS THE DATA-READING AND QUALITY-CONTROL ROUTINE (SWEEPIN).
C     THE ULTIMATE OBJECTIVE HERE IS TO PRODUCE A FILE (ANGTEST.TXT) CONTAINING
C     ANGLE CORRECTIONS BASED UPON GIVEN FLIGHT-LEVEL AND RADAR DATA. THESE 
C     CORRECTIONS ARE READ INTO A JOBFILE IN OTHER CODE.
C
C ... ABCD SUBPROGRAM REFERENCES:      
C       
C          NON-GRAPHICS     READWIND (IF USING GUESS WIND FIELD)
C                           SWEEPIN, READRAMFILE (PRESENTLY NOT USED), VRLOCATE
C
C          GRAPHICS         RASX_OPEN_WINDOW, SOLO_CONVT, SHOW_IZ
C 
C ... IMPORTANT FLAGS: <()> INDICATES DEFAULT
C          
C          IGRAPHICS      USE GRAPHICS (0) NO (1) YES
C          IJTEST         AZI-COVERAGE (0) SECTOR <(1)> FULL (AKA IACROSS)
C          IGUESS         USE A GUESS WIND FIELD <(0)> NO (1) YES (AKA IUSEWIND)
C          IREVERSE       REVERSE SIGN OF DOPPLER VR <(0)> NO (1) YES
C          IREADABCD      READ IN SUMFILE <(0)> NO (1) YES
C          IVSPEED        USE CONST. AZI ADV. <(0)> NO (1) YES
C          IRAMSFILES     USE RAMSFILE <(0)> NO (1) YES
C          ICLSWP         SWITCH FROM (0) TO (1) UPON CALLING SWEEPIN ONCE
C          IBEGIN         SWITCH FROM (0) TO (1) WHEN ANGLE PROJ SUM BEGINS
C          ILATERSWEEP    ASSIGNED (1) WITHIN SWEEPIN
C      
C     VERSION:  <TBD>
C       
C     CODE WRITTEN BY:  JOHN GAMACHE   
C                       HRD/AOML/NOAA          
C                       MIAMI, FL 33149      
C       
C     FOR ADDITIONAL DETAILS ON THE ALGORITHM SEE <TBD>
C       
C     BASED ON THEORY BY:  <TBD>
C       
C     REFERENCE THE BOOK:  <TBD>
C       
C     **************************************************  
C     *               IMPORTANT NOTE                   *  
C     *                                                *  
C     *                    <TBD>                       *  
C     *                                                *  
C     **************************************************         
C
C     SPECIFICATIONS FOR ARGUMENTS
C 
      REAL THETA2(IMAXB,JMAXB,KMAXB),RADIUS2(IMAXB,JMAXB,KMAXB)
      CHARACTER FLIGHTID*8, CHARV*2, CHARDBZ*2
      REAL SLOPETESTSUM(2),RDELSUM(2)
      REAL SUMWTSAVE(IMAXB,JMAXB,KMAXB,2),ANGTESTSUM(2)
      REAL XWSAVE(IMAXB,JMAXB,KMAXB,2)
      REAL YWSAVE(IMAXB,JMAXB,KMAXB,2),ZWSAVE(IMAXB,JMAXB,KMAXB,2)
      REAL U(IMAXB,JMAXB,KMAXB,2),V(IMAXB,JMAXB,KMAXB,2)
      REAL W(IMAXB,JMAXB,KMAXB,2),SUMDBZ(IMAXB,JMAXB,KMAXB,2)
      REAL VR(512),RANGE(512),DBZ(512),XR(512),YR(512),ZR(512)
      REAL SUM1(IMAXB,JMAXB,KMAXB,2),SUM2(IMAXB,JMAXB,KMAXB,2)
      REAL SUM3(IMAXB,JMAXB,KMAXB,2),SUM4(IMAXB,JMAXB,KMAXB,2)
      REAL SUM5(IMAXB,JMAXB,KMAXB,2),SUM6(IMAXB,JMAXB,KMAXB,2)
      REAL SUM7(IMAXB,JMAXB,KMAXB,2),SUM8(IMAXB,JMAXB,KMAXB,2)
      REAL SUM9(IMAXB,JMAXB,KMAXB,2),SUM10(IMAXB,JMAXB,KMAXB,2)
      REAL SUM11(IMAXB,JMAXB,KMAXB,2),SUM12(IMAXB,JMAXB,KMAXB,2)
      REAL SUM13(IMAXB,JMAXB,KMAXB,2)
      REAL RHOK(100),WGT(200)
      REAL DISTXYZ(IMAXB,JMAXB,KMAXB,2,2,2,2)
      REAL VRSWP(512,800),REFSWP(512,800),VRRAD(512,800)
      REAL RDTAI(512),AZ_EL(2,800),EAZM(800),EEV(800)
      REAL VNYQ(512,800),PELEV(800)
      REAL UG(IMAXB,JMAXB,KMAXB),VG(IMAXB,JMAXB,KMAXB)
      REAL WG(IMAXB,JMAXB,KMAXB)
      INTEGER JINDEX(512,800),JIINDEX(512,800)
      REAL TMP1(512,800),TMP2(512,800),UNFVEL(512,800)
      REAL SWEEPSAVE(512,800)
      REAL TMSWEEP(800),RRLAT(800),RRLON(800),RRA(800)
      REAL SUMMER(200,200,100,2)
      CHARACTER*2 TATF(80),TAF
      INTEGER INDEX1(IMAXB,JMAXB,KMAXB,2),NUMANGTEST(2)
      INTEGER NUMSLOPETEST(2),NUMRDEL(2),NSWEEPSUMS(20)
      INTEGER NS(3)
      REAL SWEEPTESTS(20),SWEEPTESTS2(20),SWEEPZTEST(20)
      REAL SWEEPZTEST2(20)
      REAL XSHIFT(80),YSHIFT(80)
C
C ... DESCRIPTION OF ARGUMENTS
C
C     RRMAX,RTMAX,RZMAX    - RADIAL,AZI,VERTICAL SCALE OF INFLUENCE (KM,DEG,KM)
C     ERMAX,ETMAX,EZMAX    - RADIAL,AZI,VERTICAL E-FOLDING DISTANCE (KM,DEG,KM)
C     XACC,YACC,ZACC       - MAX ALLOWED RADIAL,AZI,VERTICAL DIST. BETWEEN AVG. OBS POS. AND GRIDPOINT
C     NF                   - FILE NO.
C     SUM1-13              - SUMS OF PRODUCTS ACCUMULATED DURING INTERP. PROCESS
C     KMIN2,KMAX2          - TYPICALLY MIN AND MAX VERTICAL LEVEL NO.
C     SINTOL               - SIN OF MAX ALLOWED DOPPLER RADIAL ANGLE FROM HORIZ.
C     SRB,STHETAB,SZB      - RADIAL,AZI,VERTICAL GRID SPACING (KM,DEG,KM)
C     RZB,THETAZB,ZZB      - MIN RADIUS,AZI,HEIGHT (KM,DEG,KM)
C     ROTB                 - COORD. ROTATION (ALWAYS ZERO IN CYL COORDS)
C     IMAXB,JMAXB,KMAXB    - RADIAL,AZI,VERTICAL ARRAY DIMENSION
C     SUMDBZ               - WEIGHTED AVG. REFLECTIVITY AT GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN
C     SUMWTSAVE            - ACCUMULATED WEIGHT AT GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN
C     XWSAVE,YWSAVE,ZWSAVE - WEIGHTED AVG. R,THETA,Z DIST. BETWEEN DATUM AND GRIDPOINT
C     OLAT,OLON            - LAT,LON OF GRID ORIGIN (STORM CENTER)
C     SLOPE1               - REFLECTIVITY SLOPE CORRECTION FACTOR SET TO ONE
C     CENTIME              - ANALYSIS TIME (S)
C     TSTART,TEND          - SEE STIME,ETIME
C     SMOTIONU,SMOTIONV    - STORM MOTION (M/S)
C     FLIGHTID             - FLIGHT NAME
C     DBZTEST              - MIN DBZ TO INCLUDE
C     RRRR                 - MIN RANGE TO INCLUDE
C     UGUESS,VGUESS,WGUESS - GUESS RADIAL, TANGENTIAL, AND VERTICAL WIND (ZERO, M/S)
C     DISTXYZ              - DISTANCE OF THE CLOSEST OBS THAT WAS INTERP. TO GRIDPOINT (I,J,K)
C     PIMAX                - MAX AZI ANGLE FOR OBS TO BE INCLUDED IN WT AVG
C     VSPEED0              - CONST. ADV. SPEED USED IN COMPOSITING (M/S)
C     VFACTOR              - FACTOR MULT. WIND SPEED TO USE IN COMPOSITING (M/S)
C     TATF                 - IDENTIFY SCAN TYPE 
C
C     SPECIFICATIONS FOR LOCAL VARIABLES
C
C **** GRAPHICS
C 

C
C **** REMAINING
C 

C
C ... DESCRIPTION OF VARIABLES PASSED BETWEEN SUBROUTINES
C 
C **** SWEEPIN
C
C     VRSWP(GATE,RAY)     - DOPPLER RADIAL VELOCITY FOR GIVEN GATE AND RADIAL (M/S)
C     REFSWP(GATE,RAY)    - REFLECTIVITY FOR GIVEN GATE AND RADIAL (DBZ)
C     MAX_GATES           - MAX NO. OF GATES STORED FOR EACH RADIAL
C     MAX_RAYS            - MAX NO. OF RADIALS EXPECTED IN A FULL SWEEP
C     NUM_RAYS            - RADIAL COUNTER
C     RDTAI(GATE)         - ??
C     AZ_EL(1/2,RAY)      - 1/2 RAW AZIMUTH/ELEVATION ANGLE FOR GIVEN RADIAL (AIRCRAFT RELATIVE, DEG)
C     NRECORD             - NUMBER OF RECORDS (APPEARS TO BE 1)
C     VRRAD(GATE,RAY)     - ??     
C     UNFVEL(GATE,RAY)    - NOT USED
C     TMP1(GATE,RAY)      - NOT USED
C     TMP2(GATE,RAY)      - NOT USED
C     JINDEX(GATE,RAY)    - NOT USED
C     JIINDEX(GATE,RAY)   - NOT USED    
C     VNYQ(GATE,RAY)      - ASSIGNED A VALUE IN SWEEPIN, BUT NOT USED
C     SWEEPSAVE(GATE,RAY) - ASSIGNED A VALUE IN SWEEPIN, BUT NOT USED
C     UG,VG,WG            - GUESS WIND FIELD (TYPICALLY ZERO)
C     IMXG,JMXG,KMXG      - GUESS WIND RADIAL,AZI,VERTICAL ARRAY DIMENSION
C     SXG,SYG,SZG         - GUESS WIND RADIAL,AZI,VERTICAL GRID SPACING (KM,DEG,KM)
C     OLATG,OLONG         - GUESS WIND LAT,LON OF GRID ORIGIN
C     XZG,YZG,ZZG         - GUESS WIND MIN RADIUS,AZI,HEIGHT (KM,DEG,KM)
C     EAZM(RAY)           - AZIMUTH ANGLE FOR GIVEN RADIAL (EARTH RELATIVE, DEG)
C     EEV(RAY)            - ELEVATION ANGLE FOR GIVEN RADIAL (EARTH RELATIVE, DEG)
C     TMSWEEP(RAY)        - TIME OF EACH RADIAL (S)
C     RRLAT,RRLON(RAY)    - RADAR LAT,LON FOR GIVEN RADIAL
C     RRA(RAY)            - RADAR ALTITUDE FOR GIVEN RADIAL
C     PELEV(RAY)          - ELEVATION ANGLE (AIRCRAFT RELATIVE, DEG)
C     NTASWEEP            - ??
C     RDWS(RAY)           - FLIGHT-LEVEL WIND SPEED FOR GIVEN RADIAL (M/S)
C     RDWD(RAY)           - FLIGHT-LEVEL WIND DIRECTION FOR GIVEN RADIAL (DEG)
C     RDVWS(RAY)          - FLIGHT-LEVEL VERTICAL WIND SPEED FOR GIVEN RADIAL (M/S)
C     NBINS               - ??
C
C **** READRAMFILE
C
C     TIMES               - TIME OF GIVEN RADIAL (S) 
C     TIME_RAM            - ??
C     RLAT,RLON           - RADAR LAT,LON FOR GIVEN RADIAL
C     DM1-7               - ??
C     IOS                 - ??
C
C **** VRLOCATE
C
C     RALT                - RADAR ALTITUDE FOR GIVEN RADIAL
C     ELEV                - ELEVATION ANGLE FOR GIVEN RADIAL (EARTH RELATIVE, DEG)
C     AZIM                - AZIMUTH ANGLE FOR GIVEN RADIAL (EARTH RELATIVE, DEG)
C     RANGE               - GATE RANGE FOR GIVEN RADIAL
C     XR,YR,ZR            - (X,Y,Z) DISTANCE OF DATUM FROM GRID ORIGIN (KM)
C     ISCANDIM            - RANGE GATE DIMENSION OF ARRAYS 
C     XSHFT,YSHFT         - ZERO BY DEFAULT IN R-THETA INTERPOLATION
C     RAD                 - DISTANCE OF DATUM FROM GRID ORIGIN (KM)
C     THETA               - ANGLE DATUM MAKES WITH POSITIVE X AXIS
C     ISCANMAX            - MAX NUMBER OF GATES INCLUDED
C 
      FLAG=-1.0E+10
      IUSEWIND=IGUESS
C
C     SINCE THIS ROUTINE IS USED AFTER THE BACKGROUND WAVE-0/1 WIND FIELD IS 
C     COMPUTED, CALL TO READWIND IS CARRIED OUT
C 
      IF(IUSEWIND.EQ.1)THEN
       IJKMX=IMAXB*JMAXB*KMAXB
       CALL READWIND(UG,VG,WG,IMXG,JMXG,KMXG,SXG,SYG,SZG,
     +  OLATG,OLONG,XZG,YZG,ZZG,IJKMX,ZLOW,ZHIGH,HB2,DPB2)
       IF(IMXG.NE.IMAXB.OR.JMXG.NE.JMAXB.OR.KMXG.NE.KMAXB)THEN
        WRITE(6,*)'IMXG,IMAXB = ',IMXG,IMAXB
        WRITE(6,*)'JMXG,JMAXB = ',JMXG,JMAXB
        WRITE(6,*)'KMXG,KMAXB = ',KMXG,KMAXB
        WRITE(6,*)'SINCE MASKING IS DONE WITH GUESS FIELD'
        WRITE(6,*)'AND FIELDS DONT MATCH I AM SUSPENDING'
        PAUSE
       ENDIF
      ELSE
       IMXG=IMAXB
       JMXG=JMAXB
       KMXG=KMAXB
       SXG=SXB
       SYG=SYB
       SZG=SZB
       OLATG=OLAT
       OLONG=OLON
       XZG=XZB
       YZG=YZB
       ZZG=ZZB
      ENDIF
C 
      IERR=0
      MAX_GATES=512
      MAX_RAYS=800
C
C     MDIM IS TOTAL NO. OF GRID POINTS IN OUTPUT FIELDS
C 
      MDIM=IMAXB*JMAXB*KMAXB
      WRITE(6,'(A2)')CHARV
      WRITE(6,'(A2)')CHARDBZ
      WRITE(6,*)'MDIM = IMAXB*JMAXB*KMAXB = ',MDIM
C
C     DETERMINE PI TO FULL REAL-VARIABLE RESOLUTION
C 
      PI=2.*ASIN(1.)
      PI2=2.*PI
      DTR=PI/180.
      ICRESS=0
      ISCANDIM=512
      ISCANMAX=128
      IBINS=7
      SXB2=.5*SXB*SXB
      SYB2=.5*SYB*SYB
      SZB2=.5*SZB*SZB
      JBINS=3*IBINS+1
      RDEL=0.
C 
      DO K=1,KMAXB
       DO J=1,JMAXB
        DO I=1,IMAXB
         RADIUS2(I,J,K)=FLAG
         THETA2(I,J,K)=FLAG
        ENDDO
       ENDDO
      ENDDO
C 
      DO L=1,2
       DO K=1,KMAXB
        DO J=1,JMAXB
         DO I=1,IMAXB
          DO KK=1,2
           DO JJ=1,2
            DO II=1,2
             DISTXYZ(I,J,K,L,II,JJ,KK)=1000.
            ENDDO
           ENDDO
          ENDDO
         ENDDO
        ENDDO
       ENDDO
      ENDDO
C 
      DO I=1,JBINS
       RATIOI=(FLOAT(I)/FLOAT(IBINS))**2.
       WGT(I)=EXP(-RATIOI)
      ENDDO
      DO K=1,KMAXB
       HEIGHT=ZZB+(K-1)*SZB
       RHOK(K)=EXP(-HEIGHT*.10437052)
      ENDDO
      ZTOP=(KMAXB-1)*SZB
      RLZ=ZTOP
      RLH=25.*SXB
      UBAR=10.
      DO I=1,256
       A=I
       RANGE(I)=A
       VR(I)=-A
       DBZ(I)=A*2.
      ENDDO
      write(6,*)'entered abcd'
      NS(1)=0
      NS(2)=0
      NS(3)=1
      NSTEP=2
      NSTEP2=1
      MDIM2=IMAXB*JMAXB
      WRITE(6,*)'IMAXB,JMAXB,KMAXB,SXB,SYB,SZB,ROTB'
      WRITE(6,*)IMAXB,JMAXB,KMAXB,SXB,SYB,SZB,ROTB
      WRITE(6,*)'Entered ABCD'
      RRWEIGHT=ERMAX*ERMAX
      RTWEIGHT=ETMAX*ETMAX
      RHWEIGHT=EHMAX*EHMAX
      RZWEIGHT=EZMAX*EZMAX
      RXMAX=RHMAX
      RYMAX=RHMAX
      RZMAX=RZMAXIN
      WRITE(6,*)'EHMAX,EZMAX,RXMAX,RYMAX,RZMAX'
      WRITE(6,*)EHMAX,EZMAX,RXMAX,RYMAX,RZMAX    
      WRITE(6,*)'XACC = ',XACC
      WRITE(6,*)'YACC = ',YACC
      WRITE(6,*)'ZACC = ',ZACC
      TIMER=0.
C 
C     (II,JJ,KK,L) LOOPS (RADIUS,AZI,HEIGHT,FORE/AFT) 
C 
C ... ZERO ALL ANGLE-PROJECTION SUMMATIONS. THIS IS DONE BEFORE LOOPING OVER ALL SWEEPS.
C 
      IF(IREADABCD.NE.1)THEN
       DO L=1,2
        DO KK=KMIN2,KMAX2
         DO JJ=1,JMAXB
          DO II=1,IMAXB
           SUMMER(II,JJ,KK,L)=0
           SUMDBZ(II,JJ,KK,L)=0
           SUMWTSAVE(II,JJ,KK,L)=0
           SUM1(II,JJ,KK,L)=0
           SUM2(II,JJ,KK,L)=0
           SUM3(II,JJ,KK,L)=0
           SUM4(II,JJ,KK,L)=0
           SUM5(II,JJ,KK,L)=0
           SUM6(II,JJ,KK,L)=0
           SUM7(II,JJ,KK,L)=0
           SUM8(II,JJ,KK,L)=0
           SUM9(II,JJ,KK,L)=0
           SUM10(II,JJ,KK,L)=0
           SUM11(II,JJ,KK,L)=0
           SUM12(II,JJ,KK,L)=0
           SUM13(II,JJ,KK,L)=0
           XWSAVE(II,JJ,KK,L)=0
           YWSAVE(II,JJ,KK,L)=0
           ZWSAVE(II,JJ,KK,L)=0
           INDEX1(II,JJ,KK,L)=0
          ENDDO
         ENDDO
        ENDDO
       ENDDO
      ENDIF
C 
      NRECORD=1
      RLATBEFORE=0.
      IBEGIN=0
      ICLSWP=0
C 
C     INITIALIZE CORRECTION-RELATED VARIABLES   
C 
      DO L2=1,2
       NUMANGTEST(L2)=0
       ANGTESTSUM(L2)=0
       ANGTEST=-999.9
       GROUNDSLOPE=-999.9
       NUMSLOPETEST(L2)=0
       SLOPETESTSUM(L2)=0.
       NUMRDEL(L2)=0
       RDELSUM(L2)=0
      ENDDO
C 
      IF(IREADABCD.EQ.1)GO TO 72735
C 
C     ****AFTER EACH SWEEP THE PROGRAM RETURNS HERE UNTIL MAX TIME IS REACHED****
C 
92923 TAF=TATF(NF)
C 
      write(6,*)'iusewind = ',iusewind
C
C ... SWEEPIN READS DATA FROM A TO_FB FILE, CLEANS IT UP, REMOVES THE SURFACE,
C     REMOVES SPECKLES, AND AUTOMATICALLY (BARGEN BROWN) DE-ALIASES THE DATA 
C     IN BOTH SINGLE-RADIAL AND AZIMUTHAL MODES
C 
C     MOST IMPORTANT FUNCTION HERE IS TO COMPUTE ANGTEST, GROUNDSLOPE, AND RDELDIFF    
C 
      CALL SWEEPIN(VRSWP,REFSWP,MAX_RAYS,MAX_GATES,NUM_RAYS,RDTAI,
     + AZ_EL,ICLSWP,NRECORD,VRRAD,UNFVEL,TMP1,TMP2,JINDEX,
     + JIINDEX,VNYQ,ILATERSWEEP,SWEEPSAVE,UG,VG,WG,
     + IMXG,JMXG,KMXG,SXG,SYG,SZG,OLATG,OLONG,XZG,YZG,ZZG,
     + IUSEWIND,EAZM,EEV,TMSWEEP,RRLAT,RRLON,RRA,SMOTIONU,SMOTIONV,
     + CENTIME,PELEV,ISCANMAX,ANGTEST,GROUNDSLOPE,RDELDIFF,
     + NSWEEPSUMS,SWEEPTESTS,SWEEPTESTS2,SWEEPZTEST,SWEEPZTEST2,
     + ZLOW,ZHIGH,HB2,DPB2)
C 
      DO IKJIKJ=1,512
       DO KJIKJ=1,800
        VRSWP(IKJIKJ,KJIKJ)=-888.8
        REFSWP(IKJIKJ,KJIKJ)=-32.
       ENDDO
      ENDDO
C 
      WRITE(6,*)'ANGTEST = ',ANGTEST
C 
      ICLSWP=1
      NR=1
C
C ... SET FIRST ISCANMAX ELEMENTS OF RANGE TO ??
C 
      DO I=1,ISCANMAX
       RANGE(I)=RDTAI(I)
      ENDDO
C 
C     EXECUTE THE CODE BELOW AS LONG AS RAY NUMBER (INITIALLY 1) IS <= MAX RAYS
C     RECALL NR IS THE RAY NO., WHICH IS ADVANCED BELOW 
C 
92924 DO WHILE(NR.LE.NUM_RAYS)
C 
       ELEVTEST=PELEV(NR)
C 
       IF(ELEVTEST.LE.0)THEN
        L2=1
       ELSE
        L2=2
       ENDIF
C 
C      CORRECTIONS ARE PASSED FROM SWEEPIN AND ACCUMULATED HERE FOR FORE AND
C      AFT POINTING DIRECTIONS. IT APPEARS THAT THE SAME VALUE IS ADDED EACH TIME
C      THIS CODE IS REACHED FOR A GIVEN SWEEP. THE VALUE OF ANGTEST IS ONLY 
C      UPDATED WHEN THE NEXT SWEEP IS READ IN (AND SWEEPIN IS CALLED).
C 
       IF(ANGTEST.GT.-900.)THEN
        NUMANGTEST(L2)=NUMANGTEST(L2)+1
        ANGTESTSUM(L2)=ANGTESTSUM(L2)+ANGTEST
       ENDIF
C 
       IF(RDELDIFF.GT.-900.)THEN
        NUMRDEL(L2)=NUMRDEL(L2)+1
        RDELSUM(L2)=RDELSUM(L2)+RDELDIFF
       ENDIF
C 
       IF(GROUNDSLOPE.GT.-900.)THEN
        NUMSLOPETEST(L2)=NUMSLOPETEST(L2)+1
        SLOPETESTSUM(L2)=SLOPETESTSUM(L2)+GROUNDSLOPE
       ENDIF
C      
C      TIMES STORES THE RAY TIME AND AZIM STORES THE EARTH-RELATIVE AZIMUTH ANGLE
C 
       RLATBEFORE=RLAT
       TIMES=TMSWEEP(NR)
       AZIM=EAZM(NR)
C
C ...  SWEEPIN USES MATH ANGLES BUT VRLOCATE WAS BASED UPON USING THE UF FILE 
C      READER WHICH REPORTS BACK IN NAVIGATIONAL COORDINATES. DO A REFLECTION
C      AND CHECK.
C 
       AZIM=90-AZIM
       IF(AZIM.LT.0.)AZIM=AZIM+360.
       IF(AZIM.GT.360.)AZIM=AZIM-360.
C 
       RALT=RRA(NR)
       ELEV=EEV(NR)
       RLAT=RRLAT(NR)
       RLON=RRLON(NR)
C 
       ILIST=0
C 
C ...  FOR GIVEN RADIAL STORE THE FIRST ISCANMAX GATES OF THE QC'D DOPPLER RADIAL 
C      VELOCITY IN VR AND REFLECTIVITY IN DBZ.
C 
       DO I=1,ISCANMAX
        VR(I)=VRSWP(I,NR)
        IF(VR(I).GT.-800..AND.ABS(VR(I)).GT.70.)ILIST=1
        DBZ(I)=REFSWP(I,NR)
       ENDDO
C 
       IF(RLAT.EQ.0.)RLAT=RLATBEFORE
C 
C **** RAMSFILES ARE NOT USED AT PRESENT, SO THIS CODE IS SKIPPED
C 
       IF(IRAMSFILES.EQ.1)THEN
        rlat22=rlat
        rlon22=rlon
        CALL READRAMFILE(TIMES,TIME_RAM,RLAT,RLON,DM1,DM2,DM3,
     *                      DM4,DM5,DM6,DM7,IOS)
       ENDIF
C 
C **** END SKIPPED CODE
C 
C      IF A NEW DAY IS REACHED, THEN ADD 86400 SEC TO THE TIME
C 
       IF(IBEGIN.EQ.1.AND.TIMES.LT.TSTART)TIMES=TIMES+86400.
C
C      EXIT PROCESSING OF RADIALS ONCE END TIME IS REACHED OR UPON ERROR
C 
       IF(TIMES.GT.TEND.OR.IERR.EQ.-1)GO TO 92929
C
C      INITIALLY TIMEOLD EQUALS ZERO, SO THIS CODE IS EXECUTED FIRST TIME.
C      APPEARS TO EXECUTE EVERY TIME.
C      
       IF(TIMES.GT.TIMEOLD)THEN
        ITIMES=TIMES
        IHOURS=TIMES/3600
        IHSECS=IHOURS*3600
        ILEFT=ITIMES-IHSECS
        IMINS=ILEFT/60
        ISECS=ILEFT-60*IMINS
        ITIMESS=IHOURS*10000+IMINS*100+ISECS       
       ENDIF
C 
       TIMEOLD=TIMES
C 
C ...  BEGIN ANGLE SUMMING CODE
C 
       IF(IREADABCD.NE.1.AND.TIMES.GE.TSTART.AND.TIMES.LE.TEND)THEN
C 
C       RDEL APPEARS TO BE ZERO...ALWAYS. RESULT: JJJSTART=2
C 
        JJJSTART=1
        IF(RDEL.LT.0)THEN
         DO JJJ=JJJSTART,ISCANMAX
          RANGE(JJJ)=RANGE(JJJ)+RDEL
          IF(IREVERSE.EQ.1)THEN
c          VR(JJJ)=-VR(JJJ)
         ENDIF
         ENDDO
        ENDIF
C 
        RHIGH=300.
        RLOW=.1
C 
        IBEGIN=1
C 
        XWEIGHT=0
        YWEIGHT=0
        ZWEIGHT=0
        SUMWEIGHT=0
C
C ...   VRLOCATE DETERMINES DATUM LOCATION WITHIN INTERPOLATION GRID
C       RETURNS XR,YR,ZR,RAD,THETA
C 
        CALL VRLOCATE(OLAT,OLON,TIMES,
     +   RLAT,RLON,RALT,ELEV,AZIM,RANGE,XR,YR,ZR,
     +   SMOTIONU,SMOTIONV,ISCANDIM,CENTIME,IBINS,WGT,VR,ISCANMAX)
C 
C       AZIMM IS JUST EARTH-RELATIVE AZIMUTH ANGLE (SINCE ROTB IS ZERO)
C 
        AZIMM=AZIM-ROTB
C 
C ...   COMPUTE DIRECTION COSINES WHICH ARE FUNCTIONS OF EARTH-RELATIVE 
C       RAY ORIENTATION ALONE: ALPHA_M, BETA_M, GAMMA_M
C 
        GAMMA=SIN(ELEV*DTR)
        ALPHA=SIN(AZIMM*DTR)*COS(ELEV*DTR)
        BETA=COS(AZIMM*DTR)*COS(ELEV*DTR)
C 
        ISCANTEST=0
        IF(ILIST.EQ.1)THEN
         WRITE(6,*)'TIMES = ',TIMES
         WRITE(6,*)'RANGE = ',(RANGE(I),I=1,ISCANMAX)
         WRITE(6,*)'VR = ',(VR(I),I=1,ISCANMAX)
        ENDIF
C
C       (I) LOOPS (GATES)
C
C ...   SEE DOCUMENTATION AT BEGINNING OF SUBROUTINE FOR MATHEMATICAL EXPRESSIONS
C       BEING FORMULATED IN CODE BELOW. NUMBERS POINT TO RESPECTIVE EXPRESSIONS.
C 
        DO I=JJJSTART,ISCANMAX
C 
         DBZCHK=-31.99
         ZRCHECK=0.
C 
         RXMAX=RHMAX
         RYMAX=RHMAX 
         RZMAX=RZMAXIN        
C 
         RHO=EXP(-ZR(I)*.10437052)
C 
         XR(I)=XR(I)+XSHIFT(NF)
         YR(I)=YR(I)+YSHIFT(NF)
C 
C        VRVR STORES DOPPLER RADIAL VELOCITY FOR GATE I: VR_M
C 
         VRVR=VR(I)
C 
C        IF DOPPLER RADIAL VELOCITY EXISTS OR REFLECTIVITY IS ABOVE DBZCHK
C        AND THE GATE IS WITHIN THE SPECIFIED RANGE, EXECUTE THE FOLLOWING:
C 
         IF(VR(I).GT.-800..OR.DBZ(I).GT.DBZCHK.AND.
     +     ZR(I).GT.ZRCHECK.AND.ZR(I).GT..075.
     +     AND.RANGE(I).GT.RLOW.AND.RANGE(I).LT.RHIGH)THEN
C 
          IGAMMATEST=1
C 
C         IF EARTH-RELATIVE ELEVATION ANGLE IS <= 90 (DEFAULT), EXECUTE THE FOLLOWING:
C 
          IF(ABS(GAMMA).LE.SINTOL)IGAMMATEST=1
CCC1 
          IF(IGAMMATEST.EQ.1)THEN
CCC1 
           CALL DIFFOBLONG(XR(I),YR(I),ZR(I),
     +      RXMAX,RYMAX,RZMAX,SXB,SYB,SZB,
     +      XZB,YZB,ZZB,IMAXB,JMAXB,KMAXB,
     +      IXMIN,IXMAX,IYMIN,IYMAX,IZMIN,IZMAX,ROTB)
C 
           ICALLED=0
C 
           DO KK=IZMIN,IZMAX
            RHOVRVR=VRVR*RHOK(KK)
            DO JJ=IYMIN,IYMAX
             DO II=IXMIN,IXMAX  
C 
              CALL DIFFDISTXYRT(XR(I),YR(I),ZR(I),
     +        II,JJ,KK,INEAR,JNEAR,KNEAR,
     +        SXB,SYB,SZB,XZB,YZB,ZZB,RX,RY,RZ,ROTB,
     +        DELTHETA,DELRAD,DISTTHETA,
     +        IMAXB,JMAXB,KMAXB,THETA1,RADIUS1,THETA2,RADIUS2,
     +        ICALLED,XBROT,YBROT)
C 
              XX=(FLOAT(II-1)+.5)*SXB-XZB
              YY=(FLOAT(JJ-1)+.5)*SYB-YZB
              ZZ=(KK-1)*SZB+ZZB
              ZZ2=ZZ*2.
C 
              IF(ZZ2.LT.SZB)ZZ2=SZB
C 
C             RX <= 0 DATUM RADIALLY AT OR INSIDE GRIDPOINT --> IA=1
C             RX > 0  DATUM RADIALLY OUTSIDE GRIDPOINT      --> IA=2
C             RY <= 0 DATUM CLOCKWISE FROM GRIDPOINT        --> JA=1
C             RY > 0  DATUM COUNTERCLOCKWISE FROM GRIDPOINT --> JA=2
C             RZ <= 0 DATUM AT OR LOWER THAN GRIDPOINT      --> KA=1
C             RZ > 0  DATUM HIGHER THAN GRIDPOINT           --> KA=2
C 
              IF(RX.LE.0)IA=1
              IF(RX.GT.0)IA=2
              IF(RY.LE.0)JA=1
              IF(RY.GT.0)JA=2
              IF(RZ.LE.0)KA=1
              IF(RZ.GT.0)KA=2
C 
C             RR IS DISTANCE IN CYLINDRICAL COORDINATES BETWEEN DATUM AND GRIDPOINT
C 
              RR=SQRT(RX*RX+RY*RY+RZ*RZ)
C
C ...          IF DISTANCE RR BETWEEN GIVEN DATUM AND GRIDPOINT (II,JJ,KK) IS LESS THAN
C              CURRENT MINIMUM DISTANCE, ASSIGN DISTXYZ FOR GRIDPOINT (II,JJ,KK) THE 
C              VALUE RR. THIS IS DONE SEPARATELY FOR FORE AND AFT SWEEPS (L2=1,2). 
C              THIS IS ALSO DONE SEPARATELY FOR THE 8 DIFFERENT SECTORS (IA,JA,KA=1,2) 
C              ABOUT THE GRIDPOINT.
C 
              IF(RR.LT.DISTXYZ(II,JJ,KK,L2,IA,JA,KA))THEN
               DISTXYZ(II,JJ,KK,L2,IA,JA,KA)=RR
              ENDIF
C 
C             ??? CONDITION
C 
              IF(ABS(DELRAD).LT.RRMAX.AND.ABS(DISTTHETA).LT.RTMAX.AND.
     1           ABS(RZ).LT.RZMAX.AND.ZR(I).LT.ZZ2)THEN
C 
               ABCC=DELRAD**2./RRMAX*2.+DISTTHETA**2./RTMAX**2.+
     1           RZ**2./RZMAX**2.
               ABC=DELRAD*DELRAD/RRWEIGHT+
     1           DISTTHETA*DISTTHETA/RTWEIGHT+RZ*RZ/RZWEIGHT
               ALPHANEW=ALPHA*COS(DELTHETA)-BETA*SIN(DELTHETA)
               BETANEW=ALPHA*SIN(DELTHETA)+BETA*COS(DELTHETA)
C 
               IF(ICRESS.NE.1)THEN
C 
C ...           P=WEIGHT=e^(-((R_D-R_GP)^2/EFOLD_R^2+(T_D-T_GP)^2/EFOLD_THETA^2+(Z_D-Z_GP)^2/EFOLD_Z^2))
C 
                WEIGHT=EXP(-ABC)
                P=WEIGHT
C 
               ELSE
C 
                WEIGHT=1-ABCC
                IF(WEIGHT.LT.0.)WEIGHT=0
                P=WEIGHT
C 
               ENDIF
C 
               SUMWEIGHT=P
C 
C              SLOPE1 IS HARDWIRED TO 1, SO DBZZ STORES DBZ DATUM 
C 
               IF(DBZ(I).GT.-100)THEN
                DBZZ=DBZ(I)*SLOPE1
               ELSE
                DBZZ=-200.
               ENDIF
C
C ...          ZE IS DBZ CONVERTED TO POWER. SUMDBZ IS THE ACCUMULATED WEIGHTED POWER AT 
C              GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN. SUMMER IS THE ACCUMULATED WEIGHT
C              AT GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN. ACCUMULATION OCCURS ONLY IF
C              THE REFELCTIVITY IS NOT FLAGGED.
C 
               ZE=10.**(DBZZ/10.)
               IF(ABS(VR(I)).LT.800.)THEN
                VTEST=1.
               ELSE
                VTEST=0.
               ENDIF
               IF(DBZ(I).GT.DBZCHK)THEN
                SUMDBZ(II,JJ,KK,L2)=
     +          SUMDBZ(II,JJ,KK,L2)+P*ZE
                SUMMER(II,JJ,KK,L2)=SUMMER(II,JJ,KK,L2)+P
               ENDIF
C 
               IF(II.EQ.1000.AND.JJ.EQ.1000)THEN
                WRITE(6,*)'TIMES = ',TIMES
                WRITE(6,*)'ELEV,AZIM,ALPHA,BETA,GAMMA = ',
     +                     ELEV,AZIM,ALPHA,BETA,GAMMA
                WRITE(6,*)'ALPHANEW,BETANEW,GAMMANEW = ',
     +                     ALPHANEW,BETANEW,GAMMANEW
                WRITE(6,*)'VR = ',(VR(IINDEX),IINDEX=1,ISCANMAX)
                WRITE(6,*)'II,JJ,KK,I,ISCANMAX,RANGE,XR,YR,ZR,VR = ',
     +           II,JJ,KK,I,ISCANMAX,RANGE(I),XR(I),YR(I),ZR(I),VR(I)
                PAUSE
               ENDIF
C 
               ISCANTEST=1
C 
C ...          PERFORM WEIGHTED SUMS OF DIRECTION COSINE/VR TERMS. 
C              THE FIRST 9 ARE USED IN THE COST-FUNCTION GRADIENT...
C 
C ...          SUMWTSAVE IS THE ACCUMULATED WEIGHT AT GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN. 
C              ACCUMULATION OCCURS ONLY IF THE DOPPLER RADIAL VELOCITY IS NON-FLAGGED. THIS 
C              VARIABLE IS DISTINGUISHED FROM SUMMER, WHICH IS BASED UPON REFLECTIVITY.
C 
               SUMWTSAVE(II,JJ,KK,L2)=SUMWTSAVE(II,JJ,KK,L2)+P
C
C              (1) 
               SUM1(II,JJ,KK,L2)=
     +         SUM1(II,JJ,KK,L2)+P*ALPHANEW*BETANEW
C
C              RHO*(2)
               SUM2(II,JJ,KK,L2)=
     +         SUM2(II,JJ,KK,L2)+P*BETANEW*RHOVRVR
C
C              (3)
               SUM3(II,JJ,KK,L2)=
     +         SUM3(II,JJ,KK,L2)+P*BETANEW*BETANEW
C
C              RHO*(4)
               SUM4(II,JJ,KK,L2)=
     +         SUM4(II,JJ,KK,L2)+P*ALPHANEW*RHOVRVR
C
C              (5)
               SUM5(II,JJ,KK,L2)=
     +         SUM5(II,JJ,KK,L2)+P*ALPHANEW*ALPHANEW
C
C              (6)
               SUM6(II,JJ,KK,L2)=
     +         SUM6(II,JJ,KK,L2)+P*ALPHANEW*GAMMA
C
C              (7)
               SUM7(II,JJ,KK,L2)=
     +         SUM7(II,JJ,KK,L2)+P*BETANEW*GAMMA
C
C              (8)
               SUM8(II,JJ,KK,L2)=
     +         SUM8(II,JJ,KK,L2)+P*GAMMA*GAMMA
C
C              RHO*(9)
               SUM9(II,JJ,KK,L2)=
     +         SUM9(II,JJ,KK,L2)+P*GAMMA*RHOVRVR
C
C ...          THE REMAINING SUMMATIONS ARE USED IN THE DEFINITION OF THE COST FUNCTION...
C
C              (10)
               SUM10(II,JJ,KK,L2)=
     +         SUM10(II,JJ,KK,L2)+P*ALPHANEW
C
C              (11)
               SUM11(II,JJ,KK,L2)=
     +         SUM11(II,JJ,KK,L2)+P*BETANEW
C
C              (12)
               SUM12(II,JJ,KK,L2)=
     +         SUM12(II,JJ,KK,L2)+P*GAMMA
C
C              RHO*(13) 
               SUM13(II,JJ,KK,L2)=
     +         SUM13(II,JJ,KK,L2)+P*RHOVRVR
C
C ...          X/Y/ZSAVE ARE ACCUMULATED WEIGHTED R, THETA AND Z DISTANCES.
C 
               XWSAVE(II,JJ,KK,L2)=XWSAVE(II,JJ,KK,L2)+P*RX
               YWSAVE(II,JJ,KK,L2)=YWSAVE(II,JJ,KK,L2)+P*RY
               ZWSAVE(II,JJ,KK,L2)=ZWSAVE(II,JJ,KK,L2)+P*RZ
C 
              ENDIF
C 
C             END ??? CONDITION
C 
             ENDDO
            ENDDO
           ENDDO
C
C          END LOOPS OVER RADIUS, AZIMUTH, AND HEIGHT (II,JJ,KK)
CCC1 
          ENDIF
CCC1 
C         END ELEVATION ANGLE CONDITION
C 
         ENDIF
C
C        END VR/DBZ/RANGE CONDITION
C  
        ENDDO
C 
C       END LOOP OVER GATES (I)
C 
       ENDIF
C
C      END CONTRIBUTION TO SUMMATIONS FROM GIVEN RAY
C 
C ...  INCREMENT RAY NUMBER
C 
27272  NR=NR+1
C 
      ENDDO
C 
C     DONE EXECUTING ABOVE CODE FOR EACH RAY (NR) FOR A GIVEN SWEEP 
C 
      GO TO 92923
C 
C     PROGRAM HAS NOW READ IN, QC'D AND INCORPORATED ALL SWEEPS
C 
92929 WRITE(6,*)'JUST FINISHED VR SUMMATION'
C 
      CLOSE(320)
      CLOSE(321)
C 
      IOKAY=1
CCC1 
72735 IF(IOKAY.EQ.1)THEN
CCC1
C      AT THE END OF EACH COMPLETE ITERATION
C
C      L2 = 1 AND 2 REPRESENT FORE AND AFT SUMMATIONS, RESPECTIVELY
C 
       WRITE(6,*)'IN ABCD'
       WRITE(6,*)'SUM1,SUM2,SUM3 = ',
     +  SUM1(20,20,4,1),SUM2(20,20,4,1),SUM3(20,20,4,1),
     +  SUMDBZ(20,20,4,1),SUMWTSAVE(20,20,4,1)
       OPEN(93,FILE='SUMS')
C 
       DO L2=1,2
C
C       (II,JJ,KK) LOOPS (RADIUS,AZI,HEIGHT)
C 
        DO KK=KMIN2,KMAX2
         DO JJ=1,JMAXB
          DO II=1,IMAXB
C
C          IF REFLECTIVITY AND DOPPLER VELOCITY EXIST AT (II,JJ,KK) FOR THE FORE
C          OR AFT SCAN, THE WEIGHTED SUM THERE FOR THE FORE OR AFT SCAN IS NORMALIZED 
C          BY THE ACCUMULATED WEIGHT.
C 
           IF(SUMWTSAVE(II,JJ,KK,L2).GT.0..AND.
     +        SUMMER(II,JJ,KK,L2).GT.0..AND.IMXG.EQ.IMAXB.
     +        AND.JMXG.EQ.JMAXB.AND.KMXG.EQ.KMAXB.AND.
     +        UG(II,JJ,KK).GT.-999.)THEN
C 
            ZE=SUMDBZ(II,JJ,KK,L2)/SUMMER(II,JJ,KK,L2)
C
C           CONVERT AVERAGE POWER TO DBZ
C 
            SUMDBZ(II,JJ,KK,L2)=10.*ALOG10(ZE)
C 
            SUM1(II,JJ,KK,L2)=SUM1(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM2(II,JJ,KK,L2)=SUM2(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM3(II,JJ,KK,L2)=SUM3(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM4(II,JJ,KK,L2)=SUM4(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM5(II,JJ,KK,L2)=SUM5(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM6(II,JJ,KK,L2)=SUM6(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM7(II,JJ,KK,L2)=SUM7(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM8(II,JJ,KK,L2)=SUM8(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM9(II,JJ,KK,L2)=SUM9(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM10(II,JJ,KK,L2)=SUM10(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM11(II,JJ,KK,L2)=SUM11(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM12(II,JJ,KK,L2)=SUM12(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM13(II,JJ,KK,L2)=SUM13(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            XWSAVE(II,JJ,KK,L2)=XWSAVE(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            YWSAVE(II,JJ,KK,L2)=YWSAVE(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            ZWSAVE(II,JJ,KK,L2)=ZWSAVE(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
C 
           ELSEIF(SUMMER(II,JJ,KK,L2).GT.0.)THEN
            ZE=SUMDBZ(II,JJ,KK,L2)/SUMMER(II,JJ,KK,L2)
C
C           CONVERT AVERAGE POWER TO DBZ
C 
            SUMDBZ(II,JJ,KK,L2)=10.*ALOG10(ZE)
            SUMWTSAVE(II,JJ,KK,L2)=0.
            SUM1(II,JJ,KK,L2)=0.
            SUM2(II,JJ,KK,L2)=0.
            SUM3(II,JJ,KK,L2)=0.
            SUM4(II,JJ,KK,L2)=0.
            SUM5(II,JJ,KK,L2)=0.
            SUM6(II,JJ,KK,L2)=0.
            SUM7(II,JJ,KK,L2)=0.
            SUM8(II,JJ,KK,L2)=0.
            SUM9(II,JJ,KK,L2)=0.
            SUM10(II,JJ,KK,L2)=0.
            SUM11(II,JJ,KK,L2)=0.
            SUM12(II,JJ,KK,L2)=0.
            SUM13(II,JJ,KK,L2)=0.
            XWSAVE(II,JJ,KK,L2)=1000.
            YWSAVE(II,JJ,KK,L2)=1000.
            ZWSAVE(II,JJ,KK,L2)=1000.
C 
           ELSE
C 
            SUMWTSAVE(II,JJ,KK,L2)=0.
            SUM1(II,JJ,KK,L2)=0.
            SUM2(II,JJ,KK,L2)=0.
            SUM3(II,JJ,KK,L2)=0.
            SUM4(II,JJ,KK,L2)=0.
            SUM5(II,JJ,KK,L2)=0.
            SUM6(II,JJ,KK,L2)=0.
            SUM7(II,JJ,KK,L2)=0.
            SUM8(II,JJ,KK,L2)=0.
            SUM9(II,JJ,KK,L2)=0.
            SUM10(II,JJ,KK,L2)=0.
            SUM11(II,JJ,KK,L2)=0.
            SUM12(II,JJ,KK,L2)=0.
            SUM13(II,JJ,KK,L2)=0.
            XWSAVE(II,JJ,KK,L2)=1000.
            YWSAVE(II,JJ,KK,L2)=1000.
            ZWSAVE(II,JJ,KK,L2)=1000.
            SUMDBZ(II,JJ,KK,L2)=FLAG
C 
           ENDIF
C 
          ENDDO
C 
          WRITE(93,*)'L2,KK,JJ = ',L2,KK,JJ
          WRITE(93,*)'SUMWTSAVE = '
          WRITE(93,8602)(SUMWTSAVE(II,JJ,KK,L2),II=1,IMAXB)
          WRITE(93,*)'SUMMER = '
          WRITE(93,8602)(SUMMER(II,JJ,KK,L2),II=1,IMAXB)
          WRITE(93,*)'SUM2 = '
          WRITE(93,8602)(SUM3(II,JJ,KK,L2),II=1,IMAXB)
          WRITE(93,*)'SUM4 = '
          WRITE(93,8602)(SUM4(II,JJ,KK,L2),II=1,IMAXB)
          WRITE(93,*)'SUM9 = '
          WRITE(93,8602)(SUM9(II,JJ,KK,L2),II=1,IMAXB)
8602      FORMAT(8E14.4)
C 
         ENDDO
        ENDDO   
C    
       ENDDO
CCC1 
      ENDIF
CCC1 
      CLOSE(93)
C 
      ISUMTEST=0
      IREMOVE=0
C 
      OPEN(94,FILE='windrefstats.txt')
C 
      WRITE(94,*)'NSWEEPSUMS = '
      WRITE(94,8110)(NSWEEPSUMS(I),I=1,20)
8110  FORMAT(8I10)
      WRITE(94,*)'SWEEPTESTS = '
      WRITE(94,6527)(SWEEPTESTS(I),I=1,20)
      WRITE(94,*)'SWEEPZTEST = '
      WRITE(94,6527)(SWEEPZTEST(I),I=1,20)
      WRITE(94,*)'SWEEPTESTS2 = '
      WRITE(94,6527)(SWEEPTESTS2(I),I=1,20)
      WRITE(94,*)'SWEEPZTEST2 = '
      WRITE(94,6527)(SWEEPZTEST2(I),I=1,20)
6527  FORMAT(8F10.3)
C 
      CLOSE(94)
C 
      DO I=1,9
       DIFFRAD2=ABS(SWEEPZTEST2(I+1)-SWEEPZTEST2(I))
       DIFFRAD1=ABS(SWEEPZTEST(I+1)-SWEEPZTEST(I))
       IF((DIFFRAD1.GT.3..AND.DIFFRAD2.GT.3.).OR.
     1     SWEEPZTEST(I).LE.-31.99)THEN
          IREMOVE=I
       ENDIF
      ENDDO
C 
C     WRITE AVERAGE TILT CORRECTION (ANGTEST), AZIMUTHAL ANGLE
C     CORRECTION (GROUNDSLOPE), AND RANGE DELAY CORRECTION (RDELDIFF) 
C     FOR FORE AND AFT POINTING DIRECTIONS TO OUTPUT FILE ANGTEST.TXT
C 
      OPEN(89,FILE='angtest.txt')
C 
      WRITE(89,6258)IREMOVE
      DO L2=1,2
       ANGTEST=-999.
       GROUNDSLOPE=-999.
       IF(NUMANGTEST(L2).GT.2)THEN
        ANGTEST=ANGTESTSUM(L2)/NUMANGTEST(L2)
       ENDIF
       WRITE(89,6259)L2,ANGTEST,ANGTESTSUM(L2),NUMANGTEST(L2)
       IF(NUMSLOPETEST(L2).GT.2)THEN
        GROUNDSLOPE=SLOPETESTSUM(L2)/NUMSLOPETEST(L2)
       ENDIF
       WRITE(89,6259)L2,GROUNDSLOPE,SLOPETESTSUM(L2),NUMSLOPETEST(L2) 
       IF(NUMRDEL(L2).GE.1)THEN
        RDELSUM(L2)=RDELSUM(L2)*.001
        RANGEDELAY=RDELSUM(L2)/NUMRDEL(L2)
       ENDIF
       WRITE(89,6259)L2,RANGEDELAY,RDELSUM(L2),NUMRDEL(L2)
6259   FORMAT(I2,2F12.3,I10)
6258   FORMAT(I2,I10)
      ENDDO
C 
      CLOSE(89)
C 
      RETURN
      END
C
C  *********************************************************************
C 
      SUBROUTINE VRLOCATE(OLAT,OLON,TIMES,
     + RLAT,RLON,ALT,ELEV,AZIM,RANGE,XR,YR,ZR,
     + SMOTIONU,SMOTIONV,ISCANDIM,CENTIME,IBINS,WEIGHT,VR,ISCANMAX)
      REAL RANGE(ISCANDIM),XR(ISCANDIM),YR(ISCANDIM),ZR(ISCANDIM)
      REAL SUM(512),WSUM(512),WEIGHT(200),VR(512)
      RALT=ALT/1000.
      PI=ASIN(1.0)*2.
      DTR=PI/180.
      REARTH=6366.
      TDIFF=TIMES-CENTIME
      JBINS=IBINS*3
      XSHIFT=TDIFF*SMOTIONU/1000.
      YSHIFT=TDIFF*SMOTIONV/1000.     
      RAZIM=AZIM*DTR
      RELEV=ELEV*DTR
      DO I=1,ISCANMAX
c xradar=horizontal distance from aircraft
c yradar=vertical distance from center of earth
       XRADAR=RANGE(I)*COS(RELEV)
       YRADAR=REARTH+RALT+RANGE(I)*SIN(RELEV)
c radnew=distance of datum from center of earth
       RADNEW=SQRT(XRADAR*XRADAR+YRADAR*YRADAR)
c delangle=angle between vertical at aircraft and vertical at datum
       DELANGLE=ATAN(XRADAR/YRADAR)
c distance along great circle from radar to datum
       DISTANCE=.5*(RADNEW+REARTH+RALT)*DELANGLE
c height=altitude of datum
       HEIGHT=RADNEW-REARTH
c distance2=xradar
       DISTANCE2=RANGE(I)*COS(RELEV)
c height2=altitude of datum not accounting for earth's curvature
       HEIGHT2=RALT+RANGE(I)*SIN(RELEV)
c delx=distance (aircraft/datum) along great circle due to east west
       DELX=DISTANCE*SIN(RAZIM)
c dely=distance(aircraft/datum)along great circle due to north-south
       DELY=DISTANCE*COS(RAZIM)
c dx=east west distance from origin to aircraft
       XLAT=.5*(RLAT+OLAT)*DTR
       DX=(RLON-OLON)*DTR*REARTH*COS(XLAT)
c dy=north south distance from origin to aircraft
       DY=(RLAT-OLAT)*DTR*REARTH
c xshift=east-west distance from lower left corner to origin
c yshift=north-south distance from lower left corner to origin
c XR=distance of datum from lower left corner
c YR=distance of datum from lower left corner
       XR(I)=DELX+DX-XSHIFT
c yshift=distance from lower left corner to origin
       YR(I)=DELY+DY-YSHIFT
       ZR(I)=HEIGHT
c       WRITE(6,*)'I,RANGE,DISTANCE,HEIGHT,DELX,DELY,DX,DY,XSHIFT,'
c     +  'YSHIFT = ',
c     +  I,RANGE(I),DISTANCE,HEIGHT,DELX,DELY,DX,DY,XSHIFT,YSHIFT
      ENDDO
      CONTINUE
      RETURN
      END
C
C  *********************************************************************
C 
      SUBROUTINE WRITEU(U,IMAX,JMAX,KMAX)
      REAL U(IMAX,JMAX,KMAX)
      WRITE(6,*)'ENTERED WRITEU'
      WRITE(6,*)'IMAX,JMAX,KMAX = ',IMAX,JMAX,KMAX
      DO K=1,KMAX
       WRITE(6,*)'KMAX = ',KMAX
       DO J=1,JMAX
        WRITE(6,*)'JMAX = ',JMAX
        WRITE(6,*)'WRITEU J,K,U = ',J,K,(U(I,J,K),I=1,IMAX)
       ENDDO
      ENDDO
      RETURN
      END


