      SUBROUTINE ABCD(U,V,W,
     1   RHMAX,RZMAXIN,EHMAX,EZMAX,XACC,YACC,ZACC,NF,NFILE,
     2   SUM1,SUM2,SUM3,SUM4,SUM5,SUM6,SUM7,SUM8,SUM9,
     2   SUM10,SUM11,SUM12,SUM13,EVRCOR,
     3   SUMWEIGHT,TOLERANCE,KMIN2,KMAX2,
     4   SINTOL,SXB,SYB,SZB,XZB,YZB,ZZB,
     5   ROTB,IMAXB,JMAXB,KMAXB,SUMDBZ,
     6   BETATEST,SUMWTSAVE,XWSAVE,YWSAVE,ZWSAVE,UNEW,IGUESS,FACTR,
     7   ICONTINUITY,IVWIND,FACTZ,IREADABCD,OLAT,OLON,LUSCAN,
     9   IRSW,HB1,DPB1,HB2,DPB2,SLOPE1,IFFILTER,CENTIME,TSTART,TEND,
     1   SMOTIONU,SMOTIONV,FLIGHTID,RDEL,DBZTEST,RRRR,ZLOW,ZHIGH,INDEX1,
     1   UG,VG,WG,IREVERSE,IRAMSFILES,XSHIFT,YSHIFT,IECHO,
     1   DISTXYZ,CHARV,CHARDBZ,LINUXYES,IW0,ICRESS,TATF,
     1   RRMAX,RTMAX,ERMAX,ETMAX,RADIUS2,THETA2,IGRAPHICS)
C
C     MAIN SUBROUTINE OF PROGRAM LEASTWIND (DNEWBIG_INTERPOLATE_AUTO_GUESS_XYRT_VAR.F)
C       
C ... FUNCTION:   
C
C     THIS SUBROUTINE CALLS THE DATA-READING AND QUALITY-CONTROL ROUTINE (SWEEPIN).
C     IT THEN INTERPOLATES THE REQUIRED PRODUCTS OF RADIAL VELOCITY WITH DIRECTION COSINE 
C     AS WELL AS THE PRODUCTS OF SEPARATE DIRECTION COSINES, AND FINALLY SUMS OF RADAR 
C     REFLECTIVITY. ALL BUT THE RADAR REFLECTIVITY SUMS ARE USED IN THE SYNTHESIS METHOD 
C     THAT USES A VARIATIONAL LEAST-SQUARES SOLUTION OF THE WIND FIELD.
C
C     FIRST CONSIDER THE TWO FUNCTIONALS (F_1=FORE,F_2=AFT) CORRESPONDING TO THE 
C     DOPPLER OBSERVATIONS, REPRESENTING THE DIFFERENCE BETWEEN THE ANALYSIS AND 
C     OBSERVATIONS. PROJECTING THE DOPPLER RADIAL VELOCITY ONTO ZONAL, MERIDIONAL, 
C     AND VERTICAL DIRECTIONS:
C    
C     F_1 = S_M1(S_IJK(DELTA_IJKM1*(VR_M1-BETAI_IJKM1*U_IJK-ALPHAI_IJKM1*V_IJK-GAMMA_M1*(W_IJK-VT_IJK))^2))
C
C     WHERE S_M1 IS SUM OVER ALL FORE DOPPLER OBS FOR GRID POINT (I,J,K) WITHIN SCALE OF INFLUENCE
C           S_IJK IS SUM OVER ALL GRIDPOINTS
C           VR_M1 IS FORE DOPPLER RADIAL VELOCITY OBS M1
C           VT_IJK IS FALL SPEED AT GRIDPOINT IJK
C           U_IJK IS ZONAL VELOCITY AT GRIDPOINT IJK
C           V_IJK IS MERIDIONAL VELOCITY AT GRIDPOINT IJK
C           W_IJK IS VERTICAL VELOCITY AT GRIDPOINT IJK
C
C           DELTA_IJKM1 IS WEIGHT OF FORE DOPPLER OBS M1 AT GRIDPOINT IJK (VARIABLE P)
C                      
C           GAMMA_M1 = SIN(TAU_M1)                   (vrhat.Zhat)
C           BETA_M1  = COS(PHI_M1)*COS(TAU_M1)       (vrhat.Xhat)
C           ALPHA_M1 = SIN(PHI_M1)*COS(TAU_M1)       (vrhat.Yhat)
C
C           ALPHAI_IJKM1 = COS(PHI_IJK)*SIN(PHI_M1)*COS(TAU_M1) - SIN(PHI_IJK)*COS(PHI_M1)*COS(TAU_M1)
C           BETAI_IJKM1  = SIN(PHI_IJK)*SIN(PHI_M1)*COS(TAU_M1) + COS(PHI_IJK)*COS(PHI_M1)*COS(TAU_M1)
C
C           WHERE PHI_M1 AND TAU_M1 ARE EARTH-RELATIVE FORE DOPPLER AZIMUTH (EAST IS ZERO) 
C                 AND ELEVATION (HORIZONTAL IS ZERO) ANGLES, RESPECTIVELY, DEFINED IN 
C                 CONVERTANGLES.F. NOTE THAT THESE ANGLES DIFFER FROM THOSE DEFINED IN 
C                 JORGENSEN ET AL (1883), WHICH REFERENCES ELEVATION TO THE VERTICAL AND 
C                 AZIMUTH TO THE NORTH. PHI_IJK IS THE AZIMUTHAL ANGLE OF GRIDPOINT 
C                 ABOUT THE GRID ORIGIN (X-AXIS IS ZERO).
C
C     THE GRADIENT WRT (U,V,W) IS USED IN THE VARIATIONAL LEAST-SQUARES SOLUTION:
C         
C     DF_1/DU --> 2.0*S_M1(S_IJK(DELTA_IJKM1*(VR_M1-BETAI_IJKM1*U_IJK-ALPHAI_IJKM1*V_IJK-
C                                GAMMA_M1*(W_IJK-VT_IJK))*(-BETAI_IJKM1)))
C
C     DF_1/DV --> 2.0*S_M1(S_IJK(DELTA_IJKM1*(VR_M1-BETAI_IJKM1*U_IJK-ALPHAI_IJKM1*V_IJK-
C                                GAMMA_M1*(W_IJK-VT_IJK))*(-ALPHAI_IJKM1)))
C
C     DF_1/DW --> 2.0*S_M1(S_IJK(DELTA_IJKM1*(VR_M1-BETAI_IJKM1*U_IJK-ALPHAI_IJKM1*V_IJK-
C                                GAMMA_M1*(W_IJK-VT_IJK))*(-GAMMA_M1)))  
C    
C     THE FOLLOWING 9 SUMMATIONS OVER ALL M1 ARE THEN NEEDED:
C
C     (4) DELTA_IJKM1*ALPHAI_IJKM1*VR_M1  
C     (5) DELTA_IJKM1*ALPHAI_IJKM1*ALPHAI_IJKM1
C     (1) DELTA_IJKM1*ALPHAI_IJKM1*BETAI_IJKM1
C     (6) DELTA_IJKM1*ALPHAI_IJKM1*GAMMA_M1
C     (2) DELTA_IJKM1*BETAI_IJKM1*VR_M1
C     (3) DELTA_IJKM1*BETAI_IJKM1*BETAI_IJKM1
C     (7) DELTA_IJKM1*BETAI_IJKM1*GAMMA_M1
C     (9) DELTA_IJKM1*GAMMA_M1*VR_M1  
C     (8) DELTA_IJKM1*GAMMA_M1*GAMMA_M1
C
C ... ABCD SUBPROGRAM REFERENCES:      
C       
C          NON-GRAPHICS     READWIND (IF USING GUESS WIND FIELD)
C                           SWEEPIN, READRAMFILE (PRESENTLY NOT USED), VRLOCATE
C                           DIFFOBLONG, DIFFDISTXYRT
C
C          GRAPHICS         RASX_OPEN_WINDOW, SOLO_CONVT, SHOW_IZ
C 
C ... IMPORTANT FLAGS: <()> INDICATES DEFAULT
C          
C          IGRAPHICS      USE GRAPHICS (0) NO (1) YES
C          IJTEST         AZI-COVERAGE (0) SECTOR <(1)> FULL (AKA IACROSS)
C          IGUESS         USE A GUESS WIND FIELD (0) NO <(1)> YES (AKA IUSEWIND)
C          IREVERSE       REVERSE SIGN OF DOPPLER VR <(0)> NO (1) YES
C          IREADABCD      READ IN SUMFILE <(0)> NO (1) YES
C          IVSPEED        USE CONST. AZI ADV. <(0)> NO (1) YES
C          IRAMSFILES     USE RAMSFILE <(0)> NO (1) YES
C          ICLSWP         SWITCH FROM (0) TO (1) UPON CALLING SWEEPIN ONCE
C          IBEGIN         SWITCH FROM (0) TO (1) WHEN ANGLE PROJ SUM BEGINS
C          ILATERSWEEP    ASSIGNED (1) WITHIN SWEEPIN    
C          ICRESS         USE <(0)> GAUSSIAN OR (1) CRESSMAN WEIGHTING 
C      
C     VERSION:  <TBD>
C       
C     CODE WRITTEN BY:  JOHN GAMACHE   
C                       HRD/AOML/NOAA          
C                       MIAMI, FL 33149      
C       
C     FOR ADDITIONAL DETAILS ON THE ALGORITHM SEE <TBD>
C       
C     BASED ON THEORY BY:  <TBD>
C       
C     REFERENCE THE BOOK:  <TBD>
C       
C     **************************************************  
C     *               IMPORTANT NOTE                   *  
C     *                                                *  
C     *                    <TBD>                       *  
C     *                                                *  
C     **************************************************         
C
C     SPECIFICATIONS FOR ARGUMENTS
C 
      INTEGER NF,NFILE
      INTEGER IMAXB,JMAXB,KMAXB,KMIN2,KMAX2
      INTEGER IGRAPHICS,IGUESS,IREVERSE,IREADABCD
      INTEGER IRAMSFILES,ICRESS
C     NOT USED
      INTEGER ICONTINUITY,IVWIND,IECHO,IW0
      INTEGER IFFILTER,LINUXYES,LUSCAN,IRSW
C 
      INTEGER INDEX1(IMAXB,JMAXB,KMAXB,2)
      REAL RHMAX,RZMAXIN,EHMAX,EZMAX
      REAL RRMAX,RTMAX,ERMAX,ETMAX
      REAL SXB,SYB,SZB,XZB,YZB,ZZB,ROTB
      REAL XACC,YACC,ZACC,PIMAX
      REAL SINTOL
      REAL SMOTIONU,SMOTIONV,OLAT,OLON
      REAL TSTART,TEND,SLOPE1,CENTIME     
      REAL DBZTEST,RRRR  
      REAL SUMWEIGHT,HB2,DPB2,RDEL,ZLOW,ZHIGH
C     NOT USED
      REAL EVRCOR,TOLERANCE,BETATEST,UNEW,FACTR,FACTZ
      REAL HB1,DPB1  
C                      
      REAL SUM1(IMAXB,JMAXB,KMAXB,2),SUM2(IMAXB,JMAXB,KMAXB,2)
      REAL SUM3(IMAXB,JMAXB,KMAXB,2),SUM4(IMAXB,JMAXB,KMAXB,2)
      REAL SUM5(IMAXB,JMAXB,KMAXB,2),SUM6(IMAXB,JMAXB,KMAXB,2)
      REAL SUM7(IMAXB,JMAXB,KMAXB,2),SUM8(IMAXB,JMAXB,KMAXB,2)
      REAL SUM9(IMAXB,JMAXB,KMAXB,2),SUM10(IMAXB,JMAXB,KMAXB,2)
      REAL SUM11(IMAXB,JMAXB,KMAXB,2),SUM12(IMAXB,JMAXB,KMAXB,2)
      REAL SUM13(IMAXB,JMAXB,KMAXB,2)
      REAL SUMWTSAVE(IMAXB,JMAXB,KMAXB,2),SUMDBZ(IMAXB,JMAXB,KMAXB,2)
      REAL XWSAVE(IMAXB,JMAXB,KMAXB,2)
      REAL YWSAVE(IMAXB,JMAXB,KMAXB,2),ZWSAVE(IMAXB,JMAXB,KMAXB,2)
      REAL UG(IMAXB,JMAXB,KMAXB),VG(IMAXB,JMAXB,KMAXB)
      REAL WG(IMAXB,JMAXB,KMAXB)
      REAL U(IMAXB,JMAXB,KMAXB,2),V(IMAXB,JMAXB,KMAXB,2)
      REAL W(IMAXB,JMAXB,KMAXB,2)
      REAL DISTXYZ(IMAXB,JMAXB,KMAXB,2,2,2,2)
      REAL THETA2(IMAXB,JMAXB,KMAXB),RADIUS2(IMAXB,JMAXB,KMAXB)
      REAL XSHIFT(80),YSHIFT(80)
      CHARACTER*2 TATF(80)
      CHARACTER FLIGHTID*8,CHARV*2,CHARDBZ*2
C
C ... DESCRIPTION OF ARGUMENTS
C
C     U,V,W                - 
C     RHMAX,RZMAXIN        - HORIZONTAL,VERTICAL SCALE OF INFLUENCE (KM)
C     EHMAX,EZMAX          - HORIZONTAL,VERTICAL E-FOLDING DISTANCE (KM)
C     XACC,YACC,ZACC       - MAX ALLOWED X/Y/Z DIST. BETWEEN AVG. OBS POS. AND GRIDPOINT
C     NF                   - FILE NO.
C     NFILE                - 
C     SUM1-13              - SUMS OF PRODUCTS ACCUMULATED DURING INTERP. PROCESS
C     SUMWEIGHT            - 
C     KMIN2,KMAX2          - TYPICALLY MIN AND MAX VERTICAL LEVEL NO.
C     SINTOL               - SIN OF MAX ALLOWED DOPPLER RADIAL ANGLE FROM HORIZ.
C     SXB,SYB,SZB          - X/Y/Z GRID SPACING (KM)
C     XZB,YZB,ZZB          - MIN X/Y/Z (KM)
C     ROTB                 - COORD. ROTATION (ALWAYS ZERO IN CYL COORDS)
C     IMAXB,JMAXB,KMAXB    - RADIAL,AZI,VERTICAL ARRAY DIMENSION
C     SUMDBZ               - WEIGHTED AVG. REFLECTIVITY AT GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN
C     SUMWTSAVE            - ACCUMULATED WEIGHT AT GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN
C     XWSAVE,YWSAVE,ZWSAVE - WEIGHTED AVG. X/Y/Z DIST. BETWEEN DATUM AND GRIDPOINT
C     OLAT,OLON            - LAT,LON OF GRID ORIGIN (STORM CENTER)
C     SLOPE1               - REFLECTIVITY SLOPE CORRECTION FACTOR SET TO ONE
C     CENTIME              - ANALYSIS TIME (S)
C     TSTART,TEND          - SEE STIME,ETIME
C     SMOTIONU,SMOTIONV    - STORM MOTION (M/S)
C     FLIGHTID             - FLIGHT NAME
C     RDEL                 -
C     DBZTEST              - MIN DBZ TO INCLUDE
C     RRRR                 - MIN RANGE TO INCLUDE
C     INDEX1               - 
C     UG,VG,WG             - GUESS X/Y/Z WIND (M/S)
C     XSHIFT,YSHIFT        - (DEFAULT 0 KM)
C     DISTXYZ              - DISTANCE OF THE CLOSEST OBS THAT WAS INTERP. TO GRIDPOINT (I,J,K)
C     CHARV                - 
C     CHARDBZ              -
C     PIMAX                - MAX AZI ANGLE FOR OBS TO BE INCLUDED IN WT AVG
C     VSPEED0              - CONST. ADV. SPEED USED IN COMPOSITING (M/S)
C     VFACTOR              - FACTOR MULT. WIND SPEED TO USE IN COMPOSITING (M/S)
C     TATF                 - IDENTIFY SCAN TYPE 
C     RRMAX,RTMAX          - RADIAL AND AZI SCALE OF INFLUENCE (KM,DEG)    
C     ERMAX,ETMAX          - RADIAL AND AZI E-FOLDING DISTANCE (KM,DEG)
C     RADIUS2,THETA2       - 
C
C     SPECIFICATIONS FOR LOCAL VARIABLES
C
C **** GRAPHICS
C 
      PARAMETER(MAX_X=750,MAX_Y=250)
      INTEGER RAW_WINDOW(100),RAWZ_WINDOW(100)
      INTEGER*2 DBZ_INT(MAX_X,MAX_Y)
      CHARACTER DISPLAY_LABEL*32,WINDOW_LABEL*28
      CHARACTER DISPLAY_LABELZ*32,WINDOW_LABELZ*18
C
C **** REMAINING
C 
      INTEGER WINDOWERROR
      INTEGER DATA_TYPE
      INTEGER NUMANGTEST(2)
      INTEGER NUMSLOPETEST(2),IAZM(800)
      INTEGER NS(3)
      INTEGER JINDEX(512,800),JIINDEX(512,800)
      REAL GTLENGTH(512)
      REAL SLOPETESTSUM(2)
      REAL ANGTESTSUM(2)
      REAL VR(512),RANGE(512),DBZ(512),XR(512),YR(512),ZR(512)
      REAL RHOK(200),WGT(200)
      REAL VRSWP(512,800),REFSWP(512,800),VRRAD(512,800)
      REAL RDTAI(512),AZ_EL(2,800),EAZM(800),EEV(800)
      REAL VNYQ(512,800),PELEV(800)
      REAL TMP1(512,800),TMP2(512,800),UNFVEL(512,800)
      REAL SWEEPSAVE(512,800)
      REAL TMSWEEP(800),RRLAT(800),RRLON(800),RRA(800)
      REAL SUMMER(200,200,200,2)
      CHARACTER*2 TAF
C 
C ... DESCRIPTION OF VARIABLES PASSED BETWEEN SUBROUTINES
C 
C **** READWIND
C
C 
C **** SWEEPIN
C
C
C **** READRAMFILE
C
C
C **** VRLOCATE
C
C
C **** DIFFOBLONG
C
C
C **** DIFFDISTXYRT
C 
      FLAG=-1.0E+10
C 
C ... OPEN GRAPHICS WINDOWS
C 
      IF(IGRAPHICS.EQ.1)THEN
       WINDOW_LABEL='cleaned up radial velocities'
       WINDOW_LABELZ='reflectivity (dBZ)'
       ILOG_LU=6
       CALL RASX_OPEN_WINDOW(RAW_WINDOW,WINDOWERROR,WINDOW_LABEL)
       CALL RASX_OPEN_WINDOW(RAWZ_WINDOW,WINDOWERROR,WINDOW_LABELZ)
      ENDIF
C
C     THE INITIAL GUESS WIND FIELD IS THAT FROM THE WAVENUMBER ZERO
C     AND ONE DECOMPOSITION PERFORMED EARLIER. THE FORMAT IS (U,V,W)
C     IN CARTESIAN COORDINATES. 
C 
      IUSEWIND=IGUESS
      IF(IUSEWIND.EQ.1)THEN
       IJKMX=IMAXB*JMAXB*KMAXB
       CALL READWIND(UG,VG,WG,IMXG,JMXG,KMXG,SXG,SYG,SZG,
     +  OLATG,OLONG,XZG,YZG,ZZG,IJKMX,ZLOW,ZHIGH,HB2,DPB2)
       IF(IMXG.NE.IMAXB.OR.JMXG.NE.JMAXB.OR.KMXG.NE.KMAXB)THEN
        WRITE(6,*)'IMXG,IMAXB = ',IMXG,IMAXB
        WRITE(6,*)'JMXG,JMAXB = ',JMXG,JMAXB
        WRITE(6,*)'KMXG,KMAXB = ',KMXG,KMAXB
        WRITE(6,*)'SINCE MASKING IS DONE WITH GUESS FIELD'
        WRITE(6,*)'AND FIELDS DONT MATCH I AM SUSPENDING'
        PAUSE
       ENDIF
      ELSE
       IMXG=IMAXB
       JMXG=JMAXB
       KMXG=KMAXB
       SXG=SXB
       SYG=SYB
       SZG=SZB
       OLATG=OLAT
       OLONG=OLON
       XZG=XZB
       YZG=YZB
       ZZG=ZZB
      ENDIF
C 
      IERR=0
C 
      MAX_GATES=512
      MAX_RAYS=800
C 
      WRITE(6,'(A2)')CHARV
      WRITE(6,'(A2)')CHARDBZ
C 
C     MDIM IS TOTAL NO. OF GRID POINTS IN OUTPUT FIELDS
C 
      MDIM=IMAXB*JMAXB*KMAXB
      WRITE(6,*)'MDIM = IMAXB*JMAXB*KMAXB = ',MDIM
C
C     DETERMINE PI TO FULL REAL-VARIABLE RESOLUTION
C 
      WRITE(6,*)'A'
      PI=2.*ASIN(1.)
      PI2=2.*PI
      DTR=PI/180.
C 
      ICRESS=0
      ISCANDIM=512
      ISCANMAX=128
      IBINS=7
      SXB2=.5*SXB*SXB
      SYB2=.5*SYB*SYB
      SZB2=.5*SZB*SZB
      JBINS=3*IBINS+1
      RDEL=0.
C  
C     (II,JJ,KK,I,J,K,L) LOOPS (X SIDE,Y SIDE,VERTICAL SIDE,X,Y,HEIGHT,FORE/AFT) 
C
C ... INITIALIZE ARRAYS HOLDING ?? AND ??.
C     DISTXYZ IS THE DISTANCE OF THE CLOSEST OBS THAT WAS INTERPOLATED
C     TO GRID POINT (I,J,K). IF EQUAL TO 1000, THEN GRID POINT WAS NOT
C     SURROUNDED BY DATA WHICH COULD BE INTERPOLATED. ALL GRID POINTS
C     ARE INITIALIZED TO HAVE DISTXYZ EQUAL TO 1000.
C 
      WRITE(6,*)'B'
      DO K=1,KMAXB
       DO J=1,JMAXB
        DO I=1,IMAXB
         RADIUS2(I,J,K)=FLAG
         THETA2(I,J,K)=FLAG
        ENDDO
       ENDDO
      ENDDO 
      WRITE(6,*)'ONE' 
      DO L=1,2
       DO K=1,KMAXB
        DO J=1,JMAXB
         DO I=1,IMAXB
          DO KK=1,2
           DO JJ=1,2
            DO II=1,2
             DISTXYZ(I,J,K,L,II,JJ,KK)=1000.
            ENDDO
           ENDDO
          ENDDO
         ENDDO
        ENDDO
       ENDDO
      ENDDO
C 
C ??
C 
      DO I=1,JBINS
       RATIOI=(FLOAT(I)/FLOAT(IBINS))**2.
       WGT(I)=EXP(-RATIOI)
      ENDDO
C 
C     INITIALIZE ARRAY HOLDING DENSITY PROFILE
C 
      DO K=1,KMAXB
       HEIGHT=ZZB+(K-1)*SZB
       RHOK(K)=EXP(-HEIGHT*.10437052)
      ENDDO
C 
C ??
C 
      ZTOP=(KMAXB-1)*SZB
      RLZ=ZTOP
      RLH=25.*SXB
      UBAR=10.
C 
C     RANGE IS VECTOR (1,2,...,256)
C     VR IS VECTOR -(1,2,...,256)
C     DBZ IS VECTOR 2*(1,2,...,256)
C 
      DO I=1,256
       A=I
       RANGE(I)=A
       VR(I)=-A
       DBZ(I)=A*2.
      ENDDO
C 
      write(6,*)'entered abcd'
      NS(1)=0
      NS(2)=0
      NS(3)=1
      NSTEP=2
      NSTEP2=1
      MDIM2=IMAXB*JMAXB
      WRITE(6,*)'IMAXB,JMAXB,KMAXB,SXB,SYB,SZB,ROTB'
      WRITE(6,*)IMAXB,JMAXB,KMAXB,SXB,SYB,SZB,ROTB
      WRITE(6,*)'Entered ABCD'
C
C     RADIAL, AZI, HORIZ, AND VERTICAL WEIGHTS ARE EFOLDING SCALES SQUARED
C  
      RRWEIGHT=ERMAX*ERMAX
      RTWEIGHT=ETMAX*ETMAX
      RHWEIGHT=EHMAX*EHMAX
      RZWEIGHT=EZMAX*EZMAX
C 
      RXMAX=RHMAX
      RYMAX=RHMAX
      RZMAX=RZMAXIN
C 
      WRITE(6,*)'EHMAX,EZMAX,RXMAX,RYMAX,RZMAX'
      WRITE(6,*)EHMAX,EZMAX,RXMAX,RYMAX,RZMAX    
      WRITE(6,*)'XACC = ',XACC
      WRITE(6,*)'YACC = ',YACC
      WRITE(6,*)'ZACC = ',ZACC
C 
      TIMER=0.
C  
C     (II,JJ,KK,L) LOOPS (X,Y,HEIGHT,FORE/AFT) 
C 
C ... ZERO ALL ANGLE-PROJECTION SUMMATIONS. THIS IS DONE BEFORE LOOPING OVER ALL SWEEPS.
C 

      IF(IREADABCD.NE.1)THEN
       DO L=1,2
        DO KK=KMIN2,KMAX2
         DO JJ=1,JMAXB
          DO II=1,IMAXB
           SUMMER(II,JJ,KK,L)=0
           SUMDBZ(II,JJ,KK,L)=0
           SUMWTSAVE(II,JJ,KK,L)=0
           SUM1(II,JJ,KK,L)=0
           SUM2(II,JJ,KK,L)=0
           SUM3(II,JJ,KK,L)=0
           SUM4(II,JJ,KK,L)=0
           SUM5(II,JJ,KK,L)=0
           SUM6(II,JJ,KK,L)=0
           SUM7(II,JJ,KK,L)=0
           SUM8(II,JJ,KK,L)=0
           SUM9(II,JJ,KK,L)=0
           SUM10(II,JJ,KK,L)=0
           SUM11(II,JJ,KK,L)=0
           SUM12(II,JJ,KK,L)=0
           SUM13(II,JJ,KK,L)=0
           XWSAVE(II,JJ,KK,L)=0
           YWSAVE(II,JJ,KK,L)=0
           ZWSAVE(II,JJ,KK,L)=0
           INDEX1(II,JJ,KK,L)=0
          ENDDO
         ENDDO
        ENDDO
       ENDDO
      ENDIF
C 
      NRECORD=1
      RLATBEFORE=0.
      IBEGIN=0
      ICLSWP=0
C 
C ??
C 
      DO L2=1,2
       NUMANGTEST(L2)=0
       ANGTESTSUM(L2)=0
       ANGTEST=-999.9
       GROUNDSLOPE=-999.9
       NUMSLOPETEST(L2)=0
       SLOPETESTSUM(L2)=0.
      ENDDO
C 
      IF(IREADABCD.EQ.1)GO TO 72735
C 
C     ****AFTER EACH SWEEP THE PROGRAM RETURNS HERE UNTIL MAX TIME IS REACHED****
C 
92923 TAF=TATF(NF)
C 
C ... SWEEPIN READS DATA FROM A TO_FB FILE, CLEANS IT UP, REMOVES THE SURFACE,
C     REMOVES SPECKLES, AND AUTOMATICALLY (BARGEN BROWN) DE-ALIASES THE DATA 
C     IN BOTH SINGLE-RADIAL AND AZIMUTHAL MODES
C 
      CALL SWEEPIN(VRSWP,REFSWP,MAX_RAYS,MAX_GATES,NUM_RAYS,RDTAI,
     + AZ_EL,ICLSWP,NRECORD,VRRAD,UNFVEL,TMP1,TMP2,JINDEX,
     + JIINDEX,VNYQ,ILATERSWEEP,SWEEPSAVE,UG,VG,WG,
     + IMXG,JMXG,KMXG,SXG,SYG,SZG,OLATG,OLONG,XZG,YZG,ZZG,
     + IUSEWIND,EAZM,EEV,TMSWEEP,RRLAT,RRLON,RRA,SMOTIONU,SMOTIONV,
     + CENTIME,PELEV,ISCANMAX,ANGTEST,GROUNDSLOPE,IAZM,
     + ZLOW,ZHIGH,HB2,DPB2)
C 
      ICLSWP=1
      NR=1
C 
C ... SET FIRST 128 ELEMENTS OF RANGE TO ??. GTLENGTH CONTAINS SAME INFO.
C 
      DO I=1,ISCANMAX
       RANGE(I)=RDTAI(I)
       GTLENGTH(I)=RDTAI(I)
      ENDDO
C
C ... BEGIN GRAPHICS
C 
      IF(IGRAPHICS.EQ.1)THEN
C 
       RMX=GTLENGTH(ISCANMAX)
       write(6,*)'rmx = ',rmx
       XDIS=75.
       YDIS=10.
       SWEEPSX=.20
       SWEEPSY=.20
       IMAXSWEEP=MAX_X
       JMAXSWEEP=MAX_Y
       MAXX=MAX_X
       MAXY=MAX_Y
       RDEL=0.
       RDEL_Z=0.
       NMOSM=0
       BAD_VAL=-888.8
       DOPMIN=-80.
       DOPMAX=80.
       TOO_NOISY=-200.
       AMBIGUOUS=-100.
       BAD_VALZ=-31.5
       DBZMIN=-20.
       DBZMAX=55.
       IXL=20
       IYB=20
C  
C      FIRST FOR DATA_TYPE=2
C       
       DATA_TYPE=2
C 
       CALL SOLO_CONVT(DATA_TYPE,ELMIN,ELMAX,
     +  DBZ_INT,MAXX,MAXY,ILOG_LU,
     +  AZ_EL,VRSWP,MAX_GATES,ISCANMAX,NUM_RAYS,IERSM,
     +  IMAXSWEEP,JMAXSWEEP,SWEEPSX,SWEEPSY,XDIS,YDIS,RLATDUM,
     +  RLONDUM,SLATDUM,SLONDUM,RMX,RDEL_Z,TIMES,NMOSM,ITFLG,
     +  GTLENGTH,BAD_VAL)
       CALL SHOW_IZ(IXL,IYB,DBZ_INT,MAXX,MAXY,IMAXSWEEP,JMAXSWEEP,
     +  DOPMIN,DOPMAX,DATA_TYPE,TOO_NOISY,AMBIGUOUS,
     +  RAW_WINDOW,DISPLAY_LABEL)
C      
C      THEN FOR DATA_TYPE=1
C 
       DATA_TYPE=1
C 
       CALL SOLO_CONVT(DATA_TYPE,ELMIN,ELMAX,
     +  DBZ_INT,MAXX,MAXY,ILOG_LU,
     +  AZ_EL,REFSWP,MAX_GATES,ISCANMAX,NUM_RAYS,IERSM,
     +  IMAXSWEEP,JMAXSWEEP,SWEEPSX,SWEEPSY,XDIS,YDIS,RLATDUM,
     +  RLONDUM,SLATDUM,SLONDUM,RMX,RDEL_Z,TIMES,NMOSM,ITFLG,
     +  GTLENGTH,BAD_VALZ)
       CALL SHOW_IZ(IXL,IYB,DBZ_INT,MAXX,MAXY,IMAXSWEEP,JMAXSWEEP,
     +  DBZMIN,DBZMAX,DATA_TYPE,TOO_NOISY,AMBIGUOUS,
     +  RAWZ_WINDOW,DISPLAY_LABELZ)
C 
      ENDIF
C
C ... END GRAPHICS
C  
C     EXECUTE THE CODE BELOW AS LONG AS RAY NUMBER (INITIALLY 1) IS <= MAX RAYS
C     RECALL NR IS THE RAY NO., WHICH IS ADVANCED BELOW 
C 
92924 DO WHILE(NR.LE.NUM_RAYS)
C 
       IAZMM=IAZM(NR)
       IF(IAZMM.NE.1)THEN
        NR=NR+1
        GO TO 92924
       ENDIF
C 
       ELEVTEST=PELEV(NR)
C 
C      RECALL ELEVTEST IS THE AIRCRAFT-RELATIVE ELEVATION ANGLE FOR 
C      THIS RAY. IF <= 0 THEN FORE AND L2=1. IF > 0 THEN AFT AND L2=2.
C 
       IF(ELEVTEST.LE.0)THEN
        L2=1
       ELSE
        L2=2
       ENDIF
       IF(ANGTEST.GT.-900.)THEN
        NUMANGTEST(L2)=NUMANGTEST(L2)+1
        ANGTESTSUM(L2)=ANGTESTSUM(L2)+ANGTEST
        WRITE(6,*)'L2,NUMANGTEST,ANGTESTSUM = ',
     1   L2,NUMANGTEST(L2),ANGTESTSUM(L2)
       ENDIF
       IF(GROUNDSLOPE.GT.-900.)THEN
        NUMSLOPETEST(L2)=NUMSLOPETEST(L2)+1
        SLOPETESTSUM(L2)=SLOPETESTSUM(L2)+GROUNDSLOPE
        WRITE(6,*)'L2,NUMSLOPETEST,SLOPETESTSUM = ',
     1   L2,NUMSLOPETEST(L2),SLOPETESTSUM(L2)
       ENDIF
C 
       RLATBEFORE=RLAT
       TIMES=TMSWEEP(NR)
       AZIM=EAZM(NR)
C
C ...  SWEEPIN USES MATH ANGLES BUT VRLOCATE WAS BASED UPON USING THE UF FILE 
C      READER WHICH REPORTS BACK IN NAVIGATIONAL COORDINATES. DO A REFLECTION
C      AND CHECK.
C 
       AZIM=90-AZIM
       IF(AZIM.LT.0.)AZIM=AZIM+360.
       IF(AZIM.GT.360.)AZIM=AZIM-360.
C 
       RALT=RRA(NR)
       ELEV=EEV(NR)
       RLAT=RRLAT(NR)
       RLON=RRLON(NR)
C 
C ...  FOR GIVEN RADIAL STORE THE FIRST 128 GATES OF THE QC'D DOPPLER RADIAL 
C      VELOCITY IN VR AND REFLECTIVITY IN DBZ.
C 
       ILIST=0
       DO I=1,ISCANMAX
        VR(I)=VRSWP(I,NR)
        IF(VR(I).GT.-800..AND.ABS(VR(I)).GT.70.)ILIST=1
        DBZ(I)=REFSWP(I,NR)
       ENDDO
C 
       IF(RLAT.EQ.0.)RLAT=RLATBEFORE
C 
C **** RAMSFILES ARE NOT USED AT PRESENT, SO THIS CODE IS SKIPPED
C 
       IF(IRAMSFILES.EQ.1)THEN
        rlat22=rlat
        rlon22=rlon
        CALL READRAMFILE(TIMES,TIME_RAM,RLAT,RLON,DM1,DM2,DM3,
     *                      DM4,DM5,DM6,DM7,IOS)
       ENDIF
C 
C **** END SKIPPED CODE
C 
C      IF A NEW DAY IS REACHED, THEN ADD 86400 SEC TO THE TIME
C 
       IF(IBEGIN.EQ.1.AND.TIMES.LT.TSTART)TIMES=TIMES+86400.
C
C      EXIT PROCESSING OF RADIALS ONCE END TIME IS REACHED OR UPON ERROR
C 
       IF(TIMES.GT.TEND.OR.IERR.EQ.-1)GO TO 92929
C
C      INITIALLY TIMEOLD EQUALS ZERO, SO THIS CODE IS EXECUTED FIRST TIME.
C      APPEARS TO EXECUTE EVERY TIME.
C      
       IF(TIMES.GT.TIMEOLD)THEN
        ITIMES=TIMES
        IHOURS=TIMES/3600
        IHSECS=IHOURS*3600
        ILEFT=ITIMES-IHSECS
        IMINS=ILEFT/60
        ISECS=ILEFT-60*IMINS
        ITIMESS=IHOURS*10000+IMINS*100+ISECS       
       ENDIF
C 
       TIMEOLD=TIMES
C 
C ...  BEGIN ANGLE SUMMING CODE
C 
       IF(IREADABCD.NE.1.AND.TIMES.GE.TSTART.AND.TIMES.LE.TEND)THEN
C 
        JJJSTART=1
        IF(RDEL.LT.0)THEN
         DO JJJ=JJJSTART,ISCANMAX
          RANGE(JJJ)=RANGE(JJJ)+RDEL
          IF(IREVERSE.EQ.1)THEN
         ENDIF
         ENDDO
        ENDIF
C 
        RHIGH=300.
        RLOW=.1
C 
        IBEGIN=1
C 
        XWEIGHT=0
        YWEIGHT=0
        ZWEIGHT=0
        SUMWEIGHT=0
C 
C ...   VRLOCATE DETERMINES DATUM LOCATION WITHIN INTERPOLATION GRID.
C       RETURNS XR,YR,ZR,??
C 
        CALL VRLOCATE(OLAT,OLON,TIMES,
     +   RLAT,RLON,RALT,ELEV,AZIM,RANGE,XR,YR,ZR,
     +   SMOTIONU,SMOTIONV,ISCANDIM,CENTIME,IBINS,WGT,VR,ISCANMAX)
C 
C       AZIMM IS JUST EARTH-RELATIVE AZIMUTH ANGLE (SINCE ROTB IS ZERO)
C 
        AZIMM=AZIM-ROTB
C 
C ...   COMPUTE DIRECTION COSINES WHICH ARE FUNCTIONS OF EARTH-RELATIVE 
C       RAY ORIENTATION ALONE: ALPHA_M, BETA_M, GAMMA_M. SEE DOCUMENTATION
C       AT BEGINNING OF SUBROUTINE FOR DETAILS.
C 
        GAMMA=SIN(ELEV*DTR)
        ALPHA=SIN(AZIMM*DTR)*COS(ELEV*DTR)
        BETA=COS(AZIMM*DTR)*COS(ELEV*DTR)
C 
C       (I) LOOPS (GATES)
C
C ...   SEE DOCUMENTATION AT BEGINNING OF SUBROUTINE FOR MATHEMATICAL EXPRESSIONS
C       BEING FORMULATED IN CODE BELOW. NUMBERS POINT TO RESPECTIVE EXPRESSIONS.
C 
        ISCANTEST=0
        DO I=JJJSTART,ISCANMAX
C 
         DBZCHK=-31.99
         ZRCHECK=0.
C 
         RXMAX=RHMAX
         RYMAX=RHMAX 
         RZMAX=RZMAXIN 
C        
         RHO=EXP(-ZR(I)*.10437052)
C  
C        ??
C        VRVR STORES DOPPLER RADIAL VELOCITY FOR GATE I: VR_M
C 
         XR(I)=XR(I)+XSHIFT(NF)
         YR(I)=YR(I)+YSHIFT(NF)
         VRVR=VR(I)
C 
C        IF DOPPLER RADIAL VELOCITY EXISTS OR REFLECTIVITY IS ABOVE DBZCHK
C        AND ??
C        AND THE GATE IS WITHIN THE SPECIFIED RANGE, EXECUTE THE FOLLOWING:
C 
         IF(VR(I).GT.-800..OR.DBZ(I).GT.DBZCHK.AND.
     +     ZR(I).GT.ZRCHECK.AND.ZR(I).GT..075.
     +     AND.RANGE(I).GT.RLOW.AND.RANGE(I).LT.RHIGH.
     +     AND.IAZMM.EQ.1)THEN
C 
          IGAMMATEST=1
C 
C         IF EARTH-RELATIVE ELEVATION ANGLE IS <= 90 (DEFAULT), EXECUTE THE FOLLOWING:
C 
          IF(ABS(GAMMA).LE.SINTOL)IGAMMATEST=1
C 
          IF(IGAMMATEST.EQ.1)THEN
C
C ...      DETERMINE ACTUAL DISTANCE BETWEEN DATUM AND POINT BEING EVALUATED IN OUTPUT FILE
C 
           CALL DIFFOBLONG(XR(I),YR(I),ZR(I),
     +      RXMAX,RYMAX,RZMAX,SXB,SYB,SZB,
     +      XZB,YZB,ZZB,IMAXB,JMAXB,KMAXB,
     +      IXMIN,IXMAX,IYMIN,IYMAX,IZMIN,IZMAX,ROTB)
C 
           ICALLED=0
C 
C          (II,JJ,KK) LOOPS (X,Y,HEIGHT) 
C 
           DO KK=IZMIN,IZMAX
            RHOVRVR=VRVR*RHOK(KK)
C 
            DO JJ=IYMIN,IYMAX
             DO II=IXMIN,IXMAX  
C 
              CALL DIFFDISTXYRT(XR(I),YR(I),ZR(I),
     +        II,JJ,KK,INEAR,JNEAR,KNEAR,
     +        SXB,SYB,SZB,XZB,YZB,ZZB,RX,RY,RZ,ROTB,
     +        DELTHETA,DELRAD,DISTTHETA,
     +        IMAXB,JMAXB,KMAXB,THETA1,RADIUS1,THETA2,RADIUS2,
     +        ICALLED,XBROT,YBROT)
C 
              XX=(FLOAT(II-1)+.5)*SXB-XZB
              YY=(FLOAT(JJ-1)+.5)*SYB-YZB
              ZZ=(KK-1)*SZB+ZZB
              ZZ2=ZZ*2.
C 
              IF(ZZ2.LT.SZB)ZZ2=SZB
C 
C             RX <= 0 DATUM RADIALLY AT OR INSIDE GRIDPOINT --> IA=1
C             RX > 0  DATUM RADIALLY OUTSIDE GRIDPOINT      --> IA=2
C             RY <= 0 DATUM CLOCKWISE FROM GRIDPOINT        --> JA=1
C             RY > 0  DATUM COUNTERCLOCKWISE FROM GRIDPOINT --> JA=2
C             RZ <= 0 DATUM AT OR LOWER THAN GRIDPOINT      --> KA=1
C             RZ > 0  DATUM HIGHER THAN GRIDPOINT           --> KA=2
C 
              IF(RX.LE.0)IA=1
              IF(RX.GT.0)IA=2
              IF(RY.LE.0)JA=1
              IF(RY.GT.0)JA=2
              IF(RZ.LE.0)KA=1
              IF(RZ.GT.0)KA=2
C 
C             RR IS DISTANCE IN CYLINDRICAL COORDINATES BETWEEN DATUM AND GRIDPOINT
C 
              RR=SQRT(RX*RX+RY*RY+RZ*RZ)
C
C ...         IF DISTANCE RR BETWEEN GIVEN DATUM AND GRIDPOINT (II,JJ,KK) IS LESS THAN
C             CURRENT MINIMUM DISTANCE, ASSIGN DISTXYZ FOR GRIDPOINT (II,JJ,KK) THE 
C             VALUE RR. THIS IS DONE SEPARATELY FOR FORE AND AFT SWEEPS (L2=1,2). 
C             THIS IS ALSO DONE SEPARATELY FOR THE 8 DIFFERENT SECTORS (IA,JA,KA=1,2) 
C             ABOUT THE GRIDPOINT.
C 
              IF(RR.LT.DISTXYZ(II,JJ,KK,L2,IA,JA,KA))THEN
               DISTXYZ(II,JJ,KK,L2,IA,JA,KA)=RR
              ENDIF
C 
C             IF COMPONENT DISTANCE BETWEEN DATUM AND GRIDPOINT IS LESS THAN SCALE OF 
C             INFLUENCE, THEN CONTINUE WITH NEXT GRIDPOINT. NOTE: SCALE OF INFLUENCE
C             AND WEIGHTING ARE EXPRESSED IN CYLINDRICAL COORDINATES.                      
C 
              IF(ABS(DELRAD).LT.RRMAX.AND.ABS(DISTTHETA).LT.RTMAX.AND.
     1          ABS(RZ).LT.RZMAX.AND.ZR(I).LT.ZZ2)THEN
C 
               ABCC=DELRAD**2./RRMAX*2.+DISTTHETA**2./RTMAX**2.+
     1           RZ**2./RZMAX**2.
               ABC=DELRAD*DELRAD/RRWEIGHT+
     1           DISTTHETA*DISTTHETA/RTWEIGHT+RZ*RZ/RZWEIGHT
C 
               ALPHANEW=ALPHA*COS(DELTHETA)-BETA*SIN(DELTHETA)
               BETANEW=ALPHA*SIN(DELTHETA)+BETA*COS(DELTHETA)
C 
C              DEFAULT: 
C ...          P=WEIGHT=e^(-((R_D-R_GP)^2/EFOLD_R^2+(T_D-T_GP)^2/EFOLD_THETA^2+(Z_D-Z_GP)^2/EFOLD_Z^2))
C 
               IF(ICRESS.NE.1)THEN
                WEIGHT=EXP(-ABC)
                P=WEIGHT
               ELSE
                WEIGHT=1-ABCC
                IF(WEIGHT.LT.0.)WEIGHT=0
                P=WEIGHT
               ENDIF
C
C              SLOPE1 IS HARDWIRED TO 1, SO DBZZ STORES DBZ DATUM 
C 
               SUMWEIGHT=P
               IF(DBZ(I).GT.-100)THEN
                DBZZ=DBZ(I)*SLOPE1
               ELSE
                DBZZ=-200.
               ENDIF
C
C ...          ZE IS DBZ CONVERTED TO POWER. SUMDBZ IS THE ACCUMULATED WEIGHTED POWER AT 
C              GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN. SUMMER IS THE ACCUMULATED WEIGHT
C              AT GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN. ACCUMULATION OCCURS ONLY IF
C              THE REFELCTIVITY IS GREATER THAN DBZCHK.
C 
               ZE=10.**(DBZZ/10.)
               IF(ABS(VR(I)).LT.800.)THEN
                VTEST=1.
               ELSE
                VTEST=0.
               ENDIF
               IF(DBZ(I).GT.DBZCHK)THEN
                SUMDBZ(II,JJ,KK,L2)=
     +          SUMDBZ(II,JJ,KK,L2)+P*ZE
                SUMMER(II,JJ,KK,L2)=SUMMER(II,JJ,KK,L2)+P
               ENDIF
C
C ...          PERFORM WEIGHTED SUMS OF DIRECTION COSINE/VR TERMS AS LONG AS DOPPLER RADIAL 
C              VELOCITY IS NON-FLAGGED. THE FIRST 9 ARE USED IN THE COST-FUNCTION GRADIENT...
C                
               IF(VTEST.GT.0.)THEN
C 
                ISCANTEST=1
C
C               (1) 
                SUM1(II,JJ,KK,L2)=
     +          SUM1(II,JJ,KK,L2)+P*ALPHANEW*BETANEW
C
C               RHO*(2) 
                SUM2(II,JJ,KK,L2)=
     +          SUM2(II,JJ,KK,L2)+P*BETANEW*RHOVRVR
C
C               (3) 
                SUM3(II,JJ,KK,L2)=
     +          SUM3(II,JJ,KK,L2)+P*BETANEW*BETANEW
C
C               RHO*(4) 
                SUM4(II,JJ,KK,L2)=
     +          SUM4(II,JJ,KK,L2)+P*ALPHANEW*RHOVRVR
C
C               (5) 
                SUM5(II,JJ,KK,L2)=
     +          SUM5(II,JJ,KK,L2)+P*ALPHANEW*ALPHANEW
C
C               (6) 
                SUM6(II,JJ,KK,L2)=
     +          SUM6(II,JJ,KK,L2)+P*ALPHANEW*GAMMA
C
C               (7) 
                SUM7(II,JJ,KK,L2)=
     +          SUM7(II,JJ,KK,L2)+P*BETANEW*GAMMA
C
C               (8) 
                SUM8(II,JJ,KK,L2)=
     +          SUM8(II,JJ,KK,L2)+P*GAMMA*GAMMA
C
C               RHO*(9)
                SUM9(II,JJ,KK,L2)=
     +          SUM9(II,JJ,KK,L2)+P*GAMMA*RHOVRVR
C
C ...           THE REMAINING SUMMATIONS ARE USED IN THE DEFINITION OF THE COST FUNCTION...
C
C               (10) 
                SUM10(II,JJ,KK,L2)=
     +          SUM10(II,JJ,KK,L2)+P*ALPHANEW
C
C               (11) 
                SUM11(II,JJ,KK,L2)=
     +          SUM11(II,JJ,KK,L2)+P*BETANEW
C
C               (12) 
                SUM12(II,JJ,KK,L2)=
     +          SUM12(II,JJ,KK,L2)+P*GAMMA
C
C               RHO*(13) 
                SUM13(II,JJ,KK,L2)=
     +          SUM13(II,JJ,KK,L2)+P*RHOVRVR
C 
C ...           SUMWTSAVE IS THE ACCUMULATED WEIGHT AT GRIDPOINT (I,J,K) FOR FORE OR AFT SCAN. 
C               ACCUMULATION OCCURS ONLY IF THE DOPPLER RADIAL VELOCITY IS NON-FLAGGED. THIS 
C               VARIABLE IS DISTINGUISHED FROM SUMMER, WHICH USES A REFLECTIVITY CHECK.
C 
                SUMWTSAVE(II,JJ,KK,L2)=SUMWTSAVE(II,JJ,KK,L2)+P
C
C ...           X/Y/ZSAVE ARE ACCUMULATED WEIGHTED R, THETA AND Z DISTANCES.
C 
                XWSAVE(II,JJ,KK,L2)=XWSAVE(II,JJ,KK,L2)+P*RX
                YWSAVE(II,JJ,KK,L2)=YWSAVE(II,JJ,KK,L2)+P*RY
                ZWSAVE(II,JJ,KK,L2)=ZWSAVE(II,JJ,KK,L2)+P*RZ
C 
               ENDIF
C
C              END DOPPLER RADIAL VELOCITY CONDITION 
C 
              ENDIF
C
C             END SCALE OF INFLUENCE CONDITION 
C 
             ENDDO
            ENDDO
           ENDDO
C
C          END LOOPS OVER X, Y, AND HEIGHT (II,JJ,KK)
C 
          ENDIF
C
C         END ELEVATION ANGLE CONDITION
C 
         ENDIF
C
C        END VR/DBZ/RANGE CONDITION
C  
        ENDDO
C       
C       END LOOP OVER GATES (I)
C 
       ENDIF
C
C      END CONTRIBUTION TO SUMMATIONS FROM GIVEN RAY
C
C ...  INCREMENT RAY NUMBER
C 
27272  NR=NR+1
C 
      ENDDO
C 
C     RETURN TO SWEEPIN TO INCORPORATE NEXT RADAR SWEEP
C 
      GO TO 92923
C 
C     PROGRAM HAS NOW READ IN, QC'D AND INCORPORATED ALL SWEEPS
C 
92929 WRITE(6,*)'JUST FINISHED VR SUMMATION'
C 
      CLOSE(320)
      CLOSE(321)
C 
      IOKAY=1
C 
72735 IF(IOKAY.EQ.1)THEN
C
C      AT THE END OF EACH COMPLETE ITERATION
C
C      L2 = 1 AND 2 REPRESENT FORE AND AFT SUMMATIONS, RESPECTIVELY
C 
       WRITE(6,*)'IN ABCD'
       WRITE(6,*)'SUM1,SUM2,SUM3 = ',
     + SUM1(20,20,4,1),SUM2(20,20,4,1),SUM3(20,20,4,1),
     + SUMDBZ(20,20,4,1),SUMWTSAVE(20,20,4,1)
C 
       OPEN(93,FILE='SUMS')
C 
       DO L2=1,2
C
C       (II,JJ,KK) LOOPS (X,Y,HEIGHT)
C 
        DO KK=KMIN2,KMAX2
         DO JJ=1,JMAXB
          DO II=1,IMAXB
C
C          IF REFLECTIVITY AND DOPPLER VELOCITY EXIST AT (II,JJ,KK) FOR THE FORE
C          OR AFT SCAN, THE WEIGHTED SUM THERE FOR THE FORE OR AFT SCAN IS NORMALIZED 
C          BY THE ACCUMULATED WEIGHT.
C 
           IF(SUMWTSAVE(II,JJ,KK,L2).GT.0..AND.
     +        SUMMER(II,JJ,KK,L2).GT.0..AND.IMXG.EQ.IMAXB.
     +        AND.JMXG.EQ.JMAXB.AND.KMXG.EQ.KMAXB.AND.
     +        UG(II,JJ,KK).GT.-999.)THEN 
            SUM1(II,JJ,KK,L2)=SUM1(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM2(II,JJ,KK,L2)=SUM2(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM3(II,JJ,KK,L2)=SUM3(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM4(II,JJ,KK,L2)=SUM4(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM5(II,JJ,KK,L2)=SUM5(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM6(II,JJ,KK,L2)=SUM6(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM7(II,JJ,KK,L2)=SUM7(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM8(II,JJ,KK,L2)=SUM8(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM9(II,JJ,KK,L2)=SUM9(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM10(II,JJ,KK,L2)=SUM10(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM11(II,JJ,KK,L2)=SUM11(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM12(II,JJ,KK,L2)=SUM12(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            SUM13(II,JJ,KK,L2)=SUM13(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            XWSAVE(II,JJ,KK,L2)=XWSAVE(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            YWSAVE(II,JJ,KK,L2)=YWSAVE(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            ZWSAVE(II,JJ,KK,L2)=ZWSAVE(II,JJ,KK,L2)/
     +          SUMWTSAVE(II,JJ,KK,L2)
            ZE=SUMDBZ(II,JJ,KK,L2)/SUMMER(II,JJ,KK,L2)
C
C           CONVERT AVERAGE POWER TO DBZ
C 
            SUMDBZ(II,JJ,KK,L2)=10.*ALOG10(ZE)
C
C           IF NO DOPPLER VELOCITY AT (II,JJ,KK), BUT REFLECTIVITY EXISTS,
C           COMPUTE AVERAGE REFLECTIVITY. ALL OTHER SUMMATIONS ARE ZERO AT
C           THAT GRID POINT.
C 
           ELSEIF(SUMMER(II,JJ,KK,L2).GT.0.)THEN
            ZE=SUMDBZ(II,JJ,KK,L2)/SUMMER(II,JJ,KK,L2)
            SUMDBZ(II,JJ,KK,L2)=10.*ALOG10(ZE)
            SUMWTSAVE(II,JJ,KK,L2)=0.
            SUM1(II,JJ,KK,L2)=0.
            SUM2(II,JJ,KK,L2)=0.
            SUM3(II,JJ,KK,L2)=0.
            SUM4(II,JJ,KK,L2)=0.
            SUM5(II,JJ,KK,L2)=0.
            SUM6(II,JJ,KK,L2)=0.
            SUM7(II,JJ,KK,L2)=0.
            SUM8(II,JJ,KK,L2)=0.
            SUM9(II,JJ,KK,L2)=0.
            SUM10(II,JJ,KK,L2)=0.
            SUM11(II,JJ,KK,L2)=0.
            SUM12(II,JJ,KK,L2)=0.
            SUM13(II,JJ,KK,L2)=0.
            XWSAVE(II,JJ,KK,L2)=1000.
            YWSAVE(II,JJ,KK,L2)=1000.
            ZWSAVE(II,JJ,KK,L2)=1000.
C
C           IF NOTHING EXISTS AT (II,JJ,KK) THEN SUMMATIONS ARE ZERO AND THE 
C           REFLECTIVITY IS FLAGGED.
C 
           ELSE
            SUMWTSAVE(II,JJ,KK,L2)=0.
            SUM1(II,JJ,KK,L2)=0.
            SUM2(II,JJ,KK,L2)=0.
            SUM3(II,JJ,KK,L2)=0.
            SUM4(II,JJ,KK,L2)=0.
            SUM5(II,JJ,KK,L2)=0.
            SUM6(II,JJ,KK,L2)=0.
            SUM7(II,JJ,KK,L2)=0.
            SUM8(II,JJ,KK,L2)=0.
            SUM9(II,JJ,KK,L2)=0.
            SUM10(II,JJ,KK,L2)=0.
            SUM11(II,JJ,KK,L2)=0.
            SUM12(II,JJ,KK,L2)=0.
            SUM13(II,JJ,KK,L2)=0.
            XWSAVE(II,JJ,KK,L2)=1000.
            YWSAVE(II,JJ,KK,L2)=1000.
            ZWSAVE(II,JJ,KK,L2)=1000.
            SUMDBZ(II,JJ,KK,L2)=FLAG
           ENDIF
C 
          ENDDO
C 
          WRITE(93,*)'L2,KK,JJ = ',L2,KK,JJ
          WRITE(93,*)'SUMWTSAVE = '
          WRITE(93,8602)(SUMWTSAVE(II,JJ,KK,L2),II=1,IMAXB)
          WRITE(93,*)'SUMMER = '
          WRITE(93,8602)(SUMMER(II,JJ,KK,L2),II=1,IMAXB)
          WRITE(93,*)'SUM2 = '
          WRITE(93,8602)(SUM3(II,JJ,KK,L2),II=1,IMAXB)
          WRITE(93,*)'SUM4 = '
          WRITE(93,8602)(SUM4(II,JJ,KK,L2),II=1,IMAXB)
          WRITE(93,*)'SUM9 = '
          WRITE(93,8602)(SUM9(II,JJ,KK,L2),II=1,IMAXB)
8602      FORMAT(8E14.4)
C 
         ENDDO
        ENDDO    
C   
       ENDDO
C 
      ENDIF
C 
      CLOSE(93)
C 
      RETURN
      END
C
C  *********************************************************************
C 
      SUBROUTINE VRLOCATE(OLAT,OLON,TIMES,
     + RLAT,RLON,ALT,ELEV,AZIM,RANGE,XR,YR,ZR,
     + SMOTIONU,SMOTIONV,ISCANDIM,CENTIME,IBINS,WEIGHT,VR,ISCANMAX)
C
C     SUBROUTINE CALLED BY ABCD
C       
C ... FUNCTION:   
C       
C     THIS SUBROUTINE LOCATES AN OBSERVATION PROPERLY WITHIN THE 
C     INTERPOLATION COORDINATE GRID.
C       
C ... VRLOCATE SUBPROGRAM REFERENCES:      
C       
C          NONE     
C 
C ... IMPORTANT FLAGS: <()> INDICATES DEFAULT
C          
C          NONE
C      
C     VERSION:  <TBD>
C       
C     CODE WRITTEN BY:  JOHN GAMACHE   
C                       HRD/AOML/NOAA          
C                       MIAMI, FL 33149      
C       
C     FOR ADDITIONAL DETAILS ON THE ALGORITHM SEE TBD
C       
C     BASED ON THEORY BY:  <TBD>
C       
C     REFERENCE THE BOOK:  <TBD>
C       
C     **************************************************  
C     *               IMPORTANT NOTE                   *  
C     *                                                *  
C     *                    <TBD>                       *  
C     *                                                *  
C     **************************************************         
C
C     SPECIFICATIONS FOR ARGUMENTS
C 
      INTEGER ISCANDIM,ISCANMAX,IBINS
      REAL OLAT,OLON,TIMES,RLAT,RLON,ALT,ELEV,AZIM
      REAL SMOTIONU,SMOTIONV,CENTIME
      REAL RANGE(ISCANDIM),XR(ISCANDIM),YR(ISCANDIM),ZR(ISCANDIM)
      REAL WEIGHT(200),VR(512)
C 
C ... DESCRIPTION OF ARGUMENTS
C
C     OLAT,OLON           - LAT,LON OF GRID ORIGIN (STORM CENTER)
C     TIMES               - TIME OF GIVEN RADIAL (S)
C     RLAT,RLON,ALT       - RADAR LAT,LON,ALTITUDE FOR GIVEN RADIAL
C     ELEV                - ELEVATION ANGLE FOR GIVEN RADIAL (EARTH RELATIVE, DEG)
C     AZIM                - AZIMUTH ANGLE FOR GIVEN RADIAL (EARTH RELATIVE, DEG)
C     RANGE               - GATE RANGE FOR GIVEN RADIAL
C     XR,YR,ZR            - (X,Y,Z) DISTANCE OF DATUM FROM GRID ORIGIN (KM)
C     SMOTIONU,SMOTIONV   - STORM MOTION (M/S)
C     ISCANDIM            - RANGE GATE DIMENSION OF ARRAYS 
C     CENTIME             - ANALYSIS TIME (S)
C     WEIGHT              - 
C     VR                  - 
C     ISCANMAX            - MAX NUMBER OF RANGE GATES INCLUDED
C     IBINS               - 
C
C     SPECIFICATIONS FOR LOCAL VARIABLES 
C 
      INTEGER I 
      REAL RALT,PI,DTR,REARTH,TDIFF,XSHIFT,YSHIFT,RAZIM,RELEV
      REAL XRADAR,YRADAR,RADNEW,DELANGLE,DISTANCE,HEIGHT
      REAL DELX,DELY,XLAT,DX,DY
C 
      PI=ASIN(1.0)*2.
      DTR=PI/180.
      REARTH=6366.
C 
C     RADAR ALTITUDE IN KM
C 
      RALT=ALT/1000.
C 
C ... COMPUTE X AND Y DISPLACEMENT (KM) BASED ON STORM MOTION 
C     AND DEPARTURE FROM ANALYSIS TIME. FOR EXAMPLE, STORM IS MOVING
C     DUE EAST AND THE OBS IS MADE 10 MIN AFTER CENTIME...XSHIFT>0
C 
      TDIFF=TIMES-CENTIME
      XSHIFT=TDIFF*SMOTIONU/1000.
      YSHIFT=TDIFF*SMOTIONV/1000.   
C 
C     AZIMUTH AND ELEVATION ANGLES IN RADIANS
C   
      RAZIM=AZIM*DTR
      RELEV=ELEV*DTR
C 
C     (I) LOOPS (GATES)
C 
      DO I=1,ISCANMAX
C
C      XRADAR/YRADAR IS HORIZONTAL/VERTICAL DISTANCE FROM AIRCRAFT.
C      YRADAR INCLUDES DISTANCE FROM CENTER OF EARTH TO AIRCRAFT.
C      RELEV=90 WOULD HAVE NO HORIZ. PROJECTION.
C 
       XRADAR=RANGE(I)*COS(RELEV)
       YRADAR=REARTH+RALT+RANGE(I)*SIN(RELEV)
C
C      RADNEW IS DISTANCE OF DATUM FROM CENTER OF EARTH
C 
       RADNEW=SQRT(XRADAR*XRADAR+YRADAR*YRADAR)
C
C      DELANGLE IS ANGLE BETWEEN VERTICAL AT AIRCRAFT AND VERTICAL AT DATUM
C 
       DELANGLE=ATAN(XRADAR/YRADAR)
C
C      DISTANCE IS GREAT CIRCLE DISTANCE FROM RADAR TO DATUM
C 
       DISTANCE=.5*(RADNEW+REARTH+RALT)*DELANGLE
C
C      HEIGHT IS ALTITUDE OF DATUM
C 
       HEIGHT=RADNEW-REARTH
C
C      DELX/DELY IS EAST-WEST/NORTH-SOUTH COMPONENT OF AIRCRAFT-DATUM GREAT CIRCLE DISTANCE 
C 
       DELX=DISTANCE*SIN(RAZIM)
       DELY=DISTANCE*COS(RAZIM)
C
C      DX/DY IS EAST-WEST/NORTH-SOUTH DISTANCE FROM GRID ORIGIN TO AIRCRAFT
C 
       XLAT=.5*(RLAT+OLAT)*DTR
       DX=(RLON-OLON)*DTR*REARTH*COS(XLAT)
       DY=(RLAT-OLAT)*DTR*REARTH
C
C      XR/YR IS COMPONENT DISTANCE OF DATUM FROM GRID ORIGIN:
C      X/YSHFT + (DELX/Y + DX/Y) --> GRID ORIGIN TO DATUM DISTANCE
C      SUBTRACTING X/YSHIFT ADVECTS DATUM TO CENTIME USING STORM MOTION.
C 
       XR(I)=DELX+DX-XSHIFT
       YR(I)=DELY+DY-YSHIFT
       ZR(I)=HEIGHT
C 
      ENDDO
C 
      CONTINUE
      RETURN
      END
C
C  *********************************************************************
C 
      SUBROUTINE WRITEU(U,IMAX,JMAX,KMAX)
C 
      REAL U(IMAX,JMAX,KMAX)
C 
      WRITE(6,*)'ENTERED WRITEU'
      WRITE(6,*)'IMAX,JMAX,KMAX = ',IMAX,JMAX,KMAX
      DO K=1,KMAX
       WRITE(6,*)'KMAX = ',KMAX
       DO J=1,JMAX
        WRITE(6,*)'JMAX = ',JMAX
        WRITE(6,*)'WRITEU J,K,U = ',J,K,(U(I,J,K),I=1,IMAX)
       ENDDO
      ENDDO
C 
      RETURN
      END


