	Subroutine AssignVar(id,nid,flag2)

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer nid,id(nid),flag2

	IF (flag2.EQ.0) THEN
	 Call AssignId(id,nid)
	 Call AssignDefault
	ELSEIF (flag2.EQ.1) THEN
	 Call AssignMisc
	ENDIF

	Return
	End
**************************************************
	Subroutine AssignId(id,nid)
	
	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'
	
	Integer nid,id(nid)

C Assign data from array id
C Scan mode (ie: COP,AIR...etc)
	Call GetScanMode(id,nid)
C Coordinate origin data 
	Call GetOrig(id,nid)
C Time & date info
	Call GetTime(id,nid)
C Coordinate info 
	Call GetCoord(id,nid)
C Calculate variables used in contour routine
	Call CalcContour(id,nid)

	Return
	End
**************************************************
	Subroutine AssignDefault
	
	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'
	
	Data pri_grid1,pri_grid2,sec_grid1,sec_grid2/10,10,1,1/
	Data orient,title_flag,grid_flag,scale_pos/'P','ON','BOTH','HOR'/
*	Data template/1/
	Data cont_offset,zero_linewidth,linewidth,dash_on,dash_off,
     +		dash_beg
     +  /20,1.5,.5,6,3,0/
	Data ptskip,vec_speed,vec_length,arrow_h,arrow_hh,arrow_ht
     +  /-1,20.,5.,.20,.18,.05/
	Data font_title,font_num,font_label,stretch_horiz,stretch_vert,
     +  sp_horiz_text,sp_vert_text,sp_scale,page_w,page_h
     +  /15,8,10,1.,1.,.5,.5,.5,21.59,27.94/
	Data l_marg,r_marg,t_marg,b_marg/1.,1.,1.,1./
	Data sp_row,sp_col/1.,1./
	Data scale_w,scale_h/.75,10./
	Data spacex,spacey/1,1/
	Data num_text_flds/16/
	Data num_colors/42/

C 17 June 1997 Added defaults for non_uniform contour intervals:
	Data non_uniform, fill_nonunif, nofill_nonunif/0,0,0/
C The default values for horiz_beg,horiz_end,horiz_inc,horiz_num,vert_beg,
C vert_end,vert_inc,vert_num,fix_beg,fix_end,fix_inc,fix_num are based
C on the header info & are assigned in AssignId.f

	Return
	End
**************************************************
	Subroutine AssignMisc

C This subroutine assigns values to the variables utilized in WritePS

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer flag
	Real temp1,temp2

	Data vec1,vec2,cont1,cont2/1,2,3,4/
	
C Calculate number of points in horizontal & vertical direction
	Call CalcNumPts
C Calculate orient
	Call CalcOrient
C Change page_w & page_h if orientation=L
	Call CalcPage
C Calculate num_ht, title_ht, label_ht
	Call TextHt 
C Calculate size of panel
	Call CalcPanel
C Calculate the maximum dimensions of box in cm
	flag=0
	Call CalcBox (flag)
	Call CalcKm
C Calculate the actual dimensions of box in cm
	flag=1
	Call CalcBox (flag)
C Calulate shift_horiz, shift_vert
	Call TransOrigin
C Calculate horiz_axis, vert_axis
	Call CalcAxis
C Calculate vec_scale
	Call CalcScale
C Calculate xpos1,ypos1..xposn,yposn
	Call CalcPos
C Calculate number of boxes for gray/color scale
	Call CalcNumBox
C Calculate the beginning & ending tick marks (horizontal & vertical)
	temp1=horiz_beg
	temp2=aint(horiz_beg)
	Call CalcTick (temp1,temp2,pri_grid1,tick_hbeg1,tick_hbeg2)
	temp1=vert_beg
	temp2=aint(vert_beg)
	Call CalcTick (temp1,temp2,pri_grid2,tick_vbeg1,tick_vbeg2)
C Assign box position labels
	Call AssignStr
C Calculate the number of plots
*	Call CalcNumPlot
C Calculate the name of the unit based on the fixed axis
	Call CalcUnit
C Calculate variables used in contour routine
*	Call CalcContour
C Calculate the Scale width & height based on choice of template
*	Call CalcScaleDim

	Return
	End
**************************************************
	Subroutine TextHt 

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

C Calculate the heights of the text (in cm) based on the font size using 
C the fact that 1 pt=.025 cm

C text height
	label_ht=font_label*.025
	title_ht=font_title*.025
	num_ht=font_num*.025
	num_w=font_num*.025
	
	Return
	End
**************************************************
	Subroutine CalcMarg

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

C Calculate right or bottom margin based on where the scale is
C The appropriate margins should allow room for the scale
	IF (plot_type.NE.1) THEN
	 IF (scale_pos.EQ.'VER'.OR.scale_pos.EQ.'ver') THEN
	  r_marg=r_marg + num_ht + sp_vert_text + scale_w + sp_scale
	 ELSEIF (scale_pos.EQ.'HOR'.OR.scale_pos.EQ.'hor') THEN
	  b_marg=b_marg + num_ht + sp_horiz_text + scale_w + sp_scale
	 ENDIF
	ENDIF
	
	Return
	End
**************************************************
	Subroutine CalcPanel

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer panelh 

C Calculate width & height of panel based on the value of template
C panel_w & panel_h reflect actual sizes based on the page width & height 

C Calculate the space to allow for various labels (only those labels that
C will be on every plot, such as the numbers, will be included in the
C panel width & height)
	sp_left_label=label_ht+sp_vert_text
	sp_right_label=0
C sp_horiz_text*1.5 allow more spacing for the top & bottom titles
	sp_top_label=title_ht+(sp_horiz_text*1.5)
	sp_bottom_label=(label_ht*4)+(sp_horiz_text*3)
*	sp_bottom_label=(label_ht*5)+(sp_horiz_text*4)
     $  +(sp_horiz_text*1.5)
	IF (plot_type.NE.1) THEN
	 IF (scale_pos.EQ.'VER'.OR.scale_pos.EQ.'ver') THEN
	  sp_right_label=sp_right_label+num_ht+sp_vert_text
     $    +scale_w+sp_scale
	 ELSEIF (scale_pos.EQ.'HOR'.OR.scale_pos.EQ.'hor') THEN
	  sp_bottom_label=sp_bottom_label+num_ht+sp_horiz_text
     $    +scale_w+sp_scale
	 ENDIF
	ENDIF
	
C Determine vertical divisions
	IF (template.LE.5.OR.template.EQ.11) THEN
	 panel_w=page_w-r_marg-sp_right_label-l_marg-sp_left_label
	ENDIF
	IF ((template.GT.5.AND.template.LE.10).OR.template.EQ.12.OR.
     $ template.EQ.13) THEN
	 panel_w=(page_w-r_marg-sp_right_label-l_marg-sp_left_label)/2
	ENDIF
C Determine number of horizontal divisions of the page 
	IF (template.EQ.1.OR.template.EQ.6.OR.template.EQ.11.OR.
     $  template.EQ.12) THEN
	 panelh=1
	ELSEIF (template.EQ.2.OR.template.EQ.7.OR.template.EQ.13) THEN
	 panelh=2
	ELSEIF (template.EQ.3.OR.template.EQ.8) THEN
	 panelh=3
	ELSEIF (template.EQ.4.OR.template.EQ.9) THEN
	 panelh=4
	ELSEIF (template.EQ.5.OR.template.EQ.10) THEN
	 panelh=5
	ENDIF
C Finally, calculate the panel height
	panel_h=(page_h-b_marg-sp_bottom_label-t_marg
     $  -sp_top_label)/panelh

	Return
	End	
**************************************************
	Subroutine CalcBox (flag)

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer flag
	Real term1,term2,term3,term4,term5,term6,term7,term8,term9

C If flag = 0 then calculate the maximum dimensions of box in cm (not using
C stretch factors.  Use these values to determine the value of a km in cm.	
	IF (flag.EQ.0) THEN
C Calculate the maximum dimensions (in cm) of the box
	 term1=panel_w
	 term2=sp_vert_text
	 term3=num_ht
	 term4=label_ht
	 term5=title_ht
	 term6=panel_h
	 term7=sp_horiz_text
	 term8=sp_row
	 term9=sp_col

	IF (template.EQ.1.OR.template.EQ.11) THEN
*	 max_w=panel_w-num_ht-sp_vert_text
*	 max_h=panel_h-num_ht-label_ht-(sp_horiz_text*2)
	 max_w=panel_w-num_w-label_ht-(sp_vert_text*2)
	 max_h=panel_h-num_ht-label_ht-(sp_horiz_text*2)
	ELSEIF (template.NE.1.OR.template.NE.11) THEN
*	 max_w=panel_w-num_ht-sp_vert_text-(sp_col/2)
*	 max_h=panel_h-num_ht-label_ht-(sp_horiz_text*2)-(sp_row/2)
	 max_w=panel_w-num_w-label_ht-(sp_vert_text*2)-(sp_col/2)
	 max_h=panel_h-num_ht-label_ht-(sp_horiz_text*2)-(sp_row/2)
	ENDIF
	
C If flag = 1 then calculate the dimensions of box in cm (using stretch
C factors
	ELSEIF (flag.EQ.1) THEN
C Calculate the actual width & height of box in cm after stretch factor has
C been applied
 	 IF (fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z') THEN
	  box_w=horiz_dist*xkm
	  box_h=vert_dist*ykm
	 ELSEIF (fix_axis.EQ.'Y'.OR.fix_axis.EQ.'y') THEN
	  box_w=horiz_dist*xkm
	  box_h=vert_dist*zkm
	 ELSEIF (fix_axis.EQ.'X'.OR.fix_axis.EQ.'x') THEN
	  box_w=horiz_dist*ykm
	  box_h=vert_dist*zkm
	 ENDIF
	ENDIF

	Return
	End
**************************************************
	Subroutine CalcKm 

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'
	
	Integer warning
	Real max_stretch,temp_horiz_km,temp_vert_km

C Calculate horizontal & vertical distances (in km)
	horiz_dist=horiz_end-horiz_beg
	vert_dist=vert_end-vert_beg

C Calculate the horizontal & vertical value of km in cm (ie: 1 km=? cm)
	temp_horiz_km=max_w/horiz_dist
	temp_vert_km=max_h/vert_dist
	IF (temp_horiz_km.LE.temp_vert_km) THEN
	 temp_vert_km=temp_horiz_km
C Calculate the maximum amount that the vertical axis can be stretched
	 max_stretch=max_h/(temp_vert_km*vert_dist)
	 IF (stretch_vert.GE.max_stretch) THEN
	  warning=10
	  stretch_vert=max_stretch
	 ENDIF
	 temp_vert_km=temp_vert_km*stretch_vert
C Check to make sure horizontal stretch factor is 1
	 IF (stretch_horiz.NE.1.) THEN
	  warning=12
	  stretch_horiz=1.0
	 ENDIF
	ELSEIF (temp_horiz_km.GT.temp_vert_km) THEN
	 temp_horiz_km=temp_vert_km
C Calculate the maximum amount that the horizontal axis can be stretched
	 max_stretch=max_w/(temp_horiz_km*horiz_dist)
	 IF (stretch_horiz.GE.max_stretch) THEN
	  warning=20
	  stretch_horiz=max_stretch
	 ENDIF
	 temp_horiz_km=temp_horiz_km*stretch_horiz
C Check to make sure vertical stretch factor is 1
	 IF (stretch_vert.NE.1.) THEN
	  warning=22
	  stretch_vert=1.0
	 ENDIF
	ENDIF
	
	IF (fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z') THEN
	 xkm=temp_horiz_km
	 ykm=temp_vert_km
	ELSEIF (fix_axis.EQ.'Y'.OR.fix_axis.EQ.'y') THEN
	 xkm=temp_horiz_km
	 zkm=temp_vert_km
	ELSEIF (fix_axis.EQ.'X'.OR.fix_axis.EQ.'x') THEN
	 ykm=temp_horiz_km
	 zkm=temp_vert_km
	ENDIF

C Print warnings
	IF (warning.EQ.10) THEN
10	  Write(92,*)
     +		 'WARNING:  VERTICAL STRETCH FACTOR EXEEDS SIZE OF BOX'
	  Print 11,max_stretch
11	  Format ('SETTING VERTICAL STRETCH FACTOR TO ',F4.2)
	ELSEIF (warning.EQ.12) THEN
12	  Write(92,*) 
     +		'WARNING:  HORIZONTAL STRETCH FACTOR EXEEDS SIZE OF BOX'
	  Write(92,13)stretch_horiz
13	  Format ('SETTING HORIZONTAL STRETCH FACTOR TO ',F4.2)
	ELSEIF (warning.EQ.20) THEN
20	  Write(92,*) 
     +		'WARNING:  HORIZONTAL STRETCH FACTOR EXEEDS SIZE OF BOX'
	  Write(92,21)max_stretch
21	  Format ('SETTING HORIZONTAL STRETCH FACTOR TO ',F4.2)
	ELSEIF (warning.EQ.22) THEN
22	  Write(92,*) 
     +		'WARNING:  VERTICAL STRETCH FACTOR EXEEDS SIZE OF BOX'
	  Write(92,23)stretch_vert
23	  Format ('SETTING VERTICAL STRETCH FACTOR TO ',F4.2)
	ENDIF
	
	Return
	End
**************************************************
**************************************************
	Subroutine CalcOrient

	Implicit none
	Include 'common1.h'
	Include 'common3.h'

C Assign the orientation based on the selected template
	IF (template.LE.10) THEN
	 orient='P'
	ELSEIF (template.GT.10) THEN
	 orient='L'
	ENDIF

	Return
	End
**************************************************
	Subroutine CalcPage

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'
	
	Real temp1,temp2

	IF (orient.EQ.'L'.AND.(page_w.LT.page_h)) THEN 
	 temp1=page_w
	 temp2=page_h
	 page_w=temp2
	 page_h=temp1
	ELSEIF (orient.EQ.'P'.AND.(page_w.GT.page_h)) THEN 
	 temp1=page_w
	 temp2=page_h
	 page_w=temp2
	 page_h=temp1
	ENDIF
	
	Return
	End
**************************************************
	Subroutine TransOrigin
	
	Implicit none
	Include 'common2.h'

C Calculate the amount the grid needs to be shifted

	shift_horiz=0-horiz_beg
	shift_vert=0-vert_beg
	
	Return
	End
**************************************************
	Subroutine CalcAxis

	Implicit none
	Include 'common3.h'

	IF (fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z') THEN
	 horiz_axis='X'
	 vert_axis='Y'
	ELSEIF (fix_axis.EQ.'Y'.OR.fix_axis.EQ.'y') THEN
	 horiz_axis='X'
	 vert_axis='Z'
	ELSEIF (fix_axis.EQ.'X'.OR.fix_axis.EQ.'x') THEN
	 horiz_axis='Y'
	 vert_axis='Z'
	ENDIF

	Return
	End
**************************************************
	Subroutine CalcScale

	Implicit none
	Include 'common2.h'

	vec_scale=vec_length / vec_speed

	Return
	End
**************************************************
	Subroutine CalcPos

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Real term1,term2,term3,term4,term5,term6,term7,term8,term9
	Real paper_w,paper_h 

	term1=r_marg
	term2=l_marg
	term3=t_marg
	term4=b_marg
	term5=sp_horiz_text
	term6=sp_vert_text
	term7=num_ht
	term8=label_ht
	term9=title_ht
	
	IF (template.GE.1.AND.template.LE.10) THEN
	 paper_w=21.59
	 paper_h=27.94
	ELSE
	 paper_w=27.94
	 paper_h=21.59
	ENDIF

C Calculate the position of the panels based on selected template
C Calculate horizontal position
        IF ((template.GE.1.AND.template.LE.5).OR.template.EQ.11) THEN
         xpos1=((paper_w-sp_right_label)/2)-(box_w/2)
        ENDIF

        IF ((template.GE.6.AND.template.LE.10).OR.template.EQ.12
     $.OR.template.EQ.13) THEN
	  xpos1=((paper_w-sp_right_label)/2)-
     $    ((sp_col+label_ht+num_w+(sp_vert_text*2))/2)-box_w
        ENDIF
C Calculate vertical position
        IF (template.EQ.1.OR.template.EQ.11.OR.template.EQ.12) THEN
         ypos1=(paper_h/2)-(box_h/2)
        ENDIF
        IF ((template.GT.1.AND.template.LE.10).OR.template.EQ.13) THEN
         ypos1=b_marg+sp_bottom_label+num_ht+sp_horiz_text
        ENDIF

	Return
	End
**************************************************
	Subroutine CalcNumBox

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'
C Modified for non-uniform contours....17 June 1997
C Calculate the number of contour levels 
	if( non_uniform .eq. 0) then
        	num_box=nint((fill_end-fill_beg)/fill_inc)
		fill_num=(fill_end-fill_beg)/fill_inc
		nofill_num=(nofill_end-nofill_beg)/nofill_inc
	else
		num_box = fill_nonunif
		fill_num = fill_nonunif
		nofill_num = nofill_nonunif
	end if

	IF (color_flag.EQ.'Y'.AND.fill_num.GT.num_colors) THEN
	   Write(92,*)'ERROR!  TOO MANY CONTOUR INCREMENTS'
	   Write(92,*)'MUST BE LESS THAN 42!'
	   stop
	ENDIF

	Return
	End
**************************************************
	Subroutine CalcTick (temp1,temp2,grid,tick,diff)

	Implicit none
	Include 'common1.h'
	Include 'common2.h'

	Integer grid
	Real temp1,temp2,diff,tick
	real real_grid
        real_grid=grid
	tick=0

Cout 	If (mod(temp1,1).NE.0) THEN
C This the way that works in hp f90:
	If (mod(temp1,1.0).NE.0) THEN
	 diff=1-(temp1-temp2)
	else
	 diff=0
	ENDIF

	temp2=temp1+diff

Cout 10	IF (mod(temp2,grid).NE.0) THEN
C Ftn 90 foersnt like mixing int and real so 
10	IF (mod(temp2,real_grid).NE.0) THEN
	 temp2=temp2+1
	 tick=tick+1
	 go to 10
	ENDIF

	tick=tick+diff

	Return
	End
**************************************************
	Subroutine AssignStr

	Implicit none
	Include 'common3.h'

C Assign horizontal position labels for the box 
	strx(1)='xpos1'
	strx(2)='xpos2'
	strx(3)='xpos3'
	strx(4)='xpos4'
	strx(5)='xpos5'
	strx(6)='xpos6'
	strx(7)='xpos7'
	strx(8)='xpos8'
	strx(9)='xpos9'
	strx(10)='xpos10'

C Assign vertical position labels for the box 
	stry(1)='ypos1'
	stry(2)='ypos2'
	stry(3)='ypos3'
	stry(4)='ypos4'
	stry(5)='ypos5'
	stry(6)='ypos6'
	stry(7)='ypos7'
	stry(8)='ypos8'
	stry(9)='ypos9'
	stry(10)='ypos10'

	Return
	End
**************************************************
	Subroutine CalcNumPlot

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	IF (level_type.EQ.0) THEN
	 IF (level_flag.EQ.'D') THEN
	  num_plot=ifix(((dist_end-dist_beg)/dist_inc)+1)
	 ELSEIF (level_flag.EQ.'L') THEN
Cout 	  num_plot=ifix(((lev_end-lev_beg)/lev_inc)+1)
C F90 does not like that. so we try
	  num_plot=ifix(((lev_end-lev_beg)/lev_inc)+1.0)
	 ENDIF
	ENDIF
	
	Return
	End
**************************************************
	Subroutine CalcUnit

	Implicit none
	Include 'common3.h'

        IF (fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z') THEN
         hkm='xkm'
         vkm='ykm'
        ELSEIF (fix_axis.EQ.'Y'.OR.fix_axis.EQ.'y') THEN
         hkm='xkm'
         vkm='zkm'
        ELSEIF (fix_axis.EQ.'X'.OR.fix_axis.EQ.'x') THEN
         hkm='ykm'
         vkm='zkm'
        ENDIF

	Return
	End
**************************************************
	Subroutine GetScanMode(id,nid)

	Implicit none
	Include 'common3.h'

	Integer nid,id(nid)

	IF (id(16).EQ.1095303168.AND.id(17).EQ.1377828864) scan_mode='AIR'
	IF (id(16).EQ.1129250816.AND.id(17).EQ.1347158016) scan_mode='COP'
	IF (id(16).EQ.1129447424.AND.id(17).EQ.1411383296) scan_mode='CRT'

	Return
	End
**************************************************
	Subroutine GetOrig(id,nid)

	Implicit none
	Include 'common1.h'

	Integer nid,id(nid)

	lat_deg=id(33) 
	lat_min=id(34)
	lat_sec=nint(id(35)*.01)
	long_deg=id(36)
	long_min=id(37)
	long_sec=nint(id(38)*.01)
	xhoriz_orig=id(41)
	yhoriz_orig=id(42)
	clockwise_deg=id(40)

	Return
	End
**************************************************
	Subroutine GetTime(id,nid)

	Implicit none
	Include 'common1.h'

	Integer nid,id(nid)

	year_beg=id(116)
	month_beg=id(117)
	day_beg=id(118)
	hour_beg=id(119)
	min_beg=id(120)
	sec_beg=id(121)
	year_end=id(122)
	month_end=id(123)
	day_end=id(124)
	hour_end=id(125)
	min_end=id(126)
	sec_end=id(127)

	Return
	End
**************************************************
	Subroutine GetCoord(id,nid)

	Implicit none
	Include 'common2.h'
	Include 'common3.h'

	Integer nid,id(nid)
	Real sf,km

C header info multiplied by scale factor (1/100)
	sf=.01
C m to km conversion factor (1/1000)
	km=.001

*The choice of fixed axis determines the index of the following
	IF (fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z') THEN
	 horiz_beg=id(160)*sf
	 horiz_end=id(161)*sf
	 horiz_inc=id(163)*km
	 horiz_num=id(162)
	 vert_beg=id(165)*sf
	 vert_end=id(166)*sf
	 vert_inc=id(168)*km
	 vert_num=id(167)
	 fix_beg=id(170)*km
	 fix_end=id(171)*km
	 fix_inc=id(173)*km
	 fix_num=id(172)
	ELSEIF (fix_axis.EQ.'Y'.OR.fix_axis.EQ.'y') THEN
	 horiz_beg=id(160)*sf
	 horiz_end=id(161)*sf
	 horiz_inc=id(163)*km
	 horiz_num=id(162)
	 vert_beg=id(170)*km
	 vert_end=id(171)*km
	 vert_inc=id(173)*km
	 vert_num=id(172)
	 fix_beg=id(165)*sf
	 fix_end=id(166)*sf
	 fix_inc=id(168)*km
	 fix_num=id(167)
	ELSEIF (fix_axis.EQ.'X'.OR.fix_axis.EQ.'x') THEN
	 horiz_beg=id(165)*sf
	 horiz_end=id(166)*sf
	 horiz_inc=id(168)*km
	 horiz_num=id(167)
	 vert_beg=id(170)*km
	 vert_end=id(171)*km
	 vert_inc=id(173)*km
	 vert_num=id(172)
	 fix_beg=id(160)*sf
	 fix_end=id(161)*sf
	 fix_inc=id(163)*km
	 fix_num=id(162)
	ENDIF
	
	save_hbeg=horiz_beg
	save_vbeg=vert_beg

	Return
	End
**************************************************
	Subroutine CalcNumPts

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	horiz_num=((horiz_end-horiz_beg)/horiz_inc)+1
	vert_num=((vert_end-vert_beg)/vert_inc)+1

	Return
	End
**************************************************
	Subroutine CalcContour(id,nid)

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Integer nid,id(nid)

*        ix1=horiz_beg*1000 
*        ix2=horiz_end*1000 
*        iy1=vert_beg*1000 
*        iy2=vert_end*1000 
*        xint=horiz_inc*1000 
*        yint=vert_inc*1000 
*        ii=nint(horiz_num)
*        jj=nint(vert_num)
*        iedge = 0
        IF (fix_axis.EQ.'Z'.OR.fix_axis.EQ.'z') THEN
         ix1 = id(160)*10
         ix2 = id(161)*10
         iy1 = id(165)*10
         iy2 = id(166)*10
         xint = id(163)
         yint = id(168)
         ii=id(162)
         jj=id(167)
        ELSEIF (fix_axis.EQ.'Y'.OR.fix_axis.EQ.'y') THEN
         ix1 = id(160)*10
         ix2 = id(161)*10
         iy1 = id(170)
         iy2 = id(171)
         xint = id(163)
         yint = id(173)
         ii=id(162)
         jj=id(172)
        ELSEIF (fix_axis.EQ.'X'.OR.fix_axis.EQ.'x') THEN
         ix1 = id(165)*10
         ix2 = id(166)*10
         iy1 = id(170)
         iy2 = id(171)
         xint = id(168)
         yint = id(173)
         ii=id(167)
         jj=id(172)
        ENDIF
        iedge = 0


	Return
	End
**************************************************
	Subroutine CalcScaleDim

	Implicit none
	Include 'common1.h'
	Include 'common2.h'
	Include 'common3.h'

	Real temp_box_h

        num_box=nint((fill_end-fill_beg)/fill_inc)
        IF (scale_pos.EQ.'ver') scale_pos='VER'
        IF (scale_pos.EQ.'hor') scale_pos='HOR'

C Assign temporary box height
	IF (template.EQ.1.OR.template.EQ.11.
     $  OR.template.EQ.6.OR.template.EQ.12) THEN
	 temp_box_h=box_h
	ELSEIF (template.EQ.2.OR.template.EQ.7.OR.template.EQ.13) THEN
	 temp_box_h=(box_h*2)+sp_horiz_text+label_ht+sp_row
	ELSEIF (template.GE.3.AND.template.LE.10) THEN
	 temp_box_h=(box_h*3)+(sp_horiz_text*4)+(label_ht*2)+
     $   (num_ht*2)+(sp_row*2)
	ENDIF

C Calculate the height of the scale 
	IF (scale_pos.EQ.'VER') THEN
	 IF (temp_box_h.GT.scale_h) THEN
	  scale_h=temp_box_h
	 ENDIF
	ENDIF

	Return
	End
