      SUBROUTINE UNFLD1(V0,VN,M,IRS,NB,RAY,URAY,NBINS)! Unfold Doppler Ray
C   subroutine to unfold doppler radial velocities
C   Described by D.W. Bargen and R.C. Brown (1980), preprints 
C   19th Radar Meteorology Conference, 278-283. 
C   Implemention of their B-algorithm of automatic unfolding
C   INPUT:
C        V0 - initial estimate of the velocity bias 
C             = wind speed * COS (AZM - wind direction) 
C        VN - nyquist velocity
C        M  - number of gates for averaging interval
C             = 10 - 20 for high shear regimes (convection) 
C             = 50 for low shear regimes (stratiform precip.) 
C        IRS- starting gate # for the unfolding <1 for whole ray> 
C        NB - number of gates to be processed starting at IRS 
C             <256 max for pre 1988 tapes, <512 max 1988 and after
C        RAY- original folded radial velocity estimates 
C   OUTPUT: 
C        URAY - unfolded radial velocity estimates
C   DUMMY ARRAY:
C        DRAY - holds the good (no noise) unfolded values for averaging
C 
      REAL RAY(NBINS),URAY(NBINS),DRAY(512) 
C 
C   calculate initial # of folds
      n = (v0 + sign(1.,v0)*vn) / (2*vn)
C   initialize values for averaging interval
      VNP = VN * M
      NBP = NB + IRS    
      IF(NBP.GT.NBINS) NBP=NBINS
      V0P = V0*M
C   start processing the ray
      IRC=0 
      DO I=1,IRS
       URAY(I)=-888.88
      ENDDO
C      WRITE(6,*)'V0,IRS,RAY(IRS+1) = ',V0,IRS,RAY(IRS+1)
      DO 10 I=IRS+1,NBINS
C          Check for noise flag (-888.88) 
              IF(RAY(I).lt.-800.) then
C          Noise value, set URAY to FLAG and skip unfolding 
                URAY(I)=-888.88 
              else
C          Good velocity start unfolding, store good value in DRAY
                IRC=IRC+1 
C          Check if M good values have been averaged
                IF(IRC.GT.M+1) GO TO 15 
C          If less than M values found
                IF(IRC.gt.1) V0P=V0P+DRAY(IRC-1)-V0
                GO TO 16
C          If more than M values found
15              V0P=V0P+DRAY(IRC-1)-DRAY(IRC-M-1) 
C          Do the unfolding tests (N is the number of folds)
16              VP=M*(RAY(I)+2.*N*VN)
                JL=0
                DO WHILE(ABS(VP-V0P).GT.VNP.AND.JL.LE.3)
                 JL=JL+1
                 VP0=VP/M
                 IF(VP.GT.V0P+VNP)N=N-1
                 IF(VP.LT.V0P-VNP)N=N+1
                 VP=M*(RAY(I)+2.*N*VN)
                ENDDO
                URAY(I)=RAY(I)+2.*N*VN
                DRAY(IRC)=URAY(I) 
              endif 
10            CONTINUE
      RETURN
      END 
