C these subs use my pseudo-Sigmet calls...
C 17 June 1998: To speed this up I made special versions of 
C tvline that do not Xflush after each segment. Rather an explicit
C flush call must be made after drawing a bunch of segments.
	subroutine x_tv_map(color, geofil, rlat, rlon, xl, yb,
     +		idim, jdim, sx, sy, xrad, yrad, im_struct)
C draw a map, scaling can differ between x and y
C radar lat and lon: rlat,rlon
C lower left corner of plot window in pixels: xl, yb
C width and height in pixels: idim, jdim
C width and height in km: xkm, ykm
C position of radar in km: xrad, yrad
	integer color
	character geofil*32
	real rlat, rlon, xl, yb
	integer idim, jdim
	real sx, sy, xrad, yrad
	integer*4 im_struct(47)
C
	integer hemis
	real w(4)
	real kmdeglat, kmdeglon 
	logical lamcon
C
	xkm = idim * sx
	ykm = jdim * sy
	hemis = 1 ! N hemisphere
	lamcon = .true.
C
	if( geofil(1:4) .eq. 'none') then
		return
	end if
	call setmap(rlat,rlon,xrad,yrad,xkm,ykm,XLATMN,XLATMX,
     +        		XLONMN,XLONMX,kmdeglat,kmdeglon)
C
	w(1) = xl
	w(2) = yb
	w(3) = w(1) + idim - 1
	w(4) = w(2) + jdim - 1
	pkm_x = 1.0 / sx ! pixels per km in x direction
	pkm_y = 1.0 / sy
	radkm = max(xkm-xrad, ykm - yrad)
	call set_varproj(xrad, yrad, pkm_x, pkm_y,
     +		    rlat, rlon, radkm, cone, xsc, ysc, xc, yc, hemis) 
	call x_drawmap(geofil, color, lamcon,
     +		XLATMN,XLATMX,XLONMN,XLONMX, 
     +        	xc,yc,xsc,ysc,cone,rlon,hemis, w, im_struct)
	call x_tvflush(im_struct)
	end
C ----------      
	subroutine set_varproj(xkm, ykm, p_km_x,
     +	  p_km_y, clat, clon, radkm, cone, xsc, ysc, xc, yc, hemis) 
C set factors to use lambert confromal proj and 
C return scaling so that u,v can be translated into 
C km relative to clat and clon.
      real kmdeglat, kmdeglon 
      integer hemis 
      parameter(for5=0.7853982,pi180=.0174533)
c REMOVED REFERENCE TO COSD ON 19 APRIL 2007
      kmdeglat = 111.13209-0.56605*cos(2.*clat*pi180)+
     +        0.00012*cos(4.0*clat*pi180)-0.000002*cos(6.*clat*pi180) 
      kmdeglon = 111.41513*cos(clat*pi180)-0.09455*cos(3.*clat*pi180)+
     +        0.00012*cos(5.*clat*pi180)
	th1 = (clat + radkm / kmdeglat)*pi180 
        th2 = (clat - radkm / kmdeglat)*pi180 
c     write(6,*)'parallels:',th1/pi180,th2/pi180
C cone factor:
        cone=log10(cos(th1))-hemis*log10(cos(th2))
        cone=cone/(log10(tan(for5-hemis*th1*0.5))-
     +        log10(tan(for5-hemis*th2*0.5))) 
C scaling and translation factors:
        call lam_proj(clat,clon,ucen,vcen,cone,clon,hemis)
        ylat_s = clat - ykm / kmdeglat ! radkm km South of clat
        call lam_proj(ylat_s,clon,uup,vup,cone,clon,hemis) 
        ysc =  ykm * p_km_y / (vcen - vup) 
        xlon_w = clon - xkm / kmdeglon ! radkm km South of clat
        call lam_proj(clat, xlon_w, uup,vup,cone,clon,hemis) 
        xsc =  xkm * p_km_x / (ucen - uup) 
        xc = -ucen * xsc + xkm * p_km_x
        yc = -vcen * ysc + ykm * p_km_y
C	WRITE(6,*)' xc, yc, xsc, ysc: ',xc,yc,xsc,ysc
      return
      end 
C **********************************
      subroutine setmap(olat,olon,xkm,ykm,xext,yext,XLATMN,XLATMX,
     +        XLONMN,XLONMX,kmdeglat,kmdeglon)
      real kmdeglat,kmdeglon
C  THIS subroutine CALCULATES THE MIN AND MAX LATITUDE AND
C  LONGITUDE FOR THE CURRENT window.
C  SET SCALE FACTOR TO KILOMETERS PER DEGREE AVERAGE
      radlat=olat*0.0174533 ! degrees to radians
C trig series from Bowditch:
      kmdeglat=111.13209-0.56605*cos(2.*radlat)+
     +        0.00012*cos(4.0*radlat)-0.000002*cos(6.*radlat) 
      kmdeglon=111.41513*cos(radlat)-0.09455*cos(3.*radlat)+
     +        0.00012*cos(5.*radlat)
C  CALCULATE MAP LAT AND LON LIMITS. LONGITUDE VALUES INCREASE
C  TO THE LEFT (WEST OF 0 DEGREES). 
      XLATMN = OLAT - YKM / kmdeglat
      XLATMX = OLAT + (YEXT-YKM) / kmdeglat 
      XLONMn = OLON - XKM / kmdeglon
      XLONMx = OLON + (XEXT - XKM) / kmdeglon 
      return
      END 
C ******************************* 
      SUBROUTINE x_drawmap(fil, color, lamcon,
     +		XLATMN,XLATMX,XLONMN,XLONMX, 
     +        xcen,ycen,xscale,yscale,cone,cenlon,hemis, w, im_struct)
C  THIS  TAKES AS INPUT THE MAP LIMITS FOR THE CURRENT
C  COMPOSITE AND PLOTS THE GEOGRAPHY WITHIN THOSE LIMITS. 
C Stolen by Peter d. from PAL and modified to ask no questions. 
C fil determines which geography data file to use, lamcon determines
C whether to use lambert conformal conic or flat earth proj.
C West Hemisphere lons are <0.
      integer hemis ! +1=N. Hemisphere, -1=S. Hemisphere
      DIMENSION RBUF(2,100) 
      CHARACTER*32 fil, head*28
      logical lamcon, visible
	real w(4) ! clipping window, in inches.
	integer color
	integer*4 im_struct(47)
C
	lp = 14
	xl = w(1)
	yb = w(2)
C  OPEN DATA FILE which on HP-UX is unformatted file
700   OPEN(LP,FILE=fil,status='old',form = 'unformatted',
     +		IOSTAT=IERR,ERR=100)
C  READ DATA FILE MAPPING LIMITS
	read(lp)head ! this because header is ASCII !
      READ(head,65,IOSTAT=IERR,ERR=150) YMIN,YMAX,XMIN,XMAX 
65    FORMAT(4F7.2) 
C  WRITE DATA FILE MAPPING LIMITS TO CNS
C     WRite(6,'("MAP FILE LATITUDE LIMITS ",2(F7.2,1X))') YMIN,YMAX 
C     WRite(6,'("MAP FILE LONGITUDE LIMITS ",2(F7.2,1X))') XMIN,XMAX
C  READ LOOP
	xp = 0.0
	yp = 0.0
201   CONTINUE
Cout      if(ifbrk().lt.0) go to 600 ! close file, then return
      READ(LP,IOSTAT=IERR,ERR=900,END=600)((RBUF(I,J),I=1,2),J=1,100) 
      DO 300 ICNT=1,100 
C  CHECK FOR PEN-UP MARKER
      IF(RBUF(1,ICNT).EQ.-200.)GO TO 11 
C  READ LATS AND LONS 
      RLAT=RBUF(2,ICNT) 
      RLON=RBUF(1,ICNT) 
C primitive clipping:
C  CHECK COORDINATES TO SEE IF WITHIN MAP LIMITS
	IF( (RLAT .GT. XLATMX) .OR. (RLAT .LT. XLATMN) .or.
     +	  (RLON .GT. XLONMX) .OR. (RLON .LT. XLONMN) ) then
		go to 11
	end if
C  CALCULATE LOCATIONS 
      if(.not.lamcon)then 
        u=(rlon-xlonmn) 
        v=(rlat-xlatmn) 
      else ! use lambert conformal conical proj 
        call lam_proj(rlat,rlon,u,v,cone,cenlon,hemis)
      endif 
      x = xl + u * xscale + xcen 
      y = yb + v * yscale + ycen 
C  WRITE OUT COORDINATES AND PEN VALUES 
cD      WRite(6,871)X,Y,RLAT,RLON,IP 
cD 871  FORMAT(' X,Y ',2F10.2,' LAT,LON ',2F10.2,I5) 
C  MOVE TO NEXT POINT WITH PEN UP OR DOWN 
c     IF (IP.EQ.2) CALL TVLABS (IX,IY,icolor) ! PEN DOWN
c     IF (IP.EQ.3) CALL TVSETC(IX,IY) ! PEN UP
	if( ip .eq. 3)then ! pen up move
		xp = x
		yp = y
	else if(ip .eq. 2) then ! pen down, so clip:
		call wclip(xp,yp,x,y,w,visible, ic_code) 
		if(visible)then 
		   ixp = xp
		   iyp = yp
		   ix = x
		   iy = y
		   call x_tvline_nf(ixp,iyp,ix,iy,color,im_struct)
		end if
		xp = x
		yp = y
	end if
      IP=2
      GO TO 300 
11    IP=3
300   CONTINUE
      GO TO 201 
100   WRite(6,'("OPEN ERROR ",I5," ON FILE ",a32,)') IERR,fil 
      GO TO 600 
150   WRite(6,'("READ ERROR ",I5," ON FILE ",a32,)') IERR,fil 
600   CONTINUE
      CLOSE(LP) ! CLOSE DATA FILE 
      RETURN ! RETURN TO CALLING SEGMENT
900   WRite(6,'("ERROR ",I5," ON FILE ",I3)')IERR,LP
      GO TO 201 
      END 
C ******************************* 
      subroutine lam_proj(rlat,rlon,u,v,cone,cenlon,hemis)
C lifted out of NCAR Supmap documentation 
      parameter(for5=0.7853982,pi180=.0174533)
      integer hemis ! +1= N. Hemisphere, -1= S. Hemisphere
      rfac=(tan(for5-hemis*rlat*0.5*pi180))**cone 
      u=rfac*sin(cone*(rlon-cenlon)*pi180)
      v=-hemis*rfac*cos(cone*(rlon-cenlon)*pi180) 
cd     write(6,*)'rfac,u,v',rfac,u,v 
      return
      end 
C
	subroutine inv_lam_proj(u,v,rlat,rlon,cone,cenlon,hemis)
C Inverse of lambert conformal
      parameter(for5=0.7853982)
      integer hemis ! +1= N. Hemisphere, -1= S. Hemisphere
	rad2deg = 180.0 / acos(-1.0)
	rfac = sqrt(u*u + v*v)
	stuff = atan(rfac**(1.0/cone))
	rlat = (for5-stuff)*2.0*hemis * rad2deg
	stuff = atan2(u, -v)
	rlon = (stuff / cone) * rad2deg + cenlon
	return
	end	

C -------------------------------------
C
	subroutine x_tv_flight_track(start_time, end_time,
     +		dt, color, rlat, rlon, xl, yb,
     +		idim, jdim, sx, sy, xrad, yrad, im_struct)
C radar lat and lon: rlat,rlon
C lower left corner of plot window in pixels: xl, yb
C width and height in pixels: idim, jdim
C width and height in km: xkm, ykm
C position of radar in km: xrad, yrad
	integer color
	real rlat, rlon, xl, yb
	integer idim, jdim
	real sx, sy, xrad, yrad
	integer*4 im_struct(47)
C
	integer hemis
	real w(4)
	real kmdeglat, kmdeglon 
	logical lamcon
C
	xkm = idim * sx
	ykm = jdim * sy
	hemis = 1 ! N hemisphere
	lamcon = .true.
C
	call setmap(rlat,rlon,xrad,yrad,xkm,ykm,XLATMN,XLATMX,
     +        		XLONMN,XLONMX,kmdeglat,kmdeglon)
C
	w(1) = xl
	w(2) = yb
	w(3) = w(1) + idim - 1
	w(4) = w(2) + jdim - 1
	pkm_x = 1.0 / sx ! pixels per km in x direction
	pkm_y = 1.0 / sy
	radkm = max(xkm-xrad, ykm - yrad)
	call set_varproj(xrad, yrad, pkm_x, pkm_y,
     +		    rlat, rlon, radkm, cone, xsc, ysc, xc, yc, hemis) 
	call x_draw_ram(start_time, end_time, dt, cone, rlon, hemis, 
     +        xsc, ysc, xc, yc, w, color, im_struct)
	call x_tvflush(im_struct)
	return
	end
C ------------------------------------------------------
      subroutine x_draw_ram(t1,t2,dt,cone,cenlon,hemis, 
     +        xscale,yscale,xcen,ycen,w, color, im_struct)
	real t1,t2,dt,cone,cenlon
	integer hemis ! +1 for northern hemis
	real xscale,yscale,xcen,ycen,w(4)
	integer color
	integer*4 im_struct(47)
C
	logical vis
	real u,v
C 
	xl = w(1)
	yb = w(2)
cd	write(6,*)' xc, yc, xsc, ysc: ',xcen,ycen,xscale,yscale
	time = t1
10      call readramfile(time, trec, ylat, xlon, ralt, wd, ws,
     +		ucom, vcom, vws, wg, ios)
cd	write(6,*)' ram start lat lon:',ylat,xlon
      call lam_proj(ylat,xlon,u,v,cone,cenlon,hemis)
      x = xl + u * xscale + xcen 
      y = yb + v * yscale + ycen
cd     write(6,*)' Start lat, lon and plot coords: ',ylat, xlon,x,y
      xs = x
      ys = y
      time = time + dt
      do while(time.le.t2)
		call readramfile(time, trec, ylat, xlon,
     +			 ralt, wd, ws, ucom, vcom, vws, wg, ios)
cd	WRITE(6,*)'read ram for time',time,'ios = ',ios
		call lam_proj(ylat,xlon,u,v,cone,cenlon,hemis)
		x = xl + u * xscale + xcen 
		y = yb + v * yscale + ycen
cd             write(6,*)' lat, lon and plot coords: ',ylat, xlon,x,y
		call wclip(xs,ys,x,y,w,vis, ic_code)
		if(vis)then
			ixs = xs
			iys = ys
			ix = x
			iy = y
		 call x_tvline_nf(ixs,iys,ix,iy,color,im_struct)
		end if
		xs = x
		ys = y
		time = time + dt
      end do
      return
      end 
C -------------------
	subroutine x_tv_geo_box(color, rlat, rlon, xl, yb,
     +			idim, jdim, sx, sy, xrad, yrad, 
     +			box_lat, box_lon, box_wid, box_ht, im_struct)
	integer color
	real rlat, rlon, box_lat, box_lon, box_wid, box_ht,xl, yb
	integer idim, jdim
	real sx, sy, xrad, yrad
	integer*4 im_struct(47)
C
	integer hemis
	real w(4)
	real kmdeglat, kmdeglon 
	logical lamcon, visible
C
	xkm = idim * sx
	ykm = jdim * sy
	hemis = 1 ! N hemisphere
	lamcon = .true.
C
	call setmap(rlat,rlon,xrad,yrad,xkm,ykm,XLATMN,XLATMX,
     +        		XLONMN,XLONMX,kmdeglat,kmdeglon)
C
	w(1) = xl
	w(2) = yb
	w(3) = w(1) + idim - 1
	w(4) = w(2) + jdim - 1
	pkm_x = 1.0 / sx ! pixels per km in x direction
	pkm_y = 1.0 / sy
	radkm = max(xkm-xrad, ykm - yrad)
	call set_varproj(xrad, yrad, pkm_x, pkm_y,
     +		    rlat, rlon, radkm, cone, xsc, ysc, xc, yc, hemis) 
        call lam_proj(box_lat,box_lon,u,v,cone,rlon,hemis)
	bx = xl + u * xsc + xc 
      	by = yb + v * ysc + yc 
	x1 = bx
	y1 = by
	x2 = x1
	y2 = y1 + box_ht * pkm_y
	call wclip(x1,y1,x2,y2,w,visible, ic_code) 
	if(visible)then 
		   ixp = x1
		   iyp = y1
		   ix = x2
		   iy = y2
		   call x_tvline(ixp,iyp,ix,iy,color,im_struct)
	end if
	x1 = bx
	y1 = by
	x2 = x1 + box_wid * pkm_x
	y2 = y1 
	call wclip(x1,y1,x2,y2,w,visible, ic_code) 
	if(visible)then 
		   ixp = x1
		   iyp = y1
		   ix = x2
		   iy = y2
		   call x_tvline(ixp,iyp,ix,iy,color,im_struct)
	end if
	x1 = bx + box_wid * pkm_x
	y1 = by
	x2 = x1 
	y2 = y1 + box_ht * pkm_y
	call wclip(x1,y1,x2,y2,w,visible, ic_code) 
	if(visible)then 
		   ixp = x1
		   iyp = y1
		   ix = x2
		   iy = y2
		   call x_tvline(ixp,iyp,ix,iy,color,im_struct)
	end if
	x1 = bx
	y1 = by + box_ht * pkm_y
	x2 = x1 + box_wid * pkm_x
	y2 = y1 
	call wclip(x1,y1,x2,y2,w,visible, ic_code) 
	if(visible)then 
		   ixp = x1
		   iyp = y1
		   ix = x2
		   iy = y2
		   call x_tvline(ixp,iyp,ix,iy,color,im_struct)
	end if
	return
	end
C -----------------------------------------------------------------
	subroutine x_tv_geo_polygon(color, rlat, rlon, xl, yb,
     +			idim, jdim, sx, sy, xrad, yrad, 
     +			plat, plon, n_verts, im_struct)
	integer color
	real rlat, rlon, plat(n_verts), plon(n_verts),xl, yb
	integer idim, jdim
	real sx, sy, xrad, yrad
	integer*4 im_struct(47)
C
	integer hemis
	real w(4)
	real kmdeglat, kmdeglon 
	logical lamcon, visible
C
	xkm = idim * sx
	ykm = jdim * sy
	hemis = 1 ! N hemisphere
	lamcon = .true.
C
	call setmap(rlat,rlon,xrad,yrad,xkm,ykm,XLATMN,XLATMX,
     +        		XLONMN,XLONMX,kmdeglat,kmdeglon)
C
	w(1) = xl
	w(2) = yb
	w(3) = w(1) + idim - 1
	w(4) = w(2) + jdim - 1
	pkm_x = 1.0 / sx ! pixels per km in x direction
	pkm_y = 1.0 / sy
	radkm = max(xkm-xrad, ykm - yrad)
	call set_varproj(xrad, yrad, pkm_x, pkm_y,
     +		    rlat, rlon, radkm, cone, xsc, ysc, xc, yc, hemis) 
	call lam_proj(plat(1),plon(1),u,v,cone,rlon,hemis)
	bx_p = xl + u * xsc + xc 
      	by_p = yb + v * ysc + yc 
	do i = 2, n_verts
	  call lam_proj(plat(i),plon(i),u,v,cone,rlon,hemis)
	  bx = xl + u * xsc + xc 
      	  by = yb + v * ysc + yc 
	  x1 = bx_p
	  y1 = by_p
	  x2 = bx
	  y2 = by
	  call wclip(x1,y1,x2,y2,w,visible, ic_code) 
	  if(visible)then 
		   ixp = x1
		   iyp = y1
		   ix = x2
		   iy = y2
		   call x_tvline(ixp,iyp,ix,iy,color,im_struct)
	  end if
	  bx_p = bx
	  by_p = by
	end do
	call lam_proj(plat(1),plon(1),u,v,cone,rlon,hemis)
	bx = xl + u * xsc + xc 
      	by = yb + v * ysc + yc 
	x1 = bx_p
	y1 = by_p
	x2 = bx
	y2 = by
	call wclip(x1,y1,x2,y2,w,visible, ic_code) 
	if(visible)then 
		  ixp = x1
		  iyp = y1
		  ix = x2
		  iy = y2
		  call x_tvline(ixp,iyp,ix,iy,color,im_struct)
	end if
	return
	end

