C NON-INTERPOLATING VERSION
C p dodge 7 Jan 2003
	subroutine solo_convt(data_type, elmin, elmax,iz,maxx,maxy,iun,
     +		az_el, sweep_data, max_bins, num_bins, numrad, ierror,
     +		imax, jmax, sx, sy, xdis, ydis, rlat, rlon,
     +		slat, slon, rmx, rdel, time, nmosm, itflg,
     +		gate_length,bad_val)
	integer data_type ! =1 for dBZ, =2 for Dopppler
	integer*2 iz(maxx, maxy) ! output
	integer*2 IZ_val
	real sweep_data(max_bins, numrad) ! holds one sweep
	real az_el(2,numrad) ! holds az and el for each ray
	real gate_length(max_bins)
	real bad_val
* 	Version of smconvt for DORADE data.
* Data is passed in array sweep_data and interpolated into iz.
* Note: if sweep data contains reflectivity it will be in Z, NOT dBZ
*  But iz will be returned as dBZ * 10 !!!
*     The coordinate system window is [(0,0) , (imax*sx,jmax*sy)]. Data 
* in that space is interpolated to the array defined by 
* [(1,1) , (imax,jmax)]. Thus, indices i,j represent the point  
* (i*sx-0.5,j*sy-0.5) and conversely x,y will map to nint(x/sx+0.5) 
* and nint(y/sy+0.5) or, equivalently, trunc(x/sx+0.5), trunc(y/sy+0.5) 
* to gen array indices in bounds the clipping window is:
c 	* { ( sx/2 , sy/2 ) , ( (imax-1/2)*sx , (jmax-1/2)D*sy) ) } ...aug 18, 87 
c         xz,yz - position of radar in grid 
c         xdis,ydis - storm position in grid ( for moving coordinate systems) 
C         x0,y0 - (x,y) COORDINATE WITH RESPECT TO RADAR
C         R - RANGE FROM RADAR TO (X0,Y0) 
C         S,T - ANGULAR and radial interplolation FACTORs 
C         numrad - NUMBER OF RADIALS THAT MAKE UP SWEEP 
C         NAZ - MAX NUMBER OF RADiaLS THAT COULD MAKE UP 1 SWEEP
C if rem_storm then remove storm u, v from velocities
      DIMENSION BIN1(960), BIN2(960)
      dimension w(4) 
      logical done, vis1, vis2
	parameter( num_aux = 1023) ! should be big enough for HRD displays
	integer aux_array(0:num_aux)
C
	do j = 1, maxy
		do i = 1, maxx
			iz(i,j) = -9999
		end do
	end do
C 
	pi = acos(-1.0)
	pi180 = pi /180.0
      ierror=0
      done = .false.
	gapmax = 10.0 ! don't interpolate over a broader wedge than this
C 
      w(1) = sx*0.5 ! clipping window 
      w(2) = sy*0.5 ! changed because data goes from 1 to imax, 1 to jmax 
      w(3) = (imax-0.5)*sx
      w(4) = (jmax-0.5)*sy
c      do j=1,numrad
c       write(6,*)az_el(1,j),az_el(2,j),(sweep_data(i,j),i=1,num_bins)
c      enddo
      divsy = 1.0 / sy
      divsx = 1.0 / SX
C
	if(nmosm.ge.1)then
           if(ier.eq.-123)then ! midnight crossed so update track stuff
              itflg=itflg-1 
              ierror=4 !tell main about midnight crossing 
           endif 
c	   call storm_track( time, itflg, rlat, rlon, 
c     +		xdis, ydis, slat, slon, xz, yz)
C xz, yz is postion of radar in grid, where storm at xdis, ydis
	else
	   xz = xdis
	   yz = ydis
C xz, yz is position of radar
	end if
C get minimum distance from radar:
	call get_radii(imax, jmax, xz,yz, sx, sy, rmax, rmin)
c        write(6,*)'rmin,rmax = ',rmin,rmax
C Set up auxiliary array that holds pointers to radar data bins
C said array to have enough elements for smallest dr = min(sx, sy)
C Have to search through the range gate distance array to find the indexes,
C Because Solo (and SIGMET system) data can have variable spacing.
	dr_min = min(sx, sy)
	do iptr = 0, num_aux
		aux_array(iptr) = -1
	end do
	iptr = 0
	r = rmin
	do while( (r.lt. rmax) .and. (iptr .lt. num_aux) )
	   ii = 1
	   index = -1
	   do while( (ii .lt. num_bins-1) .and. 
     +		   (r .gt. gate_length(ii).or.
     +                  gate_length(ii).ge.999.9 ) )
			if(gate_length(ii).lt.999.9)then
                         index = ii
                        else
                         index = -1
                        endif
			ii = ii +1
	   end do
	   aux_array(iptr) = index
	   iptr = iptr +1
	   r = iptr * dr_min + rmin
	end do
C interpolate 
      iradial = 1 
C first radial:
      azm1 = az_el(1,1)
      ev1 = az_el(2,1)
	do i = 1, num_bins
      		bin1(i) = sweep_data(i,1)
	end do
c        write(6,*)'bin1 = ',(bin1(i),i=1,30)
c        pause
      PHI1 = mod(450.0-azm1, 360.0) * PI180 ! phi is math angle 
      sinphi1 = sin(phi1) 
      cosphi1 = cos(phi1)
      write(iun,*)' Began convt.' 
C Loop though rest of rays
5     iradial = iradial + 1 
      if( iradial .eq. numrad + 1 )then 
              done = .true. 
              iradial = 1 
      endif   
      azm2 = az_el(1, iradial)
      ev2 = az_el(2, iradial)
      phi2 = mod(450. - azm2, 360.0) * pi180
C decide whether to continue with this ray:
	d1 = abs( azdif( phi2, phi1, pi) )
	if( d1 .lt. 0.001)then ! rays are coincident
		go to 20
	else
		divd1 = 1.0 / d1
	end if
	delazm = abs( azm2 - azm1) 
	if(delazm.gt.360. - gapmax)delazm = gapmax - 1.0
	if(delazm.gt.gapmax)then ! don't interpolate across broad wedge
		go to 20 ! skip around interpolation
C     		write(iun,*)'azzes:',azm1,azm2
	end if
	sinphi2 = sin(phi2) 
	cosphi2 = cos(phi2) 
c      write(iun,*)' Doing radial # ',iradial,' az= ',azm2 
	do i = 1, num_bins
              bin2(i) = sweep_data(i, iradial)
	end do
c        write(6,*)'bin = ',(i,bin1(i),bin2(i),i=1,num_bins)
C 
      divcos = 1.0 / cos( EV2 * PI180) 
C 
C  DO COORDINATE CONVERSION USING BI-LINEAR INTERPOLATION 
C  First, find array index bounds in vertical 
10    x1 = xz 
      y1 = yz 
      x2 = xz + rmx * cosphi1 
      y2 = yz + rmx * sinphi1 
      call wclip(x1, y1, x2, y2, w, vis1, ic_code)
      x3 = xz 
      y3 = yz 
      x4 = xz + rmx * cosphi2 
      y4 = yz + rmx * sinphi2 
      call wclip(x3, y3, x4, y4, w, vis2, ic_code)
      if(.not.(vis1.or.vis2)) go to 2 ! neither ray in window
      ytop = min( w(4), max(y1,y2,y3,y4) ) ! in case some y's unclipped
      ybot = max( w(2), min(y1,y2,y3,y4) ) 
      jst = nint(0.5 + ybot * divsy)
      jfin = 0.5 + ytop * divsy 
C*****************************************************
      if((jst.lt.1).or.(jfin.gt.jmax))then
        write(iun,*)' smconvt generated bad j array bounds.'
        write(iun,*)'jst:',jst,'jfin:',jfin,'at azs:',azm1,azm2 
        ierror=5
        return
      end if
      DO 1 J = jst, jfin 
         Y0 = (j-0.5) * sy - yz 
         ysq = Y0 * Y0
         call wedgint(y0+yz,rmx,xz,yz,phi1,phi2,x1,x2,nints)
         if(nints.eq.0)go to 1 !this scan line not vis (should not happen)
         y1=y0+yz 
         y2=y0+yz 
         call wclip(x1,y1,x2,y2,w,vis1, ic_code)
         if(.not.vis1)go to 1 ! this slice not visible
         ist = nint( 0.5 + x1 * divsx )
         ifin=0.5+x2*divsx
         if((ist.lt.1).or.(ifin.gt.imax))then 
                write(iun,*)' smconvt generated bad i array bounds.'
                write(iun,*)'ist:',ist,'ifin:',ifin,'at y=:',y0+yz
                ierror=5
                return
         end if 
12       DO 6 I=ist,ifin
              X0=(i-0.5)*sx-xz
              R = SQRT(X0*X0 + ysq) * divcos
              IF (R .GT. RMX) GO TO 6
		iptr = nint( (r - rmin ) / dr_min )
		if((iptr.lt.0) .or. (iptr .gt. num_aux)) go to 6
		index1 = aux_array(iptr)
		if(index1.lt.1)go to 6 ! out of range
C
		PHI = atan2(y0,x0)
		D = AZDIF(PHI,PHI1,PI)
C S is an azimuth weight
		S = ABS( D * divd1 )
		INDEX2 = INDEX1+1 
		R1 = gate_length(index1)
		R2 = gate_length(index2)
C T is a radial distance weight
		T = (R-R1) / (R2-R1)
C
		Z = bad_val
		if( T .lt. 0.5 ) then ! closer to R1, index1
		   if( s .lt. 0.5) then ! closer to bin1
			if ( BIN1(INDEX1) .gt. bad_val) then
			   Z = BIN1(INDEX1)
			end if
		   else ! closer to bin2
			if ( BIN2(INDEX1) .gt. bad_val) then
			   Z = BIN2(INDEX1)
			end if
		   end if
		else ! closer to r2, index2
		   if( s .lt. 0.5) then ! closer to bin1
			if ( BIN1(INDEX2) .gt. bad_val) then
			   Z = BIN1(INDEX2)
			end if
		   else ! closer to bin2
			if ( BIN2(INDEX2) .gt. bad_val) then
			   Z = BIN2(INDEX2)
			end if
		   end if
		end if
C
		if( data_type .eq. 1) then ! convert to dBZ
C Z < 0.0 should not happen anymore, but just in case...
		   IF(Z .LE. 0.0) then
			iz(i,j) = -9999 ! should only happen on edges of bad data
		   else 
		   	idBZ = Z
C only replace dBZ if > what is already there
			if( idBZ .gt. (iz(i,j)*0.1) )then
				iz(i,j) = idBZ * 10.0 ! 0.1 dBZ res
			end if
		   end if
		else
		   if(Z .gt. bad_val) then
		     IZ_val = z *10.0
C preserve largest Doppler
		     if(iz(i,j) .gt. -9999) then
			if(abs(IZ_val) .gt. abs(iz(i,j)) ) then
				iz(i, j) = IZ_val
			end if
		     else
			iz(i, j) = IZ_val
		     end if
		   else
			iz(i,j) = -9999
		   end if
		end if
c         WRITE(6,*)' packing at',i,j,' with ',z 
6             CONTINUE
1        CONTINUE 
C 
20	AZM1 = AZM2 
	PHI1 = PHI2 
      sinphi1=sinphi2 
      cosphi1=cosphi2 
      ev1=ev2 
	do I = 1, num_bins
			BIN1(I)=BIN2(I) 
	end do
2     if(.not.done)then 
              go to 5 
      endif 
      return
      end 
C ========================
	subroutine get_radii(idim, jdim, xs,ys, sx, sy, rmax, rmin)
C determine min and max distance from xs, ys for region defined
C by lower left (0,0) and upper right (imax*sx, jmax*sy)
	real w(4)
	integer icode
C	9	|	8	|	10
C		|		| w3,w4
C ---------------------------------------------------------
C		|		|
C	1	|	0	|	2
C		| w1, w2	|
C ---------------------------------------------------------
C		|		|
C	5	|	4	|	6 
C
	w(1) = 0.0
	w(2) = 0.0
	w(3) = idim * sx
	w(4) = jdim * sy
	icode = inside( xs, ys, w)
	if( icode .eq. 0) then
		rmin = 0.0
		rmax = max( xs**2 + ys**2, xs**2 + (w(4) - ys) **2,
     +			(w(3)-xs)**2 + ys**2, 
     +			(w(3)-xs)**2 + (w(4) - ys) **2)
		rmax = sqrt(rmax)
	else if( icode .eq. 1) then
		rmin = -xs
		rmax = max(sqrt( (w(3)-xs)**2 + ys**2),
     +			sqrt( (w(3)-xs)**2 + (w(4)-ys)**2) )
	else if( icode .eq. 2) then
		rmin = xs - w(3)
		rmax = max(sqrt( xs**2 + ys**2),
     +			sqrt( xs**2 + (w(4)-ys)**2) )
	else if( icode .eq. 4) then
		rmin = -ys
		rmax = max( sqrt(xs**2 +(w(4)-ys)**2),
     +			sqrt((w(3)-xs)**2 + (w(4) -ys)**2) )
	else if( icode .eq. 5) then
		rmin = sqrt( xs*xs + ys*ys)
		rmax = sqrt( (w(3)-xs)**2 + (w(4)-ys)**2)
	else if( icode .eq. 6) then
		rmin = sqrt( (xs-w(3))**2 + ys**2)
		rmax = sqrt( xs**2 + (w(4) - ys)**2)
	else if( icode .eq. 8) then
		rmin = ys - w(4)
		rmax = max( sqrt(xs**2 +ys**2),
     +			sqrt((xs-w(3))**2 + ys**2) )
	else if( icode .eq. 9) then
		rmin = sqrt( xs**2 + (ys-w(4))**2)
		rmax = sqrt( (w(3)-xs)**2 + ys**2)
	else if( icode .eq. 10) then
		rmin = sqrt( (xs-w(3))**2 + (ys-w(4))**2)
		rmax = sqrt( xs**2 + ys**2)
	end if
	return
	end
c        function azdif( ang1, ang2, pi)
c        real ang1, ang2, azdif_pd
c        diff = ang1 - ang2
c        if( diff .gt. pi ) then
c                diff = 2.0 * pi - diff
c        else if ( diff .lt. -pi ) then
c                diff = -2.0 * pi - diff
c        end if
c        azdif = diff
c        end

