      SUBROUTINE SWEEPIN(SWEEP,SWEEPZ,MAX_RAYS,MAX_GATES,NUM_RAYS,RDTAI,
     + AZ_EL,ICALLSWEEPIN,NUMREC,VRRAD,UNFVEL,TMP1,TMP2,JINDEX,
     + JIINDEX,NYQ,ILATERSWEEP,SWEEPSAVE,U,V,W,IMX,JMX,KMX,SX,SY,SZ,
     + OLAT,OLON,XZ,YZ,ZZ,IUSEWIND,EAZM,EEV,TMSWEEP,RRLAT,RRLON,RRA,
     + SMOTIONU0,SMOTIONV0,CENTIME0,PELEV,NTASWEEPER,
     + RDWS,RDWD,RDVWS)
C 
C     Doppler/Reflectivity processing program. 
C     This program reads the radar tapes or fortran-binary copies of them
C     and writes rays of Doppler data and sends them back to routine abcd
C     to be interpolated.
C 
C  Subroutines used: 
C     READTAPE - Reads merged tapes and returns 1 record.
C
C     UNFLDNEW - A version of unfld written since last changes in biglib
C
C     AZIUNFLD - A version of unfolding that demands azimuthal continuity
C 
C  Logical units: 
C     unit(1) - user's terminal 
C     unit(LUNR) - tape drive LU #
C
C     IF LUNRT IS LESS THAN 6 THEN LUNR IS SET TO 80.  THIS IS A SIGNAL TO
C     READTAPE TO READ FROM A FORTRAN BINARY FILE INSTEAD OF A DATA TAPE
C
C     unit(LP) - line printer LU #. (6/7 dot-matrix printer)--THIS IS LEGACY
C       SINCE C IS NOW THE DEFAULT OUTPUT TO THE TERMINAL
C  Variables in Common Block and Main Program:
C     NIX - Flag for end-of-file/end-of-tape.(NIX=-100).
C     NGATE1 - Gate number to start mapping the data, for negative range del.
C     IFLT/INM - Flight date/ project name.
C     STIME/ETIME - Starting/Ending times of disc file in seconds.
C     WD/WS - Wind direction(deg) and Wind Speed (m/s).
C     IVT - flag to calculate  and subtract the terminal velocity (y/n).
C     RAMFL - flag to open and read the ram data with the GPS information.
C     XR,YR,ZR - east-west,north-south,and vertical distances of radar gate
C      from the radar
C 
      COMMON /AREA1/ INM,IFLT,STIME,ETIME,WD,WS,NIX,NGATE1,LP,LUNR,
     +               IVT,RAMFL
C      COMMON /AREA1/ NIX,NGATE1,IFLT,INM,STIME,ETIME,WD,WS,IVT,RAMFL,
C     +               LP,LUNR
      COMMON /TAPEHEADER/ nbytesheader,ntape,nversion,ihheader,imheader,
     +                    isheader,ine,ndrive,naircraft,flightid,stmname
     +                    ,nsamplelf,nsampleta,refslopelf,refslopeta,
     +                    refnoisethreslf,refnoisethresta,sqilf,sqita,
     +                    widththreslf,widththresta,caliblf,calibta,
     +                    modedatalf,modedatata,noisetmlf,noisetmta,
     +                    rpmlf,rpmta,gtlnlf,ivrangelf,ivrangeta,
     +                    gtlnta(3),rdellf,rdelta,rdelcorlf,rdelcorta,
     +                    nbinlf,nbinta,nbins,rmaxlf,rmaxta,
     +                    radiita(512),radiilf(512),prf_flaglf,
     +                    prf_flagta,prf_highlf,prf_highta,xniqlf,
     +                    xniqta,iheader(1024)
      COMMON /RAYHEADER / nbytesdata,nlfsweep,ntasweep,numrecord,
     +                    irecflag,idradar,nbytesray,icode,idsp,mdata,
     +                    iyear,month,iday,iraycode,radtime,ih,im,is,
     +                    is100,radlat,radlon,radalt,gse,gsn,radgs,
     +                    radvgs,ucom,vcom,radwd,radws,radvws,ircu,
     +                    elev,radazm,pitch,roll,drift,heading,
     +                    dbzbuffer(512),velbuffer(512),widthbuffer(512)
      COMMON /PARAMS/ trakazm,trakelev,driftnew,
     +                rot,track,htbb,dbb,thresh,swthresh,dbzrs,ibst(2),
     +                inob(2),ileg,xniq,irsw,maxnbins,v0,
     +                pcor,dcor,rcor,azmcor,elcor,dbzcor,dbzslope,
     +                iunfoldflag,iattenflag,
     +                badstabflag,surfelimflag,echoflag,atmflag
      common /tsearch/ kountrec,firstsweep(2),keylf(1024,2),
     +                 keyta(4096,2),
     +                 numsweep(2),itimex(2),lastpoint(2),
     +                 iheadertime,ioldsweep(2),kwords,nwords,krays,
     +                 ibuf(2048)
      LOGICAL badstabflag, surfelimflag, echoflag, atmflag
      REAL TIMEONE,RLATONE,RLONONE,RAONE,AZMONE,EVONE
      REAL BINONE(512),REFONE(512),RDWD(800),RDWS(800)
      INTEGER*2 IHEADER
      INTEGER OLDTIME,IITEST(5),JJTEST(5),IKEEP(512,800)
      INTEGER PRF_FLAGLF, PRF_FLAGTA
      REAL UNFVEL(512,800)
      REAL TMP1(512,800),TMP2(512,800)
      INTEGER JINDEX(512,800),JIINDEX(512,800)
      REAL RDVWS(800)
      REAL SWEEP(512,800),RDTAI(512),AZ_EL(2,800)
      REAL PELEV(800),RDTAIIN(512)
      REAL VROUT(512,800)
      REAL PAZM(800)
      REAL SWEEPSAVE(512,800)
      REAL PCORS(2),DCORS(2),RCORS(2)
      REAL AZMCORS(2),RDELCORTAS(2),ELCORS(2)
      REAL RAY(512),URAY(512),V0SAVE(800)
      REAL VRRAD(512,800),NYQ(512,800)
      REAL SWIDTH(512,800),SWONE(800)
      REAL XRSWEEP(512,800),YRSWEEP(512,800),ZRSWEEP(512,800)
      REAL XRMIN(512,800),YRMIN(512,800),ZRMIN(512,800)
      REAL XRMAX(512,800),YRMAX(512,800),ZRMAX(512,800)
      REAL AZMIN(512,800),AZMAX(512,800)
      REAL SWEEPZ(512,800),ZDIFF(512,800)
      REAL ZMIN(512,800),ZMAX(512,800)
      REAL XR(512),YR(512),ZR(512)
      REAL U(IMX,JMX,KMX),V(IMX,JMX,KMX),W(IMX,JMX,KMX)
      REAL EAZM(800),EEV(800),RRLAT(800),RRLON(800),RRA(800)
      REAL TMSWEEP(800)
      INTEGER ISEG(512,800),ISEGB(512,800),ISEGE(512,800)
      CHARACTER CDUMMY*80
      CHARACTER FLIGHTID*8,STMNAME*16,DUMMYREAD*1
      CHARACTER IFLT*8, INM*12
      CHARACTER *1 TAPE, RAMFL, IVT, IATTEN
      CHARACTER *80 NAMERAM, IFILE, NAMEO
      CHARACTER*80 RADARFILE
      DIMENSION BIN(512),REF(512),BIN1(512),REF1(512)
      SAVE
c      SAVE ISWEEPCHECK,BINONE,REFONE,TIMEONE,RLATONE,RLONONE
c      SAVE RAONE,AZMONE,EVONE,RCAZM,AZELONE,AZELTWO,PELEVONE
c      SAVE ICONSERVE,ITAPEOPEN,RDTAIIN,RADTEST,V0ONE,PAZMONE
c      SAVE OLDTIME,ITIMECHECK,SWONE
c      SAVE PCORS,DCORS,RCORS,AZMCORS,RDELCORTAS,ELCORS
c      SAVE TIME,TIMES
c      SAVE IHS,IHE,IMS,IME,ISS,ISE
      DATA AT1/5.33E-5/, AT2/0.889/
      IMAXBINS=512
      JMAXRAYS=800
       IF(IUSEWIND.EQ.1)THEN
        WRITE(6,*)'IUSEWIND = ',IUSEWIND
c        PAUSE
       ELSE
        WRITE(6,*)'IUSEWIND = ',IUSEWIND
c        PAUSE
       ENDIF
      IF(IUSEWIND.EQ.1)THEN
       SMOTIONU=SMOTIONU0
       SMOTIONV=SMOTIONV0
       CENTIME=CENTIME0
      ELSE
       SMOTIONU=0.
       SMOTIONV=0.
       CENTIME=CENTIME0
      ENDIF
      DO I=1,800
       RDWS(I)=-999.9
       RDWD(I)=-999.9
       RDVWS(I)=-999.9
      ENDDO
      IF(ICALLSWEEPIN.EQ.0)THEN
       IFILECHECK=0
       RADTEST=-1.
       IFRANCE=0
      ELSE
       IFILECHECK=1
      ENDIF
      deg2rad = acos(-1.0) / 180.0
      rad2deg = 1.0 / deg2rad
      half_beam_ta = 0.8 ! degrees, vertical
      half_beam_lf = 2.05 ! degrees, vertical
      beam_wid = 2.0 * half_beam_ta
      WFLAG=-1.0E+10
C 
C DOPPLER processing program
c      write(6,*)'icallsweepin = ',icallsweepin
      ISWEEPSET=2
      SWEEPOLD=0.
      NUM_RAYS=0
      DO I=1,512
       DO J=1,800
        SWEEP(I,J)=-888.8
        SWEEPZ(I,J)=-32.0
       ENDDO
      ENDDO
c      write(6,*)'imx,jmx,kmx = ',imx,jmx,kmx
c      write(6,*)'sx,sy,sz = ',sx,sy,sz
c      write(6,*)'xz,yz,zz = ',xz,yz,zz
      IF(ICALLSWEEPIN.EQ.1)THEN
       NUM_RAYS=1
       RLAT=RLATONE
       RLON=RLONONE
       EAZM(1)=AZMONE
       EEV(1)=EVONE
       RRLAT(1)=RLAT
       RRLON(1)=RLON
       RRA(1)=RAONE
       RDVWS(1)=RDVWSONE
       TMSWEEP(1)=TIMEONE
       RA=RAONE
       AZM=AZMONE
       EV=EVONE
       V0SAVE(1)=V0ONE
       IF(IBST(1).GE.1)THEN
        DO I=1,IBST(1)
         SWEEP(I,1)=-888.8
         SWEEPZ(I,1)=-32.
        ENDDO
       ENDIF
       DO I=IBST(1)+1,NBINS
        SWEEP(I,1)=BINONE(I)
        SWEEPZ(I,1)=REFONE(I)
        SWIDTH(I,1)=SWONE(I)
       ENDDO
       IF(NBINS.LT.512)THEN
        DO I=NBINS+1,512
         SWEEP(I,1)=-888.8
         SWEEPZ(I,1)=-32.
        ENDDO
       ENDIF
c       DO I=1,512-IBST(1)
c        SWEEP(I,1)=BINONE(I+IBST(1))
c        SWEEPZ(I,1)=REFONE(I+IBST(1))
c       ENDDO
       OOLAT=RLAT
       OOLON=RLON
       TIMES=TIME
       IF(IUSEWIND.NE.1)CENTIME=TIMES
       ISCANDIM=512
       IBINS=512
       AZ_EL(1,1)=AZELONE
       AZ_EL(2,1)=AZELTWO
       PELEV(1)=PELEVONE
       PAZM(1)=PAZMONE
c       write(6,*)'calling vrlocate'
c       write(6,*)'olat,olon = ',olat,olon
c       write(6,*)'rlat,rlon = ',rlat,rlon
c       write(6,*)'ra,ev,azm = ',ra,ev,azm
       IF(IUSEWIND.EQ.1)THEN
        CALL VRLOCATER(TIMES,OLAT,OLON,
     +  RLAT,RLON,RA,EV,AZM,RDTAIIN,XR,YR,ZR,
     +  ISCANDIM,SMOTIONU,SMOTIONV,CENTIME)
c        WRITE(6,*)'RAY 1 SPOT,TIMES,EV,XR,YR,ZR AT 1 = ',
c     +   TIMES,EV,XR(1),YR(1),ZR(1)
        RADIANEV=EV*3.14159/180.
        RADIANAZM=AZM*3.14159/180.
        DIRCOSX=COS(RADIANEV)*COS(RADIANAZM)
        DIRCOSY=COS(RADIANEV)*SIN(RADIANAZM)
        DIRCOSZ=SIN(RADIANEV)
        XMIN=-XZ
        YMIN=-YZ
        XMAX=-XZ+IMX*SX
        YMAX=-YZ+JMX*SY
        ZZMAX=ZZ+(KMX-1)*SZ
C       WRITE(6,*)'SX,SY,SZ,XZ,YZ,ZZ = ',SX,SY,SZ,XZ,YZ,ZZ
C       WRITE(6,*)'XMIN,YMIN,ZZMIN = ',XMIN,YMIN,ZZMIN
C       WRITE(6,*)'XMAX,YMZX,ZZMAX = ',XMAX,YMAX,ZZMAX
        DO IR=1,512
         IF(BIN(IR).GT.-800.)THEN
          IINT=INT((XR(IR)+XZ+.5*SX)/SX)
          JINT=INT((YR(IR)+YZ+.5*SY)/SY)
          KINT=1+INT((ZR(IR)-ZZ)/SZ)
          VRRAD(IR,1)=0.
          VRSUM=0.
          DO I=IINT,IINT+1
           DO J=JINT,JINT+1
            DO K=KINT,KINT+1
             IF(I.GE.1.AND.I.LE.IMX)THEN
              IF(J.GE.1.AND.J.LE.JMX)THEN
               IF(K.GE.1.AND.K.LE.KMX)THEN
                IF(U(I,J,K).GT.WFLAG)THEN
                 XG=(I-1)*SX-XZ+.5*SX
                 YG=(J-1)*SY-YZ+.5*SY
                 ZG=(K-1)*SZ+ZZ
                 XI=XR(IR)-XG
                 YI=YR(IR)-YG
                 ZI=ZR(IR)-ZG
                 RADR=SQRT(XR(IR)*XR(IR)+YR(IR)*YR(IR))
                 RADG=SQRT(XG*XG+YG*YG)
                 VRAD=(U(I,J,K)*XG+V(I,J,K)*YG)/RADG
                 VTAN=(V(I,J,K)*XG-U(I,J,K)*YG)/RADG
                 URAD=(VRAD*XR(IR)-VTAN*YR(IR))/RADR
                 VRAD=(VRAD*YR(IR)+VTAN*XR(IR))/RADR
                 DISTPOINT=SQRT(XI*XI+YI*YI+ZI*ZI)
                 IF(DISTPOINT.GT.0.)THEN
                  RINT=1./DISTPOINT
                 ELSE
                  RINT=1000000.
                 ENDIF
                 VRRAD(IR,1)=VRRAD(IR,1)+
     1              RINT*(URAD*DIRCOSX+VRAD*DIRCOSY+
     1              W(I,J,K)*DIRCOSZ)
                 VRSUM=VRSUM+RINT
                ENDIF
               ENDIF
              ENDIF
             ENDIF
            ENDDO
           ENDDO
          ENDDO
          IF(VRSUM.GT.0.)THEN
           VRRAD(IR,1)=VRRAD(IR,1)/VRSUM
          ELSE
           VRRAD(IR,1)=-888.8
          ENDIF
         ELSE
          VRRAD(IR,1)=-888.8
         ENDIF
        ENDDO
c        write(6,*)'vrlocater 1 ra = ',ra
        CALL VRLOCATER(TIMES,OOLAT,OOLON,
     +  RLAT,RLON,RA,EV,AZM,RDTAIIN,XR,YR,ZR,
     +  ISCANDIM,SMOTIONU,SMOTIONV,CENTIME)
c        write(6,*)'vrlocater 1 ra = ',ra
        DO I=1,512
         XRSWEEP(I,1)=XR(I)
         YRSWEEP(I,1)=YR(I)
         ZRSWEEP(I,1)=ZR(I)
        ENDDO
       ENDIF
      ENDIF
      IF(ICALLSWEEPIN.EQ.0)THEN
       ISWEEPSET=0
c       OPEN(1,FILE='/dev/null')
       IF(IUSEWIND.NE.1)THEN
c        WRITE(6,*)'be conservative on first pass y(1)/n(0)'
c        read(1,*)ICONSERVE
        ICONSERVE=1
C       ELSE
C        ICONSERVE=0
       ENDIF
c       WRITE(6,*)'Enter job file name'
c       READ(1,'(A80)')IFILE
       IFILE='jobfile_radar'
       OPEN(98,FILE=IFILE,IOSTAT=IERR,ERR=998,STATUS='OLD')
C The Following Parameters are read from input file  - ncepwrite_file.job
C Read Flight ID and Storm Name
      READ(98,'(A8)')IFLT
      READ(98,'(A12)')INM
      DO JIJ=1,7
       READ(98,'(A1)')DUMMYREAD
      ENDDO
C      READ(98,'(A8,1X,A12)',IOSTAT=IERR,ERR=999) IFLT,INM
C Read Line Printer LU#, Tape LU# & flag for printing parameters
       LP=6
       READ(98,*)LUNRT
C       READ(315,'(I2,1X,I2)',IOSTAT=IERR,ERR=999) LP,LUNRT
C1       READ(315,*)ITAPEOPEN
C       IF(LUNRT.GT.6)THEN
C        WRITE(6,*)'YOU ARE USING TAPE DRIVE ',LUNRT
C        WRITE(6,*)'IF CORRECT ENTER 1, OTHERWISE 0'
C        READ(1,*)ILUNRT
C        IF(ILUNRT.NE.1)THEN
C         WRITE(6,*)'REENTER TAPE DRIVE UNIT NUMBER'
C         WRITE(6,*)'IF YOU MEANT TO USE A FILE ENTER 0'
C         READ(1,*)LUNRT
C        ENDIF
C       ELSE
C        WRITE(6,*)'YOU WILL BE READING FROM A RADAR FILE'
C       ENDIF
C       READ(315,'(A80)')RADARFILE
       WRITE(LP,'(1X,"NCEP program to write doppler on disc: ",A)')
     +      IFILE
       WRITE(LP,'(2X,"Date:",1X,A8,2X,"Name: ",A12,/,
     +        2X,"Line-Printer:",1X,I2,2X,"Tape-LU#:",I2)')
     + IFLT,INM,LP,LUNRT
C Read Ram File Flag{Y/N} and the Ram File Name 
C       READ(315,'(A1,1X,A80)',IOSTAT=IERR,ERR=999) RAMFL,NAMERAM 
C       IF(RAMFL.EQ.'y')RAMFL='Y'
C       IF(RAMFL.EQ.'n')RAMFL='N'
       RAMFL='N'
C      CALL CASEFOLD(RAMFL)
C Open the Ram File 
       IF (RAMFL .EQ. 'Y') THEN
          CALL OPENRAMFILE(NAMERAM,LP,STIMERAM,ETIMERAM,DATARATE,IERR)
          IF (IERR .NE. 0) GO TO 1050
          WRITE(LP,'(2X,"RAMFL= ",A1,1X,A80)') RAMFL,NAMERAM
       ENDIF 
C Read Unfolding Flag{Y/N},first guess wind and speed
C       READ(315,*,IOSTAT=IERR,ERR=999) IUNFOLDFLAG,WD,WS
c       INFOLDFLAG=1
       WD=0.
       WS=1.
       iunfoldflag=0
       WRITE(LP,'(2X,"IUNFOLDFLAG= ",I1," WD= ",F6.1," WS= ",F6.1)')
     +      IUNFOLDFLAG,WD,WS
C Read the starting bin and the number of bins for averaging
       READ(98,*,IOSTAT=IERR,ERR=999) IBST(1),INOB(1) 
       WRITE(LP,'(2X,"IBST= ",I4," INOB= ",I4)') IBST(1),INOB(1)
C Enter AZM, Elevation & rdel corrs.
       READ (98,*,IOSTAT=IERR,ERR=999) AZMCORS(1),ELCORS(1),
     +                                  RDELCORTA
       WRITE(LP,'(2X,"TA AZMCOR=",F6.2,2X,"ELCOR= ",F6.2,
     +      2X,"RDELCORTA= ",F6.2)') AZMCORS(1),ELCORS(1),
     +                               RDELCORTA
C Enter Pitch, drift and roll corrections:
       READ (98,*,IOSTAT=IERR,ERR=999) PCORS(1),DCORS(1),RCORS(1)
       WRITE(LP,'(2X,"TA PCOR= ",F5.1,2X,"DCOR= ",F5.1,
     +      2X,"RCOR= ",F5.1)') PCORS(1),DCORS(1),RCORS(1)
C Enter AZM, Elevation & rdel corrs.
       READ (98,*,IOSTAT=IERR,ERR=999) AZMCORS(2),ELCORS(2),
     +                                  RDELCORTA
       RDELCORTAS(1)=RDELCORTA
       RDELCORTAS(2)=RDELCORTA
       WRITE(LP,'(2X,"TF AZMCOR=",F6.2,2X,"ELCOR= ",F6.2,
     +      2X,"RDELCORTA= ",F6.2)') AZMCORS(2),ELCORS(2),
     +                               RDELCORTA
C Enter Pitch, drift and roll corrections:
       READ (98,*,IOSTAT=IERR,ERR=999) PCORS(2),DCORS(2),RCORS(2)
       WRITE(LP,'(2X,"TF PCOR= ",F5.1,2X,"DCOR= ",F5.1,
     +      2X,"RCOR= ",F5.1)') PCORS(2),DCORS(2),RCORS(2)
C Read threshold value
       READ (98,*,IOSTAT=IERR,ERR=999) THRESH,DBZRS,DBZCOR,DBZSLOPE
       WRITE(LP,'(2X,"NOISE VALUE= ",F5.1,2X,"DBZRS= ",F5.1,
     +          "DBZSLOPE= ",F5.1,2X,"DBZCOR= ",F5.1)')
     +       THRESH,DBZRS,DBZSLOPE,DBZCOR
C Read spectral width threshold value
       READ (98,*,IOSTAT=IERR,ERR=999) swthresh
       IF (SWTHRESH.LE.0.0 .OR. SWTHRESH.GT.13.0) SWTHRESH=99.0
       WRITE(LP,'(2X,"SPECTRAL WIDTH THRESHOLD= ",F5.1)') swthresh
C Read Flag for adding the Terminal Velocity Corr. Value, the height &
C depth of the bright band, P. Willis or Joss VT.
       IVT='N'
       HTBB=5.5
       DBB=2.
       IRSW=0
C       READ (98,*,IOSTAT=IERR,ERR=999) IVT,HTBB,DBB,IRSW
       IF(IVT.EQ.'n')IVT='N'
       IF(IVT.EQ.'y')IVT='Y'
C      CALL CASEFOLD(IVT)
       WRITE(LP,'(2X,''VT= '',A1," HTBB= ",F6.2," DBB= ",F6.2, 
     +           " IRSW= ",I1)') 
     +      IVT,HTBB,DBB,IRSW
      IF (IVT .EQ. 'N') HTBB= -99.0
C Read flag to add the intervening attenuation
      IATTEN='N'
C       READ (98,*,IOSTAT=IERR,ERR=999) IATTEN
       IF(IATTEN.EQ.'y')IATTEN='Y'
       IF(IATTEN.EQ.'n')IATTEN='N'
C      CALL CASEFOLD(IATTEN) 
       IF (IATTEN .EQ. 'Y') THEN 
C compute attenuation table if flag is on 
          CALL MAKEATTENTABLE1(2)
          WRITE(LP,'(1X,"Intervening attenuation: A=",E10.2, 
     +   "*Z**",F4.2)') AT1,AT2
          IATTENFLAG = 1
       ELSE
          IATTENFLAG = 0
       ENDIF   
C Read Start Time and End Time
       READ(98,'(3I2,1X,3I2)',IOSTAT=IERR,ERR=999)
     +     IHS,IMS,ISS,IHE,IME,ISE
       WRITE(LP,'(2X,"Start Time:",3I2.2,2X,"End Time:",3I2.2)')
     +IHS,IMS,ISS,IHE,IME,ISE
C Read a second tape:
       TAPE='N'
C       READ(98,'(A1)',IOSTAT=IERR,ERR=999) TAPE
       IF(TAPE.EQ.'y')TAPE='Y'
       IF(TAPE.EQ.'n')TAPE='N'
C      CALL CASEFOLD(TAPE)
C 
C Read Disk File Name 
C       READ(98,'(A)',IOSTAT=IERR,ERR=999) NAMEO
      READ(98,*)DUMMY
      READ(98,*)DUMMY1,DUMMY2
      READ(98,*)DUMMY1,DUMMY2
      READ(98,'(A80)')CDUMMY
      READ(98,*)DUMMY1,DUMMY2
      RADARFILE='DUMMY'
      IF(LUNRT.GT.6)THEN
       ITAPEOPEN=1
      ELSE
       ITAPEOPEN=0
       WRITE(6,*)'Enter name of radar file'
       READ(98,'(A80)')RADARFILE
      ENDIF
      READ(98,*)IFRANCE
      IF(ITAPEOPEN.EQ.1)THEN
c       CALL TAPEOPEN(LUNRT,0,LUNR)
c       CALL TAPECONTROL(LUNR,2,1) !back up 1 file
       write(6,*)'should not get here so stopping'
       STOP
      ELSE
       LUNR=80
       CALL OPENRADARFILE(RADARFILE,LUNR,1,IERROPEN)
c        OPEN(80,FILE=RADARFILE,FORM='UNFORMATTED',RECL=2,
c     1       ACCESS='DIRECT')
      ENDIF
      CLOSE(98)
      NAMEO='DUMMY'
      ENDIF
      WRITE(LP,'(2X,"NCEP Output File Name:",A)') NAMEO
      WRITE(LP,*)trakazm,trakelev,driftnew,
     +         rot,track,htbb,dbb,thresh,swthresh,dbzrs,ibst(1),ibst(2),
     +         inob(1),inob(2),ileg,xniq,irsw,maxnbins,v0,
     +         pcor,dcor,rcor,azmcor,elcor,dbzcor,dbzslope,
     +         iunfoldflag,iattenflag,
     +         badstabflag,surfelimflag,echoflag,atmflag
C Open Disk File
c      OPEN(320,FILE=NAMEO,IOSTAT=IERR,ERR=1000,STATUS='UNKNOWN',
c     +     FORM='unformatted') 
C 
      STIME=FLOAT(IHS)*3600.0 + FLOAT(IMS)*60.0 + FLOAT(ISS)
      ETIME=FLOAT(IHE)*3600.0 + FLOAT(IME)*60.0 + FLOAT(ISE)
C
C Search for the start time:
971   write(6,*)'itapeopen,icallsweepin = ',itapeopen,icallsweepin
      IF(ICALLSWEEPIN.EQ.0)THEN
       write(6,*)'calling tapesearch'
       ROLDTIME=200000.
97100  WRITE(6,*)'CALLING READTAPE'
       kwords=0
       nwords=-1
       TIME=STIME
       CALL READTAPE(TIME,RLAT,RLON,RA,AZM,EV,BIN,REF,RCAZM,
     +  ITAPEOPEN,RADARFILE,NUMREC,PCORS,DCORS,RCORS,AZMCORS,
     +  RDELCORTAS,ELCORS)
c       DO I=1,512
c        IF(REF(I).GT.64.)THEN
c         WRITE(6,*)'I,REF(I) = ',I,REF(I)
c         PAUSE
c        ENDIF
c       ENDDO
       NTASWEEPER=NTASWEEP
       WRITE(6,*)'TIME,RLAT,RLON,RA = ',TIME,RLAT,RLON,RA
       WRITE(6,*)'TIME,OLDTIME = ',TIME,ROLDTIME
       IF(TIME.EQ.ROLDTIME)GO TO 97100
       TIMEMSTIME=TIME-STIME
       WRITE(6,*)'TIME,STIME,TIMEMSTIME = ',TIME,STIME,TIMEMSTIME
       IF(TIMEMSTIME.LT.-72000..AND.ITAPEOPEN.EQ.1)THEN
C        WRITE(6,*)'BACKSPACING'
C        CALL TAPECONTROL(LUNR,2,1)
C        CALL TAPECONTROL(LUNR,2,1)
C        ROLDTIME=TIME
C        GO TO 97100
        WRITE(6,*)'SHOULD NOT GET HERE.  STOPPING'
        STOP
       ENDIF
97101  IF(LUNR.NE.80)THEN
C        CALL TAPESEARCH(LUNR,2,2,STIME,IERR)
        WRITE(6,*)'SHOULD NOT GET HERE.  STOPPING'
        STOP
       ELSE
c94826        WRITE(6,*)'CALLING DISCSEARCH'
94826   CALL DISCSEARCH(LUNR,2,2,STIME,IERR)
        NTIMER=0
        write(6,*)'called discsearch'
        timetest=itimex(2)
        write(6,*)'timetest,etime = ',timetest,etime
        if(timetest.gt.etime)then
         itimex(2)=1
         time=itimex(2)
         write(6,*)'new time,itimex = ',time,itimex(2)
         ierr=20
         go to 94826
        endif
      ENDIF
       WRITE(6,*)'IERR = ',IERR
       IF (IERR.LT.0) GO TO 970
      CALL READTAPE(TIME,RLAT,RLON,RA,AZM,EV,BIN,REF,RCAZM,
     +ITAPEOPEN,RADARFILE,NUMREC,PCORS,DCORS,RCORS,AZMCORS,
     +RDELCORTAS,ELCORS)
      NTASWEEPER=NTASWEEP
       IF((TIME-STIME).LT.-60000..AND.ITAPEOPEN.EQ.1)THEN
C        CALL TAPECONTROL(LUNR,2,1) !back up 1 file
C        CALL TAPECONTROL(LUNR,2,1) !back up 1 file
C        GO TO 97101
        WRITE(6,*)'SHOULD NOT GET HERE.  STOPPING'
        STOP
       ELSEIF((TIME-STIME).LT.1.)THEN
        WRITE(6,*)'SETTING IFILECHECK TO 1'
        IFILECHECK=1
       ELSE
        WRITE(6,*)'TIME IS ',TIME
       ENDIF
      ENDIF
      OLDTIME=0
      ITIMECHECK=0
C      WRITE(6,*)'START XNIQ AND XNIQTA = ',XNIQ,XNIQTA
c7040  write(6,*)'calling readtape'
7040      CALL READTAPE(TIME,RLAT,RLON,RA,AZM,EV,BIN,REF,RCAZM,
     +ITAPEOPEN,RADARFILE,NUMREC,PCORS,DCORS,RCORS,AZMCORS,
     +RDELCORTAS,ELCORS)
c       write(6,*)'returned from readtape'
c       write(6,*)'time,rlat,rlon = ',time,rlat,rlon
c       write(6,*)'pitch,roll,headnign = ',pitch,roll,heading
c       WRITE(6,*)'AFTER READTAPE TIME = ',TIME
c      IF(TIME.GT.86400.)PAUSE
c      TIME=TIME-86400.
       IF(ABS(ELEV).LT..001)THEN
        DO I=1,512
         BIN(I)=-888.88
         REF(I)=-32.
        ENDDO
       ENDIF
       DO I=1,512
        IF(REF(I).GT.60.)THEN
c         WRITE(6,*)'AFTER READTAPE,I,REF(I) = ',I,REF(I)
c         PAUSE
         REF(I)=-32.
         BIN(I)=-888.88
        ENDIF
       ENDDO
      NTASWEEPER=NTASWEEP
c      IF(NUM_RAYS.GE.92.AND.NUM_RAYS.LE.93)THEN
c       WRITE(6,*)'BIN = ',BIN
c      ENDIF
      DO I=2,512
       IF(RADIITA(I).LT.RADIITA(I-1))THEN
        DO L=I,512
         RADIITA(L)=1000.
        ENDDO
        GO TO 5699
       ENDIF
      ENDDO
5699  CONTINUE
c       write(6,*)'time,bin = ',time,(bin(i),i=1,100)
c      write(6,*)'back from readtape'
C      WRITE(6,*)'TIME,NTASWEEP,ISWEEPSET,ISWEEPCHECK = ',
C     + TIME,NTASWEEP,ISWEEPSET,ISWEEPCHECK
c      write(6,*)'time,stime = ',time,stime
      IF(TIME.GT.ETIME)THEN
       write(6,*)'time,etime,ntimer = ',time,etime,ntimer
       IF(TIME-ETIME.GT.1000..AND.NTIMER.LT.100)THEN
        TIME=1
        ITIMEX(2)=1
        NTIMER=NTIMER+1
        GO TO 7040
       ELSE
        NTIMER=0
       ENDIF
      ENDIF
      IF(TIME.GT.STIME.AND.IFILECHECK.EQ.0.AND.ITAPEOPEN.EQ.1)THEN
       WRITE(6,*)'SHOULD NOT GET HERE STOPPING'
       STOP
C       WRITE(6,*)'BACKING UP TWO FILES LOOKING FOR STARTIME'
C       CALL TAPECONTROL(LUNR,2,1) !back up 1 file
C       CALL TAPECONTROL(LUNR,2,1) !back up 1 file
C       IFILECHECK=1
C       GO TO 971
      ELSE
       IFILECHECK=1
      ENDIF
      OOLAT=RLAT
      OOLON=RLON
      TIMES=TIME
      IF(IUSEWIND.NE.1)CENTIME=TIME
      ISCANDIM=512
      IBINS=512
      IF((RADIITA(3)-RADIITA(2)).GT..145)THEN
       I150=1
      ELSE
       I150=0
      ENDIF
      IF(RADTEST.GT.0..AND.RADIITA(50).NE.RADTEST)THEN
       INEWRAD=1
       RADTEST=RADIITA(50)
      ELSE
       INEWRAD=0
      ENDIF     
      IF(TIME.LT.STIME)THEN
c       write(6,*)'calling int'
       ITIME=INT(TIME)
c       write(6,*)'returned from int'
       IF(ITIME.GT.ITIMECHECK)THEN
        WRITE(6,*)'TIME,STIME = ',TIME,STIME
        ITIMECHECK=ITIME
       ENDIF
c       write(6,*)'going to 7040 time,stime = ',time,stime
       GO TO 7040
      ENDIF
29654  CALL VRLOCATER(TIMES,OLAT,OLON,
     + RLAT,RLON,RA,EV,AZM,RDTAIIN,XR,YR,ZR,
     + ISCANDIM,SMOTIONU,SMOTIONV,CENTIME)
       IF(NUM_RAYS.GT.0.AND.IUSEWIND.EQ.1)THEN
        RADIANEV=EV*3.14159/180.
        RADIANAZM=AZM*3.14159/180.
        DIRCOSX=COS(RADIANEV)*COS(RADIANAZM)
        DIRCOSY=COS(RADIANEV)*SIN(RADIANAZM)
        DIRCOSZ=SIN(RADIANEV)
        XMIN=-XZ
        YMIN=-YZ
        XMAX=-XZ+IMX*SX
        YMAX=-YZ+JMX*SY
        ZZMAX=ZZ+(KMX-1)*SZ
        DO IR=1,512
         IF(BIN(IR).GT.-800.)THEN
          IINT=INT((XR(IR)+XZ+.5*SX)/SX)
          JINT=INT((YR(IR)+YZ+.5*SY)/SY)
          KINT=1+INT((ZR(IR)-ZZ)/SZ)
          VRRAD(IR,NUM_RAYS)=0.
          VRSUM=0.
          DO I=IINT,IINT+1
           DO J=JINT,JINT+1
            DO K=KINT,KINT+1
             IF(I.GE.1.AND.I.LE.IMX)THEN
              IF(J.GE.1.AND.J.LE.JMX)THEN
               IF(K.GE.1.AND.K.LE.KMX)THEN
                IF(U(I,J,K).GT.WFLAG)THEN
                 XG=(I-1)*SX-XZ+.5*SX
                 YG=(J-1)*SY-YZ+.5*SY
                 ZG=(K-1)*SZ+ZZ
                 XI=XR(IR)-XG
                 YI=YR(IR)-YG
                 ZI=ZR(IR)-ZG
                 RADR=SQRT(XR(IR)*XR(IR)+YR(IR)*YR(IR))
                 RADG=SQRT(XG*XG+YG*YG)
                 VRAD=(U(I,J,K)*XG+V(I,J,K)*YG)/RADG
                 VTAN=(V(I,J,K)*XG-U(I,J,K)*YG)/RADG
                 URAD=(VRAD*XR(IR)-VTAN*YR(IR))/RADR
                 VRAD=(VRAD*YR(IR)+VTAN*XR(IR))/RADR
                 DISTPOINT=SQRT(XI*XI+YI*YI+ZI*ZI)
                 IF(DISTPOINT.GT.0.)THEN
                  RINT=1./DISTPOINT
                 ELSE
                  RINT=1000000.
                 ENDIF
                 VRRAD(IR,NUM_RAYS)=VRRAD(IR,NUM_RAYS)+
     1              RINT*(URAD*DIRCOSX+VRAD*DIRCOSY+
     1              W(I,J,K)*DIRCOSZ)
                 VRSUM=VRSUM+RINT
                ENDIF
               ENDIF
              ENDIF
             ENDIF
            ENDDO
           ENDDO
          ENDDO
          IF(VRSUM.GT.0.)THEN
           VRRAD(IR,NUM_RAYS)=VRRAD(IR,NUM_RAYS)/VRSUM
          ELSE
           VRRAD(IR,NUM_RAYS)=-888.8
          ENDIF
         ELSE
          VRRAD(IR,NUM_RAYS)=-888.8
         ENDIF
        ENDDO
       ENDIF
      IF(NUM_RAYS.GT.0)THEN
       CALL VRLOCATER(TIMES,OOLAT,OOLON,
     + RLAT,RLON,RA,EV,AZM,RDTAIIN,XR,YR,ZR,
     + ISCANDIM,SMOTIONU,SMOTIONV,CENTIME)
       DO I=1,512
        XRSWEEP(I,NUM_RAYS)=XR(I)
        YRSWEEP(I,NUM_RAYS)=YR(I)
        ZRSWEEP(I,NUM_RAYS)=ZR(I)
       ENDDO
      ENDIF
C
C ISWEEPSET EQUALS ZERO MEANS START TIME HAS NOT BEEN REACHED
C
c      WRITE(6,*)'1 SWEEPTEST,SWEEPOLD,ELEV,RADAZM,TRAKELEV,TRAKAZM = ',
c     + SWEEPTEST,SWEEPOLD,ELEV,RADAZM,TRAKELEV,TRAKAZM
      SWEEPTEST=1.
      IF(ABS(ELEV).GT.0.)THEN
       SWEEPTEST=ELEV*SWEEPOLD
       SWEEPOLD=ELEV
      ENDIF
      IF(IFRANCE.NE.1.AND.ISWEEPCHECK.NE.NTASWEEP)SWEEPTEST=-1
      IF(IFRANCE.NE.1.AND.ISWEEPCHECK.EQ.NTASWEEP)SWEEPTEST=1.
c      WRITE(6,*)'2 SWEEPTEST,SWEEPOLD,ELEV,RADAZM,TRAKELEV,TRAKAZM = ',
c     + SWEEPTEST,SWEEPOLD,ELEV,RADAZM,TRAKELEV,TRAKAZM
      IF(ISWEEPSET.EQ.0)THEN
       ISWEEPCHECK=NTASWEEP
       ISWEEPSET=1
       GO TO 7040
C
C ISWEEPSET EQUALS ONE MEANS START THIME HAS BEEN REACHED BUT 
C STILL WAITING FOR THE BEGINNING OF THE NEXT SWEEP TO START PROCESSING
C
C      ELSEIF(ISWEEPSET.EQ.1.AND.NTASWEEP.EQ.ISWEEPCHECK)THEN
      ELSEIF(ISWEEPSET.EQ.1.AND.SWEEPTEST.GE.0.)THEN
       WRITE(6,*)'ISWEEP 1 NTASWEEP = ',NTASWEEP
       GO TO 7040
C      ELSEIF(ISWEEPSET.EQ.1.AND.NTASWEEP.NE.ISWEEPCHECK)THEN
      ELSEIF(ISWEEPSET.EQ.1.AND.SWEEPTEST.LT.0.)THEN
       RDDIFF=RDTAIIN(IBST(1)+1)-RDTAIIN(1)
       IF(IBST(1).GE.1)THEN
        DO I=1,IBST(1)
         RDTAIIN(I)=1000.
        ENDDO
       ENDIF
       DO I=IBST(1)+1,NBINS
        RDTAIIN(I)=RADIITA(I)
       ENDDO
       IF(NBINS.LT.512)THEN
        RDTAIIN(I)=1000.
       ENDIF
C
C SETTING ISWEEPSET TO 2 MEANS WE HAVE REACHED THE START TIME
C
       ISWEEPSET=2
       ISWEEPCHECK=NTASWEEP
C
C THE FOLLOWING BEING TRUE MEANS WE HAVE STARTED THE PROCESSING AND 
C HAVE JUST REACHED A NEW SWEEP
C
C      ELSEIF((ISWEEPSET.EQ.2.AND.NTASWEEP.NE.ISWEEPCHECK).
C     1       OR.NUM_RAYS.EQ.800)THEN
      ELSEIF((ISWEEPSET.EQ.2.AND.SWEEPTEST.LT.0.).
     1       OR.NUM_RAYS.EQ.800)THEN
       IF(NUM_RAYS.EQ.800)THEN
        WRITE(6,*)'SPECIAL END TO SWEEP'
       ENDIF
       ISWEEPCHECK=NTASWEEP
       CALL CTME(TIME,IIHH,IIMM,IISS)
       WRITE(6,*)'SWEEP END TIME IS '
       WRITE(6,'(3I2)')IIHH,IIMM,IISS
c       WRITE(67,'(3I2)')IIHH,IIMM,IISS
       TIMEONE=TIME
       RLATONE=RLAT
       RLONONE=RLON
       RAONE=RA
       RDVWSONE=RADVWS
       AZMONE=AZM
       EVONE=EV
       V0ONE=V0
       AZELONE=TRAKAZM
       AZELTWO=TRAKELEV
       PELEVONE=ELEV
       PAZMONE=RADAZM
       IF(IBST(1).GE.1)THEN
        DO I=1,IBST(1)
         BINONE(I)=-888.8
         REFONE(I)=-32.
        ENDDO
       ENDIF
       DO I=IBST(1)+1,512
        BINONE(I)=BIN(I)
        REFONE(I)=REF(I)
        SWONE(I)=WIDTHBUFFER(I)
       ENDDO
       IF(TRAKAZM.GT.91..AND.TRAKAZM.LT.269.)THEN
        IBST1=IBST(1)
        CALL FIND_GROUND(RDTAIIN,DEG2RAD,BEAM_WID,RS_TH,RS_M,
     + DBZ_MAX,IBEG,NG2,IBST1)
c       WRITE(6,*)'RS_TH,RS_M,DBZ_MAX,IBEG,NG2 = ',RS_TH,RS_M,DBZ_MAX,
c     +  IBEG,NG2
        IBEGNEW=IBEG
        REFL=-32.
        IF(IBEG.GT.1)THEN
         DO L=1,20
          IBEGL=IBEG-L+1
          IF((IBEGL-1).GE.5)THEN
c          WRITE(6,*)'IBEGL,L,REF(IBEGL),REF(IBEGL-1) = ',
c     +               IBEGL,L,REF(IBEGL),REF(IBEGL-1)
           IF(DBZBUFFER(IBEGL).GT.-31.95)REFL=DBZBUFFER(IBEGL)
           IF(REFL.GT.-31.95.AND.DBZBUFFER(IBEGL-1).GT.-31.95)THEN
            IF(REFL-DBZBUFFER(IBEGL-1).GT.5.)THEN
             IBEGNEW=IBEGL
            ENDIF
           ENDIF
          ENDIF
         ENDDO
         IBEG=IBEGNEW
         DO I=IBEG,512
          BINONE(I)=-999.9
          REFONE(I)=-999.9
         ENDDO
        ELSEIF(IBEG.EQ.-1)THEN
         DO I=1,512
          BINONE(I)=-999.9
          REFONE(I)=-999.9
         ENDDO 
        ENDIF
       ENDIF
       GO TO 2000
      ENDIF
c      write(6,*)'num_rays = ',num_rays
      NUM_RAYS=NUM_RAYS+1
      RRLAT(NUM_RAYS)=RLAT
      RRLON(NUM_RAYS)=RLON
      RRA(NUM_RAYS)=RA
      EAZM(NUM_RAYS)=AZM
      EEV(NUM_RAYS)=EV
      TMSWEEP(NUM_RAYS)=TIME
      RDWD(NUM_RAYS)=RADWD
      RDWS(NUM_RAYS)=RADWS
      RDVWS(NUM_RAYS)=RADVWS
c      write(6,*)'num_rays = ',num_rays
c      write(6,*)'trakazm = ',trakazm
      IF(TRAKAZM.GT.91..AND.TRAKAZM.LT.269.)THEN
       IBST1=IBST(1)
       CALL FIND_GROUND(RDTAIIN,DEG2RAD,BEAM_WID,RS_TH,RS_M,
     + DBZ_MAX,IBEG,NG2,IBST1)
c       WRITE(6,*)'RS_TH,RS_M,DBZ_MAX,IBEG,NG2 = ',RS_TH,RS_M,DBZ_MAX,
c     +  IBEG,NG2
       IBEGNEW=IBEG
       REFL=-32.
       IF(IBEG.GT.1)THEN
        DO L=1,20
         IBEGL=IBEG-L+1
         IF((IBEGL-1).GE.5)THEN
c          WRITE(6,*)'IBEGL,L,REF(IBEGL),REF(IBEGL-1) = ',
c     +               IBEGL,L,REF(IBEGL),REF(IBEGL-1)
          IF(DBZBUFFER(IBEGL).GT.-31.95)REFL=DBZBUFFER(IBEGL)
          IF(REFL.GT.-31.95.AND.DBZBUFFER(IBEGL-1).GT.-31.95)THEN
           IF(REFL-DBZBUFFER(IBEGL-1).GT.5.)THEN
            IBEGNEW=IBEGL
           ENDIF
          ENDIF
         ENDIF
        ENDDO
        IBEG=IBEGNEW
        DO I=IBEG,512
         BIN(I)=-999.9
         REF(I)=-999.9
        ENDDO
6927      FORMAT(10F8.2)
       ELSEIF(IBEG.EQ.-1)THEN
        DO I=1,512
         BIN(I)=-999.9
         REF(I)=-999.9
        ENDDO 
       ENDIF
      ENDIF
c      IF (TIME.GT.ETIME .OR. NIX.EQ.-100)GO TO 2000
2222  IF (NIX.EQ.-100)GO TO 2000
      IF (TAPE .EQ. 'Y') THEN 
C          call radartaperewind(lunr)
          WRITE(6,'("Change Radar Tape; RETURN to continue")')
7060      PAUSE
          WRITE(6,'("1-continue, 2-pause:",nn)')
          read(1,*,err=7060) irewind
          if (irewind .ne. 1) go to 7060
          TAPE='N'
          GO TO 7040
      ENDIF 
C 
C Write Radar Information To Disk  
      ITIME=TIME
      AZ_EL(1,NUM_RAYS)=TRAKAZM
      AZ_EL(2,NUM_RAYS)=TRAKELEV
      PELEV(NUM_RAYS)=ELEV
      PAZM(NUM_RAYS)=RADAZM
      V0SAVE(NUM_RAYS)=V0
      IF(IBST(1).GE.1)THEN
       DO I=1,IBST(1)
        BIN(I)=-888.8
        REF(I)=-32.
        WIDTHBUFFER(I)=-888.8      
       ENDDO
      ENDIF
      DO I=1,NBINS
       SWEEP(I,NUM_RAYS)=BIN(I)
       SWEEPZ(I,NUM_RAYS)=REF(I)
C       IF(SWEEPZ(I,NUM_RAYS).GT.64)THEN
C        WRITE(6,*)'ONE'
C        WRITE(6,*)'I,NUM_RAYS,SWEEPZ = ',I,NUM_RAYS,SWEEPZ(I,NUM_RAYS)
C        WRITE(6,*)'REF(I) = ',REF(I)
C        PAUSE
C       ENDIF
c       SWEEP(I,NUM_RAYS)=REF(I)
c       SWEEPZ(I,NUM_RAYS)=DBZBUFFER(I)
       SWIDTH(I,NUM_RAYS)=WIDTHBUFFER(I)
      ENDDO
      IF(NBINS.LT.512)THEN
       DO I=NBINS+1,512
        SWEEP(I,NUM_RAYS)=-888.8
        SWEEPZ(I,NUM_RAYS)=-32.
C       IF(SWEEPZ(I,NUM_RAYS).GT.64)THEN
C        WRITE(6,*)'TWO'
C        WRITE(6,*)'I,NUM_RAYS,SWEEPZ = ',I,NUM_RAYS,SWEEPZ(I,NUM_RAYS)
C        PAUSE
C       ENDIF
       ENDDO
      ENDIF
5675  FORMAT(4(I3,F10.4))
      IF (MOD(ITIME,60).EQ.0 .AND. itime.NE.OLDTIME) THEN
         CALL CTME(TIME,IH,IM,IS)
         WRITE(6,'(" Writing: ",3i2.2,1x,3(f9.3,1x),2(f12.4,1x))')
     +        IH,IM,IS,RLAT,RLON,RA,AZM,EV
      ENDIF
      OLDTIME=ITIME
      GO TO 7040
C 
C <<<<<<Error Conditions<<<<<<
970   WRITE(LP,'(1X," Error searching for start time:",i6)') IERR
      GO TO 2000
998   WRITE(LP,'(1X,"Error Opening Input File: ",A,1X,"IERR= ",I6)')
     +      IFILE,IERR
      GO TO 2000
999   WRITE(LP,'(1X,"Bad Input Data",I4)') IERR 
      GO TO 2000
1000  WRITE(LP,1030)IERR,NAMEO
1030  FORMAT(1X,'Error on Creating Output File= ',I5,1X,A) 
      GO TO 2000
1040  WRITE(LP,1045)IERR,NAMEO
1045  FORMAT(1X,'Error on Write= ',I5,1X,A)
      GO TO 2000
1050  WRITE(LP,'("Error on opening Ram File: ",I5,1X,A80)') IERR,NAMERAM 
2000  NUM_RAYS=NUM_RAYS-1
c      NLLLL=NUM_RAYS/3
c      DO LLLL=1,NLLLL
c       L1=1+(LLLL-1)*3
c       L2=LLLL*3
c       WRITE(67,'(8X,3(F8.2,16X))')(AZ_EL(1,LL),LL=L1,L2)
c       DO I=1,100
c        WRITE(67,'(I8,9F8.2)')I,
c     1  (SWEEP(I,LL),SWEEPZ(I,LL),SWIDTH(I,LL),LL=L1,L2)
c       ENDDO
c      ENDDO
      write(6,*)'num_rays = ',num_rays
      if(num_rays.ge.1)then
       radvwmax=0.
       sumvw=0.
       do j=1,num_rays
        radvwtest=abs(rdvws(j))
        sumvw=sumvw+rdvws(j)
c        write(6,*)'j,rdvws,radvwtest,radvwmax = ',j,rdvws(j),
c     1   radvwtest,radvwmax
        if(radvwtest.gt.radvwmax)radvwmax=radvwtest
       enddo
       radvwmean=sumvw/num_rays
       write(6,*)'radvwmax,radvwmean = ',radvwmax,radvwmean
       radvwmean=abs(radvwmean)
       if(radvwmax.gt.30..or.radvwmean.gt.15.)then
        do j=1,num_rays
         do i=1,nbins
          sweep(i,j)=-888.8
         enddo
        enddo
       endif
      endif
      RATEST=RA/1000.
      JSTART=0
      DO J=1,NUM_RAYS
       IF(AZ_EL(1,J).GT.90..AND.AZ_EL(1,J).LT.271.)THEN
        WRITE(6,*)'J,AZ_EL = ',AZ_EL(1,J)
        JSTART=J
        GO TO 18187
       ENDIF
      ENDDO
      GO TO 19187
18187 JEND=0
      DO J=JSTART+1,NUM_RAYS
       IF(AZ_EL(1,J).GT.270.)THEN
        JEND=J-1
        GO TO 18181
       ENDIF
      ENDDO
C18181 WRITE(6,*)'JSTART,JEND SET TO ',JSTART,JEND
18181 CONTINUE
      IRINSIDE=0
      IROUTSIDE=513
      RADIFFTEST=RATEST/1.5
      DO I=1,NBINS
       RALTDIFF=RDTAIIN(I)-RATEST
       IF(RALTDIFF.GT.-RADIFFTEST.AND.IRINSIDE.EQ.0)THEN
        IRINSIDE=I
       ENDIF
       IF(RALTDIFF.GT.RADIFFTEST)THEN
        IROUTSIDE=I-1
        GO TO 18182
       ENDIF
      ENDDO
18182 CONTINUE
C      WRITE(6,*)'IRINSIDE,IROUTSIDE = ',IRINSIDE,IROUTSIDE
      IF(IRINSIDE.GE.1.AND.IROUTSIDE.LE.NBINS)THEN
       DO I=IRINSIDE,IROUTSIDE
        DO J=1,NUM_RAYS
         IF(SWEEPZ(I,J).LT.0..OR.ZRSWEEP(I,J).LE.0.5)THEN
          SWEEP(I,J)=-999.9
          SWEEPZ(I,J)=-32.
C       IF(SWEEPZ(I,J).GT.64)THEN
C        WRITE(6,*)'THREE'
C        WRITE(6,*)'I,J,SWEEPZ = ',I,NUM_RAYS,SWEEPZ(I,J)
C        PAUSE
C       ENDIF
         ENDIF
        ENDDO
       ENDDO
      ENDIF
      DO I=1,NBINS
       IF(RDTAIIN(I).GT.RATEST)THEN
        IGTEST=0
        J=NUM_RAYS+1
        JJ=JSTART
        DO WHILE(JJ.LE.NUM_RAYS.AND.AZ_EL(1,JJ).LT.180.)
         IF(SWEEPZ(I,JJ).GT.-32.)THEN
          J=JJ+1
C         ELSE
C          GO TO 6498
         ENDIF
         JJ=JJ+1
        ENDDO
6498    IF(J.LE.NUM_RAYS.AND.AZ_EL(1,J).LT.180.)THEN
         ICHECK=1
C         write(6,*)'icheck,j,azel = ',icheck,j,az_el(1,j)
         CALL GROUNDCHECK(SWEEP,SWEEPZ,NUM_RAYS,I,J,ICHECK)
C       IF(SWEEPZ(I,NUM_RAYS).GT.64)THEN
C        WRITE(6,*)'FOUR'
C        WRITE(6,*)'I,NUM_RAYS,SWEEPZ = ',I,NUM_RAYS,SWEEPZ(I,NUM_RAYS)
C        PAUSE
C       ENDIF
        ENDIF
        J=0
        JJ=JEND
c        write(6,*)'i,j,jend = ',i,j,jend
        DO WHILE(JJ.GE.1.AND.AZ_EL(1,JJ).GT.180.)
C         write(6,*)'i,j,sweep(i,j) = ',i,j,sweep(i,j)
         IF(SWEEPZ(I,JJ).GT.-32.)THEN
          J=JJ-1
C         ELSE
C          GO TO 6499
         ENDIF
         JJ=JJ-1
        ENDDO
c        WRITE(6,*)'J,JEND = ',J,JEND
6499    IF(J.GE.1.AND.AZ_EL(1,J).GT.180.)THEN
         ICHECK=2
C         write(6,*)'icheck,j,azel = ',icheck,j,az_el(1,j)
         CALL GROUNDCHECK(SWEEP,SWEEPZ,NUM_RAYS,I,J,ICHECK)
C       IF(SWEEPZ(I,NUM_RAYS).GT.64)THEN
C        WRITE(6,*)'FIVE'
C        WRITE(6,*)'I,NUM_RAYS,SWEEPZ = ',I,NUM_RAYS,SWEEPZ(I,NUM_RAYS)
C        PAUSE
C       ENDIF
        ENDIF
       ENDIF
      ENDDO
19187 DO ICHECKSWEEP=1,3
       DO I=1,NBINS
        DO J=1,NUM_RAYS
         IKEEP(I,J)=1
         IF(SWEEP(I,J).GT.-800.)THEN
          DO I1=1,5
           II=I+I1-3
           IF(II.GT.0.AND.II.LE.512)THEN
            IF(SWEEP(II,J).GT.-800)THEN
             IITEST(I1)=1
            ELSE
             IITEST(I1)=0
            ENDIF
           ELSE
            IITEST(I1)=0
           ENDIF
          ENDDO
          DO J1=1,5
           JJ=J+J1-3
           IF(JJ.GT.0.AND.JJ.LE.NUM_RAYS)THEN
            IF(SWEEP(I,JJ).GT.-800)THEN
             JJTEST(J1)=1
            ELSE
             JJTEST(J1)=0
            ENDIF
           ELSE
            JJTEST(J1)=0
           ENDIF
          ENDDO
          IKEEPER=0
          IF(IITEST(2).EQ.1.AND.IITEST(4).EQ.1)THEN
           IKEEPER=1
          ELSEIF(IITEST(1).EQ.1.AND.IITEST(2).EQ.1)THEN
           IKEEPER=1
          ELSEIF(IITEST(4).EQ.1.AND.IITEST(5).EQ.1)THEN
           IKEEPER=1
          ENDIF
          JKEEPER=0
          IF(JJTEST(2).EQ.1.AND.JJTEST(4).EQ.1)THEN
           JKEEPER=1
          ELSEIF(JJTEST(1).EQ.1.AND.JJTEST(2).EQ.1)THEN
           JKEEPER=1
          ELSEIF(JJTEST(4).EQ.1.AND.JJTEST(5).EQ.1)THEN
           JKEEPER=1
          ENDIF
          IF(IKEEPER.EQ.0.OR.JKEEPER.EQ.0)THEN
           IKEEP(I,J)=0
          ENDIF
         ENDIF
        ENDDO
       ENDDO
       DO I=1,512
        DO J=1,NUM_RAYS
         IF(IKEEP(I,J).EQ.0)SWEEP(I,J)=-999.9
        ENDDO
       ENDDO
      ENDDO
      IF(ICONSERVE.EQ.1)THEN
       DO J=1,NUM_RAYS
        RADSAVER=0.
        I=1
        DO WHILE(I.LT.NBINS)
         IF(SWEEP(I,J).GT.-98..OR.RDTAIIN(I).LT.2..OR.
     +    RDTAIIN(I).GT.999.9)THEN
          RADSAVER=RDTAIIN(I)
          I=I+1
c          WRITE(6,*)'ONE,I,RADSAVER,SWEEP = ',I,RADSAVER,SWEEP(I,J)
         ELSEIF(RDTAIIN(I)-RADSAVER.GT.1.)THEN
c          WRITE(6,*)'TWO,I,RDTAIIN(I),RADSAVER,SWEEP(I,J) = ',
c     +       I,RDTAIIN(I),RADSAVER,SWEEP(I,J)
          DO L=I,NBINS
           SWEEP(L,J)=-888.8
          ENDDO
          GO TO 6305
         ELSE
          I=I+1
         ENDIF
        ENDDO
6305   ENDDO
      ENDIF
      XNIQTA1=XNIQTA
      CALL DEFRECKLE(IMAXBINS,JMAXRAYS,
     1 NUM_RAYS,PAZM,SWEEP,VROUT,XNIQTA1)
      DO J=1,NUM_RAYS
       V00=V0SAVE(J)
       M=INOB(1)
       IRS=1
       NB=NBINS
       VN=XNIQTA
       DO I=1,NBINS
        RAY(I)=SWEEP(I,J)
        IF(IUSEWIND.NE.1)THEN
         VRRAD(I,J)=-888.8
        ELSEIF(IUSEWIND.EQ.1)THEN
c         write(6,*)'iusewind,vrrad,ray = ',iusewind,vrrad(i,j),ray(i)
         IF(VRRAD(I,J).LT.-800.)THEN
          RAY(I)=-888.8
         ENDIF
        ENDIF
        URAY(I)=VRRAD(I,J)
       ENDDO
c       write(6,*)'AZM = ',az_el(1,j)
c       write(6,*)'calling unfolder'
c       CALL UNFLD1(V00,VN,M,IRS,NB,RAY,URAY,NB)
       CALL UNFLDNEW(V00,VN,M,IRS,NB,RAY,URAY,NB)
c       write(6,*)'j,v00,gse,gsn,radvgs,ucom,vcom,vws,ray,uray = ',
c     1            j,v00,gse,gsn,radvgs,ucom,vcom,radvws,
c     1            (ray(i),uray(i),i=1,30)
       DO I=1,NBINS
        SWEEP(I,J)=URAY(I)
       ENDDO
c       write(6,*)'finished calling unfolder'
      ENDDO
      XXNIQTA=XNIQTA*.7
      XXNIQ=XNIQTA
c      write(6,*)'setting nyq to ',xxniq
      DO I=1,NBINS
       DO J=1,NUM_RAYS
        NYQ(I,J)=XXNIQ
       ENDDO
      ENDDO
c      write(6,*)'finished setting nyq'
      write(6,*)'calling aziunfld'
      DO J=1,NUM_RAYS
       DO I=1,512
        SWEEPSAVE(I,J)=SWEEP(I,J)
       ENDDO
      ENDDO
      NB=NBINS
      CALL AZIUNFLD(SWEEP,ISEG,ISEGE,MAX_GATES,NB,MAX_RAYS,XXNIQTA,
     1 RDTAIIN,AZ_EL,XXNIQ,NUM_RAYS,VRRAD,IUSEWIND,PAZM)
c      DO J=1,NUM_RAYS
c         WRITE(68,'(3I2)')IIHH,IIMM,IISS
c         WRITE(68,'(2F8.1)')AZ_EL(1,J),AZ_EL(2,J)
c         WRITE(68,'(10F8.1)')(SWEEPSAVE(IL,J),IL=1,80)
c         WRITE(68,'(10F8.1)')(SWEEP(IL,J),IL=1,80)
c      ENDDO
      write(6,*)'returned from aziunfld'
      FLAGVAL=-888.8
      IVADFLAG=10
      IMINRNG=1
      NRANG=NBINS
      NSWEEPSUM=0
      YVRSUM=0
      XVRSUM=0
      VVRSUM=0
      DO J=1,NUM_RAYS
c       write(6,*)'pazm,sweep = ',pazm(j),sweep(5,j)
       IF(SWEEP(5,J).GT.-800.)THEN
        NSWEEPSUM=NSWEEPSUM+1
        YVRSUM=COS(PAZM(J))+YVRSUM
        XVRSUM=SIN(PAZM(J))+XVRSUM
        VVRSUM=VVRSUM+SWEEP(5,J)
       ENDIF
      ENDDO
      IF(NSWEEPSUM.GT.0)THEN
       YTEST=YVRSUM/NSWEEPSUM
       XTEST=XVRSUM/NSWEEPSUM
       VRTEST=VVRSUM/NSWEEPSUM
       WRITE(6,*)'NSWEEPSUM,YVRSUM,XVRSUM,VVRSUM = ',
     1            NSWEEPSUM,YVRSUM,XVRSUM,VVRSUM
       WRITE(6,*)'NSWEEPSUM,YTEST,XTEST,VRTEST = ',
     1            NSWEEPSUM,YTEST,XTEST,VRTEST
c       PAUSE
      ENDIF
      DO J=1,NUM_RAYS
       DO I=1,NBINS
        SWEEPSAVE(I,J)=SWEEP(I,J)
       ENDDO
      ENDDO
      ILATERSWEEP=1
      IF(I150.EQ.1)THEN
       ITEST1=64
       ITEST2=-1
       ITEST3=-1
       ITEST4=-1
       MULT1=8
       MULT2=-1
       MULT3=-1
       MULT4=-1
       KSTART1=1
       KSTART2=-1000
       KSTART3=-1000
      ELSE
       MULT1=16
       MULT2=8
       MULT3=4
       KSTART1=1
       KSTART2=257
       KSTART3=385
       ITEST1=16
       ITEST2=17
       ITEST3=33
       ITEST4=33
      ENDIF
      DO J=1,NUM_RAYS
       DO I=1,64
        IF(I.LE.ITEST1)THEN
         K=KSTART1+(I-1)*MULT1
         M=I*MULT1
        ELSEIF(I.GE.ITEST2.AND.I.LE.ITEST3)THEN
         K=KSTART2+(I-ITEST2)*MULT2
         M=K+MULT2-1
        ELSEIF(I.GE.ITEST4)THEN
         K=KSTART3+(I-ITEST4)*MULT3
         M=K+MULT3-1
        ENDIF
        SUM=0.
        SUMD=0.
        SUMND=0.
        SUMN=0.
        RADSUM=0.
        RADSUMN=0.
        DO L=K,M
         IF((ICALLSWEEPIN.EQ.0..OR.INEWRAD.EQ.1).AND.J.EQ.1)THEN
          IF(RDTAIIN(L).LT.200..AND.L.LE.NBINS)THEN
           RADSUMN=RADSUMN+1
           RADSUM=RADSUM+RDTAIIN(L)
          ENDIF
         ENDIF
c         if(j.eq.1)
c     1   write(6,*)'i,l,radsumn,radsum,RDTAIIN,icallsweepin = ',
c     1 i,l,radsum,radsumn,RDTAIIN(l),icallsweepin
         IF(SWEEP(L,J).GT.-888.8.AND.L.LE.NBINS)THEN
          SUM=SUM+SWEEP(L,J)
          SUMN=SUMN+1.
         ENDIF
         IF(SWEEPZ(L,J).GT.-20..AND.L.LE.NBINS)THEN
          SUMD=SUMD+SWEEPZ(L,J)
          SUMND=SUMND+1.
         ENDIF
        ENDDO
        IF(SUMN.GT.0.)THEN
         SWEEP(I,J)=SUM/SUMN
        ELSE
         SWEEP(I,J)=-888.8
        ENDIF
        IF((ICALLSWEEPIN.EQ.0..OR.INEWRAD.EQ.1).AND.J.EQ.1)THEN
         IF(RADSUMN.GT.0.)THEN
          RDTAI(I)=RADSUM/RADSUMN
         ELSE
          RDTAI(I)=1000.
         ENDIF
         WRITE(6,*)'I,RADSUM,RADSUMN,RDTAI = ',
     +              I,RADSUM,RADSUMN,RDTAI(I)      
        ENDIF
        IF(SUMND.GT.0.)THEN
         SWEEPZ(I,J)=SUMD/SUMND
        ELSE
         SWEEPZ(I,J)=-32.
        ENDIF
C        IF(SWEEPZ(I,J).GT.64.)THEN
C         WRITE(6,*)'I,J,SWEEPZ = ',I,J,SWEEPZ(I,J)
C         WRITE(6,*)'K,M,SWEEPZ = ',K,M,(SWEEPZ(L,J),L=K,M)
C         WRITE(6,*)'SUMD,SUMND = ',SUMD,SUMND
C         WRITE(6,*)'NBINS = ',NBINS
C         PAUSE
C        ENDIF
c        if(j.eq.1)then
c         write(6,*)'sum,sumn,sumnd,sumd,radsum,radsumn = ',
c     1             sum,sumn,sumnd,sumd,radsum,radsumn
c         write(6,*)'i,rdtai,sweep,sweepz = ',
c     1             i,rdtai(i),sweep(i,j),sweepz(i,j)
c        endif
       ENDDO
      ENDDO
      RETURN
      END 
      SUBROUTINE GROUNDCHECK(SWEEP,SWEEPZ,NUM_RAYS,I,JSTART,ICHECK)
      REAL SWEEP(512,800),SWEEPZ(512,800)
      IF(ICHECK.LT.1.OR.ICHECK.GT.2)THEN
       WRITE(6,*)'PROBLEM WITH ICHECK IN GROUNDCHECK'
       STOP
      ENDIF
      IF(SWEEPZ(I,JSTART).GT.-32.)THEN
       WRITE(6,*)'SWEEPZ(I,JSTART) GT -32.'
       WRITE(6,*)'I,JSTART,SWEEP,SWEEPZ = ',
     +  I,JSTART,SWEEP(I,JSTART),SWEEPZ(I,JSTART)
       STOP
      ENDIF
      IF(ICHECK.EQ.1)THEN
       IF(JSTART.LT.5)RETURN
       J=JSTART-4
c       WRITE(6,*)'RIGHT,I,JSTART,VEL = ',I,JSTART,
c     +             (SWEEP(I,L),L=J,JSTART)
c       WRITE(6,*)'RIGHT,I,JSTART,DBZ = ',I,JSTART,
c     +             (SWEEPZ(I,L),L=J,JSTART)
      SWTEST1=SWEEPZ(I,JSTART-1)-SWEEPZ(I,JSTART-3)
      SWTEST2=SWEEPZ(I,JSTART-2)-SWEEPZ(I,JSTART-3)
      IF(SWTEST1.GT.10..OR.SWTEST2.GT.10.)THEN
C       IF((SWEEPZ(I,JSTART-1).GT.-32..OR.SWEEPZ(I,JSTART-2).GT.-32.).
C     +  AND.SWEEPZ(I,JSTART-3).LE.-32.)THEN
        SWEEPZ(I,JSTART-1)=-32.
        SWEEPZ(I,JSTART-2)=-32.
        SWEEP(I,JSTART-1)=-888.8
        SWEEP(I,JSTART-2)=-888.8
       ENDIF
c       WRITE(6,*)'RIGHT,I,JSTART,VEL = ',I,JSTART,
c     +             (SWEEP(I,L),L=J,JSTART)
c       WRITE(6,*)'RIGHT,I,JSTART,DBZ = ',I,JSTART,
c     +             (SWEEPZ(I,L),L=J,JSTART)
      ELSE
       IF(NUM_RAYS-JSTART.LT.4)RETURN
       JEND=JSTART+4
c       WRITE(6,*) 'LEFT,I,JSTART,VEL = ',I,JSTART,
c     +             (SWEEP(I,L),L=JSTART,JEND)
c       WRITE(6,*) 'LEFT,I,JSTART,DBZ = ',I,JSTART,
c     +             (SWEEPZ(I,L),L=JSTART,JEND)
       SWTEST1=SWEEPZ(I,JSTART+1)-SWEEPZ(I,JSTART+3)
       SWTEST2=SWEEPZ(I,JSTART+2)-SWEEPZ(I,JSTART+3)
       IF(SWTEST1.GT.10..OR.SWTEST2.GT.10.)THEN
C       IF((SWEEPZ(I,JSTART+1).GT.-32..OR.SWEEPZ(I,JSTART+2).GT.-32.).
C     +  AND.SWEEPZ(I,JSTART+3).LE.-32.)THEN
        SWEEPZ(I,JSTART+1)=-32.
        SWEEPZ(I,JSTART+2)=-32.
        SWEEP(I,JSTART+1)=-888.8
        SWEEP(I,JSTART+2)=-888.8
       ENDIF
c       WRITE(6,*) 'LEFT,I,JSTART,VEL = ',I,JSTART,
c     +             (SWEEP(I,L),L=JSTART,JEND)
c       WRITE(6,*) 'LEFT,I,JSTART,DBZ = ',I,JSTART,
c     +             (SWEEPZ(I,L),L=JSTART,JEND)
      ENDIF
      RETURN
      END
C ********************
      SUBROUTINE READTAPE(TIME,RLAT,RLON,RA,AZM,EV,BIN,REF,
     +                    RCAZM,ITAPEOPEN,RADARFILE,NUMREC,
     +                    PCORS,DCORS,RCORS,AZMCORS,
     +                    RDELCORTAS,ELCORS)
      COMMON /AREA1/ INM,IFLT,STIME,ETIME,WD,WS,NIX,NGATE1,LP,LUNR,
     +               IVT,RAMFL
      COMMON /TAPEHEADER/ nbytesheader,ntape,nversion,ihheader,imheader,
     +                    isheader,ine,ndrive,naircraft,flightid,stmname
     +                    ,nsamplelf,nsampleta,refslopelf,refslopeta,
     +                    refnoisethreslf,refnoisethresta,sqilf,sqita,
     +                    widththreslf,widththresta,caliblf,calibta,
     +                    modedatalf,modedatata,noisetmlf,noisetmta,
     +                    rpmlf,rpmta,gtlnlf,ivrangelf,ivrangeta,
     +                    gtlnta(3),rdellf,rdelta,rdelcorlf,rdelcorta,
     +                    nbinlf,nbinta,nbins,rmaxlf,rmaxta,
     +                    radiita(512),radiilf(512),prf_flaglf,
     +                    prf_flagta,prf_highlf,prf_highta,xniqlf,
     +                    xniqta,iheader(1024)
      COMMON /RAYHEADER / nbytesdata,nlfsweep,ntasweep,numrecord,
     +                    irecflag,idradar,nbytesray,icode,idsp,mdata,
     +                    iyear,month,iday,iraycode,radtime,ih,im,is,
     +                    is100,radlat,radlon,radalt,gse,gsn,radgs,
     +                    radvgs,ucom,vcom,radwd,radws,radvws,ircu,
     +                    elev,radazm,pitch,roll,drift,heading,
     +                    dbzbuffer(512),velbuffer(512),widthbuffer(512)
      COMMON /PARAMS/ trakazm,trakelev,driftnew,
     +                rot,track,htbb,dbb,thresh,swthresh,dbzrs,ibst(2),
     +                inob(2),ileg,xniq,irsw,maxnbins,v0,
     +                pcor,dcor,rcor,azmcor,elcor,dbzcor,dbzslope,
     +                iunfoldflag,iattenflag,
     +                badstabflag,surfelimflag,echoflag,atmflag
      LOGICAL badstabflag, surfelimflag, echoflag, atmflag
      INTEGER*2 IHEADER
      INTEGER RTYPE
      INTEGER PRF_FLAGLF, PRF_FLAGTA
      REAL PCORS(2),DCORS(2),RCORS(2),AZMCORS(2)
      REAL RDELCORTAS(2),ELCORS(2)
      CHARACTER FLIGHTID*8,STMNAME*16 
      CHARACTER IFLT*8, INM*12
      CHARACTER *1 RAMFL, IVT
      CHARACTER*80 RADARFILE
      DIMENSION BIN(512),REF(512)
      DATA RTYPE/6/
C Subroutine to read doppler and Reflectivity data from the new 1988
C format radar tapes.  Reads refl/doppler when rtype=6 and dop/ref/sw when
C rtype=7.  It returns one ray per call.
C NIX = -100 determines an end-of-file
C Read data from tape:
      DO I=1,512
       BIN(I)=-888.8
       REF(I)=-32.
      ENDDO
c      WRITE(6,*)'ENTERED READTAPE TIME = ',TIME
      IF (SWTHRESH.GT.0.0 .AND. SWTHRESH.LE.13.0) RTYPE=7
c50    write(6,*)'calling radartaperead1'
c      write(6,*)'itapeopen,numrec = ',itapeopen,numrec
c      write(6,'(A80)')radarfile
50    IF(ITAPEOPEN.EQ.0)THEN
c       WRITE(6,*)'CALLING RADARDISCREAD'
       CALL RADARDISCREAD1(LUNR,2,0,RTYPE,IERR)
c       WRITE(6,*)'RETURNED FROM RADARDISCREAD'
C       CALL RADARFILEREAD(LUNR,2,0,RTYPE,IERR,ITAPEOPEN,RADARFILE,
C     + NUMREC)
      ELSE
       CALL RADARTAPEREAD(LUNR,2,0,RTYPE,IERR)
c       write(6,*)'Should not get here stopping'
c       STOP
      ENDIF
      IF (IERR .LT. 0) THEN
         NIX= -100
         RETURN
      ENDIF
      IF(ELEV.LT.0.)THEN
       PCOR=PCORS(1)
       DCOR=DCORS(1)
       RCOR=RCORS(1)
       AZMCOR=AZMCORS(1)
       ELCOR=ELCORS(1)
      ELSE
       PCOR=PCORS(2)
       DCOR=DCORS(2)
       RCOR=RCORS(2)
       AZMCOR=AZMCORS(2)
       ELCOR=ELCORS(2)
      ENDIF
C    clear nix variable
      NIX= 0
C    time in seconds  
      TIME=RADTIME
C    raw azimuth
      TRAKAZM=RADAZM
c    roll corrected azimuth but in heading rather than track
      RCAZM=RADAZM+RCOR+ROLL
C    raw elevation
      TRAKELEV=ELEV
C    raw drift
      DRIFTNEW=DRIFT
C    nyquist velocity
      XNIQ=XNIQTA
C ANGLECOR corrects the aircraft pitch,drift,roll,azimuth,elevation and
C adds the roll to the azimuth.
c      write(6,*)'roll,rcor,radazm,rcazm = ',roll,rcor,radazm,rcazm
      CALL ANGLECOR(PITCH,DRIFTNEW,ROLL,TRAKAZM,TRAKELEV,2,PCOR,
     +              DCOR,RCOR,AZMCOR,ELCOR)
c      write(6,*)'after roll,trakazm = ',roll,trakazm
C Convert aircraft angles to earth relative shperical coordinates
      CALL CONVERTANGLES(TRACK,TRAKAZM,TRAKELEV,HORAZM,HORELEV)
C    azimuth earth relative
      AZM=HORAZM
C    elevation earth relative
      EV=HORELEV
C get information from the ram files.
      IF (RAMFL .EQ. 'Y')
     *   CALL READRAMFILE(TIME,TIMERAM,RADLAT,RADLON,RADALT,
     *                    RADWD,RADWS,UCOM,VCOM,RADVWS,RADVGS,IOS)
C get information from the radar tape or the standard tape
      GS=RADGS                       !ground speed
      VGS=RADVGS                     !vertical ground speed
      VWS=RADVWS                     !vertical wind speed
      RLAT=RADLAT                    !latitude(deg)
      RLON=RADLON                    !longitude(deg)
      RA=RADALT                      !radar altitude(meters) 
      WD=RADWD                       !wind direction
      WS=RADWS                       !wind speed
C RAYCOR corrects the velocities one ray at a time.  It returns the airplane
C track, the first guess wind, the stabilized, vt corrected and unfolded
c velocities as well as the dbz values from the tail radar.
c      IUNFOLDFLAG=1
c      write(6,*)'before raycor'
c      write(6,*)'bin = ',bin
c      write(6,*)'velbuffer = ',velbuffer
      CALL RAYCOR1(BIN,REF)
c      write(6,*)'after raycor'
c      write(6,*)'bin = ',bin
c      write(6,*)'velbuffer = ',velbuffer
c      IUNFOLDFLAG=1
      RETURN
      END 
C ********************
      BLOCK DATA
      COMMON /AREA1/ INM,IFLT,STIME,ETIME,WD,WS,NIX,NGATE1,LP,LUNR,
     +               IVT,RAMFL
      COMMON /PARAMS/ trakazm,trakelev,driftnew,
     +                rot,track,htbb,dbb,thresh,swthresh,dbzrs,ibst(2),
     +                inob(2),ileg,xniq,irsw,maxnbins,v0,
     +                pcor,dcor,rcor,azmcor,elcor,dbzcor,dbzslope,
     +                iunfoldflag,iattenflag,
     +                badstabflag,surfelimflag,echoflag,atmflag
      LOGICAL badstabflag, surfelimflag, echoflag, atmflag
      CHARACTER IFLT*8, INM*12
      CHARACTER *1 RAMFL, IVT
      DATA NIX/0/, NGATE1/5/, IVT/'N'/, RAMFL/'N'/ 
      DATA rot/0.0/, htbb/-99./, dbb/2.0/, thresh/-99.0/, swthresh/99./,
     1     dbzrs/-99./, ibst/2*0/, inob/2*0/, ileg/1/, xniq/12.8/,
     2     irsw/0/, maxnbins/512/, 
     3     pcor,dcor,rcor,azmcor,elcor,dbzcor/6*0.0/, dbzslope/1.0/,
     4     iunfoldflag/0/, iattenflag/0/,
     5     badstabflag/.true./, surfelimflag/.false./,
     6     echoflag/.false./, atmflag/.false./
      END 
      SUBROUTINE VRLOCATER(TIMES,OLAT,OLON,
     + RLAT,RLON,ALT,ELEV,AZIM,RANGE,XR,YR,ZR,
     + ISCANDIM,SMOTIONU,SMOTIONV,CENTIME)
      REAL RANGE(ISCANDIM),XR(ISCANDIM),YR(ISCANDIM),ZR(ISCANDIM)
      REAL SUM(1024),WSUM(1024),WEIGHT(200),VR(1024)
      RALT=ALT/1000.
      PI=ASIN(1.0)*2.
      DTR=PI/180.
      REARTH=6366.
C      SMOTIONU=0.
C      SMOTIONV=0.
      TDIFF=TIMES-CENTIME
c      write(6,*)'olat,rlat,times,centime,tdiff,smotionu,smotionv = ',
c     + olat,rlat,times,centime,tdiff,smotionu,smotionv
C      TDIFF=0.
C      JBINS=IBINS*3
c      DO I=1,ISCANDIM
c       SUM(I)=0
c       WSUM(I)=0
c       ISTART=I-JBINS
c       IEND=I+JBINS
c       IF(ISTART.LT.1)ISTART=1
c       IF(IEND.GT.ISCANDIM)IEND=ISCANDIM
c       DO J=ISTART,IEND
c        IF(VR(J).GT.-900.)THEN
c         IDIFF=J-I
c         IDIFF=IABS(IDIFF)
c         WSUM(I)=WSUM(I)+WEIGHT(IDIFF)
c         SUM(I)=SUM(I)+WEIGHT(IDIFF)*VR(J)
c        ENDIF
c       ENDDO
c      ENDDO
c      DO I=1,ISCANDIM
c       IF(WSUM(I).LE.0..AND.VR(I).LE.-900.)THEN
c        VR(I)=-999.9
c       ELSE
c        VR(I)=SUM(I)/WSUM(I)
c       ENDIF
c      ENDDO
      XSHIFT=TDIFF*SMOTIONU/1000.
      YSHIFT=TDIFF*SMOTIONV/1000.     
c      write(6,*)'xshift,yshift = ',xshift,yshift
      RAZIM=AZIM*DTR
      RELEV=ELEV*DTR
      DO I=1,ISCANDIM
c xradar=horizontal distance from aircraft
c yradar=vertical distance from center of earth
       XRADAR=RANGE(I)*COS(RELEV)
       YRADAR=REARTH+RALT+RANGE(I)*SIN(RELEV)
c radnew=distance of datum from center of earth
       RADNEW=SQRT(XRADAR*XRADAR+YRADAR*YRADAR)
c delangle=angle between vertical at aircraft and vertical at datum
       DELANGLE=ATAN(XRADAR/YRADAR)
c distance along great circle from radar to datum
       DISTANCE=.5*(RADNEW+REARTH+RALT)*DELANGLE
c height=altitude of datum
       HEIGHT=RADNEW-REARTH
c distance2=xradar
       DISTANCE2=RANGE(I)*COS(RELEV)
c height2=altitude of datum not accounting for earth's curvature
       HEIGHT2=RALT+RANGE(I)*SIN(RELEV)
c delx=distance (aircraft/datum) along great circle due to east west
       DELY=DISTANCE*SIN(RAZIM)
c dely=distance(aircraft/datum)along great circle due to north-south
       DELX=DISTANCE*COS(RAZIM)
c dx=east west distance from origin to aircraft
       XLAT=.5*(RLAT+OLAT)*DTR
       DX=(RLON-OLON)*DTR*REARTH*COS(XLAT)
c dy=north south distance from origin to aircraft
       DY=(RLAT-OLAT)*DTR*REARTH
c xshift=east-west distance from lower left corner to origin
c yshift=north-south distance from lower left corner to origin
c XR=distance of datum from lower left corner
c YR=distance of datum from lower left corner
       XR(I)=DELX+DX-XSHIFT
c yshift=distance from lower left corner to origin
       YR(I)=DELY+DY-YSHIFT
       ZR(I)=HEIGHT
c       WRITE(6,*)'I,RANGE,DISTANCE,HEIGHT,DELX,DELY,DX,DY,XSHIFT,'
c     +  'YSHIFT = ',
c     +  I,RANGE(I),DISTANCE,HEIGHT,DELX,DELY,DX,DY,XSHIFT,YSHIFT
      ENDDO
      CONTINUE
      RETURN
      END
	subroutine find_ground(rdtai,deg2rad, beam_wid, 
     +		rs_th, rs_m, dBz_max, ibeg, Ng2, ibst)
C Find the surface, as in Testud's memo.
      COMMON /TAPEHEADER/ nbytesheader,ntape,nversion,ihheader,imheader,
     +                    isheader,ine,ndrive,naircraft,flightid,stmname
     +                    ,nsamplelf,nsampleta,refslopelf,refslopeta,
     +                    refnoisethreslf,refnoisethresta,sqilf,sqita,
     +                    widththreslf,widththresta,caliblf,calibta,
     +                    modedatalf,modedatata,noisetmlf,noisetmta,
     +                    rpmlf,rpmta,gtlnlf,ivrangelf,ivrangeta,
     +                    gtlnta(3),rdellf,rdelta,rdelcorlf,rdelcorta,
     +                    nbinlf,nbinta,nbins,rmaxlf,rmaxta,
     +                    radiita(512),radiilf(512),prf_flaglf,
     +                    prf_flagta,prf_highlf,prf_highta,xniqlf,
     +                    xniqta,iheader(1024)
C
      COMMON /RAYHEADER / nbytesdata,nlfsweep,ntasweep,numrecord,
     +                    irecflag,idradar,nbytesray,icode,idsp,mdata,
     +                    iyear,month,iday,iraycode,time,ih,im,
     +                    is,is100,rlat,rlon,ra,gse,gsn,gs,vgs,
     +                    ucom,vcom,wd,ws,vws,ircu,
     +                    elev,azm,pitch,roll,drift,heading,
     +                    dbzbuffer(512),velbuffer(512),widthbuffer(512)
	CHARACTER FLIGHTID*8,STMNAME*16
	integer*2 iheader
	real lambda
        real rdtai(512)
C
	theta = elev * deg2rad ! tilt relative to plane perp to radar axis
	beta = pitch * deg2rad
C In Testud's form, 0 is down, -90 port, 90 starboard:
	phi = (180 - (azm + roll) ) * deg2rad 
	epsilon = beam_wid * deg2rad
C Now get elevation of beam rel to horizontal plane through radar
	sn_lambda = sin(theta) * sin(beta) - 
     *			cos(theta) * cos(beta) * cos(phi)
	lambda = asin(sn_lambda)
C Find theoretical range of surface. - sign because lambda neg
	rs_th = -ra / sn_lambda ! ra in m, radiita in km
C Find # of gates intersecting surface at theoretical range
C This would be formula if dR was constant:
C	Ng = rs_th * epsilon / (dR * tan(lambda) )
C But we may have varying beamwidths, so
Cout	slant_depth = -rs_th * epsilon / tan(lambda) ! slight approximation
Cout	rs_th_in = ( rs_th - slant_depth * 0.5 ) * 0.001
Cout	rs_th_out = ( rs_th + slant_depth * 0.5 ) * 0.001
C mod dec 8 92:
	rs_th_in = -ra / sin(lambda - epsilon * 0.75) * 0.001
	rs_th_out = -ra / sin(lambda + epsilon * 0.75) * 0.001
	rs_km = rs_th * 0.001
c        write(6,*)'rs_th_in,rs_km,rs_th_out = ',
c     +             rs_th_in,rs_km,rs_th_out
	in = -1
        iout = -1
	do i = 1, 512
	    if( radiita(i) .gt. 0.0 )then
		if(radiita(i) .lt. rs_th_in) in = i
		if(radiita(i) .le. rs_th_out) iout = i
		if(radiita(i) .le. rs_km) Nr = i
	    end if
	end do
c        write(6,*)'rs_th_in,rs_th_out,rs_km = ',rs_th_in,rs_th_out,
c     +    rs_km
	if(in .eq. -1.or.iout.eq.-1)then
		write(6,*)' find_ground failure!'
		write(6,*)' ra:',ra
		write(6,*)'azm, phi: ', azm, phi
		write(6,*)'pitch, drift, roll: ',pitch, drift, roll
		write(6,*)'el, sin(lambda), lambda:',elev, 
     +			sn_lambda, lambda
		write(6,*)'rs_th_in, rs_th_out, rs_km:'
		write(6,*)rs_th_in, rs_th_out, rs_km
		write(6,*)' find_gs in, iout, Nr: ',in, iout, Nr
c		pause ' pausing for this mystery '
		ibeg = -1
		return
	end if
	Ng = iout - in + 1
        Ng2 = Ng
c	Ng2 =  0.5 * Ng
	if (Ng2 .eq. 0) Ng2 = 1
c        write(6,*)'in,iout,ng,ng2,nr = ',in,iout,ng,ng2,nr
C changed radius of check to 30 bins = 2.25 km, because of huge
C range delays in Andrew 8 dec 92
C Then search the gates within +- 30 of gate at theoretical
C range to find the swath Ng/2 wide with greatest Total Ze.
C Return bounding bins.
	dBz_max = -1.0
	ibeg = -1
        if(ng2.gt.30)then
         n30=ng2
        else
         n30=30
        endif
	ist = max(1, Nr - n30)
	ien = min(512-Ng2, Nr + n30 -Ng2)
d	WRITE(6,*)'find_gd ist, ien: ',ist, ien
	do i = ist, ien
	   dBzsum = 0.0
	   do j = i, i + Ng2
                if(j.gt.ibst.and.dbzbuffer(j).gt.-32.)then
 		 dBzsum = dBzsum + dbzbuffer(j)
c                dbzsum = dbzbuffer(i+Ng2)-dbzbuffer(i)
                endif
	   end do
	   if( dBzsum .gt. dBz_max)then
		dBz_max = dBzsum
		ibeg = i
	   end if
	end do
	iradius = ibeg + Ng2 * 0.5
	if( iradius .le.0) iradius = 1
        if( iradius .gt.512) iradius = 512
	rs_m = radiita( iradius ) * 1000.0
	return
	end


